/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.ClassFinder;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.interpreter.AbstractConstantExpressionsInterpreter;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.Context;
import org.eclipse.xtext.xbase.interpreter.StackedConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.UnresolvableFeatureException;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;
import org.eclipse.xtext.xbase.typesystem.util.PendingLinkingCandidateResolver;
import org.eclipse.xtext.xbase.typesystem.util.TypeLiteralLinkingCandidateResolver;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.impl.XComputedTypeReferenceImplCustom;

public class ConstantExpressionsInterpreter
extends AbstractConstantExpressionsInterpreter {
    @Inject
    private ILogicalContainerProvider containerProvider;
    @Inject
    private ProcessorInstanceForJvmTypeProvider classLoaderProvider;
    @Inject
    @Extension
    private NumberLiterals numberLiterals;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IImportsConfiguration importSectionLocator;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IResourceScopeCache cache;

    public Object evaluate(XExpression expression, JvmTypeReference expectedType) {
        ClassLoader classLoader = this.classLoaderProvider.getClassLoader((EObject)expression);
        Map<String, JvmIdentifiableElement> visibleFeatures = this.findVisibleFeatures(expression);
        JvmTypeReference _xifexpression = null;
        _xifexpression = expectedType instanceof XComputedTypeReference ? null : expectedType;
        ClassFinder _classFinder = new ClassFinder(classLoader);
        LinkedHashSet _newLinkedHashSet = CollectionLiterals.newLinkedHashSet((Object[])new XExpression[0]);
        Context _context = new Context(_xifexpression, _classFinder, visibleFeatures, (Set)_newLinkedHashSet);
        Object result = this.evaluate(expression, _context);
        return result;
    }

    protected Map<String, JvmIdentifiableElement> findVisibleFeatures(final XExpression expression) {
        JvmIdentifiableElement _nearestLogicalContainer;
        HashMap _xblockexpression = null;
        JvmGenericType _switchResult = null;
        JvmIdentifiableElement cont = _nearestLogicalContainer = this.containerProvider.getNearestLogicalContainer((EObject)expression);
        boolean _matched = false;
        if (!_matched && cont instanceof JvmGenericType) {
            _matched = true;
            _switchResult = (JvmGenericType)cont;
        }
        if (!_matched && cont instanceof JvmMember) {
            _matched = true;
            _switchResult = ((JvmMember)cont).getDeclaringType();
        }
        JvmGenericType container = _switchResult;
        Pair _mappedTo = Pair.of((Object)"visibleFeaturesForAnnotationValues", container);
        Resource _eResource = expression.eResource();
        Provider<HashMap<String, JvmIdentifiableElement>> _function = new Provider<HashMap<String, JvmIdentifiableElement>>((JvmDeclaredType)container){
            private final /* synthetic */ JvmDeclaredType val$container;
            {
                this.val$container = jvmDeclaredType;
            }

            public HashMap<String, JvmIdentifiableElement> get() {
                boolean _notEquals;
                HashMap result = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
                Resource _eResource = expression.eResource();
                XImportSection section = ConstantExpressionsInterpreter.this.importSectionLocator.getImportSection((XtextResource)_eResource);
                boolean bl = _notEquals = !Objects.equal((Object)section, null);
                if (_notEquals) {
                    EList _importDeclarations = section.getImportDeclarations();
                    for (XImportDeclaration imp : _importDeclarations) {
                        boolean _isStatic = imp.isStatic();
                        if (!_isStatic) continue;
                        String _importedTypeName = imp.getImportedTypeName();
                        JvmType type = ConstantExpressionsInterpreter.this.findTypeByName((EObject)imp, _importedTypeName);
                        boolean _matched = false;
                        if (!_matched && type instanceof JvmGenericType) {
                            _matched = true;
                            ConstantExpressionsInterpreter.this.collectAllVisibleFields((JvmDeclaredType)type, result);
                        }
                        if (_matched || !(type instanceof JvmEnumerationType)) continue;
                        _matched = true;
                        EList _literals = ((JvmEnumerationType)type).getLiterals();
                        for (JvmEnumerationLiteral feature : _literals) {
                            String _simpleName = feature.getSimpleName();
                            result.put(_simpleName, feature);
                        }
                    }
                }
                ConstantExpressionsInterpreter.this.collectAllVisibleFields(this.val$container, result);
                return result;
            }
        };
        _xblockexpression = (HashMap)this.cache.get((Object)_mappedTo, _eResource, (Provider)_function);
        return _xblockexpression;
    }

    protected void collectAllVisibleFields(JvmDeclaredType type, Map<String, JvmIdentifiableElement> result) {
        boolean _equals = Objects.equal((Object)type, null);
        if (_equals) {
            return;
        }
        JvmDeclaredType _declaringType = type.getDeclaringType();
        this.collectAllVisibleFields(_declaringType, result);
        HashMap<String, JvmIdentifiableElement> _allVisibleFields = this.getAllVisibleFields(type);
        result.putAll(_allVisibleFields);
    }

    protected HashMap<String, JvmIdentifiableElement> getAllVisibleFields(JvmDeclaredType type) {
        HashMap result = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        VisibleFieldsCollector _visibleFieldsCollector = new VisibleFieldsCollector();
        _visibleFieldsCollector.collect(type, result);
        return result;
    }

    protected JvmType findTypeByName(EObject context, String qualifiedName) {
        IScope scope = this.scopeProvider.getScope(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        QualifiedName qn = this.qualifiedNameConverter.toQualifiedName(qualifiedName);
        IEObjectDescription _singleElement = scope.getSingleElement(qn);
        EObject _eObjectOrProxy = null;
        if (_singleElement != null) {
            _eObjectOrProxy = _singleElement.getEObjectOrProxy();
        }
        return (JvmType)_eObjectOrProxy;
    }

    protected Object _internalEvaluate(XNumberLiteral it, Context ctx) {
        try {
            Number _xblockexpression = null;
            Class<?> _xifexpression = null;
            JvmTypeReference _expectedType = ctx.getExpectedType();
            boolean _equals = Objects.equal((Object)_expectedType, null);
            if (_equals) {
                _xifexpression = this.numberLiterals.getJavaType(it);
            } else {
                Class<?> _javaType;
                JvmTypeReference _expectedType_1 = ctx.getExpectedType();
                JvmType _type = _expectedType_1.getType();
                ClassFinder _classFinder = ctx.getClassFinder();
                _xifexpression = _javaType = this.getJavaType(_type, _classFinder);
            }
            Class<?> type = _xifexpression;
            _xblockexpression = this.numberLiterals.numberValue(it, (Class)type);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Object _internalEvaluate(XListLiteral it, final Context ctx) {
        try {
            boolean _notEquals;
            JvmTypeReference _expectedType;
            JvmTypeReference _switchResult = null;
            JvmTypeReference exp = _expectedType = ctx.getExpectedType();
            boolean _matched = false;
            if (!_matched && exp instanceof JvmGenericArrayTypeReference) {
                _matched = true;
                _switchResult = ((JvmGenericArrayTypeReference)exp).getComponentType();
            }
            final JvmTypeReference expectedComponentType = _switchResult;
            EList _elements = it.getElements();
            Functions.Function1<XExpression, Object> _function = new Functions.Function1<XExpression, Object>(){

                public Object apply(XExpression it) {
                    Context _cloneWithExpectation = ctx.cloneWithExpectation(expectedComponentType);
                    return ConstantExpressionsInterpreter.this.evaluate(it, _cloneWithExpectation);
                }
            };
            List elements = ListExtensions.map((List)_elements, (Functions.Function1)_function);
            Class<Object> _xifexpression = null;
            boolean bl = _notEquals = !Objects.equal((Object)expectedComponentType, null);
            if (_notEquals) {
                JvmType _type = expectedComponentType.getType();
                ClassFinder _classFinder = ctx.getClassFinder();
                _xifexpression = this.getJavaType(_type, _classFinder);
            } else {
                boolean _not;
                Class<Object> _xifexpression_1 = null;
                boolean _isEmpty = elements.isEmpty();
                boolean bl2 = _not = !_isEmpty;
                if (_not) {
                    Class<?> _class;
                    Class<Constable> _switchResult_1 = null;
                    Object _head = IterableExtensions.head((Iterable)elements);
                    Class<?> cl = _class = _head.getClass();
                    boolean _matched_1 = false;
                    if (!_matched_1 && Objects.equal(cl, Integer.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Integer.TYPE;
                    }
                    if (!_matched_1 && Objects.equal(cl, Long.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Long.TYPE;
                    }
                    if (!_matched_1 && Objects.equal(cl, Short.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Short.TYPE;
                    }
                    if (!_matched_1 && Objects.equal(cl, Boolean.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Boolean.TYPE;
                    }
                    if (!_matched_1 && Objects.equal(cl, Double.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Double.TYPE;
                    }
                    if (!_matched_1 && Objects.equal(cl, Byte.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Byte.TYPE;
                    }
                    if (!_matched_1 && Objects.equal(cl, Float.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Float.TYPE;
                    }
                    if (!_matched_1) {
                        _switchResult_1 = cl;
                    }
                    _xifexpression_1 = _switchResult_1;
                } else {
                    _xifexpression_1 = Object.class;
                }
                _xifexpression = _xifexpression_1;
            }
            Class<?> componentType = _xifexpression;
            return Conversions.unwrapArray((Object)elements, componentType);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected boolean isResolveProxies(EObject ctx) {
        Resource _eResource;
        boolean _switchResult = false;
        Resource res = _eResource = ctx.eResource();
        boolean _matched = false;
        if (!_matched && res instanceof StorageAwareResource) {
            _matched = true;
            _switchResult = ((StorageAwareResource)res).isLoadedFromStorage();
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    protected Object _internalEvaluate(XFeatureCall it, Context ctx) {
        boolean _notEquals;
        boolean _isEquivalentComputed;
        JvmTypeReference _expectedType;
        boolean _not;
        boolean _isResolveProxies = this.isResolveProxies((EObject)it);
        Object _eGet = it.eGet((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, _isResolveProxies);
        EObject feature = (EObject)_eGet;
        boolean _eIsProxy = feature.eIsProxy();
        boolean bl = _not = !_eIsProxy;
        if (_not) {
            Object _switchResult = null;
            boolean _matched = false;
            if (!_matched && feature instanceof JvmEnumerationLiteral) {
                _matched = true;
                _switchResult = feature;
            }
            if (!_matched && feature instanceof JvmField) {
                _matched = true;
                _switchResult = this.evaluateField((XAbstractFeatureCall)it, (JvmField)feature, ctx);
            }
            if (!_matched && feature instanceof JvmType) {
                _matched = true;
                _switchResult = this.toTypeReference((JvmType)feature, 0);
            }
            return _switchResult;
        }
        String featureName = it.getConcreteSyntaxFeatureName();
        JvmType _switchResult_1 = null;
        JvmTypeReference it_1 = _expectedType = ctx.getExpectedType();
        boolean _matched_1 = false;
        if (!_matched_1 && it_1 instanceof XComputedTypeReferenceImplCustom && (_isEquivalentComputed = ((XComputedTypeReferenceImplCustom)it_1).isEquivalentComputed())) {
            _matched_1 = true;
            _switchResult_1 = ((XComputedTypeReferenceImplCustom)it_1).getType();
        }
        if (!_matched_1) {
            boolean _equals;
            if (it_1 instanceof XComputedTypeReference) {
                _matched_1 = true;
            }
            if (!_matched_1 && (_equals = Objects.equal((Object)it_1, null))) {
                _matched_1 = true;
            }
            if (_matched_1) {
                _switchResult_1 = null;
            }
        }
        if (!_matched_1) {
            _switchResult_1 = it_1.getType();
        }
        JvmType expectedRawType = _switchResult_1;
        HashMap _xifexpression = null;
        boolean _isEnumExpectationInAnnotationValue = this.isEnumExpectationInAnnotationValue(it, expectedRawType);
        if (_isEnumExpectationInAnnotationValue) {
            HashMap _xblockexpression = null;
            JvmEnumerationType _switchResult_2 = null;
            boolean _matched_2 = false;
            if (!_matched_2 && expectedRawType instanceof JvmEnumerationType) {
                _matched_2 = true;
                _switchResult_2 = (JvmEnumerationType)expectedRawType;
            }
            if (!_matched_2 && expectedRawType instanceof JvmArrayType) {
                _matched_2 = true;
                JvmComponentType _componentType = ((JvmArrayType)expectedRawType).getComponentType();
                _switchResult_2 = (JvmEnumerationType)_componentType;
            }
            JvmEnumerationType enumType = _switchResult_2;
            Map _visibleFeatures = ctx.getVisibleFeatures();
            final HashMap copy = new HashMap(_visibleFeatures);
            EList _literals = enumType.getLiterals();
            Procedures.Procedure1<JvmEnumerationLiteral> _function = new Procedures.Procedure1<JvmEnumerationLiteral>(){

                public void apply(JvmEnumerationLiteral it) {
                    String _simpleName = it.getSimpleName();
                    copy.put(_simpleName, it);
                }
            };
            IterableExtensions.forEach((Iterable)_literals, (Procedures.Procedure1)_function);
            _xifexpression = _xblockexpression = copy;
        } else {
            _xifexpression = ctx.getVisibleFeatures();
        }
        HashMap visibleFeatures = _xifexpression;
        boolean _containsKey = visibleFeatures.containsKey(featureName);
        if (_containsKey) {
            Object _xblockexpression_1;
            JvmIdentifiableElement _get;
            JvmEnumerationLiteral _switchResult_2 = null;
            JvmIdentifiableElement visibleFeature = _get = (JvmIdentifiableElement)visibleFeatures.get(featureName);
            boolean _matched_2 = false;
            if (!_matched_2 && visibleFeature instanceof JvmEnumerationLiteral) {
                _matched_2 = true;
                _xblockexpression_1 = null;
                this.resolveFeature((XAbstractFeatureCall)it, visibleFeature);
                _switchResult_2 = _xblockexpression_1 = (JvmEnumerationLiteral)visibleFeature;
            }
            if (!_matched_2 && visibleFeature instanceof JvmField) {
                _matched_2 = true;
                _xblockexpression_1 = null;
                this.resolveFeature((XAbstractFeatureCall)it, visibleFeature);
                _switchResult_2 = _xblockexpression_1 = this.evaluateField((XAbstractFeatureCall)it, (JvmField)visibleFeature, ctx);
            }
            return _switchResult_2;
        }
        JvmType type = this.findTypeByName((EObject)it, featureName);
        boolean bl2 = _notEquals = !Objects.equal((Object)type, null);
        if (_notEquals) {
            this.resolveType((XAbstractFeatureCall)it, (JvmIdentifiableElement)type);
            return this.toTypeReference(type, 0);
        }
        throw new UnresolvableFeatureException("Couldn't resolve feature " + featureName, (XExpression)it);
    }

    private boolean isEnumExpectationInAnnotationValue(XFeatureCall it, JvmType expectedRawType) {
        boolean _or = false;
        if (expectedRawType instanceof JvmEnumerationType) {
            _or = true;
        } else {
            boolean bl = _or = expectedRawType instanceof JvmArrayType && ((JvmArrayType)expectedRawType).getComponentType() instanceof JvmEnumerationType;
        }
        if (_or) {
            EObject container = it.eContainer();
            if (container instanceof XAnnotationElementValuePair) {
                return true;
            }
            if (container instanceof XAnnotation) {
                return true;
            }
            if (container instanceof XListLiteral) {
                EObject _eContainer = ((XListLiteral)container).eContainer();
                if ((container = _eContainer) instanceof XAnnotationElementValuePair) {
                    return true;
                }
                if (container instanceof XAnnotation) {
                    return true;
                }
            }
        }
        return false;
    }

    protected Object _internalEvaluate(XMemberFeatureCall it, Context ctx) {
        boolean _not;
        boolean _isResolveProxies = this.isResolveProxies((EObject)it);
        Object _eGet = it.eGet((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, _isResolveProxies);
        EObject feature = (EObject)_eGet;
        boolean _eIsProxy = feature.eIsProxy();
        boolean bl = _not = !_eIsProxy;
        if (_not) {
            Object _switchResult = null;
            boolean _matched = false;
            if (!_matched && feature instanceof JvmEnumerationLiteral) {
                _matched = true;
                _switchResult = feature;
            }
            if (!_matched && feature instanceof JvmField) {
                _matched = true;
                _switchResult = this.evaluateField((XAbstractFeatureCall)it, (JvmField)feature, ctx);
            }
            if (!_matched && feature instanceof JvmType) {
                _matched = true;
                _switchResult = this.toTypeReference((JvmType)feature, 0);
            }
            return _switchResult;
        }
        final String featureName = it.getConcreteSyntaxFeatureName();
        try {
            XExpression _memberCallTarget = it.getMemberCallTarget();
            Object receiver = this.evaluate(_memberCallTarget, ctx);
            boolean _matched_1 = false;
            if (!_matched_1 && receiver instanceof JvmTypeReference) {
                JvmType _type;
                _matched_1 = true;
                JvmType type = _type = ((JvmTypeReference)receiver).getType();
                boolean _matched_2 = false;
                if (!_matched_2 && type instanceof JvmEnumerationType) {
                    Functions.Function1<JvmEnumerationLiteral, Boolean> _function;
                    _matched_2 = true;
                    EList _literals = ((JvmEnumerationType)type).getLiterals();
                    JvmEnumerationLiteral enumValue = (JvmEnumerationLiteral)IterableExtensions.findFirst((Iterable)_literals, (Functions.Function1)(_function = new Functions.Function1<JvmEnumerationLiteral, Boolean>(){

                        public Boolean apply(JvmEnumerationLiteral it) {
                            String _simpleName = it.getSimpleName();
                            return Objects.equal((Object)_simpleName, (Object)featureName);
                        }
                    }));
                    boolean _equals = Objects.equal((Object)enumValue, null);
                    if (_equals) {
                        String _simpleName = ((JvmTypeReference)receiver).getSimpleName();
                        String _plus = "Couldn't find enum value " + featureName + " on enum " + _simpleName;
                        throw new ConstantExpressionEvaluationException(_plus, (XExpression)it);
                    }
                    this.resolveFeature((XAbstractFeatureCall)it, (JvmIdentifiableElement)enumValue);
                    return enumValue;
                }
                if (!_matched_2 && type instanceof JvmGenericType) {
                    Functions.Function1<JvmField, Boolean> _function;
                    _matched_2 = true;
                    Iterable _allFeatures = ((JvmGenericType)type).getAllFeatures();
                    Iterable _filter = Iterables.filter((Iterable)_allFeatures, JvmField.class);
                    JvmField field = (JvmField)IterableExtensions.findFirst((Iterable)_filter, (Functions.Function1)(_function = new Functions.Function1<JvmField, Boolean>(){

                        public Boolean apply(JvmField it) {
                            String _simpleName = it.getSimpleName();
                            return Objects.equal((Object)_simpleName, (Object)featureName);
                        }
                    }));
                    boolean _equals = Objects.equal((Object)field, null);
                    if (_equals) {
                        String _simpleName = ((JvmTypeReference)receiver).getSimpleName();
                        String _plus = "Couldn't find field " + featureName + " on type " + _simpleName;
                        throw new ConstantExpressionEvaluationException(_plus, (XExpression)it);
                    }
                    this.resolveFeature((XAbstractFeatureCall)it, (JvmIdentifiableElement)field);
                    return this.evaluateField((XAbstractFeatureCall)it, field, ctx);
                }
            }
            throw new UnresolvableFeatureException("Unresolvable feature " + featureName + " on " + receiver, (XExpression)it);
        }
        catch (Throwable _t) {
            if (_t instanceof UnresolvableFeatureException) {
                boolean _notEquals;
                UnresolvableFeatureException e = (UnresolvableFeatureException)_t;
                String typeName = this.getFullName((XExpression)it);
                JvmType type = this.findTypeByName((EObject)it, typeName);
                boolean bl2 = _notEquals = !Objects.equal((Object)type, null);
                if (_notEquals) {
                    this.resolveType((XAbstractFeatureCall)it, (JvmIdentifiableElement)type);
                    return this.toTypeReference(type, 0);
                }
                throw new UnresolvableFeatureException("Unresolvable type " + typeName, (XExpression)it);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected String _getFullName(XExpression call) {
        String _text = this.toText(call);
        String _plus = "The expression '" + _text;
        String _plus_1 = String.valueOf(_plus) + "' cannot be used as a receiver within a constant expression.";
        throw new ConstantExpressionEvaluationException(_plus_1);
    }

    protected String _getFullName(XMemberFeatureCall call) {
        XExpression _memberCallTarget = call.getMemberCallTarget();
        String prefix = this.getFullName(_memberCallTarget);
        String _concreteSyntaxFeatureName = call.getConcreteSyntaxFeatureName();
        return String.valueOf(prefix) + "." + _concreteSyntaxFeatureName;
    }

    protected String _getFullName(XFeatureCall call) {
        return call.getConcreteSyntaxFeatureName();
    }

    protected Object evaluateField(XAbstractFeatureCall call, JvmField field, Context context) {
        try {
            Resource _eResource = field.eResource();
            if (_eResource instanceof TypeResource) {
                JvmDeclaredType _declaringType = field.getDeclaringType();
                ClassFinder _classFinder = context.getClassFinder();
                Class<?> clazz = this.getJavaType((JvmType)_declaringType, _classFinder);
                String _simpleName = field.getSimpleName();
                Field _field = clazz.getField(_simpleName);
                Object _get = null;
                if (_field != null) {
                    _get = _field.get(null);
                }
                return _get;
            }
            XExpression expression = this.containerProvider.getAssociatedExpression((JvmIdentifiableElement)field);
            Set _alreadyEvaluating = context.getAlreadyEvaluating();
            boolean _contains = _alreadyEvaluating.contains(expression);
            if (_contains) {
                throw new ConstantExpressionEvaluationException("Endless recursive evaluation detected.");
            }
            try {
                Map<String, JvmIdentifiableElement> visibleFeatures = this.findVisibleFeatures(expression);
                JvmTypeReference _type = field.getType();
                ClassFinder _classFinder_1 = context.getClassFinder();
                Set _alreadyEvaluating_1 = context.getAlreadyEvaluating();
                Context ctx = new Context(_type, _classFinder_1, visibleFeatures, _alreadyEvaluating_1);
                return this.evaluate(expression, ctx);
            }
            catch (Throwable _t) {
                if (_t instanceof ConstantExpressionEvaluationException) {
                    ConstantExpressionEvaluationException e = (ConstantExpressionEvaluationException)_t;
                    throw new StackedConstantExpressionEvaluationException((XExpression)call, field, e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Class<?> getJavaType(JvmType type, ClassFinder classFinder) throws ClassNotFoundException {
        if (type instanceof JvmArrayType) {
            JvmType t = type;
            String dimensions = "";
            while (t instanceof JvmArrayType) {
                dimensions = String.valueOf(dimensions) + "[]";
                JvmComponentType _componentType = ((JvmArrayType)t).getComponentType();
                t = _componentType;
            }
            Class<?> componentClass = this.getJavaType(t, classFinder);
            String _name = componentClass.getName();
            String _plus = String.valueOf(_name) + dimensions;
            return (Class)classFinder.forName(_plus);
        }
        String _identifier = type.getIdentifier();
        boolean _equals = Objects.equal((Object)_identifier, (Object)"java.lang.Class");
        if (_equals) {
            return JvmTypeReference.class;
        }
        if (type instanceof JvmEnumerationType) {
            return JvmEnumerationLiteral.class;
        }
        if (type instanceof JvmAnnotationType) {
            return XAnnotation.class;
        }
        String _identifier_1 = type.getIdentifier();
        return (Class)classFinder.forName(_identifier_1);
    }

    protected void resolveType(XAbstractFeatureCall featureCall, JvmIdentifiableElement feature) {
        TypeLiteralLinkingCandidateResolver _typeLiteralLinkingCandidateResolver = new TypeLiteralLinkingCandidateResolver(featureCall);
        _typeLiteralLinkingCandidateResolver.resolveLinkingProxy((InternalEObject)featureCall, feature, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0);
    }

    protected void resolveFeature(XAbstractFeatureCall featureCall, JvmIdentifiableElement feature) {
        PendingLinkingCandidateResolver _pendingLinkingCandidateResolver = new PendingLinkingCandidateResolver((XExpression)featureCall);
        _pendingLinkingCandidateResolver.resolveLinkingProxy((InternalEObject)featureCall, feature, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0);
    }

    public Object internalEvaluate(XExpression it, Context ctx) {
        if (it instanceof XBinaryOperation) {
            return this._internalEvaluate((XBinaryOperation)it, ctx);
        }
        if (it instanceof XFeatureCall) {
            return this._internalEvaluate((XFeatureCall)it, ctx);
        }
        if (it instanceof XListLiteral) {
            return this._internalEvaluate((XListLiteral)it, ctx);
        }
        if (it instanceof XMemberFeatureCall) {
            return this._internalEvaluate((XMemberFeatureCall)it, ctx);
        }
        if (it instanceof XUnaryOperation) {
            return this._internalEvaluate((XUnaryOperation)it, ctx);
        }
        if (it instanceof XBooleanLiteral) {
            return this._internalEvaluate((XBooleanLiteral)it, ctx);
        }
        if (it instanceof XCastedExpression) {
            return this._internalEvaluate((XCastedExpression)it, ctx);
        }
        if (it instanceof XNumberLiteral) {
            return this._internalEvaluate((XNumberLiteral)it, ctx);
        }
        if (it instanceof XStringLiteral) {
            return this._internalEvaluate((XStringLiteral)it, ctx);
        }
        if (it instanceof XTypeLiteral) {
            return this._internalEvaluate((XTypeLiteral)it, ctx);
        }
        if (it instanceof XAnnotation) {
            return this._internalEvaluate((XAnnotation)it, ctx);
        }
        if (it != null) {
            return this._internalEvaluate(it, ctx);
        }
        if (it == null) {
            return this._internalEvaluate(null, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, ctx).toString());
    }

    public String getFullName(XExpression call) {
        if (call instanceof XFeatureCall) {
            return this._getFullName((XFeatureCall)call);
        }
        if (call instanceof XMemberFeatureCall) {
            return this._getFullName((XMemberFeatureCall)call);
        }
        if (call != null) {
            return this._getFullName(call);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(call).toString());
    }

    public static class VisibleFieldsCollector {
        public void collect(JvmDeclaredType type, Map<String, JvmIdentifiableElement> result) {
            HashSet _newHashSet = CollectionLiterals.newHashSet((Object[])new JvmType[0]);
            this.collect(type, _newHashSet, result);
        }

        private void collect(JvmDeclaredType type, Set<JvmType> seen, Map<String, JvmIdentifiableElement> result) {
            boolean _add = seen.add((JvmType)type);
            if (_add) {
                EList _members = type.getMembers();
                for (JvmMember member : _members) {
                    boolean _notEquals;
                    boolean _isStatic;
                    if (!(member instanceof JvmField)) continue;
                    boolean _and = false;
                    boolean _isFinal = ((JvmField)member).isFinal();
                    _and = !_isFinal ? false : (_isStatic = ((JvmField)member).isStatic());
                    if (!_and) continue;
                    String _simpleName = ((JvmField)member).getSimpleName();
                    JvmIdentifiableElement existing = result.put(_simpleName, (JvmIdentifiableElement)member);
                    boolean bl = _notEquals = !Objects.equal((Object)existing, null);
                    if (!_notEquals) continue;
                    String _simpleName_1 = existing.getSimpleName();
                    result.put(_simpleName_1, existing);
                }
                EList _superTypes = type.getSuperTypes();
                for (JvmTypeReference superType : _superTypes) {
                    boolean _eIsProxy;
                    boolean _not;
                    JvmType _type = null;
                    if (superType != null) {
                        _type = superType.getType();
                    }
                    JvmType rawSuperType = _type;
                    boolean _and_1 = false;
                    _and_1 = !(rawSuperType instanceof JvmDeclaredType) ? false : (_not = !(_eIsProxy = rawSuperType.eIsProxy()));
                    if (!_and_1) continue;
                    this.collect((JvmDeclaredType)rawSuperType, seen, result);
                }
            }
        }
    }
}

