/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.typesystem;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.jvmmodel.AnonymousClassUtil;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.typesystem.DispatchOperationBodyComputationState;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.CreateExtensionInfo;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.InferredTypeIndicator;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.internal.LogicalContainerAwareReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractReentrantTypeReferenceProvider;
import org.eclipse.xtext.xbase.typing.IJvmTypeReferenceProvider;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.impl.XComputedTypeReferenceImplCustom;

public class XtendReentrantTypeResolver
extends LogicalContainerAwareReentrantTypeResolver {
    @Inject
    private DispatchHelper dispatchHelper;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private IJvmModelAssociator associator;
    @Inject
    private AnonymousClassUtil anonymousClassUtil;
    @Inject
    private JvmTypesBuilder typesBuilder;
    @Inject
    private OverrideTester overrideTester;

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session) {
        EObject root = this.getRoot();
        if (root instanceof XtendTypeDeclaration) {
            this.computeTypes(resolvedTypes, session, root);
        } else {
            super.computeTypes(resolvedTypes, session);
        }
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, EObject element) {
        if (element instanceof XtendTypeDeclaration) {
            if (element == this.getRoot()) {
                this.computeTypes(resolvedTypes, featureScopeSession, (XtendTypeDeclaration)element);
            }
        } else if (element instanceof XtendMember) {
            this.computeTypes(resolvedTypes, featureScopeSession, (XtendMember)element);
        } else {
            super.computeTypes(resolvedTypes, featureScopeSession, element);
        }
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, XtendTypeDeclaration typeDeclaration) {
        this.computeXtendAnnotationTypes(resolvedTypes, featureScopeSession, (List<XAnnotation>)typeDeclaration.getAnnotations());
        for (XtendMember member : typeDeclaration.getMembers()) {
            this.computeTypes(resolvedTypes, featureScopeSession, member);
        }
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, XtendMember member) {
        XExpression expression = null;
        if (member instanceof XtendFunction) {
            XtendFunction function = (XtendFunction)member;
            expression = function.getExpression();
            CreateExtensionInfo createInfo = function.getCreateExtensionInfo();
            if (createInfo != null) {
                this.computeDanglingExpressionType(resolvedTypes, featureScopeSession, function, createInfo.getCreateExpression());
            }
            for (XtendParameter parameter : function.getParameters()) {
                this.computeXtendAnnotationTypes(resolvedTypes, featureScopeSession, (List<XAnnotation>)parameter.getAnnotations());
            }
        } else if (member instanceof XtendConstructor) {
            XtendConstructor constructor = (XtendConstructor)member;
            expression = constructor.getExpression();
            for (XtendParameter parameter : constructor.getParameters()) {
                this.computeXtendAnnotationTypes(resolvedTypes, featureScopeSession, (List<XAnnotation>)parameter.getAnnotations());
            }
        } else if (member instanceof XtendField) {
            expression = ((XtendField)member).getInitialValue();
        }
        if (expression != null) {
            this.computeDanglingExpressionType(resolvedTypes, featureScopeSession, member, expression);
        }
        this.computeXtendAnnotationTypes(resolvedTypes, featureScopeSession, (List<XAnnotation>)member.getAnnotations());
    }

    protected void computeDanglingExpressionType(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, XtendMember member, XExpression expression) {
        if (!this.allRootedExpressions.contains(expression)) {
            this.rootedInstances.add(expression);
            IFeatureScopeSession session = member == null || member.isStatic() ? featureScopeSession : featureScopeSession.toInstanceContext();
            super.computeTypes(resolvedTypes, session, (EObject)expression);
        }
    }

    protected boolean isHandled(XExpression expression) {
        EObject root = this.getRoot();
        if (root instanceof XtendTypeDeclaration) {
            return this.doIsHandled(root, (EObject)expression);
        }
        return super.isHandled(expression);
    }

    protected boolean doIsHandled(EObject root, EObject instance) {
        AnonymousClass casted;
        if (root.eClass() == XtendPackage.Literals.ANONYMOUS_CLASS && ((casted = (AnonymousClass)root) == instance || EcoreUtil.isAncestor((EObject)casted.getConstructorCall(), (EObject)instance))) {
            return false;
        }
        boolean result = EcoreUtil.isAncestor((EObject)root, (EObject)instance);
        return result;
    }

    protected boolean isHandled(JvmIdentifiableElement identifiableElement) {
        EObject root = this.getRoot();
        if (root instanceof XtendTypeDeclaration) {
            return this.doIsHandled(root, (EObject)identifiableElement);
        }
        return super.isHandled(identifiableElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _computeTypes(Map<JvmIdentifiableElement, ResolvedTypes> preparedResolvedTypes, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmOperation operation) {
        ResolvedTypes childResolvedTypes = preparedResolvedTypes.get(operation);
        if (childResolvedTypes == null) {
            if (!preparedResolvedTypes.containsKey(operation)) throw new IllegalStateException("No resolved type found. Type was: " + operation.getIdentifier());
            return;
        }
        if (this.dispatchHelper.isDispatcherFunction(operation)) {
            preparedResolvedTypes.put((JvmIdentifiableElement)operation, null);
            this.computeAnnotationTypes(childResolvedTypes, featureScopeSession, (JvmExecutable)operation);
            this.mergeChildTypes(childResolvedTypes);
            return;
        }
        if (this.dispatchHelper.isDispatchFunction(operation) && InferredTypeIndicator.isInferred((JvmTypeReference)operation.getReturnType())) {
            JvmOperation dispatcher = this.dispatchHelper.getDispatcherOperation(operation);
            if (dispatcher == null) {
                super._computeTypes(preparedResolvedTypes, resolvedTypes, featureScopeSession, operation);
                return;
            }
            ArrayList<JvmOperation> dispatchCasesWithDeclaredReturnType = new ArrayList<JvmOperation>();
            ArrayList<JvmOperation> dispatchCasesWithInferredReturnType = new ArrayList<JvmOperation>();
            List<JvmOperation> dispatchCases = this.dispatchHelper.getLocalDispatchCases(dispatcher);
            for (JvmOperation dispatchCase : dispatchCases) {
                if (InferredTypeIndicator.isInferred((JvmTypeReference)dispatchCase.getReturnType())) {
                    dispatchCasesWithInferredReturnType.add(dispatchCase);
                    continue;
                }
                dispatchCasesWithDeclaredReturnType.add(dispatchCase);
            }
            try {
                ResolvedTypes dispatchCaseResolvedTypes;
                this.markComputing(dispatcher.getReturnType());
                LightweightTypeReference declaredDispatcherType = this.getReturnTypeOfOverriddenOperation(dispatcher, childResolvedTypes, featureScopeSession);
                ArrayList dispatchCaseResults = Lists.newArrayListWithCapacity((int)dispatchCases.size());
                LightweightTypeReference implicitVoid = null;
                LightweightTypeReference thrownVoid = null;
                for (JvmOperation dispatchCase : dispatchCasesWithDeclaredReturnType) {
                    dispatchCaseResolvedTypes = preparedResolvedTypes.get(dispatchCase);
                    if (dispatchCaseResolvedTypes == null && preparedResolvedTypes.containsKey(dispatchCase)) {
                        dispatchCaseResolvedTypes = childResolvedTypes;
                    }
                    if (dispatchCaseResolvedTypes == null) {
                        throw new IllegalStateException("No resolved type found. Type was: " + dispatchCase.getIdentifier());
                    }
                    dispatchCaseResults.add(dispatchCaseResolvedTypes.getActualType((JvmIdentifiableElement)dispatchCase));
                }
                for (JvmOperation dispatchCase : dispatchCasesWithInferredReturnType) {
                    ResolvedTypes resolvedTypes2 = dispatchCaseResolvedTypes = dispatchCase == operation ? childResolvedTypes : preparedResolvedTypes.get(dispatchCase);
                    if (dispatchCaseResolvedTypes == null) {
                        if (!preparedResolvedTypes.containsKey(dispatchCase)) throw new IllegalStateException("No resolved type found. Type was: " + dispatchCase.getIdentifier());
                        if (InferredTypeIndicator.isInferred((JvmTypeReference)dispatchCase.getReturnType())) {
                            if (declaredDispatcherType != null) continue;
                            dispatchCaseResults.add(childResolvedTypes.getActualType((JvmIdentifiableElement)dispatchCase));
                            continue;
                        }
                        dispatchCaseResults.add(childResolvedTypes.getActualType((JvmIdentifiableElement)dispatchCase));
                        continue;
                    }
                    preparedResolvedTypes.put((JvmIdentifiableElement)dispatchCase, null);
                    DispatchOperationBodyComputationState state = new DispatchOperationBodyComputationState(dispatchCaseResolvedTypes, dispatchCase.isStatic() ? featureScopeSession : featureScopeSession.toInstanceContext(), dispatchCase, dispatcher, declaredDispatcherType);
                    this.addExtensionProviders((ITypeComputationState)state, (List)dispatchCase.getParameters());
                    ITypeComputationResult dispatchCaseResult = null;
                    try {
                        this.markComputing(dispatchCase.getReturnType());
                        dispatchCaseResult = state.computeTypes();
                    }
                    finally {
                        this.unmarkComputing(dispatchCase.getReturnType());
                    }
                    if (InferredTypeIndicator.isInferred((JvmTypeReference)dispatchCase.getReturnType())) {
                        LightweightTypeReference returnType;
                        if (declaredDispatcherType == null && (returnType = dispatchCaseResult.getReturnType()) != null) {
                            if (returnType.isPrimitiveVoid()) {
                                int conformanceFlags = dispatchCaseResult.getConformanceFlags();
                                if ((conformanceFlags & 0x20000000) == 0) {
                                    if ((conformanceFlags & 0x4000000) != 0) {
                                        dispatchCaseResults.add(returnType);
                                    } else {
                                        implicitVoid = returnType;
                                    }
                                } else {
                                    thrownVoid = returnType;
                                }
                            } else {
                                dispatchCaseResults.add(returnType);
                            }
                        }
                    } else {
                        LightweightTypeReference explicitType = dispatchCaseResolvedTypes.getActualType((JvmIdentifiableElement)dispatchCase);
                        dispatchCaseResults.add(explicitType);
                    }
                    this.computeAnnotationTypes(dispatchCaseResolvedTypes, featureScopeSession, (JvmExecutable)dispatchCase);
                    this.computeLocalTypes(preparedResolvedTypes, dispatchCaseResolvedTypes, featureScopeSession, (JvmFeature)dispatchCase);
                    this.mergeChildTypes(dispatchCaseResolvedTypes);
                }
                LightweightTypeReference commonDispatchType = this.normalizeDispatchReturnType(declaredDispatcherType, dispatchCaseResults, implicitVoid, thrownVoid, childResolvedTypes);
                if (commonDispatchType == null) return;
                this.resolveDispatchCaseTypes(dispatcher, dispatchCasesWithInferredReturnType, commonDispatchType, featureScopeSession);
                return;
            }
            finally {
                this.unmarkComputing(dispatcher.getReturnType());
            }
        }
        super._computeTypes(preparedResolvedTypes, resolvedTypes, featureScopeSession, operation);
    }

    protected void resolveDispatchCaseTypes(JvmOperation dispatcher, List<JvmOperation> dispatchCases, LightweightTypeReference type, IFeatureScopeSession featureScopeSession) {
        if (InferredTypeIndicator.isInferred((JvmTypeReference)dispatcher.getReturnType())) {
            InferredTypeIndicator.resolveTo((JvmTypeReference)dispatcher.getReturnType(), (JvmTypeReference)this.toJavaCompliantTypeReference(type, featureScopeSession));
        }
        for (JvmOperation dispatchCase : dispatchCases) {
            if (!InferredTypeIndicator.isInferred((JvmTypeReference)dispatchCase.getReturnType())) continue;
            InferredTypeIndicator.resolveTo((JvmTypeReference)dispatchCase.getReturnType(), (JvmTypeReference)this.toJavaCompliantTypeReference(type, featureScopeSession));
        }
    }

    protected LightweightTypeReference normalizeDispatchReturnType(LightweightTypeReference declaredType, List<LightweightTypeReference> computedTypes, LightweightTypeReference implicitVoidOrNull, LightweightTypeReference thrownVoidOrNull, ResolvedTypes resolvedTypes) {
        LightweightTypeReference result = null;
        if (declaredType != null) {
            result = declaredType;
        } else {
            if (implicitVoidOrNull != null && !computedTypes.isEmpty()) {
                ArrayList wrapped = Lists.newArrayListWithCapacity((int)computedTypes.size());
                int i = 0;
                while (i < computedTypes.size()) {
                    wrapped.add(((LightweightTypeReference)computedTypes.get(i)).getWrapperTypeIfPrimitive());
                    ++i;
                }
                computedTypes = wrapped;
            }
            if (computedTypes.isEmpty() && implicitVoidOrNull != null) {
                result = implicitVoidOrNull;
            } else if (computedTypes.isEmpty()) {
                if (thrownVoidOrNull == null) {
                    throw new IllegalStateException("thrownVoidOrNull may not be null in this situation");
                }
                result = thrownVoidOrNull;
            } else {
                result = this.getServices().getTypeConformanceComputer().getCommonSuperType(computedTypes, resolvedTypes.getReferenceOwner());
            }
        }
        return result;
    }

    protected void computeXtendAnnotationTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, List<XAnnotation> annotations) {
        for (XAnnotation annotation : annotations) {
            this.computeDanglingExpressionType(resolvedTypes, featureScopeSession, null, (XExpression)annotation);
        }
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmField field, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        JvmTypeReference knownType = field.getType();
        if (InferredTypeIndicator.isInferred((JvmTypeReference)knownType)) {
            XtendFunction function;
            XComputedTypeReference castedKnownType = (XComputedTypeReference)knownType;
            EObject sourceElement = this.associations.getPrimarySourceElement((EObject)field);
            if (sourceElement instanceof XtendFunction && (function = (XtendFunction)sourceElement).getCreateExtensionInfo() != null) {
                JvmOperation operation = this.associations.getDirectlyInferredOperation(function);
                this.declareTypeParameters(resolvedTypes, (JvmIdentifiableElement)field, resolvedTypesByContext);
                XComputedTypeReference fieldType = this.getServices().getXtypeFactory().createXComputedTypeReference();
                fieldType.setTypeProvider((IJvmTypeReferenceProvider)new CreateCacheFieldTypeReferenceProvider(operation, resolvedTypes, featureScopeSession));
                castedKnownType.setEquivalent((JvmTypeReference)fieldType);
                return;
            }
        }
        super._doPrepare(resolvedTypes, featureScopeSession, field, resolvedTypesByContext);
        this.doPrepareLocalTypes(resolvedTypes, featureScopeSession, (JvmFeature)field, resolvedTypesByContext);
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmConstructor constructor, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        super._doPrepare(resolvedTypes, featureScopeSession, constructor, resolvedTypesByContext);
        this.doPrepareLocalTypes(resolvedTypes, featureScopeSession, (JvmFeature)constructor, resolvedTypesByContext);
    }

    protected IFeatureScopeSession addThisTypeToStaticScope(IFeatureScopeSession session, JvmDeclaredType type) {
        return session.addTypesToStaticScope(Collections.singletonList(type), Collections.singletonList(type));
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmOperation operation, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        JvmFormalParameter firstParameter;
        JvmTypeReference parameterType;
        XtendFunction function;
        EObject sourceElement;
        super._doPrepare(resolvedTypes, featureScopeSession, operation, resolvedTypesByContext);
        resolvedTypes = resolvedTypesByContext.get(operation);
        if (this.dispatchHelper.isDispatcherFunction(operation)) {
            EList parameters = operation.getParameters();
            int i = 0;
            while (i < parameters.size()) {
                JvmFormalParameter parameter = (JvmFormalParameter)parameters.get(i);
                JvmTypeReference parameterType2 = parameter.getParameterType();
                if (InferredTypeIndicator.isInferred((JvmTypeReference)parameterType2)) {
                    XComputedTypeReference casted = (XComputedTypeReference)parameterType2;
                    XComputedTypeReference computedParameterType = this.getServices().getXtypeFactory().createXComputedTypeReference();
                    computedParameterType.setTypeProvider((IJvmTypeReferenceProvider)new DispatchParameterTypeReferenceProvider(operation, i, resolvedTypes, featureScopeSession, this));
                    casted.setEquivalent((JvmTypeReference)computedParameterType);
                } else if (parameterType2 == null) {
                    XComputedTypeReference computedParameterType = this.getServices().getXtypeFactory().createXComputedTypeReference();
                    computedParameterType.setTypeProvider((IJvmTypeReferenceProvider)new DispatchParameterTypeReferenceProvider(operation, i, resolvedTypes, featureScopeSession, this));
                    parameter.setParameterType((JvmTypeReference)computedParameterType);
                }
                ++i;
            }
        } else if (operation.getParameters().size() >= 1 && (sourceElement = this.associations.getPrimarySourceElement((EObject)operation)) instanceof XtendFunction && (function = (XtendFunction)sourceElement).getCreateExtensionInfo() != null && InferredTypeIndicator.isInferred((JvmTypeReference)(parameterType = (firstParameter = (JvmFormalParameter)operation.getParameters().get(0)).getParameterType()))) {
            XComputedTypeReference casted = (XComputedTypeReference)parameterType;
            XComputedTypeReference computedParameterType = this.getServices().getXtypeFactory().createXComputedTypeReference();
            computedParameterType.setTypeProvider((IJvmTypeReferenceProvider)new InitializerParameterTypeReferenceProvider(function, resolvedTypesByContext, resolvedTypes, featureScopeSession, this));
            casted.setEquivalent((JvmTypeReference)computedParameterType);
        }
        this.doPrepareLocalTypes(resolvedTypes, featureScopeSession, (JvmFeature)operation, resolvedTypesByContext);
    }

    protected void doPrepareLocalTypes(final ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmFeature container, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        EList localClasses = container.getLocalClasses();
        for (final JvmGenericType localClass : localClasses) {
            JvmUnknownTypeReference superTypeReference;
            XConstructorCall constructorCall;
            IScope typeScope;
            JvmTypeReference superType = (JvmTypeReference)localClass.getSuperTypes().get(0);
            final IFeatureScopeSession nestedSession = featureScopeSession;
            if (!InferredTypeIndicator.isInferred((JvmTypeReference)superType)) continue;
            final XComputedTypeReference casted = (XComputedTypeReference)superType;
            InferredTypeIndicator typeProvider = (InferredTypeIndicator)casted.getTypeProvider();
            final AnonymousClass anonymousClass = (AnonymousClass)typeProvider.getExpression();
            JvmDeclaredType type = this.anonymousClassUtil.getSuperTypeNonResolving(anonymousClass, typeScope = featureScopeSession.getScope((EObject)(constructorCall = anonymousClass.getConstructorCall()), TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, (IResolvedTypes)resolvedTypes));
            if (type == null) {
                superTypeReference = TypesFactory.eINSTANCE.createJvmUnknownTypeReference();
                this.requestCapturedLocalVariables((JvmTypeReference)superTypeReference, (JvmDeclaredType)localClass, resolvedTypes, resolvedTypesByContext, (IAcceptor)new IAcceptor<JvmTypeReference>(){

                    public void accept(JvmTypeReference capturingTypeReference) {
                        casted.setEquivalent(capturingTypeReference);
                        XtendReentrantTypeResolver.this.inferAnonymousClassConstructor(anonymousClass, localClass);
                    }
                });
                continue;
            }
            superTypeReference = this.createSuperTypeReference((JvmType)type, constructorCall);
            this.requestCapturedLocalVariables((JvmTypeReference)superTypeReference, (JvmDeclaredType)localClass, resolvedTypes, resolvedTypesByContext, (IAcceptor)new IAcceptor<JvmTypeReference>((JvmParameterizedTypeReference)superTypeReference, type, anonymousClass){
                private final /* synthetic */ JvmParameterizedTypeReference val$superTypeReference;
                private final /* synthetic */ JvmDeclaredType val$type;
                private final /* synthetic */ AnonymousClass val$anonymousClass;
                {
                    this.val$superTypeReference = jvmParameterizedTypeReference;
                    this.val$type = jvmDeclaredType;
                    this.val$anonymousClass = anonymousClass;
                }

                public void accept(JvmTypeReference capturingTypeReference) {
                    casted.setEquivalent(capturingTypeReference);
                    IFeatureScopeSession mySession = XtendReentrantTypeResolver.this.addThisAndSuper(nestedSession, resolvedTypes.getReferenceOwner(), (JvmDeclaredType)localClass, (JvmTypeReference)this.val$superTypeReference, false);
                    if (this.val$type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)this.val$type).isInterface()) {
                        localClass.getSuperTypes().add(0, (Object)XtendReentrantTypeResolver.this.typesBuilder.newTypeRef((EObject)localClass, Object.class, new JvmTypeReference[0]));
                        XtendReentrantTypeResolver.this.inferAnonymousClassConstructor(this.val$anonymousClass, localClass);
                    } else {
                        for (JvmMember superMember : this.val$type.getMembers()) {
                            if (!(superMember instanceof JvmConstructor)) continue;
                            JvmConstructor superTypeConstructor = (JvmConstructor)superMember;
                            boolean visible = mySession.isVisible((JvmMember)superTypeConstructor);
                            XtendReentrantTypeResolver.this.inferAnonymousClassConstructor(this.val$anonymousClass, localClass, superTypeConstructor, visible);
                        }
                    }
                }
            });
        }
    }

    protected JvmParameterizedTypeReference createSuperTypeReference(JvmType superType, XConstructorCall constructorCall) {
        JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        result.setType(superType);
        for (JvmTypeReference typeReference : constructorCall.getTypeArguments()) {
            result.getArguments().add((Object)this.typesBuilder.cloneWithProxies(typeReference));
        }
        return result;
    }

    protected JvmConstructor inferAnonymousClassConstructor(AnonymousClass anonymousClass, JvmGenericType inferredLocalClass, JvmConstructor superConstructor, boolean visible) {
        JvmConstructor constructor = TypesFactory.eINSTANCE.createJvmConstructor();
        inferredLocalClass.getMembers().add((Object)constructor);
        this.associator.associatePrimary((EObject)anonymousClass.getConstructorCall(), (EObject)constructor);
        if (visible) {
            constructor.setVisibility(JvmVisibility.DEFAULT);
        } else {
            constructor.setVisibility(JvmVisibility.PRIVATE);
        }
        constructor.setSimpleName(inferredLocalClass.getSimpleName());
        EList parameters = superConstructor.getParameters();
        for (JvmFormalParameter parameter : parameters) {
            parameter.getName();
            constructor.getParameters().add((Object)((JvmFormalParameter)this.typesBuilder.cloneWithProxies((JvmIdentifiableElement)parameter)));
        }
        for (JvmTypeReference exception : superConstructor.getExceptions()) {
            constructor.getExceptions().add((Object)this.typesBuilder.cloneWithProxies(exception));
        }
        if (!parameters.isEmpty()) {
            this.typesBuilder.setBody((JvmExecutable)constructor, (Procedures.Procedure1)new Procedures.Procedure1<ITreeAppendable>((List)parameters){
                private final /* synthetic */ List val$parameters;
                {
                    this.val$parameters = list;
                }

                public void apply(ITreeAppendable a) {
                    a.append((CharSequence)"super(");
                    int i = 0;
                    while (i < this.val$parameters.size()) {
                        if (i != 0) {
                            a.append((CharSequence)", ");
                        }
                        a.append((CharSequence)((JvmFormalParameter)this.val$parameters.get(i)).getSimpleName());
                        ++i;
                    }
                    a.append((CharSequence)");");
                }
            });
        }
        return constructor;
    }

    @Deprecated
    protected JvmConstructor inferAnonymousClassConstructor(AnonymousClass anonymousClass, JvmGenericType inferredLocalClass, JvmDeclaredType superInterface) {
        return this.inferAnonymousClassConstructor(anonymousClass, inferredLocalClass);
    }

    protected JvmConstructor inferAnonymousClassConstructor(AnonymousClass anonymousClass, JvmGenericType inferredLocalClass) {
        XConstructorCall constructorCall = anonymousClass.getConstructorCall();
        JvmConstructor constructor = TypesFactory.eINSTANCE.createJvmConstructor();
        inferredLocalClass.getMembers().add((Object)constructor);
        this.associator.associatePrimary((EObject)constructorCall, (EObject)constructor);
        constructor.setVisibility(JvmVisibility.DEFAULT);
        constructor.setSimpleName(inferredLocalClass.getSimpleName());
        return constructor;
    }

    protected AbstractReentrantTypeReferenceProvider createTypeProvider(Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmMember member, boolean returnType) {
        JvmOperation operation;
        if (member instanceof JvmOperation && this.dispatchHelper.isDispatcherFunction(operation = (JvmOperation)member)) {
            return new DispatchReturnTypeReferenceProvider(operation, resolvedTypes, featureScopeSession, this);
        }
        return super.createTypeProvider(resolvedTypesByContext, resolvedTypes, featureScopeSession, member, returnType);
    }

    protected String getInvalidWritableVariableAccessMessage(XVariableDeclaration variable, XAbstractFeatureCall featureCall, IResolvedTypes resolvedTypes) {
        EObject containingStructure = this.getNearestClosureOrTypeDeclaration((EObject)featureCall, resolvedTypes);
        if (containingStructure != null && !EcoreUtil.isAncestor((EObject)containingStructure, (EObject)variable)) {
            if (containingStructure instanceof XClosure) {
                return String.format("Cannot %srefer to the non-final variable %s inside a lambda expression", this.getImplicitlyMessagePart(featureCall), variable.getSimpleName());
            }
            if (containingStructure instanceof RichString) {
                return String.format("Cannot %srefer to the non-final variable %s inside this template.\nThis template compiles to an anonymous subclass of StringConcatenationClient because of its target type.", this.getImplicitlyMessagePart(featureCall), variable.getSimpleName());
            }
            return String.format("Cannot %srefer to the non-final variable %s inside a local class", this.getImplicitlyMessagePart(featureCall), variable.getSimpleName());
        }
        return null;
    }

    protected LightweightTypeReference getReturnTypeOfOverriddenOperation(JvmOperation operation, ResolvedTypes resolvedTypes, IFeatureScopeSession session) {
        if (operation.getVisibility() == JvmVisibility.PRIVATE) {
            return null;
        }
        if (InferredTypeIndicator.isInferred((JvmTypeReference)operation.getReturnType())) {
            LightweightTypeReference declaringType = resolvedTypes.getActualType((JvmIdentifiableElement)operation.getDeclaringType());
            if (declaringType == null) {
                throw new IllegalStateException("Cannot determine declaring type of operation: " + operation);
            }
            BottomResolvedOperation resolvedOperation = new BottomResolvedOperation(operation, declaringType, this.overrideTester);
            List overriddenMethods = resolvedOperation.getOverriddenAndImplementedMethods();
            if (overriddenMethods.isEmpty()) {
                return null;
            }
            IResolvedOperation overriddenMethod = (IResolvedOperation)overriddenMethods.get(0);
            JvmOperation declaration = overriddenMethod.getDeclaration();
            XExpression inferredFrom = this.getInferredFrom(declaration.getReturnType());
            if (inferredFrom != null && (inferredFrom == this.getInferredFrom(operation.getReturnType()) || this.isHandled(inferredFrom))) {
                return null;
            }
            LightweightTypeReference result = overriddenMethod.getResolvedReturnType();
            return result;
        }
        return null;
    }

    private EObject getNearestClosureOrTypeDeclaration(EObject object, IResolvedTypes resolvedTypes) {
        EObject candidate = object;
        while (candidate != null) {
            LightweightTypeReference type;
            if (candidate instanceof XClosure) {
                return candidate;
            }
            if (candidate instanceof XConstructorCall) {
                if (candidate.eContainingFeature() == XtendPackage.Literals.ANONYMOUS_CLASS__CONSTRUCTOR_CALL) {
                    candidate = candidate.eContainer();
                }
            } else if (candidate instanceof XtendTypeDeclaration) {
                return candidate;
            }
            if (candidate instanceof RichString && (type = resolvedTypes.getActualType((XExpression)((RichString)candidate))) != null && type.isType(StringConcatenationClient.class)) {
                return candidate;
            }
            candidate = candidate.eContainer();
        }
        return null;
    }

    public class CreateCacheFieldTypeReferenceProvider
    extends AbstractReentrantTypeReferenceProvider {
        private final JvmOperation createOperation;
        private final ResolvedTypes resolvedTypes;
        private final IFeatureScopeSession session;

        public CreateCacheFieldTypeReferenceProvider(JvmOperation createOperation, ResolvedTypes resolvedTypes, IFeatureScopeSession session) {
            this.createOperation = createOperation;
            this.resolvedTypes = resolvedTypes;
            this.session = session;
        }

        protected JvmTypeReference doGetTypeReference(XComputedTypeReferenceImplCustom context) {
            JvmTypeReference declaredReturnType = this.createOperation.getReturnType();
            TypeReferences typeReferences = this.resolvedTypes.getServices().getTypeReferences();
            ITypeReferenceOwner owner = this.resolvedTypes.getReferenceOwner();
            JvmType arrayList = typeReferences.findDeclaredType(ArrayList.class, (Notifier)this.createOperation);
            ParameterizedTypeReference arrayListReference = owner.newParameterizedTypeReference(arrayList);
            JvmType objectType = typeReferences.findDeclaredType(Object.class, (Notifier)this.createOperation);
            WildcardTypeReference wildcard = owner.newWildcardTypeReference();
            wildcard.addUpperBound((LightweightTypeReference)owner.newParameterizedTypeReference(objectType));
            arrayListReference.addTypeArgument((LightweightTypeReference)wildcard);
            JvmType hashMap = typeReferences.findDeclaredType(HashMap.class, (Notifier)this.createOperation);
            ParameterizedTypeReference hashMapReference = owner.newParameterizedTypeReference(hashMap);
            hashMapReference.addTypeArgument((LightweightTypeReference)arrayListReference);
            hashMapReference.addTypeArgument(owner.toLightweightTypeReference(declaredReturnType));
            return XtendReentrantTypeResolver.this.toJavaCompliantTypeReference((LightweightTypeReference)hashMapReference, this.session);
        }
    }

    public static class DispatchParameterTypeReferenceProvider
    extends AbstractReentrantTypeReferenceProvider {
        private final JvmOperation operation;
        private final ResolvedTypes resolvedTypes;
        private final int idx;
        private final IFeatureScopeSession session;
        private final XtendReentrantTypeResolver typeResolver;

        public DispatchParameterTypeReferenceProvider(JvmOperation operation, int idx, ResolvedTypes resolvedTypes, IFeatureScopeSession session, XtendReentrantTypeResolver typeResolver) {
            this.idx = idx;
            this.operation = operation;
            this.resolvedTypes = resolvedTypes;
            this.session = session;
            this.typeResolver = typeResolver;
        }

        protected JvmTypeReference doGetTypeReference(XComputedTypeReferenceImplCustom context) {
            try {
                List<JvmOperation> cases = this.typeResolver.dispatchHelper.getAllDispatchCases(this.operation);
                TypeConformanceComputer conformanceComputer = this.typeResolver.getServices().getTypeConformanceComputer();
                ArrayList parameterTypes = Lists.newArrayListWithCapacity((int)cases.size());
                JvmOperation inheritedDispatcher = null;
                LightweightTypeReference inheritedParameterType = null;
                for (JvmOperation caseOperation : cases) {
                    if (caseOperation.eContainer() == this.operation.eContainer() || (inheritedDispatcher = this.typeResolver.dispatchHelper.getDispatcherOperation(caseOperation)) == null) continue;
                    JvmFormalParameter inheritedParameter = (JvmFormalParameter)inheritedDispatcher.getParameters().get(this.idx);
                    inheritedParameterType = this.resolvedTypes.getActualType((JvmIdentifiableElement)inheritedParameter);
                    break;
                }
                for (JvmOperation caseOperation : cases) {
                    JvmFormalParameter parameter = (JvmFormalParameter)caseOperation.getParameters().get(this.idx);
                    LightweightTypeReference parameterType = this.resolvedTypes.getActualType((JvmIdentifiableElement)parameter);
                    if (parameterType == null || parameterType.isType(Void.class)) continue;
                    if (inheritedParameterType != null) {
                        if (caseOperation.eContainer() != this.operation.eContainer() || inheritedParameterType.isAssignableFrom(parameterType)) continue;
                        XtendParameter xtendParameter = (XtendParameter)this.typeResolver.getSourceElement((EObject)parameter);
                        this.resolvedTypes.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "dispatch_functions_may_not_widen_inherited_signature", "Dispatch function cannot widen inherited parameter type " + inheritedParameterType.getHumanReadableName(), (EObject)xtendParameter.getParameterType(), null, -1, null));
                        continue;
                    }
                    parameterTypes.add(parameterType);
                }
                if (parameterTypes.isEmpty()) {
                    if (inheritedParameterType != null) {
                        JvmTypeReference jvmTypeReference = this.typeResolver.toJavaCompliantTypeReference(inheritedParameterType, this.session);
                        return jvmTypeReference;
                    }
                    JvmTypeReference jvmTypeReference = this.typeResolver.getServices().getTypeReferences().getTypeForName(Object.class, (Notifier)this.operation, new JvmTypeReference[0]);
                    return jvmTypeReference;
                }
                LightweightTypeReference parameterType = conformanceComputer.getCommonSuperType((List)parameterTypes, this.resolvedTypes.getReferenceOwner());
                if (parameterType == null) {
                    JvmTypeReference jvmTypeReference = this.resolvedTypes.getReferenceOwner().newUnknownTypeReference().toJavaCompliantTypeReference();
                    return jvmTypeReference;
                }
                JvmTypeReference jvmTypeReference = this.typeResolver.toJavaCompliantTypeReference(parameterType, this.session);
                return jvmTypeReference;
            }
            finally {
                context.unsetTypeProviderWithoutNotification();
            }
        }
    }

    public static class DispatchReturnTypeReferenceProvider
    extends LogicalContainerAwareReentrantTypeResolver.AbstractDemandTypeReferenceProvider {
        private final JvmOperation operation;
        private final ResolvedTypes resolvedTypes;
        private final IFeatureScopeSession session;
        private final XtendReentrantTypeResolver typeResolver;

        public DispatchReturnTypeReferenceProvider(JvmOperation operation, ResolvedTypes resolvedTypes, IFeatureScopeSession session, XtendReentrantTypeResolver typeResolver) {
            this.operation = operation;
            this.resolvedTypes = resolvedTypes;
            this.session = session;
            this.typeResolver = typeResolver;
        }

        protected JvmTypeReference doGetTypeReference(XComputedTypeReferenceImplCustom context) {
            try {
                LightweightTypeReference expectedType = this.typeResolver.getReturnTypeOfOverriddenOperation(this.operation, this.resolvedTypes, this.session);
                if (expectedType != null) {
                    JvmTypeReference jvmTypeReference = this.typeResolver.toJavaCompliantTypeReference(expectedType, this.session);
                    return jvmTypeReference;
                }
                List<JvmOperation> cases = this.typeResolver.dispatchHelper.getAllDispatchCases(this.operation);
                ArrayList types = Lists.newArrayListWithCapacity((int)cases.size());
                for (JvmOperation operation : cases) {
                    LightweightTypeReference caseType = this.resolvedTypes.getActualType((JvmIdentifiableElement)operation);
                    types.add(caseType);
                }
                TypeConformanceComputer conformanceComputer = this.typeResolver.getServices().getTypeConformanceComputer();
                if (types.isEmpty()) {
                    return null;
                }
                LightweightTypeReference result = conformanceComputer.getCommonSuperType((List)types, this.resolvedTypes.getReferenceOwner());
                if (result == null) {
                    Iterator iterator = types.iterator();
                    while (iterator.hasNext()) {
                        if (!((LightweightTypeReference)iterator.next()).isPrimitiveVoid()) continue;
                        iterator.remove();
                    }
                    result = conformanceComputer.getCommonSuperType((List)types, this.resolvedTypes.getReferenceOwner());
                    if (result == null) {
                        throw new UnsupportedOperationException("Cannot determine common super type of: " + types);
                    }
                }
                JvmTypeReference jvmTypeReference = this.typeResolver.toJavaCompliantTypeReference(result, this.session);
                return jvmTypeReference;
            }
            finally {
                context.unsetTypeProviderWithoutNotification();
            }
        }

        protected JvmTypeReference handleReentrantInvocation(XComputedTypeReferenceImplCustom context) {
            this.resolvedTypes.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.WARNING, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", "Cannot infer type from recursive usage. Type 'Object' is used.", this.typeResolver.getSourceElement((EObject)this.operation), null, -1, null));
            AnyTypeReference result = this.resolvedTypes.getReferenceOwner().newAnyTypeReference();
            return this.typeResolver.toJavaCompliantTypeReference((LightweightTypeReference)result, this.session);
        }
    }

    public static class InitializerParameterTypeReferenceProvider
    extends AbstractReentrantTypeReferenceProvider {
        private final ResolvedTypes resolvedTypes;
        private final XtendFunction createFunction;
        private final IFeatureScopeSession featureScopeSession;
        private final Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext;
        private final XtendReentrantTypeResolver typeResolver;

        public InitializerParameterTypeReferenceProvider(XtendFunction createFunction, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, XtendReentrantTypeResolver typeResolver) {
            this.createFunction = createFunction;
            this.resolvedTypesByContext = resolvedTypesByContext;
            this.resolvedTypes = resolvedTypes;
            this.featureScopeSession = featureScopeSession;
            this.typeResolver = typeResolver;
        }

        protected JvmTypeReference doGetTypeReference(XComputedTypeReferenceImplCustom context) {
            try {
                CreateExtensionInfo createExtensionInfo = this.createFunction.getCreateExtensionInfo();
                XExpression expression = createExtensionInfo.getCreateExpression();
                LightweightTypeReference actualType = this.resolvedTypes.getReturnType(expression);
                if (actualType == null) {
                    JvmOperation operation = this.typeResolver.associations.getDirectlyInferredOperation(this.createFunction);
                    IFeatureScopeSession session = operation.isStatic() ? this.featureScopeSession : this.featureScopeSession.toInstanceContext();
                    this.typeResolver.computeTypes(this.resolvedTypesByContext, this.resolvedTypes, session, (EObject)operation);
                    actualType = this.resolvedTypes.getReturnType(expression);
                }
                if (actualType == null) {
                    return null;
                }
                JvmTypeReference jvmTypeReference = this.typeResolver.toJavaCompliantTypeReference(actualType, this.featureScopeSession);
                return jvmTypeReference;
            }
            finally {
                context.unsetTypeProviderWithoutNotification();
            }
        }
    }
}

