/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.authentication.tokens;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.cesecore.authentication.tokens.LocalJvmOnlyAuthenticationToken;
import org.cesecore.authorization.user.AccessUserAspect;
import org.cesecore.authorization.user.matchvalues.AccessMatchValue;

public class AlwaysAllowLocalAuthenticationToken
extends LocalJvmOnlyAuthenticationToken {
    private static final long serialVersionUID = -3942437717641924829L;

    public AlwaysAllowLocalAuthenticationToken(final Principal principal) {
        super((Set<? extends Principal>)new HashSet<Principal>(){
            private static final long serialVersionUID = 3125729459998373943L;
            {
                this.add(principal);
            }
        }, null);
    }

    @Override
    public boolean matches(AccessUserAspect accessUser) {
        return super.isCreatedInThisJvm();
    }

    @Override
    public boolean equals(Object authenticationToken) {
        if (this == authenticationToken) {
            return true;
        }
        if (authenticationToken == null) {
            return false;
        }
        return this.getClass() == authenticationToken.getClass();
    }

    @Override
    public int hashCode() {
        return "AlwaysAllowLocalAuthenticationToken".hashCode();
    }

    @Override
    public boolean matchTokenType(String tokenType) {
        return true;
    }

    @Override
    public AccessMatchValue getDefaultMatchValue() {
        return InternalMatchValue.DEFAULT;
    }

    @Override
    public AccessMatchValue getMatchValueFromDatabaseValue(Integer databaseValue) {
        return InternalMatchValue.INSTANCE;
    }

    private static enum InternalMatchValue implements AccessMatchValue
    {
        INSTANCE(0),
        DEFAULT(Integer.MAX_VALUE);

        private static final String TOKEN_TYPE = "AlwaysAllowAuthenticationToken";
        private final int numericValue;

        private InternalMatchValue(int numericValue) {
            this.numericValue = numericValue;
        }

        @Override
        public int getNumericValue() {
            return this.numericValue;
        }

        @Override
        public String getTokenType() {
            return TOKEN_TYPE;
        }

        @Override
        public boolean isIssuedByCa() {
            return false;
        }

        @Override
        public boolean isDefaultValue() {
            return this.numericValue == InternalMatchValue.DEFAULT.numericValue;
        }
    }
}

