/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.authentication.tokens;

import java.io.Serializable;
import java.security.Principal;
import java.util.Set;
import org.cesecore.authentication.AuthenticationFailedException;
import org.cesecore.authorization.user.AccessUserAspect;
import org.cesecore.authorization.user.matchvalues.AccessMatchValue;

public abstract class AuthenticationToken
implements Serializable {
    private static final long serialVersionUID = 1888731103952962350L;
    private final Set<? extends Principal> principals;
    private final Set<?> credentials;

    public AuthenticationToken(Set<? extends Principal> principals, Set<?> credentials) {
        this.principals = principals;
        this.credentials = credentials;
    }

    public Set<? extends Principal> getPrincipals() {
        return this.principals;
    }

    public Set<?> getCredentials() {
        return this.credentials;
    }

    public abstract boolean matches(AccessUserAspect var1) throws AuthenticationFailedException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<? extends Principal> principals = this.getPrincipals();
        if (principals != null) {
            for (Principal principal : principals) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(principal.getName());
            }
        }
        return sb.toString();
    }

    public abstract boolean matchTokenType(String var1);

    public abstract AccessMatchValue getDefaultMatchValue();

    public abstract AccessMatchValue getMatchValueFromDatabaseValue(Integer var1);
}

