/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.authentication.tokens;

import java.security.Principal;
import java.security.SecureRandom;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.cesecore.authentication.tokens.AuthenticationToken;

public abstract class LocalJvmOnlyAuthenticationToken
extends AuthenticationToken {
    private static final long serialVersionUID = -6830176240864231535L;
    private static final Logger log = Logger.getLogger(LocalJvmOnlyAuthenticationToken.class);
    private static final byte[] RANDOM_TOKEN = LocalJvmOnlyAuthenticationToken.createRandomToken();
    private transient byte[] authToken = RANDOM_TOKEN;

    protected LocalJvmOnlyAuthenticationToken(Set<? extends Principal> principals, Set<?> credentials) {
        super(principals, credentials);
    }

    protected final boolean isCreatedInThisJvm() {
        boolean isCreatedInThisJvm = ArrayUtils.isEquals((Object)this.authToken, (Object)RANDOM_TOKEN);
        if (log.isTraceEnabled()) {
            log.trace((Object)("isCreatedInThisJvm: " + isCreatedInThisJvm));
        }
        return isCreatedInThisJvm;
    }

    public void initRandomToken() {
        this.authToken = RANDOM_TOKEN;
    }

    private static byte[] createRandomToken() {
        byte[] token = new byte[32];
        new SecureRandom().nextBytes(token);
        return token;
    }
}

