/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.authentication.tokens;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.cesecore.authentication.tokens.InvalidAuthenticationTokenException;
import org.cesecore.authentication.tokens.LocalJvmOnlyAuthenticationToken;
import org.cesecore.authorization.user.AccessUserAspect;
import org.cesecore.authorization.user.matchvalues.AccessMatchValue;
import org.cesecore.authorization.user.matchvalues.AccessMatchValueReverseLookupRegistry;
import org.cesecore.authorization.user.matchvalues.X500PrincipalAccessMatchValue;
import org.cesecore.certificates.util.DNFieldExtractor;
import org.cesecore.util.CertTools;

public class X509CertificateAuthenticationToken
extends LocalJvmOnlyAuthenticationToken {
    public static final String TOKEN_TYPE = "CertificateAuthenticationToken";
    private static final Logger log = Logger.getLogger(X509CertificateAuthenticationToken.class);
    private static final long serialVersionUID = 1097165653913865515L;
    private static final Pattern serialPattern = Pattern.compile("\\bSERIALNUMBER=", 2);
    private final X509Certificate certificate;
    private final int adminCaId;
    private final DNFieldExtractor dnExtractor;
    private final DNFieldExtractor anExtractor;

    public X509CertificateAuthenticationToken(Set<X500Principal> principals, Set<X509Certificate> credentials) {
        super(principals, credentials);
        X509Certificate[] certificateArray = this.getCredentials().toArray(new X509Certificate[0]);
        if (certificateArray.length != 1) {
            throw new InvalidAuthenticationTokenException("X509CertificateAuthenticationToken was containing " + certificateArray.length + " credentials instead of 1.");
        }
        this.certificate = certificateArray[0];
        String certstring = CertTools.getSubjectDN(this.certificate).toString();
        this.adminCaId = CertTools.getIssuerDN(this.certificate).hashCode();
        certstring = serialPattern.matcher(certstring).replaceAll("SN=");
        String altNameString = CertTools.getSubjectAlternativeName(this.certificate);
        this.dnExtractor = new DNFieldExtractor(certstring, 0);
        this.anExtractor = new DNFieldExtractor(altNameString, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(AccessUserAspect accessUser) {
        if (!super.isCreatedInThisJvm()) {
            return false;
        }
        boolean returnvalue = false;
        int size = 0;
        String[] clientstrings = null;
        if (StringUtils.equals((String)TOKEN_TYPE, (String)accessUser.getTokenType())) {
            if (accessUser.getCaId() == this.adminCaId) {
                DNFieldExtractor usedExtractor = this.dnExtractor;
                X500PrincipalAccessMatchValue matchValue = (X500PrincipalAccessMatchValue)this.getMatchValueFromDatabaseValue(accessUser.getMatchWith());
                if (matchValue == X500PrincipalAccessMatchValue.WITH_SERIALNUMBER) {
                    try {
                        BigInteger matchValueAsBigInteger = new BigInteger(accessUser.getMatchValue(), 16);
                        switch (accessUser.getMatchTypeAsType()) {
                            case TYPE_EQUALCASE: 
                            case TYPE_EQUALCASEINS: {
                                return matchValueAsBigInteger.equals(this.certificate.getSerialNumber());
                            }
                            case TYPE_NOT_EQUALCASE: 
                            case TYPE_NOT_EQUALCASEINS: {
                                if (matchValueAsBigInteger.equals(this.certificate.getSerialNumber())) return false;
                                return true;
                            }
                        }
                        return returnvalue;
                    }
                    catch (NumberFormatException nfe) {
                        log.info((Object)("Invalid matchValue for accessUser when expecting a hex serialNumber: " + accessUser.getMatchValue()));
                    }
                    return returnvalue;
                } else if (matchValue == X500PrincipalAccessMatchValue.WITH_FULLDN) {
                    String value = accessUser.getMatchValue();
                    switch (accessUser.getMatchTypeAsType()) {
                        case TYPE_EQUALCASE: {
                            returnvalue = value.equals(CertTools.getSubjectDN(this.certificate));
                        }
                        case TYPE_EQUALCASEINS: {
                            return value.equalsIgnoreCase(CertTools.getSubjectDN(this.certificate));
                        }
                        case TYPE_NOT_EQUALCASE: {
                            returnvalue = !value.equals(CertTools.getSubjectDN(this.certificate));
                        }
                        case TYPE_NOT_EQUALCASEINS: {
                            if (value.equalsIgnoreCase(CertTools.getSubjectDN(this.certificate))) return false;
                            return true;
                        }
                    }
                    return returnvalue;
                } else {
                    int i;
                    int parameter = 2;
                    switch (matchValue) {
                        case WITH_COUNTRY: {
                            parameter = 13;
                            break;
                        }
                        case WITH_DOMAINCOMPONENT: {
                            parameter = 12;
                            break;
                        }
                        case WITH_STATEORPROVINCE: {
                            parameter = 11;
                            break;
                        }
                        case WITH_LOCALITY: {
                            parameter = 10;
                            break;
                        }
                        case WITH_ORGANIZATION: {
                            parameter = 9;
                            break;
                        }
                        case WITH_ORGANIZATIONALUNIT: {
                            parameter = 8;
                            break;
                        }
                        case WITH_TITLE: {
                            parameter = 7;
                            break;
                        }
                        case WITH_DNSERIALNUMBER: {
                            parameter = 3;
                            break;
                        }
                        case WITH_COMMONNAME: {
                            parameter = 2;
                            break;
                        }
                        case WITH_UID: {
                            parameter = 1;
                            break;
                        }
                        case WITH_DNEMAILADDRESS: {
                            parameter = 0;
                            break;
                        }
                        case WITH_RFC822NAME: {
                            parameter = 17;
                            usedExtractor = this.anExtractor;
                            break;
                        }
                        case WITH_UPN: {
                            parameter = 25;
                            usedExtractor = this.anExtractor;
                            break;
                        }
                    }
                    size = usedExtractor.getNumberOfFields(parameter);
                    clientstrings = new String[size];
                    for (i = 0; i < size; ++i) {
                        clientstrings[i] = usedExtractor.getField(parameter, i);
                    }
                    if (clientstrings == null) return returnvalue;
                    switch (accessUser.getMatchTypeAsType()) {
                        case TYPE_EQUALCASE: {
                            i = 0;
                            while (i < size) {
                                returnvalue = clientstrings[i].equals(accessUser.getMatchValue());
                                if (returnvalue) return returnvalue;
                                ++i;
                            }
                            return returnvalue;
                        }
                        case TYPE_EQUALCASEINS: {
                            i = 0;
                            while (i < size) {
                                returnvalue = clientstrings[i].equalsIgnoreCase(accessUser.getMatchValue());
                                if (returnvalue) return returnvalue;
                                ++i;
                            }
                            return returnvalue;
                        }
                        case TYPE_NOT_EQUALCASE: {
                            i = 0;
                            while (i < size) {
                                if (!clientstrings[i].equals(accessUser.getMatchValue())) {
                                    return true;
                                }
                                boolean bl = returnvalue = false;
                                if (returnvalue) return returnvalue;
                                ++i;
                            }
                            return returnvalue;
                        }
                        case TYPE_NOT_EQUALCASEINS: {
                            i = 0;
                            while (i < size) {
                                if (!clientstrings[i].equalsIgnoreCase(accessUser.getMatchValue())) {
                                    return true;
                                }
                                boolean bl = returnvalue = false;
                                if (returnvalue) return returnvalue;
                                ++i;
                            }
                            return returnvalue;
                        }
                    }
                }
                return returnvalue;
            } else {
                if (!log.isTraceEnabled()) return returnvalue;
                log.trace((Object)("Caid does not match. Required=" + this.adminCaId + ", actual was " + accessUser.getCaId()));
            }
            return returnvalue;
        } else {
            if (!log.isTraceEnabled()) return returnvalue;
            log.trace((Object)("Token type does not match. Required=CertificateAuthenticationToken, actual was " + accessUser.getTokenType()));
        }
        return returnvalue;
    }

    @Override
    public String toString() {
        return CertTools.getSubjectDN(this.certificate);
    }

    @Override
    public int hashCode() {
        int prime = 4711;
        int result = 1;
        result = 4711 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509CertificateAuthenticationToken other = (X509CertificateAuthenticationToken)obj;
        return !(this.certificate == null ? other.certificate != null : !this.certificate.equals(other.certificate));
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public boolean matchTokenType(String tokenType) {
        return tokenType.equals(TOKEN_TYPE);
    }

    @Override
    public AccessMatchValue getMatchValueFromDatabaseValue(Integer databaseValue) {
        return AccessMatchValueReverseLookupRegistry.INSTANCE.performReverseLookup(TOKEN_TYPE, databaseValue);
    }

    @Override
    public AccessMatchValue getDefaultMatchValue() {
        return X500PrincipalAccessMatchValue.NONE;
    }
}

