/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.authorization.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum AuditLogRules {
    BASE("/secureaudit"),
    CONFIGURE(BASE.resource() + "/management/manage"),
    EXPORT_LOGS(BASE.resource() + "/auditor/export"),
    VIEW(BASE.resource() + "/auditor/select"),
    VERIFY(BASE.resource() + "/auditor/verify"),
    LOG(BASE.resource() + "/log"),
    LOG_CUSTOM(BASE.resource() + "/log_custom_events");

    private final String resource;
    private static final List<String> allResources;

    private AuditLogRules(String resource) {
        this.resource = resource;
    }

    public String resource() {
        return this.resource;
    }

    public String toString() {
        return this.resource;
    }

    public static List<String> getAllResources() {
        return Collections.unmodifiableList(allResources);
    }

    static {
        allResources = new ArrayList<String>();
        for (AuditLogRules rule : AuditLogRules.values()) {
            allResources.add(rule.resource());
        }
    }
}

