/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.authorization.rules;

import java.util.HashMap;
import java.util.Map;

public enum AccessRuleState {
    RULE_NOTUSED("UNUSED", 0),
    RULE_ACCEPT("ACCEPT", 1),
    RULE_DECLINE("DECLINE", 2);

    private String name;
    private int databaseValue;
    private static Map<Integer, AccessRuleState> databaseValueToRuleMap;
    private static Map<String, AccessRuleState> nameToRuleMap;

    private AccessRuleState(String name, int databaseValue) {
        this.name = name;
        this.databaseValue = databaseValue;
    }

    public String getName() {
        return this.name;
    }

    public int getDatabaseValue() {
        return this.databaseValue;
    }

    public static AccessRuleState matchDatabaseValue(Integer value) {
        return databaseValueToRuleMap.get(value);
    }

    public static AccessRuleState matchName(String name) {
        return nameToRuleMap.get(name);
    }

    static {
        databaseValueToRuleMap = new HashMap<Integer, AccessRuleState>();
        nameToRuleMap = new HashMap<String, AccessRuleState>();
        for (AccessRuleState state : AccessRuleState.values()) {
            databaseValueToRuleMap.put(state.getDatabaseValue(), state);
            nameToRuleMap.put(state.getName(), state);
        }
    }
}

