/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.authorization.user;

import java.util.HashMap;
import java.util.Map;

public enum AccessMatchType {
    TYPE_EQUALCASE(1000),
    TYPE_EQUALCASEINS(1001),
    TYPE_NOT_EQUALCASE(1002),
    TYPE_NOT_EQUALCASEINS(1003),
    TYPE_NONE(1999);

    private int numericValue;
    private static Map<Integer, AccessMatchType> databaseLookup;
    private static Map<String, AccessMatchType> nameLookup;

    private AccessMatchType(int numericValue) {
        this.numericValue = numericValue;
    }

    public int getNumericValue() {
        return this.numericValue;
    }

    public static AccessMatchType matchFromDatabase(int numericValue) {
        return databaseLookup.get(numericValue);
    }

    public static AccessMatchType matchFromName(String name) {
        return nameLookup.get(name);
    }

    static {
        databaseLookup = new HashMap<Integer, AccessMatchType>();
        nameLookup = new HashMap<String, AccessMatchType>();
        for (AccessMatchType accessMatchType : AccessMatchType.values()) {
            databaseLookup.put(accessMatchType.numericValue, accessMatchType);
            nameLookup.put(accessMatchType.name(), accessMatchType);
        }
    }
}

