/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.authorization.user.matchvalues;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cesecore.authorization.user.matchvalues.AccessMatchValue;
import org.cesecore.authorization.user.matchvalues.InvalidMatchValueException;
import org.cesecore.authorization.user.matchvalues.ReverseMatchValueLookupException;

public enum AccessMatchValueReverseLookupRegistry {
    INSTANCE;

    private final Map<String, Map<String, AccessMatchValue>> nameLookupRegistry = new ConcurrentHashMap<String, Map<String, AccessMatchValue>>();
    private final Map<String, Map<Integer, AccessMatchValue>> idLookupRegistry = new ConcurrentHashMap<String, Map<Integer, AccessMatchValue>>();
    private final Map<String, AccessMatchValue> defaultValues = new ConcurrentHashMap<String, AccessMatchValue>();

    public Set<String> getAllTokenTypes() {
        return this.defaultValues.keySet();
    }

    public void register(AccessMatchValue[] values) {
        if (values.length > 0) {
            String tokenType = values[0].getTokenType();
            if (this.defaultValues.containsKey(tokenType)) {
                throw new InvalidMatchValueException(tokenType + " has already been registered.");
            }
            this.defaultValues.put(tokenType, values[0]);
            HashMap<String, AccessMatchValue> nameLookup = new HashMap<String, AccessMatchValue>();
            HashMap<Integer, AccessMatchValue> idLookup = new HashMap<Integer, AccessMatchValue>();
            for (AccessMatchValue value : values) {
                nameLookup.put(value.name(), value);
                idLookup.put(value.getNumericValue(), value);
                if (!value.isDefaultValue()) continue;
                this.defaultValues.put(tokenType, value);
            }
            this.nameLookupRegistry.put(tokenType, nameLookup);
            this.idLookupRegistry.put(tokenType, idLookup);
        }
    }

    public AccessMatchValue performReverseLookup(String tokenType, int databaseValue) {
        if (tokenType == null) {
            return null;
        }
        Map<Integer, AccessMatchValue> valueMap = this.idLookupRegistry.get(tokenType);
        if (valueMap == null) {
            return null;
        }
        return valueMap.get(databaseValue);
    }

    public AccessMatchValue lookupMatchValueFromTokenTypeAndName(String tokenType, String matchValueName) {
        Map<String, AccessMatchValue> valueMap = this.nameLookupRegistry.get(tokenType);
        if (valueMap == null) {
            throw new ReverseMatchValueLookupException("Token type of name " + tokenType + " not found.");
        }
        return valueMap.get(matchValueName);
    }

    public Map<String, AccessMatchValue> getNameLookupRegistryForTokenType(String tokenType) {
        Map<String, AccessMatchValue> valueMap = this.nameLookupRegistry.get(tokenType);
        if (valueMap == null) {
            throw new ReverseMatchValueLookupException("Token type of name " + tokenType + " not found.");
        }
        return valueMap;
    }

    public AccessMatchValue getDefaultValueForTokenType(String tokenType) {
        AccessMatchValue result = this.defaultValues.get(tokenType);
        if (!this.nameLookupRegistry.containsKey(tokenType)) {
            throw new ReverseMatchValueLookupException("Token type " + tokenType + " does not exist.");
        }
        return result;
    }
}

