/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.authorization.user.matchvalues;

import org.cesecore.authorization.user.matchvalues.AccessMatchValue;
import org.cesecore.authorization.user.matchvalues.AccessMatchValueReverseLookupRegistry;

public enum X500PrincipalAccessMatchValue implements AccessMatchValue
{
    NONE(0),
    WITH_COUNTRY(1),
    WITH_DOMAINCOMPONENT(2),
    WITH_STATEORPROVINCE(3),
    WITH_LOCALITY(4),
    WITH_ORGANIZATION(5),
    WITH_ORGANIZATIONALUNIT(6),
    WITH_TITLE(7),
    WITH_COMMONNAME(8),
    WITH_UID(9),
    WITH_DNSERIALNUMBER(10),
    WITH_SERIALNUMBER(11),
    WITH_DNEMAILADDRESS(12),
    WITH_RFC822NAME(13),
    WITH_UPN(14),
    WITH_FULLDN(15);

    private final int numericValue;

    private X500PrincipalAccessMatchValue(int numericValue) {
        this.numericValue = numericValue;
    }

    @Override
    public int getNumericValue() {
        return this.numericValue;
    }

    @Override
    public boolean isDefaultValue() {
        return this.numericValue == X500PrincipalAccessMatchValue.WITH_SERIALNUMBER.numericValue;
    }

    @Override
    public String getTokenType() {
        return "CertificateAuthenticationToken";
    }

    @Override
    public boolean isIssuedByCa() {
        return true;
    }

    static {
        AccessMatchValueReverseLookupRegistry.INSTANCE.register(X500PrincipalAccessMatchValue.values());
    }
}

