/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ca;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.operator.OperatorCreationException;
import org.cesecore.certificates.ca.CAInfo;
import org.cesecore.certificates.ca.CAOfflineException;
import org.cesecore.certificates.ca.CertificateGenerationParams;
import org.cesecore.certificates.ca.IllegalNameException;
import org.cesecore.certificates.ca.IllegalValidityException;
import org.cesecore.certificates.ca.InvalidAlgorithmException;
import org.cesecore.certificates.ca.SignRequestSignatureException;
import org.cesecore.certificates.ca.catoken.CAToken;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAService;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAServiceInfo;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAServiceNotActiveException;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAServiceRequest;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAServiceRequestException;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAServiceResponse;
import org.cesecore.certificates.ca.extendedservices.IllegalExtendedCAServiceRequestException;
import org.cesecore.certificates.certificate.CertificateCreateException;
import org.cesecore.certificates.certificate.certextensions.AvailableCustomCertificateExtensionsConfiguration;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.request.RequestMessage;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.crl.RevokedCertInfo;
import org.cesecore.certificates.endentity.EndEntityInformation;
import org.cesecore.certificates.util.AlgorithmConstants;
import org.cesecore.internal.InternalResources;
import org.cesecore.internal.UpgradeableDataHashMap;
import org.cesecore.keys.token.CryptoToken;
import org.cesecore.keys.token.CryptoTokenOfflineException;
import org.cesecore.util.Base64;
import org.cesecore.util.CertTools;
import org.cesecore.util.ValidityDate;

public abstract class CA
extends UpgradeableDataHashMap
implements Serializable {
    private static final long serialVersionUID = -8755429830955594642L;
    private static Logger log = Logger.getLogger(CA.class);
    private static final InternalResources intres = InternalResources.getInstance();
    public static final String CATYPE = "catype";
    protected static final String SUBJECTDN = "subjectdn";
    protected static final String CAID = "caid";
    protected static final String NAME = "name";
    protected static final String VALIDITY = "validity";
    protected static final String EXPIRETIME = "expiretime";
    protected static final String CERTIFICATECHAIN = "certificatechain";
    protected static final String ROLLOVERCERTIFICATECHAIN = "rollovercertificatechain";
    public static final String CATOKENDATA = "catoken";
    protected static final String SIGNEDBY = "signedby";
    protected static final String DESCRIPTION = "description";
    protected static final String REVOCATIONREASON = "revokationreason";
    protected static final String REVOCATIONDATE = "revokationdate";
    protected static final String CERTIFICATEPROFILEID = "certificateprofileid";
    protected static final String CRLPERIOD = "crlperiod";
    protected static final String DELTACRLPERIOD = "deltacrlperiod";
    protected static final String CRLISSUEINTERVAL = "crlIssueInterval";
    protected static final String CRLOVERLAPTIME = "crlOverlapTime";
    protected static final String CRLPUBLISHERS = "crlpublishers";
    private static final String FINISHUSER = "finishuser";
    protected static final String REQUESTCERTCHAIN = "requestcertchain";
    protected static final String EXTENDEDCASERVICES = "extendedcaservices";
    protected static final String EXTENDEDCASERVICE = "extendedcaservice";
    protected static final String APPROVALSETTINGS = "approvalsettings";
    protected static final String NUMBEROFREQAPPROVALS = "numberofreqapprovals";
    protected static final String INCLUDEINHEALTHCHECK = "includeinhealthcheck";
    private static final String DO_ENFORCE_UNIQUE_PUBLIC_KEYS = "doEnforceUniquePublicKeys";
    private static final String DO_ENFORCE_UNIQUE_DISTINGUISHED_NAME = "doEnforceUniqueDistinguishedName";
    private static final String DO_ENFORCE_UNIQUE_SUBJECTDN_SERIALNUMBER = "doEnforceUniqueSubjectDNSerialnumber";
    private static final String USE_CERTREQ_HISTORY = "useCertreqHistory";
    private static final String USE_USER_STORAGE = "useUserStorage";
    private static final String USE_CERTIFICATE_STORAGE = "useCertificateStorage";
    private static final String LATESTLINKCERTIFICATE = "latestLinkCertificate";
    private HashMap<Integer, ExtendedCAService> extendedcaservicemap = new HashMap();
    private ArrayList<Certificate> certificatechain = null;
    private ArrayList<Certificate> requestcertchain = null;
    private CAInfo cainfo = null;
    private CAToken caToken = null;

    protected CA() {
    }

    public CA(CAInfo cainfo) {
        this.init(cainfo);
    }

    public void init(CAInfo cainfo) {
        this.data = new LinkedHashMap();
        this.cainfo = cainfo;
        this.data.put(VALIDITY, cainfo.getValidity());
        this.setSignedBy(cainfo.getSignedBy());
        this.data.put(DESCRIPTION, cainfo.getDescription());
        this.data.put(REVOCATIONREASON, -1);
        this.data.put(CERTIFICATEPROFILEID, cainfo.getCertificateProfileId());
        this.setCRLPeriod(cainfo.getCRLPeriod());
        this.setCRLIssueInterval(cainfo.getCRLIssueInterval());
        this.setCRLOverlapTime(cainfo.getCRLOverlapTime());
        this.setDeltaCRLPeriod(cainfo.getDeltaCRLPeriod());
        this.setCRLPublishers(cainfo.getCRLPublishers());
        this.setFinishUser(cainfo.getFinishUser());
        this.setIncludeInHealthCheck(cainfo.getIncludeInHealthCheck());
        this.setDoEnforceUniquePublicKeys(cainfo.isDoEnforceUniquePublicKeys());
        this.setDoEnforceUniqueDistinguishedName(cainfo.isDoEnforceUniqueDistinguishedName());
        this.setDoEnforceUniqueSubjectDNSerialnumber(cainfo.isDoEnforceUniqueSubjectDNSerialnumber());
        this.setUseCertReqHistory(cainfo.isUseCertReqHistory());
        this.setUseUserStorage(cainfo.isUseUserStorage());
        this.setUseCertificateStorage(cainfo.isUseCertificateStorage());
        Iterator<ExtendedCAServiceInfo> iter = cainfo.getExtendedCAServiceInfos().iterator();
        ArrayList<Integer> extendedservicetypes = new ArrayList<Integer>();
        while (iter.hasNext()) {
            ExtendedCAServiceInfo next = iter.next();
            this.createExtendedCAService(next);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding extended service to CA '" + cainfo.getName() + "': " + next.getType() + ", " + next.getImplClass()));
            }
            extendedservicetypes.add(next.getType());
        }
        this.data.put(EXTENDEDCASERVICES, extendedservicetypes);
        this.setApprovalSettings(cainfo.getApprovalSettings());
        this.setNumOfRequiredApprovals(cainfo.getNumOfReqApprovals());
    }

    private void createExtendedCAService(ExtendedCAServiceInfo info) {
        try {
            Class<?> implClass = Class.forName(info.getImplClass());
            ExtendedCAService service = (ExtendedCAService)implClass.getConstructor(ExtendedCAServiceInfo.class).newInstance(info);
            this.setExtendedCAService(service);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"failed to add extended CA service: ", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"failed to add extended CA service: ", (Throwable)e);
        }
        catch (SecurityException e) {
            log.warn((Object)"failed to add extended CA service: ", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.warn((Object)"failed to add extended CA service: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"failed to add extended CA service: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.warn((Object)"failed to add extended CA service: ", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)"failed to add extended CA service: ", (Throwable)e);
        }
    }

    public CA(HashMap<Object, Object> data) {
        this.init(data);
    }

    public void init(HashMap<Object, Object> data) {
        this.loadData(data);
        this.extendedcaservicemap = new HashMap();
    }

    public void setCAInfo(CAInfo cainfo) {
        this.cainfo = cainfo;
    }

    public CAInfo getCAInfo() {
        return this.cainfo;
    }

    public String getSubjectDN() {
        return this.cainfo.getSubjectDN();
    }

    public void setSubjectDN(String subjectdn) {
        this.cainfo.subjectdn = subjectdn;
    }

    public int getCAId() {
        return this.cainfo.getCAId();
    }

    public void setCAId(int caid) {
        this.cainfo.caid = caid;
    }

    public String getName() {
        return this.cainfo.getName();
    }

    public void setName(String caname) {
        this.cainfo.name = caname;
    }

    public int getStatus() {
        return this.cainfo.getStatus();
    }

    public void setStatus(int status) {
        this.cainfo.status = status;
    }

    public int getCAType() {
        return (Integer)this.data.get(CATYPE);
    }

    public long getValidity() {
        return ((Number)this.data.get(VALIDITY)).longValue();
    }

    public void setValidity(long validity) {
        this.data.put(VALIDITY, validity);
    }

    public Date getExpireTime() {
        return (Date)this.data.get(EXPIRETIME);
    }

    public void setExpireTime(Date expiretime) {
        this.data.put(EXPIRETIME, expiretime);
    }

    public int getSignedBy() {
        return (Integer)this.data.get(SIGNEDBY);
    }

    public void setSignedBy(int signedby) {
        this.data.put(SIGNEDBY, signedby);
    }

    public String getDescription() {
        return (String)this.data.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.data.put(DESCRIPTION, description);
    }

    public int getRevocationReason() {
        return (Integer)this.data.get(REVOCATIONREASON);
    }

    public void setRevocationReason(int reason) {
        this.data.put(REVOCATIONREASON, reason);
    }

    public Date getRevocationDate() {
        return (Date)this.data.get(REVOCATIONDATE);
    }

    public void setRevocationDate(Date date) {
        this.data.put(REVOCATIONDATE, date);
    }

    public long getCRLPeriod() {
        return (Long)this.data.get(CRLPERIOD);
    }

    public void setCRLPeriod(long crlperiod) {
        this.data.put(CRLPERIOD, crlperiod);
    }

    public long getDeltaCRLPeriod() {
        if (this.data.containsKey(DELTACRLPERIOD)) {
            return (Long)this.data.get(DELTACRLPERIOD);
        }
        return 0L;
    }

    public void setDeltaCRLPeriod(long deltacrlperiod) {
        this.data.put(DELTACRLPERIOD, deltacrlperiod);
    }

    public long getCRLIssueInterval() {
        return (Long)this.data.get(CRLISSUEINTERVAL);
    }

    public void setCRLIssueInterval(long crlIssueInterval) {
        this.data.put(CRLISSUEINTERVAL, crlIssueInterval);
    }

    public long getCRLOverlapTime() {
        return (Long)this.data.get(CRLOVERLAPTIME);
    }

    public void setCRLOverlapTime(long crlOverlapTime) {
        this.data.put(CRLOVERLAPTIME, crlOverlapTime);
    }

    public Collection<Integer> getCRLPublishers() {
        return (Collection)this.data.get(CRLPUBLISHERS);
    }

    public void setCRLPublishers(Collection<Integer> crlpublishers) {
        this.data.put(CRLPUBLISHERS, crlpublishers);
    }

    public int getCertificateProfileId() {
        return (Integer)this.data.get(CERTIFICATEPROFILEID);
    }

    public CAToken getCAToken() {
        if (this.caToken == null) {
            HashMap tokendata = (HashMap)this.data.get(CATOKENDATA);
            CAToken ret = new CAToken(tokendata);
            String signaturealg = (String)tokendata.get("signaturealgorithm");
            String encryptionalg = (String)tokendata.get("encryptionalgorithm");
            String keysequence = "00000";
            Object seqo = tokendata.get("sequence");
            if (seqo != null) {
                keysequence = (String)seqo;
            }
            int keysequenceformat = 1;
            Object seqfo = tokendata.get("sequenceformat");
            if (seqfo != null) {
                keysequenceformat = (Integer)seqfo;
            }
            ret.setSignatureAlgorithm(signaturealg);
            ret.setEncryptionAlgorithm(encryptionalg);
            ret.setKeySequence(keysequence);
            ret.setKeySequenceFormat(keysequenceformat);
            this.caToken = ret;
        }
        return this.caToken;
    }

    public void setCAToken(CAToken catoken) throws InvalidAlgorithmException {
        String sigAlg = catoken.getSignatureAlgorithm();
        if (StringUtils.isNotEmpty((String)sigAlg) && !ArrayUtils.contains((Object[])AlgorithmConstants.AVAILABLE_SIGALGS, (Object)sigAlg)) {
            String msg = intres.getLocalizedMessage("createcert.invalidsignaturealg", sigAlg, ArrayUtils.toString((Object)AlgorithmConstants.AVAILABLE_SIGALGS));
            throw new InvalidAlgorithmException(msg);
        }
        String encAlg = catoken.getEncryptionAlgorithm();
        if (StringUtils.isNotEmpty((String)encAlg) && !ArrayUtils.contains((Object[])AlgorithmConstants.AVAILABLE_SIGALGS, (Object)encAlg)) {
            String msg = intres.getLocalizedMessage("createcert.invalidsignaturealg", encAlg, ArrayUtils.toString((Object)AlgorithmConstants.AVAILABLE_SIGALGS));
            throw new InvalidAlgorithmException(msg);
        }
        this.data.put(CATOKENDATA, catoken.saveData());
        this.caToken = catoken;
    }

    public Collection<Certificate> getRequestCertificateChain() {
        Collection storechain;
        if (this.requestcertchain == null && (storechain = (Collection)this.data.get(REQUESTCERTCHAIN)) != null) {
            this.requestcertchain = new ArrayList();
            for (String b64Cert : storechain) {
                try {
                    this.requestcertchain.add(CertTools.getCertfromByteArray(Base64.decode(b64Cert.getBytes())));
                }
                catch (CertificateParsingException e) {
                    throw new IllegalStateException("Database seems to contain invalid certificate information.", e);
                }
            }
        }
        return this.requestcertchain;
    }

    public void setRequestCertificateChain(Collection<Certificate> requestcertificatechain) {
        ArrayList<String> storechain = new ArrayList<String>();
        for (Certificate cert : requestcertificatechain) {
            try {
                storechain.add(new String(Base64.encode(cert.getEncoded())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.data.put(REQUESTCERTCHAIN, storechain);
        this.requestcertchain = new ArrayList();
        this.requestcertchain.addAll(requestcertificatechain);
    }

    public Collection<Certificate> getCertificateChain() {
        if (this.certificatechain == null) {
            Collection storechain = (Collection)this.data.get(CERTIFICATECHAIN);
            if (storechain == null) {
                return null;
            }
            Iterator iter = storechain.iterator();
            this.certificatechain = new ArrayList();
            while (iter.hasNext()) {
                String b64Cert = (String)iter.next();
                try {
                    Certificate cert = CertTools.getCertfromByteArray(Base64.decode(b64Cert.getBytes()));
                    if (cert != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Adding CA certificate from CERTIFICATECHAIN to certificatechain:");
                            log.debug((Object)("Cert subjectDN: " + CertTools.getSubjectDN(cert)));
                            log.debug((Object)("Cert issuerDN: " + CertTools.getIssuerDN(cert)));
                        }
                        this.certificatechain.add(cert);
                        continue;
                    }
                    throw new IllegalArgumentException("Can not create certificate object from: " + b64Cert);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.certificatechain;
    }

    public void setCertificateChain(Collection<Certificate> certificatechain) {
        Iterator<Certificate> iter = certificatechain.iterator();
        ArrayList<String> storechain = new ArrayList<String>();
        while (iter.hasNext()) {
            Certificate cert = iter.next();
            try {
                String b64Cert = new String(Base64.encode(cert.getEncoded()));
                storechain.add(b64Cert);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.data.put(CERTIFICATECHAIN, storechain);
        this.certificatechain = new ArrayList();
        this.certificatechain.addAll(certificatechain);
        this.cainfo.setCertificateChain(certificatechain);
    }

    public void setRolloverCertificateChain(Collection<Certificate> certificatechain) {
        Iterator<Certificate> iter = certificatechain.iterator();
        ArrayList<String> storechain = new ArrayList<String>();
        while (iter.hasNext()) {
            Certificate cert = iter.next();
            try {
                String b64Cert = new String(Base64.encode(cert.getEncoded()));
                storechain.add(b64Cert);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.data.put(ROLLOVERCERTIFICATECHAIN, storechain);
    }

    public List<Certificate> getRolloverCertificateChain() {
        List storechain = (List)this.data.get(ROLLOVERCERTIFICATECHAIN);
        if (storechain == null) {
            return null;
        }
        ArrayList<Certificate> chain = new ArrayList<Certificate>(storechain.size());
        for (Object o : storechain) {
            String b64Cert = (String)o;
            try {
                byte[] decoded = Base64.decode(b64Cert.getBytes("US-ASCII"));
                Certificate cert = CertTools.getCertfromByteArray(decoded);
                chain.add(cert);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            catch (CertificateParsingException e) {
                throw new IllegalStateException(e);
            }
        }
        return chain;
    }

    public void clearRolloverCertificateChain() {
        this.data.remove(ROLLOVERCERTIFICATECHAIN);
    }

    public Certificate getCACertificate() {
        if (this.certificatechain == null) {
            this.getCertificateChain();
            if (this.certificatechain == null) {
                return null;
            }
        }
        if (this.certificatechain.size() == 0) {
            return null;
        }
        Certificate ret = this.certificatechain.get(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("CA certificate chain is " + this.certificatechain.size() + " levels deep."));
            log.debug((Object)("CA-cert subjectDN: " + CertTools.getSubjectDN(ret)));
            log.debug((Object)("CA-cert issuerDN: " + CertTools.getIssuerDN(ret)));
        }
        return ret;
    }

    public boolean getUseNextCACert(RequestMessage request) {
        Certificate currentCert = this.getCACertificate();
        if (request == null) {
            log.trace((Object)"getUseNextCACert: request is null. most likely this is a new CA");
            return false;
        }
        BigInteger requestSerNo = request.getSerialNo();
        if (requestSerNo == null) {
            log.debug((Object)"getUseNextCACert: No serial number in request. Will use current CA cert.");
            return false;
        }
        BigInteger currentSerNo = CertTools.getSerialNumber(currentCert);
        if (currentSerNo == null || currentSerNo.equals(requestSerNo)) {
            log.trace((Object)"getUseNextCACert: CA serial number matches request serial number");
            return false;
        }
        List<Certificate> rolloverChain = this.getRolloverCertificateChain();
        if (rolloverChain == null || rolloverChain.isEmpty()) {
            log.debug((Object)"getUseNextCACert: Serial number in request does not match CA serial number, and no roll over certificate chain is present. Will use current CA cert.");
            return false;
        }
        Certificate rolloverCert = rolloverChain.get(0);
        BigInteger rolloverSerNo = CertTools.getSerialNumber(rolloverCert);
        if (rolloverSerNo != null && rolloverSerNo.equals(requestSerNo)) {
            log.debug((Object)"getUseNextCACert: Serial number in request matches next (rollover) CA cert. Using next CA cert and key.");
            return true;
        }
        log.debug((Object)"getUseNextCACert: Serial number in request does not match CA serial number nor next (rollover) CA cert. Will use current CA cert.");
        return false;
    }

    protected boolean getFinishUser() {
        return this.getBoolean(FINISHUSER, true);
    }

    private void setFinishUser(boolean finishuser) {
        this.putBoolean(FINISHUSER, finishuser);
    }

    protected boolean getIncludeInHealthCheck() {
        return this.getBoolean(INCLUDEINHEALTHCHECK, true);
    }

    protected void setIncludeInHealthCheck(boolean includeInHealthCheck) {
        this.putBoolean(INCLUDEINHEALTHCHECK, includeInHealthCheck);
    }

    public boolean isDoEnforceUniquePublicKeys() {
        return this.getBoolean(DO_ENFORCE_UNIQUE_PUBLIC_KEYS, false);
    }

    private void setDoEnforceUniquePublicKeys(boolean doEnforceUniquePublicKeys) {
        this.putBoolean(DO_ENFORCE_UNIQUE_PUBLIC_KEYS, doEnforceUniquePublicKeys);
    }

    public boolean isDoEnforceUniqueDistinguishedName() {
        return this.getBoolean(DO_ENFORCE_UNIQUE_DISTINGUISHED_NAME, false);
    }

    private void setDoEnforceUniqueDistinguishedName(boolean doEnforceUniqueDistinguishedName) {
        this.putBoolean(DO_ENFORCE_UNIQUE_DISTINGUISHED_NAME, doEnforceUniqueDistinguishedName);
    }

    public boolean isDoEnforceUniqueSubjectDNSerialnumber() {
        return this.getBoolean(DO_ENFORCE_UNIQUE_SUBJECTDN_SERIALNUMBER, false);
    }

    private void setDoEnforceUniqueSubjectDNSerialnumber(boolean doEnforceUniqueSubjectDNSerialnumber) {
        this.putBoolean(DO_ENFORCE_UNIQUE_SUBJECTDN_SERIALNUMBER, doEnforceUniqueSubjectDNSerialnumber);
    }

    public boolean isUseCertReqHistory() {
        return this.getBoolean(USE_CERTREQ_HISTORY, true);
    }

    private void setUseCertReqHistory(boolean useCertReqHistory) {
        this.putBoolean(USE_CERTREQ_HISTORY, useCertReqHistory);
    }

    public boolean isUseUserStorage() {
        return this.getBoolean(USE_USER_STORAGE, true);
    }

    private void setUseUserStorage(boolean useUserStorage) {
        this.putBoolean(USE_USER_STORAGE, useUserStorage);
    }

    public boolean isUseCertificateStorage() {
        return this.getBoolean(USE_CERTIFICATE_STORAGE, true);
    }

    private void setUseCertificateStorage(boolean useCertificateStorage) {
        this.putBoolean(USE_CERTIFICATE_STORAGE, useCertificateStorage);
    }

    public Collection<Integer> getApprovalSettings() {
        if (this.data.get(APPROVALSETTINGS) == null) {
            return new ArrayList<Integer>();
        }
        return (Collection)this.data.get(APPROVALSETTINGS);
    }

    public void setApprovalSettings(Collection<Integer> approvalSettings) {
        this.data.put(APPROVALSETTINGS, approvalSettings);
    }

    public int getNumOfRequiredApprovals() {
        if (this.data.get(NUMBEROFREQAPPROVALS) == null) {
            return 1;
        }
        return (Integer)this.data.get(NUMBEROFREQAPPROVALS);
    }

    public void setNumOfRequiredApprovals(int numOfReqApprovals) {
        this.data.put(NUMBEROFREQAPPROVALS, numOfReqApprovals);
    }

    public void updateCA(CryptoToken cryptoToken, CAInfo cainfo, AvailableCustomCertificateExtensionsConfiguration cceConfig) throws InvalidAlgorithmException {
        Collection<ExtendedCAServiceInfo> infos;
        this.data.put(VALIDITY, cainfo.getValidity());
        this.data.put(DESCRIPTION, cainfo.getDescription());
        this.data.put(CRLPERIOD, cainfo.getCRLPeriod());
        this.data.put(DELTACRLPERIOD, cainfo.getDeltaCRLPeriod());
        this.data.put(CRLISSUEINTERVAL, cainfo.getCRLIssueInterval());
        this.data.put(CRLOVERLAPTIME, cainfo.getCRLOverlapTime());
        this.data.put(CRLPUBLISHERS, cainfo.getCRLPublishers());
        this.data.put(APPROVALSETTINGS, cainfo.getApprovalSettings());
        this.data.put(NUMBEROFREQAPPROVALS, cainfo.getNumOfReqApprovals());
        if (cainfo.getCertificateProfileId() > 0) {
            this.data.put(CERTIFICATEPROFILEID, cainfo.getCertificateProfileId());
        }
        if (cainfo.getCAToken() != null) {
            this.setCAToken(cainfo.getCAToken());
        }
        this.setFinishUser(cainfo.getFinishUser());
        this.setIncludeInHealthCheck(cainfo.getIncludeInHealthCheck());
        this.setDoEnforceUniquePublicKeys(cainfo.isDoEnforceUniquePublicKeys());
        this.setDoEnforceUniqueDistinguishedName(cainfo.isDoEnforceUniqueDistinguishedName());
        this.setDoEnforceUniqueSubjectDNSerialnumber(cainfo.isDoEnforceUniqueSubjectDNSerialnumber());
        this.setUseCertReqHistory(cainfo.isUseCertReqHistory());
        this.setUseUserStorage(cainfo.isUseUserStorage());
        this.setUseCertificateStorage(cainfo.isUseCertificateStorage());
        Collection<Certificate> newcerts = cainfo.getCertificateChain();
        if (newcerts != null && newcerts.size() > 0) {
            this.setCertificateChain(newcerts);
            Certificate cacert = newcerts.iterator().next();
            this.setExpireTime(CertTools.getNotAfter(cacert));
        }
        if ((infos = cainfo.getExtendedCAServiceInfos()) != null) {
            ArrayList<ExtendedCAServiceInfo> newInfos = new ArrayList<ExtendedCAServiceInfo>();
            Collection<Integer> extendedservicetypes = this.getExternalCAServiceTypes();
            for (ExtendedCAServiceInfo info : infos) {
                ExtendedCAService service = this.getExtendedCAService(info.getType());
                if (service == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating new extended CA service of type: " + info.getType()));
                    }
                    this.createExtendedCAService(info);
                    extendedservicetypes.add(info.getType());
                    newInfos.add(info);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating extended CA service of type: " + info.getType()));
                }
                service.update(cryptoToken, info, this, cceConfig);
                this.setExtendedCAService(service);
                ExtendedCAServiceInfo newInfo = service.getExtendedCAServiceInfo();
                newInfos.add(newInfo);
            }
            cainfo.setExtendedCAServiceInfos(newInfos);
            this.data.put(EXTENDEDCASERVICES, extendedservicetypes);
        }
        if (cainfo.getStatus() == 7) {
            this.updateUninitializedCA(cainfo);
        }
        this.cainfo = cainfo;
    }

    public void updateUninitializedCA(CAInfo cainfo) {
        this.setSignedBy(cainfo.getSignedBy());
    }

    public Certificate generateCertificate(CryptoToken cryptoToken, EndEntityInformation subject, PublicKey publicKey, int keyusage, Date notBefore, long validity, CertificateProfile certProfile, String sequence, AvailableCustomCertificateExtensionsConfiguration cceConfig) throws Exception {
        if (notBefore == null) {
            notBefore = new Date();
        }
        Date notAfter = validity != -1L ? ValidityDate.getDate(validity, notBefore) : null;
        return this.generateCertificate(cryptoToken, subject, null, publicKey, keyusage, notBefore, notAfter, certProfile, null, sequence, cceConfig);
    }

    public abstract Certificate generateCertificate(CryptoToken var1, EndEntityInformation var2, RequestMessage var3, PublicKey var4, int var5, Date var6, Date var7, CertificateProfile var8, Extensions var9, String var10, CertificateGenerationParams var11, AvailableCustomCertificateExtensionsConfiguration var12) throws CryptoTokenOfflineException, CAOfflineException, InvalidAlgorithmException, IllegalValidityException, IllegalNameException, OperatorCreationException, CertificateCreateException, CertificateExtensionException, SignatureException;

    public final Certificate generateCertificate(CryptoToken cryptoToken, EndEntityInformation subject, RequestMessage request, PublicKey publicKey, int keyusage, Date notBefore, Date notAfter, CertificateProfile certProfile, Extensions extensions, String sequence, AvailableCustomCertificateExtensionsConfiguration cceConfig) throws CryptoTokenOfflineException, CAOfflineException, InvalidAlgorithmException, IllegalValidityException, IllegalNameException, OperatorCreationException, CertificateCreateException, CertificateExtensionException, SignatureException {
        return this.generateCertificate(cryptoToken, subject, request, publicKey, keyusage, notBefore, notAfter, certProfile, extensions, sequence, null, cceConfig);
    }

    public abstract X509CRLHolder generateCRL(CryptoToken var1, Collection<RevokedCertInfo> var2, int var3) throws Exception;

    public abstract X509CRLHolder generateDeltaCRL(CryptoToken var1, Collection<RevokedCertInfo> var2, int var3, int var4) throws Exception;

    public abstract byte[] createPKCS7(CryptoToken var1, Certificate var2, boolean var3) throws SignRequestSignatureException;

    public abstract byte[] createPKCS7Rollover(CryptoToken var1, int var2) throws SignRequestSignatureException;

    public abstract byte[] createRequest(CryptoToken var1, Collection<ASN1Encodable> var2, String var3, Certificate var4, int var5) throws CryptoTokenOfflineException;

    public abstract byte[] createAuthCertSignRequest(CryptoToken var1, byte[] var2) throws CryptoTokenOfflineException;

    public abstract byte[] encryptKeys(CryptoToken var1, String var2, KeyPair var3) throws IOException, CryptoTokenOfflineException, NoSuchAlgorithmException, NoSuchProviderException, CMSException;

    public abstract KeyPair decryptKeys(CryptoToken var1, String var2, byte[] var3) throws CMSException, CryptoTokenOfflineException, IOException, ClassNotFoundException;

    public abstract byte[] encryptData(CryptoToken var1, byte[] var2, int var3) throws CryptoTokenOfflineException, NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException;

    public abstract byte[] decryptData(CryptoToken var1, byte[] var2, int var3) throws CMSException, CryptoTokenOfflineException;

    public void initExtendedService(CryptoToken cryptoToken, int type, CA ca, AvailableCustomCertificateExtensionsConfiguration cceConfig) throws Exception {
        ExtendedCAService service = this.getExtendedCAService(type);
        if (service != null) {
            service.init(cryptoToken, ca, cceConfig);
            this.setExtendedCAService(service);
        }
    }

    public ExtendedCAServiceInfo getExtendedCAServiceInfo(int type) {
        ExtendedCAServiceInfo ret = null;
        ExtendedCAService service = this.getExtendedCAService(type);
        if (service != null) {
            ret = service.getExtendedCAServiceInfo();
        }
        return ret;
    }

    public ExtendedCAServiceResponse extendedService(CryptoToken cryptoToken, ExtendedCAServiceRequest request) throws ExtendedCAServiceRequestException, IllegalExtendedCAServiceRequestException, ExtendedCAServiceNotActiveException, CertificateEncodingException, CertificateException, OperatorCreationException {
        ExtendedCAService service = this.getExtendedCAService(request.getServiceType());
        if (service == null) {
            String msg = "Extended CA service is null for service request: " + request.getClass().getName();
            log.error((Object)msg);
            throw new IllegalExtendedCAServiceRequestException();
        }
        service.setCA(this);
        return service.extendedService(cryptoToken, request);
    }

    public HashMap getExtendedCAServiceData(int type) {
        HashMap serviceData = (HashMap)this.data.get(EXTENDEDCASERVICE + type);
        return serviceData;
    }

    public void setExtendedCAServiceData(int type, HashMap serviceData) {
        this.data.put(EXTENDEDCASERVICE + type, serviceData);
    }

    protected ExtendedCAService getExtendedCAService(int type) {
        ExtendedCAService returnval = null;
        try {
            returnval = this.extendedcaservicemap.get(type);
            if (returnval == null) {
                HashMap serviceData = this.getExtendedCAServiceData(type);
                if (serviceData != null) {
                    String implClassname = (String)serviceData.get("IMPLCLASS");
                    if (implClassname == null) {
                        log.error((Object)("implementation classname is null for extended service type: " + type + ". Service not created."));
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("implementation classname for extended service type: " + type + " is " + implClassname));
                        }
                        Class<?> implClass = Class.forName(implClassname);
                        returnval = (ExtendedCAService)implClass.getConstructor(HashMap.class).newInstance(serviceData);
                        this.extendedcaservicemap.put(type, returnval);
                    }
                } else {
                    log.error((Object)("Servicedata is null for extended CA service of type: " + type));
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Extended CA service of type " + type + " can not get created: "), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Extended CA service of type " + type + " can not get created: "), (Throwable)e);
        }
        catch (SecurityException e) {
            log.warn((Object)("Extended CA service of type " + type + " can not get created: "), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.warn((Object)("Extended CA service of type " + type + " can not get created: "), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("Extended CA service of type " + type + " can not get created: "), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.warn((Object)("Extended CA service of type " + type + " can not get created: "), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)("Extended CA service of type " + type + " can not get created: "), (Throwable)e);
        }
        return returnval;
    }

    public void setExtendedCAService(ExtendedCAService extendedcaservice) {
        ExtendedCAServiceInfo info = extendedcaservice.getExtendedCAServiceInfo();
        this.setExtendedCAServiceData(info.getType(), (HashMap)extendedcaservice.saveData());
        this.extendedcaservicemap.put(info.getType(), extendedcaservice);
    }

    public Collection<Integer> getExternalCAServiceTypes() {
        if (this.data.get(EXTENDEDCASERVICES) == null) {
            return new ArrayList<Integer>();
        }
        return (Collection)this.data.get(EXTENDEDCASERVICES);
    }

    public abstract boolean upgradeExtendedCAServices();

    public abstract void createOrRemoveLinkCertificate(CryptoToken var1, boolean var2, CertificateProfile var3, AvailableCustomCertificateExtensionsConfiguration var4) throws CryptoTokenOfflineException;

    protected void updateLatestLinkCertificate(byte[] encodedLinkCertificate) {
        if (encodedLinkCertificate == null) {
            this.data.remove(LATESTLINKCERTIFICATE);
        } else {
            try {
                this.data.put(LATESTLINKCERTIFICATE, new String(Base64.encode(encodedLinkCertificate), "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] getLatestLinkCertificate() {
        if (this.data.get(LATESTLINKCERTIFICATE) == null) {
            return null;
        }
        try {
            return Base64.decode(((String)this.data.get(LATESTLINKCERTIFICATE)).getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

