/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ca;

import java.io.Serializable;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Date;
import org.cesecore.certificates.ca.catoken.CAToken;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAServiceInfo;
import org.cesecore.certificates.certificate.CertificateWrapper;
import org.cesecore.util.CertTools;
import org.cesecore.util.EJBTools;
import org.cesecore.util.StringTools;

public abstract class CAInfo
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final int CATYPE_X509 = 1;
    public static final int CATYPE_CVC = 2;
    public static final int SELFSIGNED = 1;
    public static final int SIGNEDBYEXTERNALCA = 2;
    public static final int SPECIALCAIDBORDER = 10;
    public static final int REQ_APPROVAL_ADDEDITENDENTITY = 1;
    public static final int REQ_APPROVAL_KEYRECOVER = 2;
    public static final int REQ_APPROVAL_REVOCATION = 3;
    public static final int REQ_APPROVAL_ACTIVATECA = 4;
    public static final int[] AVAILABLE_APPROVALSETTINGS = new int[]{1, 2, 3, 4};
    public static final String[] AVAILABLE_APPROVALSETTINGS_TEXTS = new String[]{"APPROVEADDEDITENDENTITY", "APPROVEKEYRECOVER", "APPROVEREVOCATION", "APPROVEACTIVATECA"};
    protected String subjectdn;
    protected int caid;
    protected String name;
    protected int status = 0;
    protected long validity;
    protected Date expiretime;
    protected Date updatetime;
    protected int catype;
    protected int signedby;
    protected Collection<CertificateWrapper> certificatechain;
    protected transient Collection<Certificate> certificatechainCached;
    protected CAToken catoken;
    protected String description;
    protected int revocationReason;
    protected Date revocationDate;
    protected int certificateprofileid;
    protected long crlperiod = 86400000L;
    protected long crlIssueInterval = 0L;
    protected long crlOverlapTime = 600000L;
    protected long deltacrlperiod = 0L;
    protected Collection<Integer> crlpublishers;
    protected boolean finishuser;
    protected Collection<ExtendedCAServiceInfo> extendedcaserviceinfos;
    protected Collection<Integer> approvalSettings;
    protected int numOfReqApprovals;
    protected boolean includeInHealthCheck;
    protected boolean doEnforceUniquePublicKeys;
    protected boolean doEnforceUniqueDistinguishedName;
    protected boolean doEnforceUniqueSubjectDNSerialnumber;
    protected boolean useCertReqHistory;
    protected boolean useUserStorage;
    protected boolean useCertificateStorage;

    public String getSubjectDN() {
        return this.subjectdn;
    }

    public void setSubjectDN(String subjectdn) {
        this.subjectdn = CertTools.stringToBCDNString(StringTools.strip(subjectdn));
    }

    public int getCAId() {
        return this.caid;
    }

    public void setCAId(int caid) {
        this.caid = caid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getCAType() {
        return this.catype;
    }

    public void setCAType(int catype) {
        this.catype = catype;
    }

    public int getSignedBy() {
        return this.signedby;
    }

    public void setSignedBy(int signedby) {
        this.signedby = signedby;
    }

    public long getValidity() {
        return this.validity;
    }

    public void setValidity(long validity) {
        this.validity = validity;
    }

    public Date getExpireTime() {
        return this.expiretime;
    }

    public void setExpireTime(Date expiretime) {
        this.expiretime = expiretime;
    }

    public Date getUpdateTime() {
        return this.updatetime;
    }

    public void setUpdateTime(Date updatetime) {
        this.updatetime = updatetime;
    }

    public Collection<Certificate> getCertificateChain() {
        if (this.certificatechain == null) {
            return null;
        }
        if (this.certificatechainCached == null) {
            this.certificatechainCached = EJBTools.unwrapCertCollection(this.certificatechain);
        }
        return this.certificatechainCached;
    }

    public void setCertificateChain(Collection<Certificate> certificatechain) {
        this.certificatechainCached = certificatechain;
        this.certificatechain = EJBTools.wrapCertCollection(certificatechain);
    }

    public CAToken getCAToken() {
        return this.catoken;
    }

    public void setCAToken(CAToken catoken) {
        this.catoken = catoken;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getRevocationReason() {
        return this.revocationReason;
    }

    public void setRevocationReason(int revocationReason) {
        this.revocationReason = revocationReason;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public void setRevocationDate(Date revocationDate) {
        this.revocationDate = revocationDate;
    }

    public void setCertificateProfileId(int _certificateprofileid) {
        this.certificateprofileid = _certificateprofileid;
    }

    public int getCertificateProfileId() {
        return this.certificateprofileid;
    }

    public long getCRLPeriod() {
        return this.crlperiod;
    }

    public void setCRLPeriod(long crlperiod) {
        this.crlperiod = crlperiod;
    }

    public long getDeltaCRLPeriod() {
        return this.deltacrlperiod;
    }

    public void setDeltaCRLPeriod(long deltacrlperiod) {
        this.deltacrlperiod = deltacrlperiod;
    }

    public long getCRLIssueInterval() {
        return this.crlIssueInterval;
    }

    public void setCRLIssueInterval(long crlissueinterval) {
        this.crlIssueInterval = crlissueinterval;
    }

    public long getCRLOverlapTime() {
        return this.crlOverlapTime;
    }

    public void setCRLOverlapTime(long crloverlaptime) {
        this.crlOverlapTime = crloverlaptime;
    }

    public Collection<Integer> getCRLPublishers() {
        return this.crlpublishers;
    }

    public void setCRLPublishers(Collection<Integer> crlpublishers) {
        this.crlpublishers = crlpublishers;
    }

    public boolean getFinishUser() {
        return this.finishuser;
    }

    public void setFinishUser(boolean finishuser) {
        this.finishuser = finishuser;
    }

    public boolean getIncludeInHealthCheck() {
        return this.includeInHealthCheck;
    }

    public void setIncludeInHealthCheck(boolean includeInHealthCheck) {
        this.includeInHealthCheck = includeInHealthCheck;
    }

    public Collection<ExtendedCAServiceInfo> getExtendedCAServiceInfos() {
        return this.extendedcaserviceinfos;
    }

    public void setExtendedCAServiceInfos(Collection<ExtendedCAServiceInfo> extendedcaserviceinfos) {
        this.extendedcaserviceinfos = extendedcaserviceinfos;
    }

    public Collection<Integer> getApprovalSettings() {
        return this.approvalSettings;
    }

    public void setApprovalSettings(Collection<Integer> approvalSettings) {
        this.approvalSettings = approvalSettings;
    }

    public boolean isApprovalRequired(int action) {
        return this.approvalSettings.contains(action);
    }

    public int getNumOfReqApprovals() {
        return this.numOfReqApprovals;
    }

    public void setNumOfReqApprovals(int numOfReqApprovals) {
        this.numOfReqApprovals = numOfReqApprovals;
    }

    public boolean isUseCertReqHistory() {
        return this.useCertReqHistory;
    }

    public void setUseCertReqHistory(boolean useCertReqHistory) {
        this.useCertReqHistory = useCertReqHistory;
    }

    public boolean isUseUserStorage() {
        return this.useUserStorage;
    }

    public void setUseUserStorage(boolean useUserStorage) {
        this.useUserStorage = useUserStorage;
    }

    public boolean isUseCertificateStorage() {
        return this.useCertificateStorage;
    }

    public void setUseCertificateStorage(boolean useCertificateStorage) {
        this.useCertificateStorage = useCertificateStorage;
    }

    public boolean isDoEnforceUniquePublicKeys() {
        return this.doEnforceUniquePublicKeys;
    }

    public void setDoEnforceUniquePublicKeys(boolean doEnforceUniquePublicKeys) {
        this.doEnforceUniquePublicKeys = doEnforceUniquePublicKeys;
    }

    public boolean isDoEnforceUniqueSubjectDNSerialnumber() {
        return this.doEnforceUniqueSubjectDNSerialnumber;
    }

    public void setDoEnforceUniqueSubjectDNSerialnumber(boolean doEnforceUniqueSubjectDNSN) {
        this.doEnforceUniqueSubjectDNSerialnumber = doEnforceUniqueSubjectDNSN;
    }

    public void setDoEnforceUniqueDistinguishedName(boolean doEnforceUniqueDistinguishedName) {
        this.doEnforceUniqueDistinguishedName = doEnforceUniqueDistinguishedName;
    }

    public boolean isDoEnforceUniqueDistinguishedName() {
        return this.doEnforceUniqueDistinguishedName;
    }
}

