/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ca;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.cesecore.certificates.ca.CAInfo;
import org.cesecore.certificates.ca.catoken.CAToken;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAServiceInfo;
import org.cesecore.util.CertTools;
import org.cesecore.util.StringTools;

public class CVCCAInfo
extends CAInfo {
    private static final long serialVersionUID = 2L;

    public CVCCAInfo(String subjectdn, String name, int status, int certificateprofileid, long validity, int signedby, Collection<Certificate> certificatechain, CAToken catoken) {
        this(subjectdn, name, status, new Date(), certificateprofileid, validity, null, 2, signedby, certificatechain, catoken, "", -1, null, 86400000L, 0L, 36000000L, 36000000L, new ArrayList<Integer>(), true, new ArrayList<ExtendedCAServiceInfo>(), new ArrayList<Integer>(), 1, true, true, true, false, false, true, true);
    }

    public CVCCAInfo(String subjectdn, String name, int status, Date updateTime, int certificateprofileid, long validity, Date expiretime, int catype, int signedby, Collection<Certificate> certificatechain, CAToken catoken, String description, int revocationReason, Date revocationDate, long crlperiod, long crlIssueInterval, long crlOverlapTime, long deltacrlperiod, Collection<Integer> crlpublishers, boolean finishuser, Collection<ExtendedCAServiceInfo> extendedcaserviceinfos, Collection<Integer> approvalSettings, int numOfReqApprovals, boolean includeInHealthCheck, boolean _doEnforceUniquePublicKeys, boolean _doEnforceUniqueDistinguishedName, boolean _doEnforceUniqueSubjectDNSerialnumber, boolean _useCertReqHistory, boolean _useUserStorage, boolean _useCertificateStorage) {
        this.subjectdn = CertTools.stringToBCDNString(StringTools.strip(subjectdn));
        this.caid = CertTools.stringToBCDNString(this.subjectdn).hashCode();
        this.name = name;
        this.status = status;
        this.updatetime = updateTime;
        this.validity = validity;
        this.expiretime = expiretime;
        this.catype = catype;
        this.signedby = signedby;
        this.setCertificateChain(certificatechain);
        this.catoken = catoken;
        this.description = description;
        this.revocationReason = revocationReason;
        this.revocationDate = revocationDate;
        this.crlperiod = crlperiod;
        this.crlIssueInterval = crlIssueInterval;
        this.crlOverlapTime = crlOverlapTime;
        this.deltacrlperiod = deltacrlperiod;
        this.crlpublishers = crlpublishers;
        this.finishuser = finishuser;
        this.certificateprofileid = certificateprofileid;
        this.extendedcaserviceinfos = extendedcaserviceinfos;
        this.approvalSettings = approvalSettings;
        this.numOfReqApprovals = numOfReqApprovals;
        this.includeInHealthCheck = includeInHealthCheck;
        this.doEnforceUniquePublicKeys = _doEnforceUniquePublicKeys;
        this.doEnforceUniqueDistinguishedName = _doEnforceUniqueDistinguishedName;
        this.doEnforceUniqueSubjectDNSerialnumber = _doEnforceUniqueSubjectDNSerialnumber;
        this.useCertReqHistory = _useCertReqHistory;
        this.useUserStorage = _useUserStorage;
        this.useCertificateStorage = _useCertificateStorage;
    }

    public CVCCAInfo(int caid, long validity, CAToken catoken, String description, long crlperiod, long crlIssueInterval, long crlOverlapTime, long deltacrlperiod, Collection<Integer> crlpublishers, boolean finishuser, Collection<ExtendedCAServiceInfo> extendedcaserviceinfos, Collection<Integer> approvalSettings, int numOfReqApprovals, boolean includeInHealthCheck, boolean _doEnforceUniquePublicKeys, boolean _doEnforceUniqueDistinguishedName, boolean _doEnforceUniqueSubjectDNSerialnumber, boolean _useCertReqHistory, boolean _useUserStorage, boolean _useCertificateStorage) {
        this.caid = caid;
        this.validity = validity;
        this.catoken = catoken;
        this.description = description;
        this.crlperiod = crlperiod;
        this.crlIssueInterval = crlIssueInterval;
        this.crlOverlapTime = crlOverlapTime;
        this.deltacrlperiod = deltacrlperiod;
        this.crlpublishers = crlpublishers;
        this.finishuser = finishuser;
        this.extendedcaserviceinfos = extendedcaserviceinfos;
        this.approvalSettings = approvalSettings;
        this.numOfReqApprovals = numOfReqApprovals;
        this.includeInHealthCheck = includeInHealthCheck;
        this.doEnforceUniquePublicKeys = _doEnforceUniquePublicKeys;
        this.doEnforceUniqueDistinguishedName = _doEnforceUniqueDistinguishedName;
        this.doEnforceUniqueSubjectDNSerialnumber = _doEnforceUniqueSubjectDNSerialnumber;
        this.useCertReqHistory = _useCertReqHistory;
        this.useUserStorage = _useUserStorage;
        this.useCertificateStorage = _useCertificateStorage;
    }
}

