/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ca;

import java.io.Serializable;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.bouncycastle.cert.X509CRLHolder;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.CVCCAInfo;
import org.cesecore.certificates.ca.CvcPlugin;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAServiceInfo;
import org.cesecore.certificates.crl.RevokedCertInfo;
import org.cesecore.config.CesecoreConfiguration;
import org.cesecore.internal.InternalResources;
import org.cesecore.keys.token.CryptoToken;

public abstract class CvcCA
extends CA
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final Logger log = Logger.getLogger(CvcCA.class);
    private static final InternalResources intres = InternalResources.getInstance();
    public static final float LATEST_VERSION = 3.0f;

    public void init(CVCCAInfo cainfo) {
        super.init(cainfo);
        this.data.put("catype", 2);
        this.data.put("version", new Float(3.0f));
    }

    public static CvcCA getInstance(CVCCAInfo cainfo) {
        CvcCA ret = (CvcCA)((Object)CvcCA.createCAImpl("EAC"));
        ret.init(cainfo);
        return ret;
    }

    public static CvcCA getInstance(HashMap<Object, Object> data, int caId, String subjectDN, String name, int status, Date updateTime) {
        CvcCA ret = (CvcCA)((Object)CvcCA.createCAImpl("EAC"));
        ret.init(data, caId, subjectDN, name, status, updateTime);
        return ret;
    }

    public static ServiceLoader<? extends CvcPlugin> getImplementationClasses() {
        ServiceLoader<CvcPlugin> serviceLoader = ServiceLoader.load(CvcPlugin.class);
        return serviceLoader;
    }

    private static CvcPlugin createCAImpl(String type) {
        ServiceLoader<? extends CvcPlugin> serviceLoader = CvcCA.getImplementationClasses();
        for (CvcPlugin cvcPlugin : serviceLoader) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ServiceLoader found CvcPlugin implementation: " + cvcPlugin.getCvcType()));
            }
            if (!type.equals(cvcPlugin.getCvcType())) continue;
            return cvcPlugin;
        }
        log.info((Object)"CVC CA is not available in the version of EJBCA.");
        throw new RuntimeException("CVC CA is not available in the version of EJBCA.");
    }

    public void init(HashMap<Object, Object> data, int caId, String subjectDN, String name, int status, Date updateTime) {
        super.init(data);
        ArrayList<ExtendedCAServiceInfo> externalcaserviceinfos = new ArrayList<ExtendedCAServiceInfo>();
        for (Integer externalCAServiceType : this.getExternalCAServiceTypes()) {
            ExtendedCAServiceInfo info;
            if (externalCAServiceType == 1 || (info = this.getExtendedCAServiceInfo(externalCAServiceType)) == null) continue;
            externalcaserviceinfos.add(info);
        }
        CVCCAInfo info = new CVCCAInfo(subjectDN, name, status, updateTime, this.getCertificateProfileId(), this.getValidity(), this.getExpireTime(), this.getCAType(), this.getSignedBy(), this.getCertificateChain(), this.getCAToken(), this.getDescription(), this.getRevocationReason(), this.getRevocationDate(), this.getCRLPeriod(), this.getCRLIssueInterval(), this.getCRLOverlapTime(), this.getDeltaCRLPeriod(), this.getCRLPublishers(), this.getFinishUser(), externalcaserviceinfos, this.getApprovalSettings(), this.getNumOfRequiredApprovals(), this.getIncludeInHealthCheck(), this.isDoEnforceUniquePublicKeys(), this.isDoEnforceUniqueDistinguishedName(), this.isDoEnforceUniqueSubjectDNSerialnumber(), this.isUseCertReqHistory(), this.isUseUserStorage(), this.isUseCertificateStorage());
        super.setCAInfo(info);
        this.setCAId(caId);
    }

    public abstract String getCvcType();

    @Override
    public byte[] createPKCS7(CryptoToken cryptoToken, Certificate cert, boolean includeChain) {
        log.info((Object)intres.getLocalizedMessage("cvc.info.nocvcpkcs7", new Object[0]));
        return null;
    }

    @Override
    public byte[] createPKCS7Rollover(CryptoToken cryptoToken, int caid) {
        log.info((Object)intres.getLocalizedMessage("cvc.info.nocvcpkcs7", new Object[0]));
        return null;
    }

    @Override
    public X509CRLHolder generateCRL(CryptoToken cryptoToken, Collection<RevokedCertInfo> certs, int crlnumber) {
        String msg = intres.getLocalizedMessage("createcrl.nocrlcreate", "CVC");
        log.info((Object)msg);
        return null;
    }

    @Override
    public X509CRLHolder generateDeltaCRL(CryptoToken cryptoToken, Collection<RevokedCertInfo> certs, int crlnumber, int basecrlnumber) {
        String msg = intres.getLocalizedMessage("createcrl.nocrlcreate", "CVC");
        log.info((Object)msg);
        return null;
    }

    @Override
    public float getLatestVersion() {
        return 3.0f;
    }

    @Override
    public void upgrade() {
        if (Float.compare(3.0f, this.getVersion()) != 0) {
            log.info((Object)("Upgrading CVCCA with version " + this.getVersion()));
            if (this.data.get("crlperiod") instanceof Integer) {
                this.setCRLPeriod(0L);
            }
            if (this.data.get("crlIssueInterval") instanceof Integer) {
                this.setCRLIssueInterval(0L);
            }
            if (this.data.get("crlOverlapTime") instanceof Integer) {
                this.setCRLOverlapTime(0L);
            }
            if (this.data.get("deltacrlperiod") instanceof Integer) {
                this.setDeltaCRLPeriod(0L);
            }
            this.data.put("version", new Float(3.0f));
        }
    }

    @Override
    public boolean upgradeExtendedCAServices() {
        boolean retval = false;
        Collection<Integer> externalServiceTypes = this.getExternalCAServiceTypes();
        if (!CesecoreConfiguration.getCaKeepOcspExtendedService() && externalServiceTypes.contains(1)) {
            externalServiceTypes.remove(1);
            this.data.put("extendedcaservices", externalServiceTypes);
            retval = true;
        }
        return retval;
    }

    @Override
    public byte[] encryptKeys(CryptoToken cryptoToken, String alias, KeyPair keypair) {
        throw new IllegalArgumentException("encryptKeys not implemented for CVC CA");
    }

    @Override
    public KeyPair decryptKeys(CryptoToken cryptoToken, String alias, byte[] data) {
        throw new IllegalArgumentException("decryptKeys not implemented for CVC CA");
    }

    @Override
    public byte[] decryptData(CryptoToken cryptoToken, byte[] data, int cAKeyPurpose) {
        throw new IllegalArgumentException("decryptData not implemented for CVC CA");
    }

    @Override
    public byte[] encryptData(CryptoToken cryptoToken, byte[] data, int keyPurpose) {
        throw new IllegalArgumentException("encryptData not implemented for CVC CA");
    }
}

