/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ca;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.BufferingContentSigner;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Hex;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.CAInfo;
import org.cesecore.certificates.ca.CAOfflineException;
import org.cesecore.certificates.ca.CertificateGenerationParams;
import org.cesecore.certificates.ca.IllegalNameException;
import org.cesecore.certificates.ca.IllegalValidityException;
import org.cesecore.certificates.ca.InvalidAlgorithmException;
import org.cesecore.certificates.ca.SignRequestSignatureException;
import org.cesecore.certificates.ca.X509CAInfo;
import org.cesecore.certificates.ca.catoken.CAToken;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAService;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAServiceInfo;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.ca.internal.SernoGeneratorRandom;
import org.cesecore.certificates.certificate.CertificateCreateException;
import org.cesecore.certificates.certificate.certextensions.AvailableCustomCertificateExtensionsConfiguration;
import org.cesecore.certificates.certificate.certextensions.CertificateExtension;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionFactory;
import org.cesecore.certificates.certificate.certextensions.CustomCertificateExtension;
import org.cesecore.certificates.certificate.request.RequestMessage;
import org.cesecore.certificates.certificateprofile.CertificatePolicy;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.certificatetransparency.CTLogException;
import org.cesecore.certificates.certificatetransparency.CertificateTransparency;
import org.cesecore.certificates.certificatetransparency.CertificateTransparencyFactory;
import org.cesecore.certificates.crl.RevokedCertInfo;
import org.cesecore.certificates.endentity.EndEntityInformation;
import org.cesecore.certificates.endentity.EndEntityType;
import org.cesecore.certificates.endentity.EndEntityTypes;
import org.cesecore.certificates.endentity.ExtendedInformation;
import org.cesecore.certificates.ocsp.SHA1DigestCalculator;
import org.cesecore.certificates.util.AlgorithmConstants;
import org.cesecore.certificates.util.AlgorithmTools;
import org.cesecore.certificates.util.dn.DNFieldsUtil;
import org.cesecore.config.CesecoreConfiguration;
import org.cesecore.internal.InternalResources;
import org.cesecore.keys.token.CryptoToken;
import org.cesecore.keys.token.CryptoTokenOfflineException;
import org.cesecore.keys.token.IllegalCryptoTokenException;
import org.cesecore.keys.token.NullCryptoToken;
import org.cesecore.keys.util.KeyTools;
import org.cesecore.util.CeSecoreNameStyle;
import org.cesecore.util.CertTools;
import org.cesecore.util.PrintableStringNameStyle;
import org.cesecore.util.StringTools;

public class X509CA
extends CA
implements Serializable {
    private static final long serialVersionUID = -2882572653108530258L;
    private static final Logger log = Logger.getLogger(X509CA.class);
    private static final InternalResources intres = InternalResources.getInstance();
    public static final float LATEST_VERSION = 20.0f;
    protected static final String POLICIES = "policies";
    protected static final String SUBJECTALTNAME = "subjectaltname";
    protected static final String USEAUTHORITYKEYIDENTIFIER = "useauthoritykeyidentifier";
    protected static final String AUTHORITYKEYIDENTIFIERCRITICAL = "authoritykeyidentifiercritical";
    protected static final String AUTHORITY_INFORMATION_ACCESS = "authorityinformationaccess";
    protected static final String USECRLNUMBER = "usecrlnumber";
    protected static final String CRLNUMBERCRITICAL = "crlnumbercritical";
    protected static final String DEFAULTCRLDISTPOINT = "defaultcrldistpoint";
    protected static final String DEFAULTCRLISSUER = "defaultcrlissuer";
    protected static final String DEFAULTOCSPSERVICELOCATOR = "defaultocspservicelocator";
    protected static final String CADEFINEDFRESHESTCRL = "cadefinedfreshestcrl";
    protected static final String USEUTF8POLICYTEXT = "useutf8policytext";
    protected static final String USEPRINTABLESTRINGSUBJECTDN = "useprintablestringsubjectdn";
    protected static final String USELDAPDNORDER = "useldapdnorder";
    protected static final String USECRLDISTRIBUTIONPOINTONCRL = "usecrldistributionpointoncrl";
    protected static final String CRLDISTRIBUTIONPOINTONCRLCRITICAL = "crldistributionpointoncrlcritical";
    protected static final String CMPRAAUTHSECRET = "cmpraauthsecret";
    protected static final String NAMECONSTRAINTSPERMITTED = "nameconstraintspermitted";
    protected static final String NAMECONSTRAINTSEXCLUDED = "nameconstraintsexcluded";
    protected static final String EXTERNALCDP = "externalcdp";
    private static final CertificateTransparency ct = CertificateTransparencyFactory.getInstance();

    public X509CA(X509CAInfo cainfo) {
        super(cainfo);
        if (StringUtils.isEmpty((String)DNFieldsUtil.removeAllEmpties(cainfo.getSubjectDN())) && StringUtils.isEmpty((String)cainfo.getSubjectAltName())) {
            throw new IllegalArgumentException("Subject DN and Alt Name can't both be blank for an X509 CA.");
        }
        this.data.put(POLICIES, cainfo.getPolicies());
        this.data.put(SUBJECTALTNAME, cainfo.getSubjectAltName());
        this.setUseAuthorityKeyIdentifier(cainfo.getUseAuthorityKeyIdentifier());
        this.setAuthorityKeyIdentifierCritical(cainfo.getAuthorityKeyIdentifierCritical());
        this.setUseCRLNumber(cainfo.getUseCRLNumber());
        this.setCRLNumberCritical(cainfo.getCRLNumberCritical());
        this.setDefaultCRLDistPoint(cainfo.getDefaultCRLDistPoint());
        this.setDefaultCRLIssuer(cainfo.getDefaultCRLIssuer());
        this.setCADefinedFreshestCRL(cainfo.getCADefinedFreshestCRL());
        this.setDefaultOCSPServiceLocator(cainfo.getDefaultOCSPServiceLocator());
        this.setUseUTF8PolicyText(cainfo.getUseUTF8PolicyText());
        this.setUsePrintableStringSubjectDN(cainfo.getUsePrintableStringSubjectDN());
        this.setUseLdapDNOrder(cainfo.getUseLdapDnOrder());
        this.setUseCrlDistributionPointOnCrl(cainfo.getUseCrlDistributionPointOnCrl());
        this.setCrlDistributionPointOnCrlCritical(cainfo.getCrlDistributionPointOnCrlCritical());
        this.setCmpRaAuthSecret(cainfo.getCmpRaAuthSecret());
        this.setAuthorityInformationAccess(cainfo.getAuthorityInformationAccess());
        this.setNameConstraintsPermitted(cainfo.getNameConstraintsPermitted());
        this.setNameConstraintsExcluded(cainfo.getNameConstraintsExcluded());
        this.data.put("catype", 1);
        this.data.put("version", new Float(20.0f));
    }

    public X509CA(HashMap<Object, Object> data, int caId, String subjectDN, String name, int status, Date updateTime, Date expireTime) {
        super(data);
        this.setExpireTime(expireTime);
        ArrayList<ExtendedCAServiceInfo> externalcaserviceinfos = new ArrayList<ExtendedCAServiceInfo>();
        for (Integer type : this.getExternalCAServiceTypes()) {
            ExtendedCAServiceInfo info;
            if (type == 1 || (info = this.getExtendedCAServiceInfo(type)) == null) continue;
            externalcaserviceinfos.add(info);
        }
        X509CAInfo info = new X509CAInfo(subjectDN, name, status, updateTime, this.getSubjectAltName(), this.getCertificateProfileId(), this.getValidity(), this.getExpireTime(), this.getCAType(), this.getSignedBy(), this.getCertificateChain(), this.getCAToken(), this.getDescription(), this.getRevocationReason(), this.getRevocationDate(), this.getPolicies(), this.getCRLPeriod(), this.getCRLIssueInterval(), this.getCRLOverlapTime(), this.getDeltaCRLPeriod(), this.getCRLPublishers(), this.getUseAuthorityKeyIdentifier(), this.getAuthorityKeyIdentifierCritical(), this.getUseCRLNumber(), this.getCRLNumberCritical(), this.getDefaultCRLDistPoint(), this.getDefaultCRLIssuer(), this.getDefaultOCSPServiceLocator(), this.getAuthorityInformationAccess(), this.getNameConstraintsPermitted(), this.getNameConstraintsExcluded(), this.getCADefinedFreshestCRL(), this.getFinishUser(), externalcaserviceinfos, this.getUseUTF8PolicyText(), this.getApprovalSettings(), this.getNumOfRequiredApprovals(), this.getUsePrintableStringSubjectDN(), this.getUseLdapDNOrder(), this.getUseCrlDistributionPointOnCrl(), this.getCrlDistributionPointOnCrlCritical(), this.getIncludeInHealthCheck(), this.isDoEnforceUniquePublicKeys(), this.isDoEnforceUniqueDistinguishedName(), this.isDoEnforceUniqueSubjectDNSerialnumber(), this.isUseCertReqHistory(), this.isUseUserStorage(), this.isUseCertificateStorage(), this.getCmpRaAuthSecret());
        info.setExternalCdp(this.getExternalCdp());
        super.setCAInfo(info);
        this.setCAId(caId);
    }

    public List<CertificatePolicy> getPolicies() {
        return (List)this.data.get(POLICIES);
    }

    public void setPolicies(List<CertificatePolicy> policies) {
        this.data.put(POLICIES, policies);
    }

    public String getSubjectAltName() {
        return (String)this.data.get(SUBJECTALTNAME);
    }

    public boolean getUseAuthorityKeyIdentifier() {
        return (Boolean)this.data.get(USEAUTHORITYKEYIDENTIFIER);
    }

    public void setUseAuthorityKeyIdentifier(boolean useauthoritykeyidentifier) {
        this.data.put(USEAUTHORITYKEYIDENTIFIER, useauthoritykeyidentifier);
    }

    public boolean getAuthorityKeyIdentifierCritical() {
        return (Boolean)this.data.get(AUTHORITYKEYIDENTIFIERCRITICAL);
    }

    public void setAuthorityKeyIdentifierCritical(boolean authoritykeyidentifiercritical) {
        this.data.put(AUTHORITYKEYIDENTIFIERCRITICAL, authoritykeyidentifiercritical);
    }

    public List<String> getAuthorityInformationAccess() {
        return (List)this.data.get(AUTHORITY_INFORMATION_ACCESS);
    }

    public void setAuthorityInformationAccess(Collection<String> authorityInformationAccess) {
        this.data.put(AUTHORITY_INFORMATION_ACCESS, authorityInformationAccess);
    }

    public boolean getUseCRLNumber() {
        return (Boolean)this.data.get(USECRLNUMBER);
    }

    public void setUseCRLNumber(boolean usecrlnumber) {
        this.data.put(USECRLNUMBER, usecrlnumber);
    }

    public boolean getCRLNumberCritical() {
        return (Boolean)this.data.get(CRLNUMBERCRITICAL);
    }

    public void setCRLNumberCritical(boolean crlnumbercritical) {
        this.data.put(CRLNUMBERCRITICAL, crlnumbercritical);
    }

    public String getDefaultCRLDistPoint() {
        return (String)this.data.get(DEFAULTCRLDISTPOINT);
    }

    public void setDefaultCRLDistPoint(String defaultcrldistpoint) {
        if (defaultcrldistpoint == null) {
            this.data.put(DEFAULTCRLDISTPOINT, "");
        } else {
            this.data.put(DEFAULTCRLDISTPOINT, defaultcrldistpoint);
        }
    }

    public String getDefaultCRLIssuer() {
        return (String)this.data.get(DEFAULTCRLISSUER);
    }

    public void setDefaultCRLIssuer(String defaultcrlissuer) {
        if (defaultcrlissuer == null) {
            this.data.put(DEFAULTCRLISSUER, "");
        } else {
            this.data.put(DEFAULTCRLISSUER, defaultcrlissuer);
        }
    }

    public String getCADefinedFreshestCRL() {
        return (String)this.data.get(CADEFINEDFRESHESTCRL);
    }

    public void setCADefinedFreshestCRL(String cadefinedfreshestcrl) {
        if (cadefinedfreshestcrl == null) {
            this.data.put(CADEFINEDFRESHESTCRL, "");
        } else {
            this.data.put(CADEFINEDFRESHESTCRL, cadefinedfreshestcrl);
        }
    }

    public String getDefaultOCSPServiceLocator() {
        return (String)this.data.get(DEFAULTOCSPSERVICELOCATOR);
    }

    public void setDefaultOCSPServiceLocator(String defaultocsplocator) {
        if (defaultocsplocator == null) {
            this.data.put(DEFAULTOCSPSERVICELOCATOR, "");
        } else {
            this.data.put(DEFAULTOCSPSERVICELOCATOR, defaultocsplocator);
        }
    }

    public boolean getUseUTF8PolicyText() {
        return (Boolean)this.data.get(USEUTF8POLICYTEXT);
    }

    public void setUseUTF8PolicyText(boolean useutf8) {
        this.data.put(USEUTF8POLICYTEXT, useutf8);
    }

    public boolean getUsePrintableStringSubjectDN() {
        return (Boolean)this.data.get(USEPRINTABLESTRINGSUBJECTDN);
    }

    public void setUsePrintableStringSubjectDN(boolean useprintablestring) {
        this.data.put(USEPRINTABLESTRINGSUBJECTDN, useprintablestring);
    }

    public boolean getUseLdapDNOrder() {
        return (Boolean)this.data.get(USELDAPDNORDER);
    }

    public void setUseLdapDNOrder(boolean useldapdnorder) {
        this.data.put(USELDAPDNORDER, useldapdnorder);
    }

    public boolean getUseCrlDistributionPointOnCrl() {
        return (Boolean)this.data.get(USECRLDISTRIBUTIONPOINTONCRL);
    }

    public void setUseCrlDistributionPointOnCrl(boolean useCrlDistributionPointOnCrl) {
        this.data.put(USECRLDISTRIBUTIONPOINTONCRL, useCrlDistributionPointOnCrl);
    }

    public boolean getCrlDistributionPointOnCrlCritical() {
        return (Boolean)this.data.get(CRLDISTRIBUTIONPOINTONCRLCRITICAL);
    }

    public void setCrlDistributionPointOnCrlCritical(boolean crlDistributionPointOnCrlCritical) {
        this.data.put(CRLDISTRIBUTIONPOINTONCRLCRITICAL, crlDistributionPointOnCrlCritical);
    }

    public List<String> getNameConstraintsPermitted() {
        return (List)this.data.get(NAMECONSTRAINTSPERMITTED);
    }

    public void setNameConstraintsPermitted(List<String> encodedNames) {
        this.data.put(NAMECONSTRAINTSPERMITTED, encodedNames);
    }

    public List<String> getNameConstraintsExcluded() {
        return (List)this.data.get(NAMECONSTRAINTSEXCLUDED);
    }

    public void setNameConstraintsExcluded(List<String> encodedNames) {
        this.data.put(NAMECONSTRAINTSEXCLUDED, encodedNames);
    }

    public String getCmpRaAuthSecret() {
        return (String)this.getMapValueWithDefault(CMPRAAUTHSECRET, "");
    }

    public void setCmpRaAuthSecret(String cmpRaAuthSecret) {
        this.data.put(CMPRAAUTHSECRET, cmpRaAuthSecret);
    }

    public String getExternalCdp() {
        return (String)this.getMapValueWithDefault(EXTERNALCDP, "");
    }

    public void setExternalCdp(String externalCdp) {
        this.data.put(EXTERNALCDP, externalCdp);
    }

    private Object getMapValueWithDefault(String key, Object defaultValue) {
        Object o = this.data.get(key);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    @Override
    public void updateCA(CryptoToken cryptoToken, CAInfo cainfo, AvailableCustomCertificateExtensionsConfiguration cceConfig) throws InvalidAlgorithmException {
        super.updateCA(cryptoToken, cainfo, cceConfig);
        X509CAInfo info = (X509CAInfo)cainfo;
        this.setPolicies(info.getPolicies());
        this.setAuthorityInformationAccess(info.getAuthorityInformationAccess());
        this.setUseAuthorityKeyIdentifier(info.getUseAuthorityKeyIdentifier());
        this.setAuthorityKeyIdentifierCritical(info.getAuthorityKeyIdentifierCritical());
        this.setUseCRLNumber(info.getUseCRLNumber());
        this.setCRLNumberCritical(info.getCRLNumberCritical());
        this.setDefaultCRLDistPoint(info.getDefaultCRLDistPoint());
        this.setDefaultCRLIssuer(info.getDefaultCRLIssuer());
        this.setCADefinedFreshestCRL(info.getCADefinedFreshestCRL());
        this.setDefaultOCSPServiceLocator(info.getDefaultOCSPServiceLocator());
        this.setUseUTF8PolicyText(info.getUseUTF8PolicyText());
        this.setUsePrintableStringSubjectDN(info.getUsePrintableStringSubjectDN());
        this.setUseLdapDNOrder(info.getUseLdapDnOrder());
        this.setUseCrlDistributionPointOnCrl(info.getUseCrlDistributionPointOnCrl());
        this.setCrlDistributionPointOnCrlCritical(info.getCrlDistributionPointOnCrlCritical());
        this.setCmpRaAuthSecret(info.getCmpRaAuthSecret());
        this.setNameConstraintsPermitted(info.getNameConstraintsPermitted());
        this.setNameConstraintsExcluded(info.getNameConstraintsExcluded());
        this.setExternalCdp(info.getExternalCdp());
    }

    @Override
    public void updateUninitializedCA(CAInfo cainfo) {
        super.updateUninitializedCA(cainfo);
        X509CAInfo info = (X509CAInfo)cainfo;
        this.data.put(SUBJECTALTNAME, info.getSubjectAltName());
        this.data.put(POLICIES, info.getPolicies());
    }

    @Override
    public byte[] createPKCS7(CryptoToken cryptoToken, Certificate cert, boolean includeChain) throws SignRequestSignatureException {
        try {
            if (cert != null) {
                X509Certificate cacert = (X509Certificate)this.getCACertificate();
                PublicKey verifyKey = cacert != null ? cacert.getPublicKey() : cryptoToken.getPublicKey(this.getCAToken().getAliasFromPurpose(1));
                cert.verify(verifyKey);
            }
        }
        catch (CryptoTokenOfflineException e) {
            throw new SignRequestSignatureException("The cryptotoken was not available, could not create a PKCS7", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new SignRequestSignatureException("The specified certificate contains the wrong public key.", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new SignRequestSignatureException("An encoding error was encountered.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignRequestSignatureException("The certificate provided was signed with an invalid algorithm.", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            throw new SignRequestSignatureException("The crypto provider was not found for verification of the certificate.", (Throwable)e);
        }
        catch (SignatureException e) {
            throw new SignRequestSignatureException("Cannot verify certificate in createPKCS7(), did I sign this?", (Throwable)e);
        }
        Collection<Certificate> chain = this.getCertificateChain();
        ArrayList<JcaX509CertificateHolder> certList = new ArrayList<JcaX509CertificateHolder>();
        try {
            if (cert != null) {
                certList.add(new JcaX509CertificateHolder((X509Certificate)cert));
            }
            if (includeChain) {
                for (Certificate certificate : chain) {
                    certList.add(new JcaX509CertificateHolder((X509Certificate)certificate));
                }
            }
        }
        catch (CertificateEncodingException e) {
            throw new SignRequestSignatureException("Could not encode certificate", (Throwable)e);
        }
        try {
            CMSProcessableByteArray msg = new CMSProcessableByteArray(new byte[0]);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            PrivateKey privateKey = cryptoToken.getPrivateKey(this.getCAToken().getAliasFromPurpose(1));
            if (privateKey == null) {
                String msg1 = "createPKCS7: Private key does not exist!";
                log.debug((Object)msg1);
                throw new SignRequestSignatureException(msg1);
            }
            String signatureAlgorithmName = AlgorithmTools.getAlgorithmNameFromDigestAndKey(CMSSignedGenerator.DIGEST_SHA1, privateKey.getAlgorithm());
            try {
                ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithmName).setProvider(cryptoToken.getSignProviderName()).build(privateKey);
                JcaDigestCalculatorProviderBuilder calculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder().setProvider("BC");
                JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(calculatorProviderBuilder.build());
                gen.addSignerInfoGenerator(builder.build(contentSigner, (X509Certificate)this.getCACertificate()));
            }
            catch (OperatorCreationException e) {
                throw new IllegalStateException("BouncyCastle failed in creating signature provider.", e);
            }
            gen.addCertificates((Store)new CollectionStore(certList));
            CMSSignedData s = null;
            CAToken catoken = this.getCAToken();
            if (catoken == null || cryptoToken instanceof NullCryptoToken) {
                String msg1 = "CA Token does not exist!";
                log.debug((Object)msg1);
                throw new SignRequestSignatureException(msg1);
            }
            log.debug((Object)("createPKCS7: Provider=" + cryptoToken.getSignProviderName() + " using algorithm " + privateKey.getAlgorithm()));
            s = gen.generate((CMSTypedData)msg, true);
            return s.getEncoded();
        }
        catch (CryptoTokenOfflineException e) {
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public byte[] createPKCS7Rollover(CryptoToken cryptoToken, int caid) throws SignRequestSignatureException {
        List<Certificate> nextChain = this.getRolloverCertificateChain();
        if (nextChain == null) {
            log.debug((Object)"CA does not have a rollover chain, returning empty PKCS#7");
            nextChain = Collections.emptyList();
        } else if (nextChain.isEmpty()) {
            log.warn((Object)"next chain exists but is empty");
        }
        ArrayList<JcaX509CertificateHolder> certList = new ArrayList<JcaX509CertificateHolder>();
        try {
            for (Certificate certificate : nextChain) {
                certList.add(new JcaX509CertificateHolder((X509Certificate)certificate));
            }
        }
        catch (CertificateEncodingException e) {
            throw new SignRequestSignatureException("Could not encode certificate", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("createPKCS7Rollover: Creating a rollover chain with " + certList.size() + " certificates."));
        }
        try {
            CMSProcessableByteArray msg = new CMSProcessableByteArray(new byte[0]);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            PrivateKey privateKey = cryptoToken.getPrivateKey(this.getCAToken().getAliasFromPurpose(1));
            if (privateKey == null) {
                String msg1 = "createPKCS7Rollover: Private key does not exist!";
                log.debug((Object)"createPKCS7Rollover: Private key does not exist!");
                throw new SignRequestSignatureException("createPKCS7Rollover: Private key does not exist!");
            }
            String signatureAlgorithmName = AlgorithmTools.getAlgorithmNameFromDigestAndKey(CMSSignedGenerator.DIGEST_SHA1, privateKey.getAlgorithm());
            try {
                ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithmName).setProvider(cryptoToken.getSignProviderName()).build(privateKey);
                JcaDigestCalculatorProviderBuilder calculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder().setProvider("BC");
                JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(calculatorProviderBuilder.build());
                gen.addSignerInfoGenerator(builder.build(contentSigner, (X509Certificate)this.getCACertificate()));
            }
            catch (OperatorCreationException e) {
                throw new IllegalStateException("BouncyCastle failed in creating signature provider.", e);
            }
            catch (CertificateEncodingException e) {
                throw new IllegalStateException(e);
            }
            gen.addCertificates((Store)new CollectionStore(certList));
            CMSSignedData s = null;
            CAToken catoken = this.getCAToken();
            if (catoken == null || cryptoToken instanceof NullCryptoToken) {
                String msg1 = "CA Token does not exist!";
                log.debug((Object)msg1);
                throw new SignRequestSignatureException(msg1);
            }
            log.debug((Object)("createPKCS7Rollover: Provider=" + cryptoToken.getSignProviderName() + " using algorithm " + privateKey.getAlgorithm()));
            s = gen.generate((CMSTypedData)msg, false);
            return s.getEncoded();
        }
        catch (CryptoTokenOfflineException e) {
            throw new IllegalStateException(e);
        }
        catch (CMSException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to encode CMS data", e);
        }
    }

    @Override
    public byte[] createRequest(CryptoToken cryptoToken, Collection<ASN1Encodable> attributes, String signAlg, Certificate cacert, int signatureKeyPurpose) throws CryptoTokenOfflineException {
        log.trace((Object)(">createRequest: " + signAlg + ", " + CertTools.getSubjectDN(cacert) + ", " + signatureKeyPurpose));
        DERSet attrset = new DERSet();
        if (attributes != null) {
            log.debug((Object)"Adding attributes in the request");
            Iterator<ASN1Encodable> iter = attributes.iterator();
            ASN1EncodableVector vec = new ASN1EncodableVector();
            while (iter.hasNext()) {
                ASN1Encodable o = iter.next();
                vec.add(o);
            }
            attrset = new DERSet(vec);
        }
        X500NameStyle nameStyle = this.getUsePrintableStringSubjectDN() ? PrintableStringNameStyle.INSTANCE : CeSecoreNameStyle.INSTANCE;
        X500Name x509dn = CertTools.stringToBcX500Name(this.getSubjectDN(), nameStyle, this.getUseLdapDNOrder());
        try {
            CAToken catoken = this.getCAToken();
            String alias = catoken.getAliasFromPurpose(signatureKeyPurpose);
            KeyPair keyPair = new KeyPair(cryptoToken.getPublicKey(alias), cryptoToken.getPrivateKey(alias));
            PKCS10CertificationRequest req = CertTools.genPKCS10CertificationRequest(signAlg, x509dn, keyPair.getPublic(), (ASN1Set)attrset, keyPair.getPrivate(), cryptoToken.getSignProviderName());
            log.trace((Object)"<createRequest");
            return req.getEncoded();
        }
        catch (CryptoTokenOfflineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] createAuthCertSignRequest(CryptoToken cryptoToken, byte[] request) throws CryptoTokenOfflineException {
        throw new UnsupportedOperationException("Creation of authenticated CSRs is not supported for X509 CAs.");
    }

    @Override
    public void createOrRemoveLinkCertificate(CryptoToken cryptoToken, boolean createLinkCertificate, CertificateProfile certProfile, AvailableCustomCertificateExtensionsConfiguration cceConfig) throws CryptoTokenOfflineException {
        byte[] ret = null;
        if (createLinkCertificate) {
            try {
                CAToken catoken = this.getCAToken();
                X509Certificate currentCaCert = (X509Certificate)this.getCACertificate();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"We will create a link certificate.");
                }
                X509CAInfo info = (X509CAInfo)this.getCAInfo();
                EndEntityInformation cadata = new EndEntityInformation("nobody", info.getSubjectDN(), info.getSubjectDN().hashCode(), info.getSubjectAltName(), null, 0, new EndEntityType(EndEntityTypes.INVALID), 0, info.getCertificateProfileId(), null, null, 0, 0, null);
                PublicKey previousCaPublicKey = cryptoToken.getPublicKey(catoken.getAliasFromPurpose(6));
                PrivateKey previousCaPrivateKey = cryptoToken.getPrivateKey(catoken.getAliasFromPurpose(6));
                String provider = cryptoToken.getSignProviderName();
                String ignoredKeySequence = catoken.getProperties().getProperty("previousSequence");
                Certificate retcert = this.generateCertificate(cadata, null, currentCaCert.getPublicKey(), -1, currentCaCert.getNotBefore(), currentCaCert.getNotAfter(), certProfile, null, ignoredKeySequence, previousCaPublicKey, previousCaPrivateKey, provider, null, cceConfig);
                log.info((Object)intres.getLocalizedMessage("cvc.info.createlinkcert", cadata.getDN(), cadata.getDN()));
                ret = retcert.getEncoded();
            }
            catch (CryptoTokenOfflineException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Bad CV CA certificate.", e);
            }
        }
        this.updateLatestLinkCertificate(ret);
    }

    @Override
    public Certificate generateCertificate(CryptoToken cryptoToken, EndEntityInformation subject, RequestMessage request, PublicKey publicKey, int keyusage, Date notBefore, Date notAfter, CertificateProfile certProfile, Extensions extensions, String sequence, CertificateGenerationParams certGenParams, AvailableCustomCertificateExtensionsConfiguration cceConfig) throws CryptoTokenOfflineException, CAOfflineException, InvalidAlgorithmException, IllegalValidityException, IllegalNameException, OperatorCreationException, CertificateCreateException, CertificateExtensionException, SignatureException {
        CAToken catoken = this.getCAToken();
        int purpose = this.getUseNextCACert(request) ? 7 : 1;
        PublicKey caPublicKey = cryptoToken.getPublicKey(catoken.getAliasFromPurpose(purpose));
        PrivateKey caPrivateKey = cryptoToken.getPrivateKey(catoken.getAliasFromPurpose(purpose));
        String provider = cryptoToken.getSignProviderName();
        return this.generateCertificate(subject, request, publicKey, keyusage, notBefore, notAfter, certProfile, extensions, sequence, caPublicKey, caPrivateKey, provider, certGenParams, cceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate generateCertificate(EndEntityInformation subject, RequestMessage request, PublicKey publicKey, int keyusage, Date notBefore, Date notAfter, CertificateProfile certProfile, Extensions extensions, String sequence, PublicKey caPublicKey, PrivateKey caPrivateKey, String provider, CertificateGenerationParams certGenParams, AvailableCustomCertificateExtensionsConfiguration cceConfig) throws CAOfflineException, InvalidAlgorithmException, IllegalValidityException, IllegalNameException, CertificateExtensionException, OperatorCreationException, CertificateCreateException, SignatureException {
        X509Certificate cert;
        BufferingContentSigner signer;
        X509v3CertificateBuilder certbuilder;
        X509Certificate cacert;
        boolean isRootCA;
        String sigAlg;
        block81: {
            X509v3CertificateBuilder precertbuilder;
            SubjectPublicKeyInfo pkinfo;
            X500Name issuerDNName;
            X500Name subjectDNName;
            BigInteger serno;
            if (this.getStatus() != 1 && this.getStatus() != 3) {
                String msg = intres.getLocalizedMessage("error.caoffline", this.getName(), this.getStatus());
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg);
                }
                throw new CAOfflineException(msg);
            }
            sigAlg = certProfile.getSignatureAlgorithm() == null ? this.getCAToken().getSignatureAlgorithm() : certProfile.getSignatureAlgorithm();
            if (!ArrayUtils.contains((Object[])AlgorithmConstants.AVAILABLE_SIGALGS, (Object)sigAlg)) {
                String msg = intres.getLocalizedMessage("createcert.invalidsignaturealg", sigAlg);
                throw new InvalidAlgorithmException(msg);
            }
            isRootCA = certProfile.getType() == 8;
            boolean useNextCACert = this.getUseNextCACert(request);
            cacert = (X509Certificate)(useNextCACert ? this.getRolloverCertificateChain().get(0) : this.getCACertificate());
            Date now = new Date();
            Date checkDate = useNextCACert && cacert.getNotBefore().after(now) ? cacert.getNotBefore() : now;
            CertificateValidity.checkPrivateKeyUsagePeriod(cacert, checkDate);
            CertificateValidity val = new CertificateValidity(subject, certProfile, notBefore, notAfter, cacert, isRootCA);
            ExtendedInformation ei = subject.getExtendedinformation();
            if (certProfile.getAllowCertSerialNumberOverride()) {
                serno = ei != null && ei.certificateSerialNumber() != null ? ei.certificateSerialNumber() : SernoGeneratorRandom.instance().getSerno();
            } else {
                serno = SernoGeneratorRandom.instance().getSerno();
                if (ei != null && ei.certificateSerialNumber() != null) {
                    String msg = intres.getLocalizedMessage("createcert.certprof_not_allowing_cert_sn_override_using_normal", ei.certificateSerialNumber().toString(16));
                    log.info((Object)msg);
                }
            }
            String dn = subject.getCertificateDN();
            if (certProfile.getUseSubjectDNSubSet()) {
                dn = certProfile.createSubjectDNSubSet(dn);
            }
            X500NameStyle nameStyle = this.getUsePrintableStringSubjectDN() ? PrintableStringNameStyle.INSTANCE : CeSecoreNameStyle.INSTANCE;
            if (certProfile.getUseCNPostfix()) {
                dn = CertTools.insertCNPostfix(dn, certProfile.getCNPostfix(), nameStyle);
            }
            boolean ldapdnorder = this.getUseLdapDNOrder() && certProfile.getUseLdapDnOrder();
            if (certProfile.getAllowDNOverride() && request != null && request.getRequestX500Name() != null) {
                subjectDNName = request.getRequestX500Name();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Using X509Name from request instead of user's registered.");
                }
            } else {
                ExtendedInformation ei2 = subject.getExtendedinformation();
                if (certProfile.getAllowDNOverrideByEndEntityInformation() && ei2 != null && ei2.getRawSubjectDn() != null) {
                    String stripped = StringTools.strip(ei2.getRawSubjectDn());
                    String escapedPluses = CertTools.handleUnescapedPlus(stripped);
                    String emptiesRemoved = DNFieldsUtil.removeAllEmpties(escapedPluses);
                    X500Name subjectDNNameFromEei = CertTools.stringToUnorderedX500Name(emptiesRemoved, CeSecoreNameStyle.INSTANCE);
                    if (subjectDNNameFromEei.toString().length() > 0) {
                        subjectDNName = subjectDNNameFromEei;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Using X500Name from end entity information instead of user's registered subject DN fields.");
                            log.debug((Object)("ExtendedInformation.getRawSubjectDn(): " + ei2.getRawSubjectDn() + " will use: " + CeSecoreNameStyle.INSTANCE.toString(subjectDNName)));
                        }
                    } else {
                        subjectDNName = CertTools.stringToBcX500Name(dn, nameStyle, ldapdnorder);
                    }
                } else {
                    subjectDNName = CertTools.stringToBcX500Name(dn, nameStyle, ldapdnorder);
                }
            }
            if (StringTools.hasStripChars(subjectDNName.toString())) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("DN with illegal name: " + subjectDNName));
                }
                String msg = intres.getLocalizedMessage("createcert.illegalname", new Object[0]);
                throw new IllegalNameException(msg);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using subjectDN: " + subjectDNName.toString()));
            }
            if (isRootCA) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Using subject DN also as issuer DN, because it is a root CA");
                }
                issuerDNName = subjectDNName;
            } else {
                issuerDNName = X500Name.getInstance((Object)cacert.getSubjectX500Principal().getEncoded());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using issuer DN directly from the CA certificate: " + issuerDNName.toString()));
                }
            }
            try {
                pkinfo = new SubjectPublicKeyInfo((ASN1Sequence)ASN1Primitive.fromByteArray((byte[])publicKey.getEncoded()));
            }
            catch (IOException e) {
                throw new IllegalStateException("Caught unexpected IOException.", e);
            }
            certbuilder = new X509v3CertificateBuilder(issuerDNName, serno, val.getNotBefore(), val.getNotAfter(), subjectDNName, pkinfo);
            X509v3CertificateBuilder x509v3CertificateBuilder = precertbuilder = certProfile.isUseCertificateTransparencyInCerts() ? new X509v3CertificateBuilder(issuerDNName, serno, val.getNotBefore(), val.getNotAfter(), subjectDNName, pkinfo) : null;
            if (cacert instanceof X509Certificate) {
                GeneralNames altNameGNs = null;
                String altName = subject.getSubjectAltName();
                if (certProfile.getUseSubjectAltNameSubSet()) {
                    altName = certProfile.createSubjectAltNameSubSet(altName);
                }
                if (altName != null && altName.length() > 0) {
                    altNameGNs = CertTools.getGeneralNamesFromAltName(altName);
                }
                CertTools.checkNameConstraints(cacert, subjectDNName, altNameGNs);
            }
            if (subject.getExtendedinformation() != null) {
                ExtendedInformation ei3 = subject.getExtendedinformation();
                List<String> permittedNC = ei3.getNameConstraintsPermitted();
                List<String> excludedNC = ei3.getNameConstraintsExcluded();
                if ((permittedNC != null && !permittedNC.isEmpty() || excludedNC != null && !excludedNC.isEmpty()) && !certProfile.getUseNameConstraints()) {
                    throw new CertificateCreateException("Tried to issue a certificate with Name Constraints without having enabled NC in the certificate profile.");
                }
            }
            ExtensionsGenerator extgen = new ExtensionsGenerator();
            if (certProfile.getAllowExtensionOverride() && extensions != null) {
                ASN1ObjectIdentifier[] oids;
                for (Object oid : oids = extensions.getExtensionOIDs()) {
                    Extension ext = extensions.getExtension(oid);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Overriding extension with oid: " + oid));
                    }
                    try {
                        extgen.addExtension(oid, ext.isCritical(), ext.getParsedValue());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Caught unexpected IOException.", e);
                    }
                }
            }
            Extensions overridenexts = extgen.generate();
            if (certProfile.getAllowKeyUsageOverride() && keyusage >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AllowKeyUsageOverride=true. Using KeyUsage from parameter: " + keyusage));
                }
                if (certProfile.getUseKeyUsage() && keyusage >= 0) {
                    KeyUsage ku = new KeyUsage(keyusage);
                    if (overridenexts.getExtension(Extension.keyUsage) == null) {
                        try {
                            extgen.addExtension(Extension.keyUsage, certProfile.getKeyUsageCritical(), (ASN1Encodable)ku);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Caught unexpected IOException.", e);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"KeyUsage was already overridden by an extension, not using KeyUsage from parameter.");
                    }
                }
            }
            CertificateExtensionFactory fact = CertificateExtensionFactory.getInstance();
            List<String> usedStdCertExt = certProfile.getUsedStandardCertificateExtensions();
            Iterator<String> certStdExtIter = usedStdCertExt.iterator();
            overridenexts = extgen.generate();
            while (certStdExtIter.hasNext()) {
                Object oid;
                oid = certStdExtIter.next();
                if (overridenexts.getExtension(new ASN1ObjectIdentifier((String)oid)) == null) {
                    byte[] value;
                    CertificateExtension certExt = fact.getStandardCertificateExtension((String)oid, certProfile);
                    if (certExt == null || (value = certExt.getValueEncoded(subject, this, certProfile, publicKey, caPublicKey, val)) == null) continue;
                    extgen.addExtension(new ASN1ObjectIdentifier(certExt.getOID()), certExt.isCriticalFlag(), value);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Extension with oid " + (String)oid + " has been overridden, standard extension will not be added."));
            }
            List<Integer> usedCertExt = certProfile.getUsedCertificateExtensions();
            for (int id : usedCertExt) {
                CustomCertificateExtension certExt = cceConfig.getCustomCertificateExtension(id);
                if (certExt == null) continue;
                if (overridenexts.getExtension(new ASN1ObjectIdentifier(certExt.getOID())) == null) {
                    byte[] value = certExt.getValueEncoded(subject, this, certProfile, publicKey, caPublicKey, val);
                    if (value == null) continue;
                    extgen.addExtension(new ASN1ObjectIdentifier(certExt.getOID()), certExt.isCriticalFlag(), value);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Extension with oid " + certExt.getOID() + " has been overridden, custom extension will not be added."));
            }
            Extensions exts = extgen.generate();
            ASN1ObjectIdentifier[] oids = exts.getExtensionOIDs();
            try {
                for (ASN1ObjectIdentifier oid : oids) {
                    Extension extension = exts.getExtension(oid);
                    if (oid.equals((Object)Extension.subjectAlternativeName)) {
                        ExtensionsGenerator sanExtGen = this.getSubjectAltNameExtensionForCert(extension, precertbuilder != null);
                        Extensions sanExts = sanExtGen.generate();
                        Extension eext = sanExts.getExtension(oid);
                        certbuilder.addExtension(oid, eext.isCritical(), eext.getParsedValue());
                        if (precertbuilder == null) continue;
                        eext = this.getSubjectAltNameExtensionForCTCert(extension).generate().getExtension(oid);
                        precertbuilder.addExtension(oid, eext.isCritical(), eext.getParsedValue());
                        eext = sanExts.getExtension(new ASN1ObjectIdentifier("1.3.6.1.4.1.11129.2.4.6"));
                        if (eext == null) continue;
                        certbuilder.addExtension(eext.getExtnId(), eext.isCritical(), eext.getParsedValue());
                        continue;
                    }
                    boolean isCritical = extension.isCritical();
                    byte[] value = extension.getExtnValue().getOctets();
                    certbuilder.addExtension(extension.getExtnId(), isCritical, value);
                    if (precertbuilder == null) continue;
                    precertbuilder.addExtension(extension.getExtnId(), isCritical, value);
                }
                if (ct != null && certProfile.isUseCertificateTransparencyInCerts() && certGenParams.getConfiguredCTLogs() != null && certGenParams.getCTAuditLogCallback() != null) {
                    ct.addPreCertPoison(precertbuilder);
                    signer = new BufferingContentSigner(new JcaContentSignerBuilder(sigAlg).setProvider(provider).build(caPrivateKey), 20480);
                    X509CertificateHolder certHolder = precertbuilder.build((ContentSigner)signer);
                    X509Certificate cert2 = (X509Certificate)CertTools.getCertfromByteArray(certHolder.getEncoded());
                    ArrayList<Certificate> chain = new ArrayList<Certificate>();
                    chain.add(cert2);
                    chain.addAll(this.getCertificateChain());
                    byte[] sctlist = null;
                    try {
                        sctlist = ct.fetchSCTList(chain, certProfile, certGenParams.getConfiguredCTLogs());
                        certGenParams.getCTAuditLogCallback().logPreCertSubmission(this, subject, cert2, sctlist != null);
                    }
                    catch (Throwable throwable) {
                        certGenParams.getCTAuditLogCallback().logPreCertSubmission(this, subject, cert2, sctlist != null);
                        throw throwable;
                    }
                    if (sctlist != null) {
                        ASN1ObjectIdentifier sctOid = new ASN1ObjectIdentifier("1.3.6.1.4.1.11129.2.4.2");
                        certbuilder.addExtension(sctOid, false, (ASN1Encodable)new DEROctetString(sctlist));
                    }
                    break block81;
                }
                if (log.isDebugEnabled()) {
                    String cause = "";
                    if (ct == null) {
                        cause = cause + "CT is not available in this version of EJBCA.";
                    } else {
                        if (!certProfile.isUseCertificateTransparencyInCerts()) {
                            cause = cause + "CT is not enabled in the certificate profile. ";
                        }
                        if (certGenParams == null) {
                            cause = cause + "Certificate generation parameters was null.";
                        } else if (certGenParams.getCTAuditLogCallback() == null) {
                            cause = cause + "No CT audit logging callback was passed to X509CA.";
                        } else if (certGenParams.getConfiguredCTLogs() == null) {
                            cause = cause + "There are no CT logs configured in System Configuration.";
                        }
                    }
                    log.debug((Object)("Not logging to CT. " + cause));
                }
            }
            catch (CertificateException e) {
                throw new CertificateCreateException("Could not process CA's private key when parsing Certificate Transparency extension.", (Exception)e);
            }
            catch (IOException e) {
                throw new CertificateCreateException("IOException was caught when parsing Certificate Transparency extension.", (Exception)e);
            }
            catch (CTLogException e) {
                throw new CertificateCreateException("An exception occurred because too many CT servers were down to satisfy the certificate profile.", (Exception)e);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)">certgen.generate");
        }
        signer = new BufferingContentSigner(new JcaContentSignerBuilder(sigAlg).setProvider(provider).build(caPrivateKey), 20480);
        X509CertificateHolder certHolder = certbuilder.build((ContentSigner)signer);
        try {
            cert = (X509Certificate)CertTools.getCertfromByteArray(certHolder.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException caught when parsing certificate holder.", e);
        }
        catch (CertificateException e) {
            throw new CertificateCreateException("Could not create certificate from CA's private key,", (Exception)e);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"<certgen.generate");
        }
        PublicKey verifyKey = cacert != null && !isRootCA ? cacert.getPublicKey() : caPublicKey;
        try {
            cert.verify(verifyKey);
        }
        catch (InvalidKeyException e) {
            throw new CertificateCreateException("CA's public key was invalid,", (Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateCreateException(e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Provider was unknown", e);
        }
        catch (CertificateException e) {
            throw new CertificateCreateException(e);
        }
        if (cacert != null) {
            boolean eq;
            String msg;
            boolean eq2;
            byte[] aki = CertTools.getAuthorityKeyId(cert);
            byte[] ski = CertTools.getSubjectKeyId(isRootCA ? cert : cacert);
            if (aki != null && ski != null && !(eq2 = Arrays.equals(aki, ski))) {
                String akistr = new String(Hex.encode((byte[])aki));
                String skistr = new String(Hex.encode((byte[])ski));
                msg = intres.getLocalizedMessage("createcert.errorpathverifykeyid", akistr, skistr);
                log.error((Object)msg);
            }
            X500Principal issuerDN = cert.getIssuerX500Principal();
            X500Principal caSubjectDN = cacert.getSubjectX500Principal();
            if (issuerDN != null && caSubjectDN != null && !(eq = issuerDN.equals(caSubjectDN))) {
                msg = intres.getLocalizedMessage("createcert.errorpathverifydn", issuerDN.getName(), caSubjectDN.getName());
                log.error((Object)msg);
                throw new CertificateCreateException(msg);
            }
        }
        if (request != null) {
            request.setResponseKeyInfo(caPrivateKey, provider);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("X509CA: generated certificate, CA " + this.getCAId() + " for DN: " + subject.getCertificateDN()));
        }
        return cert;
    }

    @Override
    public X509CRLHolder generateCRL(CryptoToken cryptoToken, Collection<RevokedCertInfo> certs, int crlnumber) throws CryptoTokenOfflineException, IllegalCryptoTokenException, IOException, SignatureException, NoSuchProviderException, InvalidKeyException, CRLException, NoSuchAlgorithmException {
        return this.generateCRL(cryptoToken, certs, this.getCRLPeriod(), crlnumber, false, 0);
    }

    @Override
    public X509CRLHolder generateDeltaCRL(CryptoToken cryptoToken, Collection<RevokedCertInfo> certs, int crlnumber, int basecrlnumber) throws CryptoTokenOfflineException, IllegalCryptoTokenException, IOException, SignatureException, NoSuchProviderException, InvalidKeyException, CRLException, NoSuchAlgorithmException {
        return this.generateCRL(cryptoToken, certs, this.getDeltaCRLPeriod(), crlnumber, true, basecrlnumber);
    }

    protected ExtensionsGenerator getSubjectAltNameExtensionForCert(Extension subAltNameExt, boolean publishToCT) throws IOException {
        GeneralNames names = CertTools.getGeneralNamesFromExtension(subAltNameExt);
        GeneralName[] gns = names.getNames();
        boolean sanEdited = false;
        ASN1EncodableVector nrOfRecactedLables = new ASN1EncodableVector();
        for (int j = 0; j < gns.length; ++j) {
            GeneralName generalName = gns[j];
            if (generalName.getTagNo() != 2) continue;
            String str = CertTools.getGeneralNameString(2, generalName.getName());
            if (StringUtils.contains((String)str, (String)"(") && StringUtils.contains((String)str, (String)")")) {
                String certBuilderDNSValue = StringUtils.remove((String)str, (String)"dNSName=");
                certBuilderDNSValue = StringUtils.remove((String)certBuilderDNSValue, (char)'(');
                certBuilderDNSValue = StringUtils.remove((String)certBuilderDNSValue, (char)')');
                gns[j] = new GeneralName(2, (ASN1Encodable)new DERIA5String(certBuilderDNSValue));
                sanEdited = true;
                if (!publishToCT) continue;
                String redactedLable = StringUtils.substring((String)str, (int)StringUtils.indexOf((String)str, (String)"("), (int)(StringUtils.lastIndexOf((String)str, (String)")") + 1));
                nrOfRecactedLables.add((ASN1Encodable)new ASN1Integer((long)(StringUtils.countMatches((String)redactedLable, (String)".") + 1)));
                continue;
            }
            nrOfRecactedLables.add((ASN1Encodable)new ASN1Integer(0L));
        }
        ExtensionsGenerator gen = new ExtensionsGenerator();
        gen.addExtension(Extension.subjectAlternativeName, subAltNameExt.isCritical(), (ASN1Encodable)new GeneralNames(gns));
        if (publishToCT && sanEdited) {
            DERSequence seq = new DERSequence(nrOfRecactedLables);
            gen.addExtension(new ASN1ObjectIdentifier("1.3.6.1.4.1.11129.2.4.6"), false, (ASN1Encodable)seq);
        }
        return gen;
    }

    private ExtensionsGenerator getSubjectAltNameExtensionForCTCert(Extension subAltNameExt) throws IOException {
        String subAltName = CertTools.getAltNameStringFromExtension(subAltNameExt);
        List<String> dnsValues = CertTools.getPartsFromDN(subAltName, "dNSName");
        for (String dns : dnsValues) {
            if (!StringUtils.contains((String)dns, (String)"(") || !StringUtils.contains((String)dns, (String)")")) continue;
            String redactedLable = StringUtils.substring((String)dns, (int)StringUtils.indexOf((String)dns, (String)"("), (int)(StringUtils.lastIndexOf((String)dns, (String)")") + 1));
            subAltName = StringUtils.replace((String)subAltName, (String)redactedLable, (String)"(PRIVATE)");
        }
        ExtensionsGenerator gen = new ExtensionsGenerator();
        gen.addExtension(Extension.subjectAlternativeName, subAltNameExt.isCritical(), CertTools.getGeneralNamesFromAltName(subAltName).getEncoded());
        return gen;
    }

    private X509CRLHolder generateCRL(CryptoToken cryptoToken, Collection<RevokedCertInfo> certs, long crlPeriod, int crlnumber, boolean isDeltaCRL, int basecrlnumber) throws CryptoTokenOfflineException, IllegalCryptoTokenException, IOException, SignatureException, NoSuchProviderException, InvalidKeyException, CRLException, NoSuchAlgorithmException {
        PublicKey verifyKey;
        X509CRLHolder crl;
        X500Name issuer;
        X509Certificate cacert;
        String sigAlg = this.getCAInfo().getCAToken().getSignatureAlgorithm();
        if (log.isDebugEnabled()) {
            log.debug((Object)("generateCRL(" + certs.size() + ", " + crlPeriod + ", " + crlnumber + ", " + isDeltaCRL + ", " + basecrlnumber));
        }
        if ((cacert = (X509Certificate)this.getCACertificate()) == null) {
            X500NameStyle nameStyle = this.getUsePrintableStringSubjectDN() ? PrintableStringNameStyle.INSTANCE : CeSecoreNameStyle.INSTANCE;
            issuer = CertTools.stringToBcX500Name(this.getSubjectDN(), nameStyle, this.getUseLdapDNOrder());
        } else {
            issuer = X500Name.getInstance((Object)cacert.getSubjectX500Principal().getEncoded());
        }
        Date thisUpdate = new Date();
        Date nextUpdate = new Date();
        nextUpdate.setTime(nextUpdate.getTime() + crlPeriod);
        X509v2CRLBuilder crlgen = new X509v2CRLBuilder(issuer, thisUpdate);
        crlgen.setNextUpdate(nextUpdate);
        if (certs != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding " + certs.size() + " revoked certificates to CRL. Free memory=" + Runtime.getRuntime().freeMemory()));
            }
            for (RevokedCertInfo certinfo : certs) {
                crlgen.addCRLEntry(certinfo.getUserCertificate(), certinfo.getRevocationDate(), certinfo.getReason());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished adding " + certs.size() + " revoked certificates to CRL. Free memory=" + Runtime.getRuntime().freeMemory()));
            }
        }
        if (this.getUseAuthorityKeyIdentifier()) {
            byte[] caSkid;
            byte[] byArray = caSkid = cacert != null ? CertTools.getSubjectKeyId(cacert) : null;
            if (caSkid != null) {
                AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier(caSkid);
                crlgen.addExtension(Extension.authorityKeyIdentifier, this.getAuthorityKeyIdentifierCritical(), (ASN1Encodable)aki);
            } else {
                JcaX509ExtensionUtils extensionUtils = new JcaX509ExtensionUtils((DigestCalculator)SHA1DigestCalculator.buildSha1Instance());
                AuthorityKeyIdentifier aki = extensionUtils.createAuthorityKeyIdentifier(cryptoToken.getPublicKey(this.getCAToken().getAliasFromPurpose(2)));
                crlgen.addExtension(Extension.authorityKeyIdentifier, this.getAuthorityKeyIdentifierCritical(), (ASN1Encodable)aki);
            }
        }
        ASN1EncodableVector accessList = new ASN1EncodableVector();
        if (this.getAuthorityInformationAccess() != null) {
            for (String url : this.getAuthorityInformationAccess()) {
                if (!StringUtils.isNotEmpty((String)url)) continue;
                GeneralName accessLocation = new GeneralName(6, (ASN1Encodable)new DERIA5String(url));
                accessList.add((ASN1Encodable)new AccessDescription(AccessDescription.id_ad_caIssuers, accessLocation));
            }
        }
        if (accessList.size() > 0) {
            AuthorityInformationAccess authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)new DERSequence(accessList));
            crlgen.addExtension(Extension.authorityInfoAccess, false, (ASN1Encodable)authorityInformationAccess);
        }
        if (this.getUseCRLNumber()) {
            CRLNumber crlnum = new CRLNumber(BigInteger.valueOf(crlnumber));
            crlgen.addExtension(Extension.cRLNumber, this.getCRLNumberCritical(), (ASN1Encodable)crlnum);
        }
        if (isDeltaCRL) {
            CRLNumber basecrlnum = new CRLNumber(BigInteger.valueOf(basecrlnumber));
            crlgen.addExtension(Extension.deltaCRLIndicator, true, (ASN1Encodable)basecrlnum);
        }
        if (this.getUseCrlDistributionPointOnCrl()) {
            String crlFreshestDP;
            List<DistributionPoint> freshestDistPoints;
            String crldistpoint = this.getDefaultCRLDistPoint();
            List<DistributionPoint> distpoints = this.generateDistributionPoints(crldistpoint);
            if (distpoints.size() > 0) {
                IssuingDistributionPoint idp = new IssuingDistributionPoint(distpoints.get(0).getDistributionPoint(), false, false, null, false, false);
                crlgen.addExtension(Extension.issuingDistributionPoint, this.getCrlDistributionPointOnCrlCritical(), (ASN1Encodable)idp);
            }
            if (!isDeltaCRL && (freshestDistPoints = this.generateDistributionPoints(crlFreshestDP = this.getCADefinedFreshestCRL())).size() > 0) {
                CRLDistPoint ext = new CRLDistPoint(freshestDistPoints.toArray(new DistributionPoint[freshestDistPoints.size()]));
                crlgen.addExtension(Extension.freshestCRL, false, (ASN1Encodable)ext);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Signing CRL. Free memory=" + Runtime.getRuntime().freeMemory()));
        }
        String alias = this.getCAToken().getAliasFromPurpose(2);
        try {
            BufferingContentSigner signer = new BufferingContentSigner(new JcaContentSignerBuilder(sigAlg).setProvider(cryptoToken.getSignProviderName()).build(cryptoToken.getPrivateKey(alias)), 20480);
            crl = crlgen.build((ContentSigner)signer);
        }
        catch (OperatorCreationException e) {
            throw new RuntimeException("Can not create Jca content signer: ", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finished signing CRL. Free memory=" + Runtime.getRuntime().freeMemory()));
        }
        if (cacert != null) {
            verifyKey = cacert.getPublicKey();
            if (log.isTraceEnabled()) {
                log.trace((Object)"Got the verify key from the CA certificate.");
            }
        } else {
            verifyKey = cryptoToken.getPublicKey(alias);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Got the verify key from the CA token.");
            }
        }
        try {
            ContentVerifierProvider verifier = new JcaContentVerifierProviderBuilder().setProvider("BC").build(verifyKey);
            if (!crl.isSignatureValid(verifier)) {
                throw new SignatureException("Error verifying CRL to be returned.");
            }
        }
        catch (OperatorCreationException e) {
            throw new RuntimeException("Can not create Jca content signer: ", e);
        }
        catch (CertException e) {
            throw new SignatureException(e.getMessage(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning CRL. Free memory=" + Runtime.getRuntime().freeMemory()));
        }
        return crl;
    }

    private List<DistributionPoint> generateDistributionPoints(String distPoints) {
        if (distPoints == null) {
            distPoints = "";
        }
        Iterator<String> it = StringTools.splitURIs(distPoints).iterator();
        ArrayList<DistributionPoint> result = new ArrayList<DistributionPoint>();
        while (it.hasNext()) {
            String uri = it.next();
            GeneralName gn = new GeneralName(6, (ASN1Encodable)new DERIA5String(uri));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added CRL distpoint: " + uri));
            }
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)gn);
            GeneralNames gns = GeneralNames.getInstance((Object)new DERSequence(vec));
            DistributionPointName dpn = new DistributionPointName(0, (ASN1Encodable)gns);
            result.add(new DistributionPoint(dpn, null, null));
        }
        return result;
    }

    @Override
    public float getLatestVersion() {
        return 20.0f;
    }

    @Override
    public void upgrade() {
        if (Float.compare(20.0f, this.getVersion()) != 0) {
            Object o;
            log.info((Object)("Upgrading X509CA with version " + this.getVersion()));
            if (this.data.get(DEFAULTOCSPSERVICELOCATOR) == null) {
                this.setDefaultCRLDistPoint("");
                this.setDefaultOCSPServiceLocator("");
            }
            if (this.data.get("crlIssueInterval") == null) {
                this.setCRLIssueInterval(0L);
            }
            if (this.data.get("crlOverlapTime") == null) {
                this.setCRLOverlapTime(10L);
            }
            boolean useprintablestring = true;
            if (this.data.get("alwaysuseutf8subjectdn") == null) {
                if (this.data.get(USEUTF8POLICYTEXT) == null) {
                    this.setUseUTF8PolicyText(false);
                }
            } else {
                boolean useutf8 = (Boolean)this.data.get("alwaysuseutf8subjectdn");
                if (this.data.get(USEUTF8POLICYTEXT) == null) {
                    this.setUseUTF8PolicyText(useutf8);
                }
                boolean bl = useprintablestring = !useutf8;
            }
            if (this.data.get(USEPRINTABLESTRINGSUBJECTDN) == null) {
                this.setUsePrintableStringSubjectDN(useprintablestring);
            }
            if (this.data.get(DEFAULTCRLISSUER) == null) {
                this.setDefaultCRLIssuer(null);
            }
            if (this.data.get(USELDAPDNORDER) == null) {
                this.setUseLdapDNOrder(true);
            }
            if (this.data.get("deltacrlperiod") == null) {
                this.setDeltaCRLPeriod(0L);
            }
            if (this.data.get(USECRLDISTRIBUTIONPOINTONCRL) == null) {
                this.setUseCrlDistributionPointOnCrl(false);
            }
            if (this.data.get(CRLDISTRIBUTIONPOINTONCRLCRITICAL) == null) {
                this.setCrlDistributionPointOnCrlCritical(false);
            }
            if (this.data.get("includeinhealthcheck") == null) {
                this.setIncludeInHealthCheck(true);
            }
            if ((o = this.data.get("crlperiod")) instanceof Integer) {
                this.setCRLPeriod(((Integer)o).longValue() * 3600000L);
            }
            if ((o = this.data.get("crlIssueInterval")) instanceof Integer) {
                this.setCRLIssueInterval(((Integer)o).longValue() * 3600000L);
            }
            if ((o = this.data.get("crlOverlapTime")) instanceof Integer) {
                this.setCRLOverlapTime(((Integer)o).longValue() * 60000L);
            }
            if ((o = this.data.get("deltacrlperiod")) instanceof Integer) {
                this.setDeltaCRLPeriod(((Integer)o).longValue() * 3600000L);
            }
            this.data.put("version", new Float(20.0f));
            if (this.data.get("extendedcaservices") != null) {
                Collection types = (Collection)this.data.get("extendedcaservices");
                types.remove(2);
                this.data.put("extendedcaservices", types);
                this.data.remove("extendedcaservice2");
            }
        }
    }

    @Override
    public boolean upgradeExtendedCAServices() {
        boolean retval = false;
        Collection<Integer> externalServiceTypes = this.getExternalCAServiceTypes();
        if (!CesecoreConfiguration.getCaKeepOcspExtendedService() && externalServiceTypes.contains(1)) {
            externalServiceTypes.remove(1);
            this.data.put("extendedcaservices", externalServiceTypes);
            retval = true;
        }
        for (Integer type : externalServiceTypes) {
            ExtendedCAService service = this.getExtendedCAService(type);
            if (service != null) {
                if (Float.compare(service.getLatestVersion(), service.getVersion()) != 0) {
                    retval = true;
                    service.upgrade();
                    this.setExtendedCAServiceData(service.getExtendedCAServiceInfo().getType(), (HashMap)service.saveData());
                    continue;
                }
                if (!service.isUpgraded()) continue;
                retval = true;
                this.setExtendedCAServiceData(service.getExtendedCAServiceInfo().getType(), (HashMap)service.saveData());
                continue;
            }
            log.error((Object)("Extended service is null, can not upgrade service of type: " + type));
        }
        return retval;
    }

    @Override
    public byte[] encryptKeys(CryptoToken cryptoToken, String alias, KeyPair keypair) throws IOException, CMSException, CryptoTokenOfflineException, NoSuchAlgorithmException, NoSuchProviderException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(baos);
        os.writeObject(keypair);
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        PublicKey pk = cryptoToken.getPublicKey(alias);
        byte[] keyId = KeyTools.createSubjectKeyId(pk).getKeyIdentifier();
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(keyId, pk));
        JceCMSContentEncryptorBuilder jceCMSContentEncryptorBuilder = new JceCMSContentEncryptorBuilder(NISTObjectIdentifiers.id_aes256_CBC).setProvider("BC");
        CMSEnvelopedData ed = edGen.generate((CMSTypedData)new CMSProcessableByteArray(baos.toByteArray()), jceCMSContentEncryptorBuilder.build());
        log.info((Object)("Encrypted keys using key alias '" + alias + "' from Crypto Token " + cryptoToken.getId()));
        return ed.getEncoded();
    }

    @Override
    public KeyPair decryptKeys(CryptoToken cryptoToken, String alias, byte[] data) throws IOException, CMSException, CryptoTokenOfflineException, ClassNotFoundException {
        CMSEnvelopedData ed = new CMSEnvelopedData(data);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        RecipientInformation recipient = (RecipientInformation)recipients.getRecipients().iterator().next();
        ObjectInputStream ois = null;
        JceKeyTransEnvelopedRecipient rec = new JceKeyTransEnvelopedRecipient(cryptoToken.getPrivateKey(alias));
        rec.setProvider(cryptoToken.getEncProviderName());
        rec.setContentProvider("BC");
        rec.setMustProduceEncodableUnwrappedKey(true);
        byte[] recdata = recipient.getContent((Recipient)rec);
        ois = new ObjectInputStream(new ByteArrayInputStream(recdata));
        log.info((Object)("Decrypted keys using key alias '" + alias + "' from Crypto Token " + cryptoToken.getId()));
        return (KeyPair)ois.readObject();
    }

    @Override
    public byte[] decryptData(CryptoToken cryptoToken, byte[] data, int cAKeyPurpose) throws CMSException, CryptoTokenOfflineException {
        CMSEnvelopedData ed = new CMSEnvelopedData(data);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        RecipientInformation recipient = (RecipientInformation)recipients.getRecipients().iterator().next();
        String keyAlias = this.getCAToken().getAliasFromPurpose(cAKeyPurpose);
        JceKeyTransEnvelopedRecipient rec = new JceKeyTransEnvelopedRecipient(cryptoToken.getPrivateKey(keyAlias));
        rec.setProvider(cryptoToken.getSignProviderName());
        rec.setContentProvider("BC");
        rec.setMustProduceEncodableUnwrappedKey(true);
        byte[] recdata = recipient.getContent((Recipient)rec);
        log.info((Object)("Decrypted data using key alias '" + keyAlias + "' from Crypto Token " + cryptoToken.getId()));
        return recdata;
    }

    @Override
    public byte[] encryptData(CryptoToken cryptoToken, byte[] data, int keyPurpose) throws IOException, CMSException, CryptoTokenOfflineException, NoSuchAlgorithmException, NoSuchProviderException {
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        String keyAlias = this.getCAToken().getAliasFromPurpose(keyPurpose);
        PublicKey pk = cryptoToken.getPublicKey(keyAlias);
        byte[] keyId = KeyTools.createSubjectKeyId(pk).getKeyIdentifier();
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(keyId, pk));
        JceCMSContentEncryptorBuilder jceCMSContentEncryptorBuilder = new JceCMSContentEncryptorBuilder(NISTObjectIdentifiers.id_aes256_CBC).setProvider("BC");
        CMSEnvelopedData ed = edGen.generate((CMSTypedData)new CMSProcessableByteArray(data), jceCMSContentEncryptorBuilder.build());
        log.info((Object)("Encrypted data using key alias '" + keyAlias + "' from Crypto Token " + cryptoToken.getId()));
        return ed.getEncoded();
    }
}

