/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ca;

import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.cesecore.certificates.ca.CAInfo;
import org.cesecore.certificates.ca.catoken.CAToken;
import org.cesecore.certificates.ca.extendedservices.ExtendedCAServiceInfo;
import org.cesecore.certificates.certificateprofile.CertificatePolicy;
import org.cesecore.util.CertTools;
import org.cesecore.util.StringTools;

public class X509CAInfo
extends CAInfo {
    private static final long serialVersionUID = 2L;
    private List<CertificatePolicy> policies;
    private boolean useauthoritykeyidentifier;
    private boolean authoritykeyidentifiercritical;
    private boolean usecrlnumber;
    private boolean crlnumbercritical;
    private String defaultcrldistpoint;
    private String defaultcrlissuer;
    private String defaultocsplocator;
    private String cadefinedfreshestcrl;
    private String subjectaltname;
    private boolean useUTF8PolicyText;
    private boolean usePrintableStringSubjectDN;
    private boolean useLdapDNOrder;
    private boolean useCrlDistributionPointOnCrl;
    private boolean crlDistributionPointOnCrlCritical;
    private String cmpRaAuthSecret = "";
    private List<String> authorityInformationAccess;
    private List<String> nameConstraintsPermitted;
    private List<String> nameConstraintsExcluded;
    private String externalCdp;

    public X509CAInfo(String subjectdn, String name, int status, int certificateProfileId, long validity, int signedby, Collection<Certificate> certificatechain, CAToken catoken) {
        this(subjectdn, name, status, new Date(), "", certificateProfileId, validity, null, 1, signedby, certificatechain, catoken, "", -1, null, null, 86400000L, 0L, 36000000L, 36000000L, new ArrayList<Integer>(), true, false, true, false, null, null, null, null, null, null, null, true, new ArrayList<ExtendedCAServiceInfo>(), false, new ArrayList<Integer>(), 1, false, true, false, false, true, true, true, false, false, true, true, null);
    }

    public X509CAInfo(String subjectdn, String name, int status, Date updateTime, String subjectaltname, int certificateprofileid, long validity, Date expiretime, int catype, int signedby, Collection<Certificate> certificatechain, CAToken catoken, String description, int revocationReason, Date revocationDate, List<CertificatePolicy> policies, long crlperiod, long crlIssueInterval, long crlOverlapTime, long deltacrlperiod, Collection<Integer> crlpublishers, boolean useauthoritykeyidentifier, boolean authoritykeyidentifiercritical, boolean usecrlnumber, boolean crlnumbercritical, String defaultcrldistpoint, String defaultcrlissuer, String defaultocspservicelocator, List<String> authorityInformationAccess, List<String> nameConstraintsPermitted, List<String> nameConstraintsExcluded, String cadefinedfreshestcrl, boolean finishuser, Collection<ExtendedCAServiceInfo> extendedcaserviceinfos, boolean useUTF8PolicyText, Collection<Integer> approvalSettings, int numOfReqApprovals, boolean usePrintableStringSubjectDN, boolean useLdapDnOrder, boolean useCrlDistributionPointOnCrl, boolean crlDistributionPointOnCrlCritical, boolean includeInHealthCheck, boolean _doEnforceUniquePublicKeys, boolean _doEnforceUniqueDistinguishedName, boolean _doEnforceUniqueSubjectDNSerialnumber, boolean _useCertReqHistory, boolean _useUserStorage, boolean _useCertificateStorage, String _cmpRaAuthSecret) {
        this.subjectdn = CertTools.stringToBCDNString(StringTools.strip(subjectdn));
        this.caid = CertTools.stringToBCDNString(this.subjectdn).hashCode();
        this.name = name;
        this.status = status;
        this.updatetime = updateTime;
        this.validity = validity;
        this.expiretime = expiretime;
        this.catype = catype;
        this.signedby = signedby;
        try {
            if (certificatechain != null) {
                Certificate[] certs = certificatechain.toArray(new X509Certificate[certificatechain.size()]);
                Collection<Certificate> list = CertTools.getCertCollectionFromArray(certs, null);
                this.setCertificateChain(list);
            } else {
                this.setCertificateChain(null);
            }
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException(e);
        }
        this.catoken = catoken;
        this.description = description;
        this.setRevocationReason(revocationReason);
        this.revocationDate = revocationDate;
        this.policies = policies;
        this.crlperiod = crlperiod;
        this.crlIssueInterval = crlIssueInterval;
        this.crlOverlapTime = crlOverlapTime;
        this.deltacrlperiod = deltacrlperiod;
        this.crlpublishers = crlpublishers;
        this.useauthoritykeyidentifier = useauthoritykeyidentifier;
        this.authoritykeyidentifiercritical = authoritykeyidentifiercritical;
        this.usecrlnumber = usecrlnumber;
        this.crlnumbercritical = crlnumbercritical;
        this.defaultcrldistpoint = defaultcrldistpoint;
        this.defaultcrlissuer = defaultcrlissuer;
        this.defaultocsplocator = defaultocspservicelocator;
        this.cadefinedfreshestcrl = cadefinedfreshestcrl;
        this.finishuser = finishuser;
        this.subjectaltname = subjectaltname;
        this.certificateprofileid = certificateprofileid;
        this.extendedcaserviceinfos = extendedcaserviceinfos;
        this.useUTF8PolicyText = useUTF8PolicyText;
        this.approvalSettings = approvalSettings;
        this.numOfReqApprovals = numOfReqApprovals;
        this.usePrintableStringSubjectDN = usePrintableStringSubjectDN;
        this.useLdapDNOrder = useLdapDnOrder;
        this.useCrlDistributionPointOnCrl = useCrlDistributionPointOnCrl;
        this.crlDistributionPointOnCrlCritical = crlDistributionPointOnCrlCritical;
        this.includeInHealthCheck = includeInHealthCheck;
        this.doEnforceUniquePublicKeys = _doEnforceUniquePublicKeys;
        this.doEnforceUniqueDistinguishedName = _doEnforceUniqueDistinguishedName;
        this.doEnforceUniqueSubjectDNSerialnumber = _doEnforceUniqueSubjectDNSerialnumber;
        this.useCertReqHistory = _useCertReqHistory;
        this.useUserStorage = _useUserStorage;
        this.useCertificateStorage = _useCertificateStorage;
        this.setCmpRaAuthSecret(_cmpRaAuthSecret);
        this.authorityInformationAccess = authorityInformationAccess;
        this.nameConstraintsPermitted = nameConstraintsPermitted;
        this.nameConstraintsExcluded = nameConstraintsExcluded;
    }

    public X509CAInfo(int caid, long validity, CAToken catoken, String description, long crlperiod, long crlIssueInterval, long crlOverlapTime, long deltacrlperiod, Collection<Integer> crlpublishers, boolean useauthoritykeyidentifier, boolean authoritykeyidentifiercritical, boolean usecrlnumber, boolean crlnumbercritical, String defaultcrldistpoint, String defaultcrlissuer, String defaultocspservicelocator, List<String> authorityInformationAccess, List<String> nameConstraintsPermitted, List<String> nameConstraintsExcluded, String cadefinedfreshestcrl, boolean finishuser, Collection<ExtendedCAServiceInfo> extendedcaserviceinfos, boolean useUTF8PolicyText, Collection<Integer> approvalSettings, int numOfReqApprovals, boolean usePrintableStringSubjectDN, boolean useLdapDnOrder, boolean useCrlDistributionPointOnCrl, boolean crlDistributionPointOnCrlCritical, boolean includeInHealthCheck, boolean _doEnforceUniquePublicKeys, boolean _doEnforceUniqueDistinguishedName, boolean _doEnforceUniqueSubjectDNSerialnumber, boolean _useCertReqHistory, boolean _useUserStorage, boolean _useCertificateStorage, String _cmpRaAuthSecret) {
        this.caid = caid;
        this.validity = validity;
        this.catoken = catoken;
        this.description = description;
        this.crlperiod = crlperiod;
        this.crlIssueInterval = crlIssueInterval;
        this.crlOverlapTime = crlOverlapTime;
        this.deltacrlperiod = deltacrlperiod;
        this.crlpublishers = crlpublishers;
        this.useauthoritykeyidentifier = useauthoritykeyidentifier;
        this.authoritykeyidentifiercritical = authoritykeyidentifiercritical;
        this.usecrlnumber = usecrlnumber;
        this.crlnumbercritical = crlnumbercritical;
        this.defaultcrldistpoint = defaultcrldistpoint;
        this.defaultcrlissuer = defaultcrlissuer;
        this.defaultocsplocator = defaultocspservicelocator;
        this.cadefinedfreshestcrl = cadefinedfreshestcrl;
        this.finishuser = finishuser;
        this.extendedcaserviceinfos = extendedcaserviceinfos;
        this.useUTF8PolicyText = useUTF8PolicyText;
        this.approvalSettings = approvalSettings;
        this.numOfReqApprovals = numOfReqApprovals;
        this.usePrintableStringSubjectDN = usePrintableStringSubjectDN;
        this.useLdapDNOrder = useLdapDnOrder;
        this.useCrlDistributionPointOnCrl = useCrlDistributionPointOnCrl;
        this.crlDistributionPointOnCrlCritical = crlDistributionPointOnCrlCritical;
        this.includeInHealthCheck = includeInHealthCheck;
        this.doEnforceUniquePublicKeys = _doEnforceUniquePublicKeys;
        this.doEnforceUniqueDistinguishedName = _doEnforceUniqueDistinguishedName;
        this.doEnforceUniqueSubjectDNSerialnumber = _doEnforceUniqueSubjectDNSerialnumber;
        this.useCertReqHistory = _useCertReqHistory;
        this.useUserStorage = _useUserStorage;
        this.useCertificateStorage = _useCertificateStorage;
        this.setCmpRaAuthSecret(_cmpRaAuthSecret);
        this.authorityInformationAccess = authorityInformationAccess;
        this.nameConstraintsPermitted = nameConstraintsPermitted;
        this.nameConstraintsExcluded = nameConstraintsExcluded;
    }

    public List<CertificatePolicy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<CertificatePolicy> policies) {
        this.policies = policies;
    }

    public boolean getUseCRLNumber() {
        return this.usecrlnumber;
    }

    public void setUseCRLNumber(boolean usecrlnumber) {
        this.usecrlnumber = usecrlnumber;
    }

    public boolean getCRLNumberCritical() {
        return this.crlnumbercritical;
    }

    public void setCRLNumberCritical(boolean crlnumbercritical) {
        this.crlnumbercritical = crlnumbercritical;
    }

    public boolean getUseAuthorityKeyIdentifier() {
        return this.useauthoritykeyidentifier;
    }

    public void setUseAuthorityKeyIdentifier(boolean useauthoritykeyidentifier) {
        this.useauthoritykeyidentifier = useauthoritykeyidentifier;
    }

    public boolean getAuthorityKeyIdentifierCritical() {
        return this.authoritykeyidentifiercritical;
    }

    public void setAuthorityKeyIdentifierCritical(boolean authoritykeyidentifiercritical) {
        this.authoritykeyidentifiercritical = authoritykeyidentifiercritical;
    }

    public String getDefaultCRLDistPoint() {
        return this.defaultcrldistpoint;
    }

    public void setDefaultCRLDistPoint(String defaultCRLDistPoint) {
        this.defaultcrldistpoint = defaultCRLDistPoint;
    }

    public String getDefaultCRLIssuer() {
        return this.defaultcrlissuer;
    }

    public void setDefaultCRLIssuer(String defaultcrlissuer) {
        this.defaultcrlissuer = defaultcrlissuer;
    }

    public String getDefaultOCSPServiceLocator() {
        return this.defaultocsplocator;
    }

    public void setDefaultOCSPServiceLocator(String defaultocsplocator) {
        this.defaultocsplocator = defaultocsplocator;
    }

    public String getCADefinedFreshestCRL() {
        return this.cadefinedfreshestcrl;
    }

    public void setCADefinedFreshestCRL(String cADefinedFreshestCRL) {
        this.cadefinedfreshestcrl = cADefinedFreshestCRL;
    }

    public String getSubjectAltName() {
        return this.subjectaltname;
    }

    public void setSubjectAltName(String subjectaltname) {
        this.subjectaltname = subjectaltname;
    }

    public boolean getUseUTF8PolicyText() {
        return this.useUTF8PolicyText;
    }

    public void setUseUTF8PolicyText(boolean useUTF8PolicyText) {
        this.useUTF8PolicyText = useUTF8PolicyText;
    }

    public boolean getUsePrintableStringSubjectDN() {
        return this.usePrintableStringSubjectDN;
    }

    public void setUsePrintableStringSubjectDN(boolean usePrintableStringSubjectDN) {
        this.usePrintableStringSubjectDN = usePrintableStringSubjectDN;
    }

    public boolean getUseLdapDnOrder() {
        return this.useLdapDNOrder;
    }

    public void setUseLdapDnOrder(boolean useLdapDNOrder) {
        this.useLdapDNOrder = useLdapDNOrder;
    }

    public boolean getUseCrlDistributionPointOnCrl() {
        return this.useCrlDistributionPointOnCrl;
    }

    public void setUseCrlDistributionPointOnCrl(boolean useCrlDistributionPointOnCrl) {
        this.useCrlDistributionPointOnCrl = useCrlDistributionPointOnCrl;
    }

    public boolean getCrlDistributionPointOnCrlCritical() {
        return this.crlDistributionPointOnCrlCritical;
    }

    public void setCrlDistributionPointOnCrlCritical(boolean crlDistributionPointOnCrlCritical) {
        this.crlDistributionPointOnCrlCritical = crlDistributionPointOnCrlCritical;
    }

    public String getCmpRaAuthSecret() {
        return this.cmpRaAuthSecret;
    }

    public void setCmpRaAuthSecret(String cmpRaAuthSecret) {
        this.cmpRaAuthSecret = cmpRaAuthSecret == null ? "" : cmpRaAuthSecret;
    }

    public List<String> getAuthorityInformationAccess() {
        return this.authorityInformationAccess;
    }

    public void setAuthorityInformationAccess(List<String> authorityInformationAccess) {
        this.authorityInformationAccess = authorityInformationAccess;
    }

    public List<String> getNameConstraintsPermitted() {
        return this.nameConstraintsPermitted;
    }

    public void setNameConstraintsPermitted(List<String> encodedNames) {
        this.nameConstraintsPermitted = encodedNames;
    }

    public List<String> getNameConstraintsExcluded() {
        return this.nameConstraintsExcluded;
    }

    public void setNameConstraintsExcluded(List<String> encodedNames) {
        this.nameConstraintsExcluded = encodedNames;
    }

    public String getExternalCdp() {
        return this.externalCdp;
    }

    public void setExternalCdp(String externalCdp) {
        this.externalCdp = externalCdp;
    }
}

