/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ca.catoken;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.cesecore.certificates.ca.catoken.PurposeMapping;
import org.cesecore.internal.InternalResources;
import org.cesecore.internal.UpgradeableDataHashMap;
import org.cesecore.keys.token.CryptoToken;
import org.cesecore.keys.token.CryptoTokenOfflineException;
import org.cesecore.util.StringTools;

public class CAToken
extends UpgradeableDataHashMap {
    private static final long serialVersionUID = -459748276141898509L;
    private static final Logger log = Logger.getLogger(CAToken.class);
    private static final InternalResources intres = InternalResources.getInstance();
    public static final float LATEST_VERSION = 8.0f;
    @Deprecated
    public static final String CLASSPATH = "classpath";
    public static final String PROPERTYDATA = "propertydata";
    @Deprecated
    public static final String KEYSTORE = "KEYSTORE";
    public static final String DEFAULT_KEYSEQUENCE = "00000";
    public static final String SOFTPRIVATESIGNKEYALIAS = "signKey";
    public static final String SOFTPRIVATEDECKEYALIAS = "encryptKey";
    public static final String SEQUENCE = "sequence";
    public static final String SEQUENCE_FORMAT = "sequenceformat";
    public static final String SIGNATUREALGORITHM = "signaturealgorithm";
    public static final String ENCRYPTIONALGORITHM = "encryptionalgorithm";
    public static final String CRYPTOTOKENID = "cryptotokenid";
    private int cryptoTokenId;
    private transient PurposeMapping keyStrings = null;

    public CAToken(int cryptoTokenId, Properties caTokenProperties) {
        this.setCryptoTokenId(cryptoTokenId);
        this.internalInit(caTokenProperties);
    }

    private void internalInit(Properties caTokenProperties) {
        this.keyStrings = new PurposeMapping(caTokenProperties);
        this.setCATokenPropertyData(this.storeProperties(caTokenProperties));
    }

    public CAToken(HashMap tokendata) {
        this.loadData(tokendata);
        Object cryptoTokenIdObject = this.data.get(CRYPTOTOKENID);
        if (cryptoTokenIdObject == null) {
            log.warn((Object)"No CryptoTokenId in CAToken map. This can safely be ignored if shown during an upgrade from EJBCA 5.0.x or lower.");
        } else {
            this.cryptoTokenId = Integer.parseInt((String)cryptoTokenIdObject);
        }
        Properties caTokenProperties = this.getProperties();
        this.internalInit(caTokenProperties);
    }

    public int getTokenStatus(boolean caTokenSignTest, CryptoToken cryptoToken) {
        int ret;
        block19: {
            if (log.isTraceEnabled()) {
                log.trace((Object)">getCATokenStatus");
            }
            ret = 2;
            try {
                if (this.keyStrings == null) break block19;
                String[] aliases = this.keyStrings.getAliases();
                String aliasTestKey = this.getAliasFromPurpose(4);
                int i = 0;
                if (cryptoToken != null) {
                    HashMap<String, PrivateKey> aliasMap = new HashMap<String, PrivateKey>();
                    for (String alias : aliases) {
                        PublicKey publicKey;
                        PrivateKey privateKey = (PrivateKey)aliasMap.get(alias);
                        if (privateKey == null) {
                            try {
                                privateKey = cryptoToken.getPrivateKey(alias);
                                if (privateKey != null) {
                                    aliasMap.put(alias, privateKey);
                                }
                            }
                            catch (CryptoTokenOfflineException e) {
                                privateKey = null;
                            }
                        }
                        if (privateKey == null && log.isDebugEnabled()) {
                            log.debug((Object)("Missing private key for alias: " + alias));
                        }
                        ++i;
                        if (!alias.equals(aliasTestKey)) continue;
                        try {
                            publicKey = cryptoToken.getPublicKey(aliasTestKey);
                        }
                        catch (CryptoTokenOfflineException e) {
                            publicKey = null;
                        }
                        if (publicKey == null && log.isDebugEnabled()) {
                            log.debug((Object)("Missing public key for alias: " + alias));
                        }
                        try {
                            if (caTokenSignTest) {
                                cryptoToken.testKeyPair(alias, publicKey, privateKey);
                            }
                            ret = 1;
                        }
                        catch (Throwable th) {
                            log.error((Object)intres.getLocalizedMessage("token.activationtestfail", cryptoToken.getId()), th);
                        }
                    }
                }
                if (i < aliases.length && log.isDebugEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    for (int j = 0; j < aliases.length; ++j) {
                        builder.append(' ').append(aliases[j]);
                    }
                    log.debug((Object)("Not enough keys for the key aliases: " + builder.toString()));
                }
            }
            catch (CryptoTokenOfflineException e) {
                if (!log.isDebugEnabled()) break block19;
                log.debug((Object)("CryptoToken offline: " + e.getMessage()));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<getCATokenStatus: " + ret));
        }
        return ret;
    }

    public String getAliasFromPurpose(int purpose) throws CryptoTokenOfflineException {
        String alias;
        if (this.keyStrings == null) {
            this.keyStrings = new PurposeMapping(this.getProperties());
        }
        if ((alias = this.keyStrings.getAlias(purpose)) == null) {
            throw new CryptoTokenOfflineException("No alias for key purpose " + purpose);
        }
        return alias;
    }

    public int getCryptoTokenId() {
        return this.cryptoTokenId;
    }

    public void setCryptoTokenId(int cryptoTokenId) {
        this.cryptoTokenId = cryptoTokenId;
        this.data.put(CRYPTOTOKENID, String.valueOf(cryptoTokenId));
    }

    public void setProperty(String key, String value) {
        Properties caTokenProperties = this.getProperties();
        caTokenProperties.setProperty(key, value);
        this.setCATokenPropertyData(this.storeProperties(caTokenProperties));
    }

    private String storeProperties(Properties caTokenProperties) {
        this.keyStrings = new PurposeMapping(caTokenProperties);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        Enumeration<Object> e = caTokenProperties.keys();
        while (e.hasMoreElements()) {
            Object s = e.nextElement();
            if (caTokenProperties.get(s) == null) continue;
            writer.println(s + "=" + caTokenProperties.get(s));
        }
        writer.close();
        return baos.toString();
    }

    private void setCATokenPropertyData(String propertydata) {
        this.data.put(PROPERTYDATA, propertydata);
    }

    public Properties getProperties() {
        String propertyStr = null;
        if (this.data != null) {
            propertyStr = (String)this.data.get(PROPERTYDATA);
        }
        return CAToken.getPropertiesFromString(propertyStr);
    }

    public static Properties getPropertiesFromString(String propertyStr) {
        Properties prop = new Properties();
        if (StringUtils.isNotEmpty((String)propertyStr)) {
            try {
                propertyStr = StringUtils.replace((String)propertyStr, (String)"\\", (String)"\\\\");
                prop.load(new ByteArrayInputStream(propertyStr.getBytes()));
                for (Object keyObj : prop.keySet()) {
                    String key = (String)keyObj;
                    String value = prop.getProperty(key);
                    prop.setProperty(key, value.trim());
                }
            }
            catch (IOException e) {
                log.error((Object)"Error getting PCKS#11 token properties: ", (Throwable)e);
            }
        }
        return prop;
    }

    public String getKeySequence() {
        Object seq = this.data.get(SEQUENCE);
        if (seq == null) {
            seq = new String(DEFAULT_KEYSEQUENCE);
        }
        return (String)seq;
    }

    public void setKeySequence(String sequence) {
        this.data.put(SEQUENCE, sequence);
    }

    public void setKeySequenceFormat(int sequence) {
        this.data.put(SEQUENCE_FORMAT, sequence);
    }

    public int getKeySequenceFormat() {
        Object seqF = this.data.get(SEQUENCE_FORMAT);
        if (seqF == null) {
            seqF = 1;
        }
        return (Integer)seqF;
    }

    public String getSignatureAlgorithm() {
        return (String)this.data.get(SIGNATUREALGORITHM);
    }

    public void setSignatureAlgorithm(String signaturealgoritm) {
        this.data.put(SIGNATUREALGORITHM, signaturealgoritm);
    }

    public String getEncryptionAlgorithm() {
        return (String)this.data.get(ENCRYPTIONALGORITHM);
    }

    public void setEncryptionAlgorithm(String encryptionalgo) {
        this.data.put(ENCRYPTIONALGORITHM, encryptionalgo);
    }

    @Override
    public float getLatestVersion() {
        return 8.0f;
    }

    @Override
    public void upgrade() {
        if (Float.compare(8.0f, this.getVersion()) != 0) {
            String msg = intres.getLocalizedMessage("token.upgrade", new Float(this.getVersion()));
            log.info((Object)msg);
            if (this.data.get(SEQUENCE_FORMAT) == null) {
                log.info((Object)"Adding new sequence format to CA Token data: 1");
                this.data.put(SEQUENCE_FORMAT, 1);
            }
            if (this.data.get(SEQUENCE) == null) {
                log.info((Object)"Adding new default key sequence to CA Token data: 00000");
                this.data.put(SEQUENCE, DEFAULT_KEYSEQUENCE);
            }
            if (this.data.get(CLASSPATH) != null) {
                String classpath = (String)this.data.get(CLASSPATH);
                log.info((Object)("Upgrading CA token classpath: " + classpath));
                String newclasspath = classpath;
                if (StringUtils.equals((String)classpath, (String)"org.ejbca.core.model.ca.catoken.SoftCAToken")) {
                    newclasspath = "org.cesecore.keys.token.SoftCryptoToken";
                    Properties prop = this.getProperties();
                    if (prop.getProperty("certSignKey") == null && prop.getProperty("defaultKey") == null) {
                        log.info((Object)"Setting CAKEYPURPOSE_CERTSIGN_STRING and CAKEYPURPOSE_CRLSIGN_STRING to signKey.");
                        prop.setProperty("certSignKey", SOFTPRIVATESIGNKEYALIAS);
                        prop.setProperty("crlSignKey", SOFTPRIVATESIGNKEYALIAS);
                    }
                    if (prop.getProperty("defaultKey") == null && prop.getProperty("testKey") == null) {
                        log.info((Object)"Setting CAKEYPURPOSE_DEFAULT_STRING to encryptKey.");
                        prop.setProperty("defaultKey", SOFTPRIVATEDECKEYALIAS);
                    }
                    this.setCATokenPropertyData(this.storeProperties(prop));
                } else if (StringUtils.equals((String)classpath, (String)"org.ejbca.core.model.ca.catoken.PKCS11CAToken")) {
                    newclasspath = "org.cesecore.keys.token.PKCS11CryptoToken";
                } else if (StringUtils.equals((String)classpath, (String)"org.ejbca.core.model.ca.catoken.NullCAToken")) {
                    newclasspath = "org.cesecore.keys.token.NullCryptoToken";
                } else if (StringUtils.equals((String)classpath, (String)"org.ejbca.core.model.ca.catoken.NFastCAToken")) {
                    log.error((Object)"Upgrading of NFastCAToken not supported, you need to convert to using PKCS11CAToken before upgrading.");
                }
                this.data.put(CLASSPATH, newclasspath);
            }
            this.data.put("version", new Float(8.0f));
        }
    }

    public String generateNextSignKeyAlias() {
        String currentKeySequence = this.getKeySequence();
        String newKeySequence = StringTools.incrementKeySequence(this.getKeySequenceFormat(), currentKeySequence);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Current key sequence: " + currentKeySequence + "  New key sequence: " + newKeySequence));
        }
        String currentCertSignKeyLabel = this.keyStrings.getAlias(1);
        String newCertSignKeyLabel = StringUtils.removeEnd((String)currentCertSignKeyLabel, (String)currentKeySequence) + newKeySequence;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Current sign key alias: " + currentCertSignKeyLabel + "  New sign key alias: " + newCertSignKeyLabel));
        }
        this.setNextCertSignKey(newCertSignKeyLabel);
        this.setNextKeySequence(newKeySequence);
        return newCertSignKeyLabel;
    }

    public void activateNextSignKey() {
        Properties caTokenProperties = this.getProperties();
        boolean swichedSigningKey = false;
        String nextCertSignKeyLabel = this.keyStrings.getAlias(7);
        if (nextCertSignKeyLabel != null) {
            String currentCertSignKeyLabel = this.keyStrings.getAlias(1);
            String currentCrlSignKeyLabel = this.keyStrings.getAlias(2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("CERTSIGN_NEXT: " + nextCertSignKeyLabel));
                log.debug((Object)("CERTSIGN:      " + currentCertSignKeyLabel));
                log.debug((Object)("CRLSIGN:       " + currentCrlSignKeyLabel));
            }
            if (StringUtils.equals((String)currentCertSignKeyLabel, (String)currentCrlSignKeyLabel)) {
                log.info((Object)("Setting CRL signing key alias to: " + nextCertSignKeyLabel));
                caTokenProperties.setProperty("crlSignKey", nextCertSignKeyLabel);
            }
            log.info((Object)("Setting certificate signing key alias to: " + nextCertSignKeyLabel));
            caTokenProperties.setProperty("previousCertSignKey", currentCertSignKeyLabel);
            caTokenProperties.setProperty("certSignKey", nextCertSignKeyLabel);
            caTokenProperties.remove("nextCertSignKey");
            swichedSigningKey = !StringUtils.equals((String)nextCertSignKeyLabel, (String)currentCertSignKeyLabel);
        }
        String nextKeySequence = caTokenProperties.getProperty("nextSequence");
        String currentKeySequence = this.getKeySequence();
        if (nextKeySequence != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Current KeySequence: " + this.getKeySequence()));
            }
            log.info((Object)("Set key sequence from nextSequence: " + nextKeySequence));
            caTokenProperties.setProperty("previousSequence", currentKeySequence);
            this.setKeySequence(nextKeySequence);
            caTokenProperties.remove("nextSequence");
        } else if (swichedSigningKey) {
            String newKeySequence = StringTools.incrementKeySequence(this.getKeySequenceFormat(), currentKeySequence);
            caTokenProperties.setProperty("previousSequence", currentKeySequence);
            this.setKeySequence(newKeySequence);
        } else {
            caTokenProperties.setProperty("previousSequence", currentKeySequence);
        }
        this.setCATokenPropertyData(this.storeProperties(caTokenProperties));
    }

    public void setNextCertSignKey(String nextSignKeyAlias) {
        Properties caTokenProperties = this.getProperties();
        caTokenProperties.setProperty("nextCertSignKey", nextSignKeyAlias);
        this.setCATokenPropertyData(this.storeProperties(caTokenProperties));
    }

    public void setNextKeySequence(String newSequence) {
        Properties caTokenProperties = this.getProperties();
        caTokenProperties.setProperty("nextSequence", newSequence);
        this.setCATokenPropertyData(this.storeProperties(caTokenProperties));
    }
}

