/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ca.catoken;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public final class PurposeMapping {
    private final Map<Integer, String> map = new Hashtable<Integer, String>();
    private final Map<Integer, String> keymap = new Hashtable<Integer, String>();
    private final String defaultKeyS;

    public PurposeMapping(Properties properties) {
        String tmpS = null;
        if (properties != null) {
            tmpS = properties.getProperty("defaultKey");
            this.addKey("certSignKey", 1, properties);
            this.addKey("crlSignKey", 2, properties);
            this.addKey("keyEncryptKey", 3, properties);
            this.addKey("testKey", 4, properties);
            this.addKey("hardTokenEncrypt", 5, properties);
            this.addKey("previousCertSignKey", 6, properties);
            this.addKey("nextCertSignKey", 7, properties);
        }
        this.defaultKeyS = tmpS != null ? tmpS.trim() : null;
    }

    private void addKey(String keyS, int keyI, Properties properties) {
        String value = properties.getProperty(keyS);
        if (value != null && value.length() > 0) {
            value = value.trim();
            this.map.put(keyI, value);
            this.keymap.put(keyI, keyS);
        }
    }

    public String getAlias(int purpose) {
        String s;
        try {
            s = this.map.get(purpose);
        }
        catch (Exception e) {
            s = null;
        }
        if (s != null && s.length() > 0) {
            return s;
        }
        if (purpose != 6 && purpose != 7) {
            return this.defaultKeyS;
        }
        return null;
    }

    public String getPurposeProperty(int purpose) {
        String s;
        try {
            s = this.keymap.get(purpose);
        }
        catch (Exception e) {
            s = null;
        }
        if (s != null && s.length() > 0) {
            return s;
        }
        if (purpose != 6 && purpose != 7) {
            return "defaultKey";
        }
        return null;
    }

    public String[] getAliases() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.map.values());
        if (this.defaultKeyS != null) {
            set.add(this.defaultKeyS);
        }
        return set.toArray(new String[set.size()]);
    }

    public String toString() {
        return this.map.toString();
    }
}

