/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ca.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cesecore.certificates.certificate.HashID;
import org.cesecore.config.OcspConfiguration;
import org.cesecore.util.Base64;
import org.cesecore.util.CertTools;

public enum CaCertificateCache {
    INSTANCE;

    private final Logger log = Logger.getLogger(CaCertificateCache.class);
    private Map<Integer, X509Certificate> certsFromSubjectDN = new HashMap<Integer, X509Certificate>();
    private Map<Integer, Set<X509Certificate>> certsFromIssuerDN = new HashMap<Integer, Set<X509Certificate>>();
    private Map<Integer, X509Certificate> certsFromSubjectKeyIdentifier = new HashMap<Integer, X509Certificate>();
    private Set<X509Certificate> rootCertificates = new HashSet<X509Certificate>();
    private long certValidTo = 0L;

    public X509Certificate findLatestBySubjectDN(HashID id) {
        X509Certificate ret = this.certsFromSubjectDN.get(id.getKey());
        if (ret == null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Certificate not found from SubjectDN HashId in certsFromSubjectDN map. HashID=" + id.getB64()));
        }
        return ret;
    }

    public X509Certificate[] findLatestByIssuerDN(HashID id) {
        Set<X509Certificate> sCert = this.certsFromIssuerDN.get(id.getKey());
        if (sCert == null || sCert.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Certificate not found from IssuerDN HashId in certsFromIssuerDN map. HashID=" + id.getB64()));
            }
            return null;
        }
        return sCert.toArray(new X509Certificate[sCert.size()]);
    }

    public X509Certificate[] getRootCertificates() {
        return this.rootCertificates.toArray(new X509Certificate[0]);
    }

    public X509Certificate findBySubjectKeyIdentifier(HashID id) {
        X509Certificate ret = this.certsFromSubjectKeyIdentifier.get(id.getKey());
        if (ret == null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Certificate not found from SubjectKeyIdentifier HashId in certsFromSubjectKeyIdentifier map. HashID=" + id.getB64()));
        }
        return ret;
    }

    public boolean isCacheExpired() {
        return this.certValidTo < System.currentTimeMillis();
    }

    public synchronized void loadCertificates(Collection<Certificate> certs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loaded " + (certs == null ? "0" : Integer.toString(certs.size())) + " ca certificates"));
        }
        HashMap<Integer, X509Certificate> newCertsFromSubjectDN = new HashMap<Integer, X509Certificate>();
        HashMap<Integer, Set<X509Certificate>> newCertsFromIssuerDN = new HashMap<Integer, Set<X509Certificate>>();
        HashMap<Integer, X509Certificate> newCertsFromSubjectKeyIdentifier = new HashMap<Integer, X509Certificate>();
        HashSet<X509Certificate> newRootCertificates = new HashSet<X509Certificate>();
        for (Certificate tmp : certs) {
            if (!(tmp instanceof X509Certificate)) {
                this.log.debug((Object)("Not adding CA certificate of type: " + tmp.getType()));
                continue;
            }
            X509Certificate cert = (X509Certificate)tmp;
            try {
                newCertsFromSubjectKeyIdentifier.put(HashID.getFromKeyID(cert).getKey(), cert);
            }
            catch (Throwable t) {
                if (!this.log.isDebugEnabled()) continue;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println("Erroneous certificate fetched from database.");
                pw.println("The public key can not be extracted from the certificate.");
                pw.println("Here follows a base64 encoding of the certificate:");
                try {
                    String b64encoded = new String(Base64.encode(cert.getEncoded()));
                    pw.println("-----BEGIN CERTIFICATE-----");
                    pw.println(b64encoded);
                    pw.println("-----END CERTIFICATE-----");
                }
                catch (CertificateEncodingException e) {
                    pw.println("Not possible to encode certificate.");
                }
                pw.flush();
                this.log.debug((Object)sw.toString());
                continue;
            }
            Integer subjectDNKey = HashID.getFromSubjectDN(cert).getKey();
            X509Certificate pastCert = (X509Certificate)newCertsFromSubjectDN.get(subjectDNKey);
            boolean isLatest = pastCert != null ? CertTools.getNotBefore(cert).after(CertTools.getNotBefore(pastCert)) : true;
            if (!isLatest) continue;
            newCertsFromSubjectDN.put(subjectDNKey, cert);
            Integer issuerDNKey = HashID.getFromIssuerDN(cert).getKey();
            if (!issuerDNKey.equals(subjectDNKey)) {
                HashSet<X509Certificate> sIssuer = (HashSet<X509Certificate>)newCertsFromIssuerDN.get(issuerDNKey);
                if (sIssuer == null) {
                    sIssuer = new HashSet<X509Certificate>();
                    newCertsFromIssuerDN.put(issuerDNKey, sIssuer);
                }
                sIssuer.add(cert);
                sIssuer.remove(pastCert);
                continue;
            }
            newRootCertificates.add(cert);
            newRootCertificates.remove(pastCert);
        }
        if (this.log.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            pw.println("Found the following CA certificates :");
            for (Map.Entry key : newCertsFromSubjectKeyIdentifier.entrySet()) {
                Certificate cert = (Certificate)key.getValue();
                pw.print(CertTools.getSubjectDN(cert));
                pw.print(',');
                pw.println(CertTools.getSerialNumberAsString(cert));
            }
            this.log.debug((Object)sw);
        }
        this.certsFromSubjectKeyIdentifier = newCertsFromSubjectKeyIdentifier;
        this.certsFromIssuerDN = newCertsFromIssuerDN;
        this.certsFromSubjectDN = newCertsFromSubjectDN;
        this.rootCertificates = newRootCertificates;
        this.certValidTo = System.currentTimeMillis() + (long)OcspConfiguration.getSigningCertsValidTimeInMilliseconds();
    }
}

