/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ca.internal;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.x509.PrivateKeyUsagePeriod;
import org.cesecore.certificates.ca.CAOfflineException;
import org.cesecore.certificates.ca.IllegalValidityException;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;
import org.cesecore.certificates.endentity.ExtendedInformation;
import org.cesecore.config.CesecoreConfiguration;
import org.cesecore.internal.InternalResources;
import org.cesecore.util.CertTools;
import org.cesecore.util.ValidityDate;

public class CertificateValidity {
    private static final Logger log = Logger.getLogger(CertificateValidity.class);
    public static final long SETBACKTIME = 600000L;
    private static final InternalResources intres = InternalResources.getInstance();
    private Date lastDate;
    private Date firstDate;
    private static Date tooLateExpireDate = ValidityDate.parseCaLatestValidDateTime(CesecoreConfiguration.getCaTooLateExpireDate());

    protected static void setTooLateExpireDate(Date date) {
        tooLateExpireDate = date;
    }

    public CertificateValidity(EndEntityInformation subject, CertificateProfile certProfile, Date notBefore, Date notAfter, Certificate cacert, boolean isRootCA) throws IllegalValidityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requested notBefore: " + notBefore));
            log.debug((Object)("Requested notAfter: " + notAfter));
        }
        if (tooLateExpireDate == null) {
            throw new IllegalValidityException("ca.toolateexpiredate in ejbca.properties is not a valid date.");
        }
        Date now = new Date(new Date().getTime() - 600000L);
        Date startTimeDate = null;
        Date endTimeDate = null;
        ExtendedInformation ei = subject.getExtendedinformation();
        if (ei != null) {
            long relative;
            String eiStartTime = ei.getCustomData("STARTTIME");
            String eiEndTime = ei.getCustomData("ENDTIME");
            if (eiStartTime != null) {
                if (eiStartTime.matches("^\\d+:\\d?\\d:\\d?\\d$")) {
                    String[] startTimeArray = eiStartTime.split(":");
                    relative = (Long.parseLong(startTimeArray[0]) * 24L * 60L + Long.parseLong(startTimeArray[1]) * 60L + Long.parseLong(startTimeArray[2])) * 60L * 1000L;
                    startTimeDate = new Date(now.getTime() + relative);
                } else {
                    try {
                        startTimeDate = ValidityDate.parseAsUTC(eiStartTime);
                    }
                    catch (ParseException e) {
                        log.error((Object)intres.getLocalizedMessage("createcert.errorinvalidstarttime", eiStartTime));
                    }
                }
                if (startTimeDate != null && startTimeDate.before(now) && log.isDebugEnabled()) {
                    log.debug((Object)"Using custom start time, but it is before current date, will only be allowed if allowValidityOverride is true.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Custom notBefore: " + startTimeDate));
                }
            }
            if (eiEndTime != null) {
                if (eiEndTime.matches("^\\d+:\\d?\\d:\\d?\\d$")) {
                    String[] endTimeArray = eiEndTime.split(":");
                    relative = (Long.parseLong(endTimeArray[0]) * 24L * 60L + Long.parseLong(endTimeArray[1]) * 60L + Long.parseLong(endTimeArray[2])) * 60L * 1000L;
                    endTimeDate = new Date(now.getTime() + relative);
                } else {
                    try {
                        endTimeDate = ValidityDate.parseAsUTC(eiEndTime);
                    }
                    catch (ParseException e) {
                        log.error((Object)intres.getLocalizedMessage("createcert.errorinvalidstarttime", eiEndTime));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Custom notAfter: " + endTimeDate));
                }
            }
        }
        if (certProfile.getAllowValidityOverride()) {
            this.firstDate = startTimeDate;
            this.lastDate = endTimeDate;
            if (this.firstDate == null) {
                this.firstDate = notBefore;
            }
            if (this.lastDate == null) {
                this.lastDate = notAfter;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Allow validity override, notBefore: " + this.firstDate));
                log.debug((Object)("Allow validity override, notAfter: " + this.lastDate));
            }
        }
        if (this.firstDate == null) {
            this.firstDate = now;
        }
        long val = certProfile.getValidity();
        Date certProfileLastDate = ValidityDate.getDate(val, this.firstDate);
        if (this.lastDate == null) {
            this.lastDate = certProfileLastDate;
        }
        if (this.lastDate.before(this.firstDate)) {
            log.info((Object)intres.getLocalizedMessage("createcert.errorinvalidcausality", this.firstDate, this.lastDate));
            Date tmp = this.lastDate;
            this.lastDate = this.firstDate;
            this.firstDate = tmp;
        }
        if (this.firstDate.before(now) && !certProfile.getAllowValidityOverride()) {
            log.error((Object)intres.getLocalizedMessage("createcert.errorbeforecurrentdate", this.firstDate, subject.getUsername()));
            this.firstDate = now;
            certProfileLastDate = ValidityDate.getDate(val, this.firstDate);
            if (this.lastDate.equals(certProfileLastDate)) {
                this.lastDate = certProfileLastDate;
            }
        }
        if (this.lastDate.after(certProfileLastDate)) {
            log.info((Object)intres.getLocalizedMessage("createcert.errorbeyondmaxvalidity", this.lastDate, subject.getUsername(), certProfileLastDate));
            this.lastDate = certProfileLastDate;
        }
        if (cacert != null && this.lastDate.after(CertTools.getNotAfter(cacert)) && !isRootCA) {
            log.info((Object)intres.getLocalizedMessage("createcert.limitingvalidity", this.lastDate.toString(), CertTools.getNotAfter(cacert)));
            this.lastDate = CertTools.getNotAfter(cacert);
        }
        if (cacert != null && this.firstDate.before(CertTools.getNotBefore(cacert)) && !isRootCA) {
            log.info((Object)intres.getLocalizedMessage("createcert.limitingvaliditystart", this.firstDate.toString(), CertTools.getNotBefore(cacert)));
            this.firstDate = CertTools.getNotBefore(cacert);
        }
        if (!this.lastDate.before(tooLateExpireDate)) {
            String msg = intres.getLocalizedMessage("createcert.errorbeyondtoolateexpiredate", this.lastDate.toString(), tooLateExpireDate.toString());
            log.info((Object)msg);
            throw new IllegalValidityException(msg);
        }
    }

    public Date getNotAfter() {
        return this.lastDate;
    }

    public Date getNotBefore() {
        return this.firstDate;
    }

    public static void checkPrivateKeyUsagePeriod(X509Certificate cert) throws CAOfflineException {
        CertificateValidity.checkPrivateKeyUsagePeriod(cert, new Date());
    }

    public static void checkPrivateKeyUsagePeriod(X509Certificate cert, Date checkDate) throws CAOfflineException {
        if (cert != null) {
            PrivateKeyUsagePeriod pku = CertTools.getPrivateKeyUsagePeriod(cert);
            if (pku != null) {
                Date pkuNotAfter;
                ASN1GeneralizedTime notBefore = pku.getNotBefore();
                try {
                    Date pkuNotBefore = notBefore == null ? null : notBefore.getDate();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("PrivateKeyUsagePeriod.notBefore is " + pkuNotBefore));
                    }
                    if (pkuNotBefore != null && checkDate.before(pkuNotBefore)) {
                        String msg = intres.getLocalizedMessage("createcert.privatekeyusagenotvalid", pkuNotBefore.toString(), cert.getSubjectDN().toString());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)msg);
                        }
                        throw new CAOfflineException(msg);
                    }
                    ASN1GeneralizedTime notAfter = pku.getNotAfter();
                    pkuNotAfter = notAfter == null ? null : notAfter.getDate();
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Could not parse dates.", e);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PrivateKeyUsagePeriod.notAfter is " + pkuNotAfter));
                }
                if (pkuNotAfter != null && checkDate.after(pkuNotAfter)) {
                    String msg = intres.getLocalizedMessage("createcert.privatekeyusageexpired", pkuNotAfter.toString(), cert.getSubjectDN().toString());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg);
                    }
                    throw new CAOfflineException(msg);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No PrivateKeyUsagePeriod available in certificate.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No CA certificate available, not checking PrivateKeyUsagePeriod.");
        }
    }
}

