/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ca.internal;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import org.apache.log4j.Logger;
import org.cesecore.certificates.ca.internal.SernoGenerator;
import org.cesecore.config.CesecoreConfiguration;
import org.cesecore.internal.InternalResources;

public class SernoGeneratorRandom
implements SernoGenerator {
    private static final Logger log = Logger.getLogger(SernoGeneratorRandom.class);
    private static final InternalResources intres = InternalResources.getInstance();
    private String algorithm = "SHA1PRNG";
    private int noOctets = 8;
    private SecureRandom random;
    private static SernoGeneratorRandom instance = null;
    private BigInteger lowest = new BigInteger("0080000000000000", 16);
    private BigInteger highest = new BigInteger("7FFFFFFFFFFFFFFF", 16);

    protected SernoGeneratorRandom() {
        if (log.isTraceEnabled()) {
            log.trace((Object)">SernoGenerator()");
        }
        this.algorithm = CesecoreConfiguration.getCaSerialNumberAlgorithm();
        this.setSernoOctetSize(CesecoreConfiguration.getCaSerialNumberOctetSize());
        this.init();
        if (log.isTraceEnabled()) {
            log.trace((Object)"<SernoGenerator()");
        }
    }

    private void init() {
        try {
            this.random = SecureRandom.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm " + this.algorithm + " was not a valid algorithm.", e);
        }
        long seed = Math.abs(new Date().getTime() + (long)this.hashCode());
        this.random.setSeed(seed);
    }

    public static synchronized SernoGenerator instance() {
        if (instance == null) {
            instance = new SernoGeneratorRandom();
        }
        return instance;
    }

    @Override
    public synchronized BigInteger getSerno() {
        if (this.noOctets == 0) {
            Random rand = new Random();
            return new BigInteger(Long.toString(rand.nextInt(4)));
        }
        byte[] sernobytes = new byte[this.noOctets];
        boolean ok = false;
        BigInteger serno = null;
        while (!ok) {
            this.random.nextBytes(sernobytes);
            serno = new BigInteger(sernobytes).abs();
            if (this.checkSernoValidity(serno)) {
                ok = true;
                continue;
            }
            String msg = intres.getLocalizedMessage("sernogenerator.discarding", new Object[0]);
            log.info((Object)msg);
        }
        return serno;
    }

    protected boolean checkSernoValidity(BigInteger serno) {
        return serno.compareTo(this.lowest) >= 0 && serno.compareTo(this.highest) <= 0;
    }

    @Override
    public int getNoSernoBytes() {
        return this.noOctets;
    }

    @Override
    public void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    public void setAlgorithm(String algo) throws NoSuchAlgorithmException {
        if (this.algorithm == null || !this.algorithm.equals(algo)) {
            this.algorithm = algo;
            this.init();
        }
    }

    @Override
    public void setSernoOctetSize(int noOctets) {
        if (this.noOctets != noOctets) {
            if (noOctets > 20 && noOctets != 0) {
                throw new IllegalArgumentException("SernoOctetSize must be between 4 and 20 bytes for this generator.");
            }
            char[] arr = new char[noOctets * 2];
            Arrays.fill(arr, '0');
            arr[2] = 56;
            this.lowest = new BigInteger(String.valueOf(arr), 16);
            Arrays.fill(arr, 'F');
            arr[0] = 55;
            this.highest = new BigInteger(String.valueOf(arr), 16);
            this.noOctets = noOctets;
        }
    }
}

