/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate;

import java.io.Serializable;
import java.util.Date;
import org.cesecore.certificates.crl.RevokedCertInfo;

public class CertificateStatus
implements Serializable {
    private static final long serialVersionUID = 1515679904853388419L;
    public static final CertificateStatus REVOKED = new CertificateStatus("REVOKED", 0);
    public static final CertificateStatus OK = new CertificateStatus("OK", 0);
    public static final CertificateStatus NOT_AVAILABLE = new CertificateStatus("NOT_AVAILABLE", 0);
    private final String name;
    public final Date revocationDate;
    public final int revocationReason;
    public final int certificateProfileId;

    public CertificateStatus(String name, int certProfileId) {
        this.name = name;
        this.revocationDate = new Date(-1L);
        this.revocationReason = RevokedCertInfo.NOT_REVOKED;
        this.certificateProfileId = certProfileId;
    }

    public CertificateStatus(long date, int reason, int certProfileId) {
        this.name = CertificateStatus.REVOKED.name;
        this.revocationDate = new Date(date);
        this.revocationReason = reason;
        this.certificateProfileId = certProfileId;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj instanceof CertificateStatus && this.equals((CertificateStatus)obj);
    }

    public boolean equals(CertificateStatus obj) {
        return this.name.equals(obj.toString());
    }
}

