/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.util.encoders.Base64;
import org.cesecore.keys.util.KeyTools;
import org.cesecore.util.CertTools;

public class HashID {
    private static final Logger log = Logger.getLogger(HashID.class);
    private final boolean isOK;
    private final String b64;
    private final String b64url;
    private final Integer key;

    private HashID(byte[] hash) {
        String b64padded = new String(Base64.encode((byte[])hash));
        if (b64padded.length() != 28 || b64padded.charAt(27) != '=') {
            this.isOK = false;
            this.b64 = b64padded;
        } else {
            this.isOK = true;
            this.b64 = b64padded.substring(0, 27);
        }
        this.b64url = this.b64.replaceAll("\\+", "%2B");
        this.key = new BigInteger(hash).hashCode();
    }

    private static byte[] hashFromPrincipalDN(X500Principal principal) {
        return CertTools.generateSHA1Fingerprint(principal.getEncoded());
    }

    private static HashID getFromDN(X500Principal principal) {
        HashID id = new HashID(HashID.hashFromPrincipalDN(principal));
        if (id.isOK) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The DN '" + principal.getName() + "' is identified by the Hash string '" + id.b64 + "' when accessing the VA."));
            }
        } else {
            log.error((Object)("The DN '" + principal.getName() + "' has a non valid Hash identification string: " + id.b64));
        }
        return id;
    }

    public static HashID getFromSubjectDN(X509Certificate cert) {
        return HashID.getFromDN(cert.getSubjectX500Principal());
    }

    public static HashID getFromIssuerDN(X509Certificate cert) {
        return HashID.getFromDN(cert.getIssuerX500Principal());
    }

    public static HashID getFromIssuerDN(X509CertificateHolder certificateHolder) throws CertificateException {
        return HashID.getFromIssuerDN(new JcaX509CertificateConverter().getCertificate(certificateHolder));
    }

    public static HashID getFromDNString(String sDN) {
        return HashID.getFromDN(new X500Principal(new X509Principal(CertTools.isDNReversed(sDN) ? CertTools.reverseDN(sDN) : sDN).getEncoded()));
    }

    public static HashID getFromB64(String s) {
        return new HashID(Base64.decode((String)(s.length() == 27 ? s + '=' : s)));
    }

    public static HashID getFromKeyID(X509Certificate cert) {
        HashID id = new HashID(KeyTools.createSubjectKeyId(cert.getPublicKey()).getKeyIdentifier());
        if (id.isOK) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The certificate with subject DN '" + cert.getSubjectX500Principal().getName() + "' can be fetched with 'search.cgi?sKIDHash=" + id.b64 + "' from the VA."));
            }
        } else {
            log.error((Object)("The certificate with subject DN '" + cert.getSubjectX500Principal().getName() + "' gives a sKIDHash with a not valid format: " + id.b64));
        }
        return id;
    }

    public static HashID getFromAuthorityKeyId(X509Certificate cert) throws IOException {
        byte[] hash = CertTools.getAuthorityKeyId(cert);
        if (hash == null) {
            return null;
        }
        HashID id = new HashID(CertTools.getAuthorityKeyId(cert));
        if (!id.isOK) {
            log.error((Object)("The certificate with subject DN '" + cert.getSubjectX500Principal().getName() + "' don't have a valid AuthorityKeyId: " + id.b64));
        }
        return id;
    }

    public String getB64url() {
        return this.b64url;
    }

    public Integer getKey() {
        return this.key;
    }

    public String getB64() {
        return this.b64;
    }
}

