/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.cesecore.certificates.certificate.certextensions.CertificateExtension;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionFactory;
import org.cesecore.certificates.certificate.certextensions.CertificateExtentionConfigurationException;
import org.cesecore.certificates.certificate.certextensions.CustomCertificateExtension;
import org.cesecore.configuration.ConfigurationBase;

public class AvailableCustomCertificateExtensionsConfiguration
extends ConfigurationBase
implements Serializable {
    private static final long serialVersionUID = 7798273820046510706L;
    private static final Logger log = Logger.getLogger(AvailableCustomCertificateExtensionsConfiguration.class);
    public static final String CONFIGURATION_ID = "AVAILABLE_CUSTOM_CERT_EXTENSIONS";

    public AvailableCustomCertificateExtensionsConfiguration() {
        if (!this.isConfigurationInitialized()) {
            this.addAvailableCustomCertExtensionsFromFile();
        }
    }

    public AvailableCustomCertificateExtensionsConfiguration(Serializable dataobj) {
        LinkedHashMap d;
        this.data = d = (LinkedHashMap)dataobj;
    }

    @Override
    public String getConfigurationId() {
        return CONFIGURATION_ID;
    }

    public boolean isConfigurationInitialized() {
        return this.data.size() > 1;
    }

    public boolean isCustomCertExtensionSupported(int id) {
        return this.data.containsKey(id);
    }

    public CustomCertificateExtension getCustomCertificateExtension(int id) {
        return (CustomCertificateExtension)this.data.get(id);
    }

    public void addCustomCertExtension(CertificateExtension ce) {
        this.data.put(ce.getId(), ce);
    }

    public void addCustomCertExtension(int id, String oid, String displayName, String classPath, boolean critical, Properties properties) throws CertificateExtentionConfigurationException {
        try {
            Class<?> implClass = Class.forName(classPath);
            CertificateExtension certificateExtension = (CertificateExtension)implClass.newInstance();
            certificateExtension.init(id, oid.trim(), displayName, critical, properties);
            this.data.put(id, certificateExtension);
        }
        catch (ClassNotFoundException e) {
            throw new CertificateExtentionConfigurationException("Cannot add custom certificate extension. " + e.getLocalizedMessage());
        }
        catch (InstantiationException e) {
            throw new CertificateExtentionConfigurationException("Cannot add custom certificate extension. " + e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            throw new CertificateExtentionConfigurationException("Cannot add custom certificate extension. " + e.getLocalizedMessage());
        }
    }

    public void removeCustomCertExtension(int id) {
        this.data.remove(id);
    }

    public List<CertificateExtension> getAllAvailableCustomCertificateExtensions() {
        ArrayList<CertificateExtension> ret = new ArrayList<CertificateExtension>();
        for (Map.Entry entry : this.data.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof CertificateExtension)) continue;
            CertificateExtension ext = (CertificateExtension)value;
            ret.add(ext);
        }
        return ret;
    }

    public Properties getAsProperties() {
        Properties properties = new Properties();
        for (Map.Entry entry : this.data.entrySet()) {
            if (!(entry.getValue() instanceof CertificateExtension)) continue;
            CertificateExtension ce = (CertificateExtension)entry.getValue();
            properties.setProperty(Integer.toString(ce.getId()), ce.getDisplayName());
        }
        return properties;
    }

    @Deprecated
    public static AvailableCustomCertificateExtensionsConfiguration getAvailableCustomCertExtensionsFromFile() {
        return new AvailableCustomCertificateExtensionsConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void addAvailableCustomCertExtensionsFromFile() {
        InputStream is = CertificateExtensionFactory.class.getResourceAsStream("/certextensions.properties");
        if (is == null) {
            return;
        }
        try {
            Properties props = new Properties();
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
            int count = 0;
            for (int i = 1; i < 255; ++i) {
                if (props.get("id" + i + ".oid") == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found " + props.get("id" + i + ".oid")));
                }
                CertificateExtension ce = this.getCertificateExtensionFromFile(i, props);
                this.addCustomCertExtension(ce);
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Nr of read Custom Certificate Extensions from file: " + count));
            }
        }
        catch (IOException e) {
            log.error((Object)"Error parsing the 'certextensions.properties' file.", (Throwable)e);
        }
        catch (CertificateExtentionConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private CertificateExtension getCertificateExtensionFromFile(int id, Properties propertiesInFile) throws CertificateExtentionConfigurationException {
        String PROPERTY_ID = "id";
        String PROPERTY_OID = ".oid";
        String PROPERTY_CLASSPATH = ".classpath";
        String PROPERTY_DISPLAYNAME = ".displayname";
        String PROPERTY_USED = ".used";
        String PROPERTY_TRANSLATABLE = ".translatable";
        String PROPERTY_CRITICAL = ".critical";
        try {
            String oid = propertiesInFile.getProperty(PROPERTY_ID + id + PROPERTY_OID);
            String classPath = propertiesInFile.getProperty(PROPERTY_ID + id + PROPERTY_CLASSPATH);
            String displayName = propertiesInFile.getProperty(PROPERTY_ID + id + PROPERTY_DISPLAYNAME);
            log.debug((Object)(PROPERTY_ID + id + PROPERTY_USED + ":" + propertiesInFile.getProperty(PROPERTY_ID + id + PROPERTY_USED)));
            boolean used = propertiesInFile.getProperty(PROPERTY_ID + id + PROPERTY_USED).trim().equalsIgnoreCase("TRUE");
            boolean translatable = propertiesInFile.getProperty(PROPERTY_ID + id + PROPERTY_TRANSLATABLE).trim().equalsIgnoreCase("TRUE");
            boolean critical = propertiesInFile.getProperty(PROPERTY_ID + id + PROPERTY_CRITICAL).trim().equalsIgnoreCase("TRUE");
            log.debug((Object)(id + ", " + used + ", " + oid + ", " + critical + ", " + translatable + ", " + displayName));
            if (used) {
                if (oid != null && classPath != null && displayName != null) {
                    Class<?> implClass = Class.forName(classPath);
                    CertificateExtension certificateExtension = (CertificateExtension)implClass.newInstance();
                    Properties extensionProperties = this.getExtensionProperties(id, propertiesInFile);
                    if (translatable) {
                        extensionProperties.put("translatable", (Object)true);
                    }
                    certificateExtension.init(id, oid.trim(), displayName, critical, extensionProperties);
                    return certificateExtension;
                }
                throw new CertificateExtentionConfigurationException("Certificate Extension " + Integer.valueOf(id) + " seems to be misconfigured in the certextensions.properties");
            }
        }
        catch (Exception e) {
            throw new CertificateExtentionConfigurationException("Certificate Extension " + Integer.valueOf(id) + " seems to be misconfigured in the certextensions.properties", e);
        }
        return null;
    }

    private Properties getExtensionProperties(int id, Properties propertiesInFile) {
        Properties extProps = new Properties();
        Iterator<Object> keyIter = propertiesInFile.keySet().iterator();
        String matchString = "id" + id + ".property.";
        while (keyIter.hasNext()) {
            String nextKey = (String)keyIter.next();
            if (!nextKey.startsWith(matchString) || nextKey.length() <= matchString.length()) continue;
            extProps.put(nextKey.substring(matchString.length()), propertiesInFile.get(nextKey));
        }
        return extProps;
    }

    @Override
    public void upgrade() {
    }
}

