/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.util.encoders.Hex;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtension;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.CustomCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;
import org.cesecore.certificates.endentity.ExtendedInformation;
import org.cesecore.internal.InternalResources;

public class BasicCertificateExtension
extends CertificateExtension
implements CustomCertificateExtension {
    private static final long serialVersionUID = 6896964791897238060L;
    private static final Logger log = Logger.getLogger(BasicCertificateExtension.class);
    private static final InternalResources intres = InternalResources.getInstance();
    private static final String DISPLAY_NAME = "Basic Certificate Extension";
    private static String ENCODING_RAW = "RAW";
    private static String PROPERTY_VALUE = "value";
    private static String PROPERTY_ENCODING = "encoding";
    private static String PROPERTY_NVALUES = "nvalues";
    private static String PROPERTY_DYNAMIC = "dynamic";
    private static final Map<String, String[]> propertiesMap = new HashMap<String, String[]>();

    public BasicCertificateExtension() {
        this.setDisplayName(DISPLAY_NAME);
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation userData, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        throw new UnsupportedOperationException("Use getValueEncoded instead");
    }

    @Override
    public byte[] getValueEncoded(EndEntityInformation userData, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        byte[] result;
        String encoding = StringUtils.trim((String)this.getProperties().getProperty(PROPERTY_ENCODING));
        Object[] values = this.getValues(userData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got extension values: " + Arrays.toString(values)));
        }
        if (values == null || values.length == 0) {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.incorrectvalue", this.getId(), this.getOID()));
        }
        if (encoding.equalsIgnoreCase(ENCODING_RAW)) {
            if (values.length > 1) {
                throw new CertificateExtensionException(intres.getLocalizedMessage("certext.certextmissconfigured", this.getId()));
            }
            result = this.parseRaw((String)values[0]);
        } else {
            try {
                if (values.length > 1) {
                    ASN1EncodableVector ev = new ASN1EncodableVector();
                    for (Object value : values) {
                        ASN1Encodable derval = this.parseValue(encoding, (String)value);
                        ev.add(derval);
                    }
                    result = new DERSequence(ev).getEncoded();
                } else {
                    result = this.parseValue(encoding, (String)values[0]).toASN1Primitive().getEncoded();
                }
            }
            catch (IOException ioe) {
                throw new CertificateExtensionException(ioe.getMessage(), ioe);
            }
        }
        return result;
    }

    private String[] getValues(EndEntityInformation userData) {
        Object result = null;
        boolean dynamic = Boolean.parseBoolean(StringUtils.trim((String)this.getProperties().getProperty(PROPERTY_DYNAMIC, Boolean.FALSE.toString())));
        String strnvalues = this.getProperties().getProperty(PROPERTY_NVALUES);
        int nvalues = strnvalues == null || strnvalues.trim().equals("") ? 0 : Integer.parseInt(strnvalues);
        if (dynamic) {
            ExtendedInformation ei = userData.getExtendedinformation();
            if (ei == null) {
                result = null;
            } else if (nvalues < 1) {
                String value = userData.getExtendedinformation().getExtensionData(this.getOID());
                if (value == null || value.trim().isEmpty()) {
                    value = userData.getExtendedinformation().getExtensionData(this.getOID() + "." + PROPERTY_VALUE);
                }
                result = value == null ? null : new String[]{value};
            } else {
                for (int i = 1; i <= nvalues; ++i) {
                    String value = userData.getExtendedinformation().getExtensionData(this.getOID() + "." + PROPERTY_VALUE + Integer.toString(i));
                    if (value == null) continue;
                    if (result == null) {
                        result = new String[nvalues];
                    }
                    result[i - 1] = value;
                }
            }
        }
        if (result == null) {
            if (nvalues < 1) {
                String value = this.getProperties().getProperty(PROPERTY_VALUE);
                if (value == null || value.trim().equals("")) {
                    value = this.getProperties().getProperty(PROPERTY_VALUE + "1");
                }
                result = new String[]{value};
            } else {
                result = new String[nvalues];
                for (int i = 1; i <= nvalues; ++i) {
                    result[i - 1] = this.getProperties().getProperty(PROPERTY_VALUE + Integer.toString(i));
                }
            }
        }
        return result;
    }

    private ASN1Encodable parseValue(String encoding, String value) throws CertificateExtensionException {
        DERNull toret = null;
        Encoding encodingType = Encoding.fromString(encoding);
        if (encodingType == null) {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.incorrectenc", encoding, this.getId()));
        }
        if (!Encoding.ENCODING_DERNULL.equals(encodingType) && (value == null || value.trim().equals(""))) {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.incorrectvalue", this.getId(), this.getOID()));
        }
        switch (encodingType) {
            case ENCODING_DERBITSTRING: {
                toret = this.parseDERBitString(value);
                break;
            }
            case ENCODING_DERINTEGER: {
                toret = this.parseDERInteger(value);
                break;
            }
            case ENCODING_DEROCTETSTRING: {
                toret = this.parseDEROctetString(value);
                break;
            }
            case ENCODING_DERBOOLEAN: {
                toret = this.parseDERBoolean(value);
                break;
            }
            case ENCODING_DEROID: {
                toret = this.parseDEROID(value);
                break;
            }
            case ENCODING_DERPRINTABLESTRING: {
                toret = this.parseDERPrintableString(value);
                break;
            }
            case ENCODING_DERUTF8STRING: {
                toret = this.parseDERUTF8String(value);
                break;
            }
            case ENCODING_DERIA5STRING: {
                toret = this.parseDERIA5String(value);
                break;
            }
            case ENCODING_DERNULL: {
                toret = DERNull.INSTANCE;
                break;
            }
            case ENCODING_DEROBJECT: {
                toret = this.parseHexEncodedDERObject(value);
                break;
            }
            default: {
                throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.incorrectenc", encoding, this.getId()));
            }
        }
        return toret;
    }

    private ASN1Encodable parseDERBitString(String value) throws CertificateExtensionException {
        DERBitString retval = null;
        try {
            byte[] byteArray;
            BigInteger bigInteger = new BigInteger(value, 2);
            int padBits = value.length() - 1 - value.lastIndexOf("1");
            if (padBits == 8) {
                padBits = 0;
            }
            if ((byteArray = bigInteger.toByteArray())[0] == 0) {
                System.arraycopy(byteArray, 1, byteArray, 0, byteArray.length - 1);
            }
            retval = new DERBitString(byteArray, padBits);
        }
        catch (NumberFormatException e) {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.illegalvalue", value, this.getId(), this.getOID()));
        }
        return retval;
    }

    private ASN1Encodable parseDEROID(String value) throws CertificateExtensionException {
        ASN1ObjectIdentifier retval = null;
        try {
            retval = new ASN1ObjectIdentifier(value);
        }
        catch (Exception e) {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.illegalvalue", value, this.getId(), this.getOID()));
        }
        return retval;
    }

    private ASN1Encodable parseDERInteger(String value) throws CertificateExtensionException {
        ASN1Integer retval = null;
        try {
            BigInteger intValue = new BigInteger(value, 10);
            retval = new ASN1Integer(intValue);
        }
        catch (NumberFormatException e) {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.illegalvalue", value, this.getId(), this.getOID()));
        }
        return retval;
    }

    private ASN1Encodable parseDEROctetString(String value) throws CertificateExtensionException {
        DEROctetString retval = null;
        if (!value.matches("^\\p{XDigit}*")) {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.illegalvalue", value, this.getId(), this.getOID()));
        }
        byte[] bytes = Hex.decode((String)value);
        retval = new DEROctetString(bytes);
        return retval;
    }

    private ASN1Encodable parseHexEncodedDERObject(String value) throws CertificateExtensionException {
        ASN1Primitive retval = null;
        if (value.matches("^\\p{XDigit}*")) {
            byte[] bytes = Hex.decode((String)value);
            try {
                ASN1InputStream ais = new ASN1InputStream(bytes);
                ASN1Primitive firstObject = ais.readObject();
                if (ais.available() > 0) {
                    ASN1EncodableVector ev = new ASN1EncodableVector();
                    ev.add((ASN1Encodable)firstObject);
                    while (ais.available() > 0) {
                        ev.add((ASN1Encodable)ais.readObject());
                    }
                    retval = new DERSequence(ev);
                } else {
                    retval = firstObject;
                }
                ais.close();
            }
            catch (Exception e) {
                throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.illegalvalue", value, this.getId(), this.getOID()));
            }
        } else {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.illegalvalue", value, this.getId(), this.getOID()));
        }
        return retval;
    }

    private ASN1Encodable parseDERBoolean(String value) throws CertificateExtensionException {
        ASN1Boolean retval = null;
        if (value.equalsIgnoreCase("TRUE")) {
            retval = ASN1Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("FALSE")) {
            retval = ASN1Boolean.FALSE;
        }
        if (retval == null) {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.illegalvalue", value, this.getId(), this.getOID()));
        }
        return retval;
    }

    private ASN1Encodable parseDERPrintableString(String value) throws CertificateExtensionException {
        try {
            return new DERPrintableString(value, true);
        }
        catch (IllegalArgumentException e) {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.illegalvalue", value, this.getId(), this.getOID()));
        }
    }

    private ASN1Encodable parseDERUTF8String(String value) {
        return new DERUTF8String(value);
    }

    private ASN1Encodable parseDERIA5String(String value) throws CertificateExtensionException {
        try {
            return new DERIA5String(value, true);
        }
        catch (IllegalArgumentException e) {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.illegalvalue", value, this.getId(), this.getOID()));
        }
    }

    private byte[] parseRaw(String value) throws CertificateExtensionException {
        if (value == null) {
            throw new CertificateExtensionException(intres.getLocalizedMessage("certext.basic.incorrectvalue", this.getId(), this.getOID()));
        }
        return Hex.decode((String)value);
    }

    @Override
    public Map<String, String[]> getAvailableProperties() {
        return propertiesMap;
    }

    static {
        Encoding[] encodings = Encoding.values();
        String[] encodingValues = new String[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            encodingValues[i] = encodings[i].value;
        }
        propertiesMap.put(PROPERTY_ENCODING, encodingValues);
        propertiesMap.put(PROPERTY_VALUE, new String[0]);
        propertiesMap.put(PROPERTY_DYNAMIC, CustomCertificateExtension.BOOLEAN);
    }

    private static enum Encoding {
        ENCODING_DERBITSTRING("DERBITSTRING"),
        ENCODING_DERINTEGER("DERINTEGER"),
        ENCODING_DEROCTETSTRING("DEROCTETSTRING"),
        ENCODING_DERBOOLEAN("DERBOOLEAN"),
        ENCODING_DERPRINTABLESTRING("DERPRINTABLESTRING"),
        ENCODING_DERUTF8STRING("DERUTF8STRING"),
        ENCODING_DERIA5STRING("DERIA5STRING"),
        ENCODING_DERNULL("DERNULL"),
        ENCODING_DEROBJECT("DEROBJECT"),
        ENCODING_DEROID("DERBOJECTIDENTIFIER");

        private static final Map<String, Encoding> lookupMap;
        private final String value;

        private Encoding(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Encoding otherValue) {
            if (otherValue == null) {
                return false;
            }
            return this.value.equalsIgnoreCase(otherValue.value());
        }

        public static final Encoding fromString(String value) {
            return lookupMap.get(value);
        }

        static {
            lookupMap = new HashMap<String, Encoding>();
            for (Encoding encoding : Encoding.values()) {
                lookupMap.put(encoding.value(), encoding);
            }
        }
    }
}

