/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions;

import java.io.IOException;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Properties;
import org.bouncycastle.asn1.ASN1Encodable;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;

public abstract class CertificateExtension
implements Serializable {
    private static final long serialVersionUID = -7708267512352607118L;
    @Deprecated
    private int id;
    private String oID;
    private String displayName;
    private boolean criticalFlag;
    private Properties properties;

    public int getId() {
        return this.id;
    }

    public String getOID() {
        return this.oID;
    }

    public void setOID(String oID) {
        this.oID = oID.trim();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isCriticalFlag() {
        return this.criticalFlag;
    }

    public void setCriticalFlag(boolean criticalFlag) {
        this.criticalFlag = criticalFlag;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void init(int id, String oID, String displayName, boolean criticalFlag, Properties extensionProperties) {
        this.id = id;
        this.oID = oID.trim();
        this.displayName = displayName;
        this.criticalFlag = criticalFlag;
        this.properties = extensionProperties;
    }

    public abstract ASN1Encodable getValue(EndEntityInformation var1, CA var2, CertificateProfile var3, PublicKey var4, PublicKey var5, CertificateValidity var6) throws CertificateExtensionException;

    public byte[] getValueEncoded(EndEntityInformation userData, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        byte[] result;
        ASN1Encodable value = this.getValue(userData, ca, certProfile, userPublicKey, caPublicKey, val);
        if (value == null) {
            result = null;
        } else {
            try {
                result = value.toASN1Primitive().getEncoded();
            }
            catch (IOException ioe) {
                throw new CertificateExtensionException(ioe.getMessage(), ioe);
            }
        }
        return result;
    }
}

