/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.cesecore.certificates.certificate.certextensions.CertificateExtension;
import org.cesecore.certificates.certificate.certextensions.standard.AuthorityInformationAccess;
import org.cesecore.certificates.certificate.certextensions.standard.AuthorityKeyIdentifier;
import org.cesecore.certificates.certificate.certextensions.standard.BasicConstraint;
import org.cesecore.certificates.certificate.certextensions.standard.CertificatePolicies;
import org.cesecore.certificates.certificate.certextensions.standard.CrlDistributionPoints;
import org.cesecore.certificates.certificate.certextensions.standard.DocumentTypeList;
import org.cesecore.certificates.certificate.certextensions.standard.ExtendedKeyUsage;
import org.cesecore.certificates.certificate.certextensions.standard.FreshestCrl;
import org.cesecore.certificates.certificate.certextensions.standard.IssuerAltNames;
import org.cesecore.certificates.certificate.certextensions.standard.KeyUsage;
import org.cesecore.certificates.certificate.certextensions.standard.MsTemplate;
import org.cesecore.certificates.certificate.certextensions.standard.NameConstraint;
import org.cesecore.certificates.certificate.certextensions.standard.OcspNoCheck;
import org.cesecore.certificates.certificate.certextensions.standard.PrivateKeyUsagePeriod;
import org.cesecore.certificates.certificate.certextensions.standard.QcStatement;
import org.cesecore.certificates.certificate.certextensions.standard.SeisCardNumber;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificate.certextensions.standard.SubjectAltNames;
import org.cesecore.certificates.certificate.certextensions.standard.SubjectDirectoryAttributes;
import org.cesecore.certificates.certificate.certextensions.standard.SubjectKeyIdentifier;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.internal.InternalResources;

public class CertificateExtensionFactory {
    private static final Logger log = Logger.getLogger(CertificateExtensionFactory.class);
    private static final InternalResources intres = InternalResources.getInstance();
    private static CertificateExtensionFactory instance = null;
    private HashMap<String, String> standardCertificateExtensions = new HashMap();

    private CertificateExtensionFactory() {
        this.standardCertificateExtensions.put(Extension.basicConstraints.getId(), BasicConstraint.class.getName());
        this.standardCertificateExtensions.put(Extension.subjectKeyIdentifier.getId(), SubjectKeyIdentifier.class.getName());
        this.standardCertificateExtensions.put(Extension.authorityKeyIdentifier.getId(), AuthorityKeyIdentifier.class.getName());
        this.standardCertificateExtensions.put(Extension.keyUsage.getId(), KeyUsage.class.getName());
        this.standardCertificateExtensions.put(Extension.extendedKeyUsage.getId(), ExtendedKeyUsage.class.getName());
        this.standardCertificateExtensions.put(Extension.subjectAlternativeName.getId(), SubjectAltNames.class.getName());
        this.standardCertificateExtensions.put(Extension.issuerAlternativeName.getId(), IssuerAltNames.class.getName());
        this.standardCertificateExtensions.put("2.23.136.1.1.6.2", DocumentTypeList.class.getName());
        this.standardCertificateExtensions.put(Extension.cRLDistributionPoints.getId(), CrlDistributionPoints.class.getName());
        this.standardCertificateExtensions.put(Extension.freshestCRL.getId(), FreshestCrl.class.getName());
        this.standardCertificateExtensions.put(Extension.certificatePolicies.getId(), CertificatePolicies.class.getName());
        this.standardCertificateExtensions.put(Extension.subjectDirectoryAttributes.getId(), SubjectDirectoryAttributes.class.getName());
        this.standardCertificateExtensions.put(Extension.authorityInfoAccess.getId(), AuthorityInformationAccess.class.getName());
        this.standardCertificateExtensions.put(Extension.qCStatements.getId(), QcStatement.class.getName());
        this.standardCertificateExtensions.put(Extension.nameConstraints.getId(), NameConstraint.class.getName());
        this.standardCertificateExtensions.put(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId(), OcspNoCheck.class.getName());
        this.standardCertificateExtensions.put("1.3.6.1.4.1.311.20.2", MsTemplate.class.getName());
        this.standardCertificateExtensions.put("1.2.752.34.2.1", SeisCardNumber.class.getName());
        this.standardCertificateExtensions.put(Extension.privateKeyUsagePeriod.getId(), PrivateKeyUsagePeriod.class.getName());
    }

    public static CertificateExtensionFactory getInstance() {
        if (instance == null) {
            instance = new CertificateExtensionFactory();
        }
        return instance;
    }

    public CertificateExtension getStandardCertificateExtension(String oid, CertificateProfile certProf) {
        StandardCertificateExtension ret = null;
        String classPath = this.standardCertificateExtensions.get(oid);
        if (classPath != null) {
            try {
                Class<?> implClass = Class.forName(classPath);
                ret = (StandardCertificateExtension)implClass.newInstance();
                ret.init(certProf);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)intres.getLocalizedMessage("certext.noextensionforid", oid), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)intres.getLocalizedMessage("certext.noextensionforid", oid), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)intres.getLocalizedMessage("certext.noextensionforid", oid), (Throwable)e);
            }
        }
        if (ret == null) {
            log.error((Object)intres.getLocalizedMessage("certext.noextensionforid", oid));
        }
        return ret;
    }

    protected static void resetExtensions() {
        instance = null;
    }
}

