/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.X509CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;

public class AuthorityInformationAccess
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(AuthorityInformationAccess.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.authorityInfoAccess.getId());
        super.setCriticalFlag(false);
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        GeneralName accessLocation;
        String url2;
        ASN1EncodableVector accessList = new ASN1EncodableVector();
        List<String> caIssuers = certProfile.getCaIssuers();
        if (caIssuers != null) {
            for (String url2 : caIssuers) {
                if (!StringUtils.isNotEmpty((String)url2)) continue;
                accessLocation = new GeneralName(6, (ASN1Encodable)new DERIA5String(url2));
                accessList.add((ASN1Encodable)new AccessDescription(AccessDescription.id_ad_caIssuers, accessLocation));
            }
        }
        X509CA x509ca = (X509CA)ca;
        url2 = certProfile.getOCSPServiceLocatorURI();
        if (certProfile.getUseDefaultOCSPServiceLocator()) {
            url2 = x509ca.getDefaultOCSPServiceLocator();
        }
        if (StringUtils.isNotEmpty((String)url2)) {
            accessLocation = new GeneralName(6, (ASN1Encodable)new DERIA5String(url2));
            accessList.add((ASN1Encodable)new AccessDescription(AccessDescription.id_ad_ocsp, accessLocation));
        }
        org.bouncycastle.asn1.x509.AuthorityInformationAccess ret = null;
        if (accessList.size() > 0) {
            ret = org.bouncycastle.asn1.x509.AuthorityInformationAccess.getInstance((Object)new DERSequence(accessList));
        }
        if (ret == null) {
            log.error((Object)"AuthorityInformationAccess is used, but nor caIssuers not Ocsp url are defined!");
        }
        return ret;
    }
}

