/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.operator.DigestCalculator;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;
import org.cesecore.certificates.ocsp.SHA1DigestCalculator;
import org.cesecore.util.CertTools;

public class AuthorityKeyIdentifier
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(AuthorityKeyIdentifier.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.authorityKeyIdentifier.getId());
        super.setCriticalFlag(certProf.getAuthorityKeyIdentifierCritical());
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        byte[] akibytes;
        boolean isRootCA;
        org.bouncycastle.asn1.x509.AuthorityKeyIdentifier ret = null;
        JcaX509ExtensionUtils extensionUtils = new JcaX509ExtensionUtils((DigestCalculator)SHA1DigestCalculator.buildSha1Instance());
        ret = extensionUtils.createAuthorityKeyIdentifier(caPublicKey);
        X509Certificate cacert = (X509Certificate)ca.getCACertificate();
        boolean bl = isRootCA = certProfile.getType() == 8;
        if (cacert != null && !isRootCA && (akibytes = CertTools.getSubjectKeyId(cacert)) != null) {
            DEROctetString keyidentifier = new DEROctetString(akibytes);
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)keyidentifier));
            DERSequence seq = new DERSequence(v);
            ret = org.bouncycastle.asn1.x509.AuthorityKeyIdentifier.getInstance((Object)seq);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using AuthorityKeyIdentifier from CA-certificates SubjectKeyIdentifier.");
            }
        }
        return ret;
    }
}

