/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;

public class BasicConstraint
extends StandardCertificateExtension {
    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.basicConstraints.getId());
        super.setCriticalFlag(certProf.getBasicConstraintsCritical());
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        BasicConstraints bc = new BasicConstraints(false);
        if (certProfile.getType() == 2 || certProfile.getType() == 8) {
            bc = certProfile.getUsePathLengthConstraint() ? new BasicConstraints(certProfile.getPathLengthConstraint()) : new BasicConstraints(true);
        }
        return bc;
    }
}

