/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DisplayText;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.UserNotice;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.X509CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificatePolicy;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;

public class CertificatePolicies
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(CertificatePolicies.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.certificatePolicies.getId());
        super.setCriticalFlag(certProf.getCertificatePoliciesCritical());
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        ASN1EncodableVector qualifiers;
        DERSequence ret = null;
        X509CA x509ca = (X509CA)ca;
        int displayencoding = 1;
        if (x509ca.getUseUTF8PolicyText()) {
            displayencoding = 2;
        }
        List<CertificatePolicy> policies = certProfile.getCertificatePolicies();
        HashMap<ASN1ObjectIdentifier, ASN1EncodableVector> policiesMap = new HashMap<ASN1ObjectIdentifier, ASN1EncodableVector>();
        for (CertificatePolicy policy : policies) {
            ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(policy.getPolicyID());
            qualifiers = policiesMap.containsKey(oid) ? (ASN1EncodableVector)policiesMap.get(oid) : new ASN1EncodableVector();
            PolicyQualifierInfo pqi = this.getPolicyQualifierInformation(policy, displayencoding);
            if (pqi != null) {
                qualifiers.add((ASN1Encodable)pqi);
            }
            policiesMap.put(oid, qualifiers);
        }
        ASN1EncodableVector seq = new ASN1EncodableVector();
        for (ASN1ObjectIdentifier oid : policiesMap.keySet()) {
            qualifiers = (ASN1EncodableVector)policiesMap.get(oid);
            if (qualifiers.size() == 0) {
                seq.add((ASN1Encodable)new PolicyInformation(oid, null));
                continue;
            }
            seq.add((ASN1Encodable)new PolicyInformation(oid, (ASN1Sequence)new DERSequence(qualifiers)));
        }
        if (seq.size() > 0) {
            ret = new DERSequence(seq);
        }
        if (ret == null) {
            log.warn((Object)"Certificate policies missconfigured, no policies present!");
        }
        return ret;
    }

    private PolicyQualifierInfo getPolicyQualifierInformation(CertificatePolicy policy, int displayencoding) {
        String qualifier;
        PolicyQualifierInfo pqi = null;
        String qualifierId = policy.getQualifierId();
        if (qualifierId != null && !StringUtils.isEmpty((String)qualifierId.trim()) && (qualifier = policy.getQualifier()) != null && !StringUtils.isEmpty((String)qualifier.trim())) {
            if (qualifierId.equals(PolicyQualifierId.id_qt_cps.getId())) {
                pqi = new PolicyQualifierInfo(qualifier);
            } else if (qualifierId.equals(PolicyQualifierId.id_qt_unotice.getId())) {
                UserNotice un = new UserNotice(null, new DisplayText(displayencoding, qualifier));
                pqi = new PolicyQualifierInfo((ASN1ObjectIdentifier)PolicyQualifierId.id_qt_unotice, (ASN1Encodable)un);
            }
        }
        return pqi;
    }
}

