/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.X509CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;
import org.cesecore.util.StringTools;

public class CrlDistributionPoints
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(CrlDistributionPoints.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.cRLDistributionPoints.getId());
        super.setCriticalFlag(certProf.getCRLDistributionPointCritical());
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        String crldistpoint = certProfile.getCRLDistributionPointURI();
        String crlissuer = certProfile.getCRLIssuer();
        X509CA x509ca = (X509CA)ca;
        if (certProfile.getUseDefaultCRLDistributionPoint()) {
            crldistpoint = x509ca.getDefaultCRLDistPoint();
            crlissuer = x509ca.getDefaultCRLIssuer();
        }
        ArrayList<DistributionPointName> dpns = new ArrayList<DistributionPointName>();
        if (StringUtils.isNotEmpty((String)crldistpoint)) {
            for (String uri : StringTools.splitURIs(crldistpoint)) {
                GeneralName gn = new GeneralName(6, (ASN1Encodable)new DERIA5String(uri));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added CRL distpoint: " + uri));
                }
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)gn);
                GeneralNames gns = GeneralNames.getInstance((Object)new DERSequence(vec));
                DistributionPointName dpn = new DistributionPointName(0, (ASN1Encodable)gns);
                dpns.add(dpn);
            }
        }
        ArrayList<GeneralNames> issuers = new ArrayList<GeneralNames>();
        if (StringUtils.isNotEmpty((String)crlissuer)) {
            StringTokenizer tokenizer = new StringTokenizer(crlissuer, ";", false);
            while (tokenizer.hasMoreTokens()) {
                String issuer = tokenizer.nextToken();
                GeneralName gn = new GeneralName(new X500Name(issuer));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added CRL issuer: " + issuer));
                }
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)gn);
                GeneralNames gns = GeneralNames.getInstance((Object)new DERSequence(vec));
                issuers.add(gns);
            }
        }
        ArrayList<DistributionPoint> distpoints = new ArrayList<DistributionPoint>();
        if (!issuers.isEmpty() || !dpns.isEmpty()) {
            int i = dpns.size();
            if (issuers.size() > i) {
                i = issuers.size();
            }
            for (int j = 0; j < i; ++j) {
                DistributionPointName dpn = null;
                GeneralNames issuer = null;
                if (dpns.size() > j) {
                    dpn = (DistributionPointName)dpns.get(j);
                }
                if (issuers.size() > j) {
                    issuer = (GeneralNames)issuers.get(j);
                }
                if (dpn == null && issuer == null) continue;
                distpoints.add(new DistributionPoint(dpn, null, issuer));
            }
        }
        CRLDistPoint ret = null;
        if (!distpoints.isEmpty()) {
            ret = new CRLDistPoint(distpoints.toArray(new DistributionPoint[distpoints.size()]));
        }
        if (ret == null) {
            log.error((Object)"DrlDistributionPoints missconfigured, no distribution points available.");
        }
        return ret;
    }
}

