/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;

public class DocumentTypeList
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(DocumentTypeList.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID("2.23.136.1.1.6.2");
        super.setCriticalFlag(certProf.getDocumentTypeListCritical());
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) {
        ArrayList<String> docTypes = certProfile.getDocumentTypeList();
        if (docTypes.size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No DocumentTypeList to make a certificate extension");
            }
            return null;
        }
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1Integer(0L));
        for (String type : docTypes) {
            vec.add((ASN1Encodable)new DERSet(new ASN1Encodable[]{new DERPrintableString(type)}));
        }
        DERSequence gn = new DERSequence(vec);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Constructed DocumentTypeList:");
            log.debug((Object)ASN1Dump.dumpAsString((Object)gn, (boolean)true));
        }
        return gn;
    }
}

