/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;

public class ExtendedKeyUsage
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(ExtendedKeyUsage.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.extendedKeyUsage.getId());
        super.setCriticalFlag(certProf.getExtendedKeyUsageCritical());
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        org.bouncycastle.asn1.x509.ExtendedKeyUsage ret = null;
        ArrayList<String> oids = certProfile.getExtendedKeyUsageOids();
        if (oids.size() != 0) {
            ASN1Encodable[] usage = new ASN1Encodable[oids.size()];
            int i = 0;
            for (String oid : oids) {
                usage[i] = KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(oid));
                ++i;
            }
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)new DERSequence(usage));
            ret = org.bouncycastle.asn1.x509.ExtendedKeyUsage.getInstance((Object)seq);
        }
        if (ret == null) {
            log.error((Object)"ExtendedKeyUsage missconfigured, no oids defined");
        }
        return ret;
    }
}

