/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.X509CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;

public class FreshestCrl
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(FreshestCrl.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.freshestCRL.getId());
        super.setCriticalFlag(false);
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        String freshestcrldistpoint = certProfile.getFreshestCRLURI();
        X509CA x509ca = (X509CA)ca;
        if (certProfile.getUseCADefinedFreshestCRL()) {
            freshestcrldistpoint = x509ca.getCADefinedFreshestCRL();
        }
        CRLDistPoint ret = null;
        if (freshestcrldistpoint != null) {
            StringTokenizer tokenizer = new StringTokenizer(freshestcrldistpoint, ";", false);
            ArrayList<DistributionPoint> distpoints = new ArrayList<DistributionPoint>();
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                GeneralName gn = new GeneralName(6, (ASN1Encodable)new DERIA5String(uri));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added freshest CRL distpoint: " + uri));
                }
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)gn);
                GeneralNames gns = GeneralNames.getInstance((Object)new DERSequence(vec));
                DistributionPointName dpn = new DistributionPointName(0, (ASN1Encodable)gns);
                distpoints.add(new DistributionPoint(dpn, null, null));
            }
            if (!distpoints.isEmpty()) {
                ret = new CRLDistPoint(distpoints.toArray(new DistributionPoint[distpoints.size()]));
            }
        }
        if (ret == null) {
            log.error((Object)"UseFreshestCRL is true, but no URI string defined!");
        }
        return ret;
    }
}

