/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;
import org.cesecore.util.CertTools;

public class IssuerAltNames
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(IssuerAltNames.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.issuerAlternativeName.getId());
        super.setCriticalFlag(certProf.getIssuerAlternativeNameCritical());
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) {
        GeneralNames ret = null;
        String altName = CertTools.getSubjectAlternativeName(ca.getCACertificate());
        if (altName != null && altName.length() > 0) {
            ret = CertTools.getGeneralNamesFromAltName(altName);
        }
        if (ret == null && log.isDebugEnabled()) {
            log.debug((Object)("No altnames (SubjectAltName in issuing CA certificate) trying to make IssuerAltName extension: " + altName));
        }
        return ret;
    }
}

