/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jce.X509KeyUsage;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;
import org.cesecore.util.CertTools;

public class KeyUsage
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(KeyUsage.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.keyUsage.getId());
        super.setCriticalFlag(certProf.getKeyUsageCritical());
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        X509KeyUsage ret = null;
        int keyUsage = CertTools.sunKeyUsageToBC(certProfile.getKeyUsage());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using KeyUsage from profile: " + keyUsage));
        }
        if (keyUsage >= 0) {
            ret = new X509KeyUsage(keyUsage);
        }
        if (ret == null) {
            log.error((Object)("KeyUsage missconfigured, key usage flag invalid: " + keyUsage));
        }
        return ret;
    }
}

