/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.X509CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;
import org.cesecore.certificates.endentity.ExtendedInformation;
import org.cesecore.util.CeSecoreNameStyle;

public class NameConstraint
extends StandardCertificateExtension {
    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.nameConstraints.getId());
        super.setCriticalFlag(certProf.getNameConstraintsCritical());
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation userData, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        NameConstraints nc = null;
        if (!(ca instanceof X509CA)) {
            throw new CertificateExtensionException("Can't issue non-X509 certificate with Name Constraint");
        }
        ExtendedInformation ei = userData.getExtendedinformation();
        if (ei != null) {
            List<String> permittedNames = ei.getNameConstraintsPermitted();
            List<String> excludedNames = ei.getNameConstraintsExcluded();
            if (permittedNames != null || excludedNames != null) {
                GeneralSubtree[] permitted = NameConstraint.toGeneralSubtrees(permittedNames);
                GeneralSubtree[] excluded = NameConstraint.toGeneralSubtrees(excludedNames);
                nc = new NameConstraints(permitted, excluded);
            }
        }
        return nc;
    }

    public static GeneralSubtree[] toGeneralSubtrees(List<String> list) {
        if (list == null) {
            return null;
        }
        GeneralSubtree[] ret = new GeneralSubtree[list.size()];
        int i = 0;
        for (String entry : list) {
            GeneralName genname;
            int type = NameConstraint.getNameConstraintType(entry);
            Object data = NameConstraint.getNameConstraintData(entry);
            switch (type) {
                case 1: 
                case 2: {
                    genname = new GeneralName(type, (String)data);
                    break;
                }
                case 4: {
                    genname = new GeneralName(new X500Name(CeSecoreNameStyle.INSTANCE, (String)data));
                    break;
                }
                case 7: {
                    genname = new GeneralName(type, (ASN1Encodable)new DEROctetString((byte[])data));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Encoding of name constraint type " + type + " is not implemented.");
                }
            }
            ret[i++] = new GeneralSubtree(genname);
        }
        return ret;
    }

    private static int getNameConstraintType(String encoded) {
        String typeString = encoded.split(":", 2)[0];
        if ("iPAddress".equals(typeString)) {
            return 7;
        }
        if ("dNSName".equals(typeString)) {
            return 2;
        }
        if ("directoryName".equals(typeString)) {
            return 4;
        }
        if ("rfc822Name".equals(typeString)) {
            return 1;
        }
        throw new UnsupportedOperationException("Unsupported name constraint type " + typeString);
    }

    private static Object getNameConstraintData(String encoded) {
        int type = NameConstraint.getNameConstraintType(encoded);
        String data = encoded.split(":", 2)[1];
        switch (type) {
            case 1: 
            case 2: 
            case 4: {
                return data;
            }
            case 7: {
                try {
                    return Hex.decodeHex((char[])data.toCharArray());
                }
                catch (DecoderException e) {
                    throw new IllegalStateException("internal name constraint data could not be decoded as hex", e);
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported name constraint type " + type);
    }

    private static String parseNameConstraintEntry(String str) throws CertificateExtensionException {
        if (str.matches("^([0-9]+\\.){3,3}([0-9]+)/[0-9]+$") || str.matches("^[0-9a-fA-F]{0,4}:[0-9a-fA-F]{0,4}:[0-9a-fA-F:]*/[0-9]+$")) {
            try {
                int i;
                String[] pieces = str.split("/", 2);
                byte[] addr = InetAddress.getByName(pieces[0]).getAddress();
                byte[] encoded = new byte[2 * addr.length];
                System.arraycopy(addr, 0, encoded, 0, addr.length);
                int netmask = Integer.parseInt(pieces[1]);
                if (netmask > 8 * addr.length) {
                    throw new CertificateExtensionException("Netmask is too large: " + str);
                }
                for (i = 0; i < netmask; ++i) {
                    int n = addr.length + i / 8;
                    encoded[n] = (byte)(encoded[n] | 1 << 7 - i % 8);
                }
                for (i = netmask; i < 8 * addr.length; ++i) {
                    int n = i / 8;
                    encoded[n] = (byte)(encoded[n] & ~(1 << 7 - i % 8));
                }
                return "iPAddress:" + Hex.encodeHexString((byte[])encoded);
            }
            catch (UnknownHostException e) {
                throw new CertificateExtensionException("Failed to parse IP address in name constraint: " + str, e);
            }
        }
        if (str.matches("^([0-9]+\\.){3,3}([0-9]+)$")) {
            throw new CertificateExtensionException("Name constraint entry with IP address is missing a netmask: " + str + ". Use /32 to match only this address.");
        }
        if (str.matches("^\\.?([a-zA-Z0-9_-]+\\.)*[a-zA-Z0-9_-]+$")) {
            return "dNSName:" + str;
        }
        if (str.matches("^[^=,]*@[a-zA-Z0-9_.\\[\\]:-]+$")) {
            if (str.startsWith("@")) {
                str = str.substring(1);
            }
            return "rfc822Name:" + str;
        }
        if (str.contains("=")) {
            return "directoryName:" + new X500Name(CeSecoreNameStyle.INSTANCE, str).toString();
        }
        throw new CertificateExtensionException("Cannot parse name constraint entry (only DNS Name, RFC 822 Name, Directory Name, IPv4/Netmask and IPv6/Netmask are supported): " + str);
    }

    public static List<String> parseNameConstraintsList(String input) throws CertificateExtensionException {
        ArrayList<String> encodedNames = new ArrayList<String>();
        if (input != null) {
            String[] pieces;
            for (String piece : pieces = input.split("\n")) {
                if ((piece = piece.trim()).isEmpty()) continue;
                encodedNames.add(NameConstraint.parseNameConstraintEntry(piece));
            }
        }
        return encodedNames;
    }

    private static String formatNameConstraintEntry(String encoded) {
        if (encoded == null) {
            return "";
        }
        int type = NameConstraint.getNameConstraintType(encoded);
        Object data = NameConstraint.getNameConstraintData(encoded);
        switch (type) {
            case 2: 
            case 4: {
                return (String)data;
            }
            case 7: {
                byte[] bytes = (byte[])data;
                byte[] ip = new byte[bytes.length / 2];
                byte[] netmaskBytes = new byte[bytes.length / 2];
                System.arraycopy(bytes, 0, ip, 0, ip.length);
                System.arraycopy(bytes, ip.length, netmaskBytes, 0, netmaskBytes.length);
                int netmask = 0;
                for (int i = 0; i < 8 * netmaskBytes.length; ++i) {
                    boolean one;
                    boolean bl = one = (netmaskBytes[i / 8] >> 7 - i % 8 & 1) == 1;
                    if (one && netmask == i) {
                        ++netmask;
                        continue;
                    }
                    if (!one) continue;
                    throw new IllegalArgumentException("Unsupported netmask with mixed ones/zeros");
                }
                try {
                    return InetAddress.getByAddress(ip).getHostAddress() + "/" + netmask;
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            case 1: {
                String str = (String)data;
                return str.contains("@") ? str : "@" + str;
            }
        }
        throw new UnsupportedOperationException("Unsupported name constraint type " + type);
    }

    public static String formatNameConstraintsList(List<String> encodedList) {
        StringBuilder sb = new StringBuilder();
        if (encodedList != null) {
            boolean first = true;
            for (String encodedName : encodedList) {
                if (!first) {
                    sb.append('\n');
                }
                first = false;
                sb.append(NameConstraint.formatNameConstraintEntry(encodedName));
            }
        }
        return sb.toString();
    }
}

