/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import java.util.Date;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.Extension;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;

public class PrivateKeyUsagePeriod
extends StandardCertificateExtension {
    private static final Logger LOG = Logger.getLogger(PrivateKeyUsagePeriod.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.privateKeyUsagePeriod.getId());
        super.setCriticalFlag(false);
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        long start;
        if (val != null) {
            start = val.getNotBefore().getTime();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No validity passed in to getValue, using default 'Date().getTime() - CertificateValidity.SETBACKTIME'");
            }
            start = new Date().getTime() - 600000L;
        }
        if (certProfile.isUsePrivateKeyUsagePeriodNotBefore()) {
            start += certProfile.getPrivateKeyUsagePeriodStartOffset() * 1000L;
        }
        Date notBefore = null;
        Date notAfter = null;
        if (certProfile.isUsePrivateKeyUsagePeriodNotBefore()) {
            notBefore = new Date(start);
        }
        if (certProfile.isUsePrivateKeyUsagePeriodNotAfter()) {
            long validity = certProfile.getPrivateKeyUsagePeriodLength();
            notAfter = new Date(start + validity * 1000L);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PrivateKeyUsagePeriod.notBefore: " + notBefore));
            LOG.debug((Object)("PrivateKeyUsagePeriod.notAfter: " + notAfter));
        }
        return PrivateKeyUsagePeriod.privateKeyUsagePeriod(notBefore, notAfter);
    }

    private static DERSequence privateKeyUsagePeriod(Date notBefore, Date notAfter) throws CertificateExtensionException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (notBefore != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DERGeneralizedTime(notBefore)));
        }
        if (notAfter != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DERGeneralizedTime(notAfter)));
        }
        if (v.size() == 0) {
            throw new CertificateExtensionException("At least one of notBefore and notAfter must be specified!");
        }
        return new DERSequence(v);
    }
}

