/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.qualified.ETSIQCObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.RFC3739QCObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.SemanticsInformation;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;
import org.cesecore.util.CertTools;

public class QcStatement
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(QcStatement.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.qCStatements.getId());
        super.setCriticalFlag(certProf.getQCStatementCritical());
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        DERSequence ret = null;
        String names = certProfile.getQCStatementRAName();
        GeneralNames san = CertTools.getGeneralNamesFromAltName(names);
        SemanticsInformation si = null;
        if (san != null) {
            si = StringUtils.isNotEmpty((String)certProfile.getQCSemanticsId()) ? new SemanticsInformation(new ASN1ObjectIdentifier(certProfile.getQCSemanticsId()), san.getNames()) : new SemanticsInformation(san.getNames());
        } else if (StringUtils.isNotEmpty((String)certProfile.getQCSemanticsId())) {
            si = new SemanticsInformation(new ASN1ObjectIdentifier(certProfile.getQCSemanticsId()));
        }
        ArrayList<QCStatement> qcs = new ArrayList<QCStatement>();
        QCStatement qc = null;
        if (certProfile.getUsePkixQCSyntaxV2()) {
            ASN1ObjectIdentifier pkixQcSyntax = RFC3739QCObjectIdentifiers.id_qcs_pkixQCSyntax_v2;
            if (si != null) {
                qc = new QCStatement(pkixQcSyntax, (ASN1Encodable)si);
                qcs.add(qc);
            } else {
                qc = new QCStatement(pkixQcSyntax);
                qcs.add(qc);
            }
        }
        if (certProfile.getUseQCEtsiQCCompliance()) {
            qc = new QCStatement(ETSIQCObjectIdentifiers.id_etsi_qcs_QcCompliance);
            qcs.add(qc);
        }
        if (certProfile.getUseQCEtsiValueLimit() && certProfile.getQCEtsiValueLimit() >= 0 && certProfile.getQCEtsiValueLimitCurrency() != null) {
            int limit = certProfile.getQCEtsiValueLimit();
            int exponent = certProfile.getQCEtsiValueLimitExp();
            MonetaryValue value = new MonetaryValue(new Iso4217CurrencyCode(certProfile.getQCEtsiValueLimitCurrency()), limit, exponent);
            qc = new QCStatement(ETSIQCObjectIdentifiers.id_etsi_qcs_LimiteValue, (ASN1Encodable)value);
            qcs.add(qc);
        }
        if (certProfile.getUseQCEtsiRetentionPeriod()) {
            ASN1Integer years = new ASN1Integer((long)Integer.valueOf(certProfile.getQCEtsiRetentionPeriod()).intValue());
            qc = new QCStatement(ETSIQCObjectIdentifiers.id_etsi_qcs_RetentionPeriod, (ASN1Encodable)years);
            qcs.add(qc);
        }
        if (certProfile.getUseQCEtsiSignatureDevice()) {
            qc = new QCStatement(ETSIQCObjectIdentifiers.id_etsi_qcs_QcSSCD);
            qcs.add(qc);
        }
        if (certProfile.getUseQCCustomString() && !StringUtils.isEmpty((String)certProfile.getQCCustomStringOid()) && !StringUtils.isEmpty((String)certProfile.getQCCustomStringText())) {
            DERUTF8String str = new DERUTF8String(certProfile.getQCCustomStringText());
            ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(certProfile.getQCCustomStringOid());
            qc = new QCStatement(oid, (ASN1Encodable)str);
            qcs.add(qc);
        }
        if (!qcs.isEmpty()) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            for (QCStatement q : qcs) {
                vec.add((ASN1Encodable)q);
            }
            ret = new DERSequence(vec);
        }
        if (ret == null) {
            log.error((Object)"Qualified certificate statements extension has been enabled, but no statements were included!");
            throw new CertificateExtensionException("If qualified certificate statements extension has been enabled, at least one statement must be included!");
        }
        return ret;
    }
}

