/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERPrintableString;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;

public class SeisCardNumber
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(SeisCardNumber.class);
    public static final String OID_CARDNUMBER = "1.2.752.34.2.1";

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(OID_CARDNUMBER);
        super.setCriticalFlag(false);
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation userData, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) {
        String cardnumber = userData.getCardNumber();
        DERPrintableString ret = null;
        if (StringUtils.isNotEmpty((String)cardnumber)) {
            ret = new DERPrintableString(cardnumber);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Seis card numer: " + cardnumber));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Seis card numer is empty");
        }
        return ret;
    }
}

