/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.security.PublicKey;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.Extension;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;
import org.cesecore.certificates.util.cert.SubjectDirAttrExtension;

public class SubjectDirectoryAttributes
extends StandardCertificateExtension {
    private static final Logger log = Logger.getLogger(SubjectDirectoryAttributes.class);

    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.subjectDirectoryAttributes.getId());
        super.setCriticalFlag(false);
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) {
        String dirAttrString;
        DERSequence ret = null;
        String string = dirAttrString = subject.getExtendedinformation() != null ? subject.getExtendedinformation().getSubjectDirectoryAttributes() : null;
        if (StringUtils.isNotEmpty((String)dirAttrString)) {
            Collection<Attribute> attr = SubjectDirAttrExtension.getSubjectDirectoryAttributes(dirAttrString);
            ASN1EncodableVector vec = new ASN1EncodableVector();
            Iterator<Attribute> iter = attr.iterator();
            while (iter.hasNext()) {
                vec.add((ASN1Encodable)iter.next());
            }
            if (vec.size() > 0) {
                ret = new DERSequence(vec);
            }
        }
        if (ret == null && log.isDebugEnabled()) {
            log.debug((Object)("No directory attributes trying to create SubjectDirectoryAttributes extension: " + dirAttrString));
        }
        return ret;
    }
}

