/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.certextensions.standard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.cesecore.certificates.ca.CA;
import org.cesecore.certificates.ca.internal.CertificateValidity;
import org.cesecore.certificates.certificate.certextensions.CertificateExtensionException;
import org.cesecore.certificates.certificate.certextensions.standard.StandardCertificateExtension;
import org.cesecore.certificates.certificateprofile.CertificateProfile;
import org.cesecore.certificates.endentity.EndEntityInformation;

public class SubjectKeyIdentifier
extends StandardCertificateExtension {
    @Override
    public void init(CertificateProfile certProf) {
        super.setOID(Extension.subjectKeyIdentifier.getId());
        super.setCriticalFlag(certProf.getSubjectKeyIdentifierCritical());
    }

    @Override
    public ASN1Encodable getValue(EndEntityInformation subject, CA ca, CertificateProfile certProfile, PublicKey userPublicKey, PublicKey caPublicKey, CertificateValidity val) throws CertificateExtensionException {
        SubjectPublicKeyInfo spki;
        try {
            spki = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream((InputStream)new ByteArrayInputStream(userPublicKey.getEncoded())).readObject());
        }
        catch (IOException e) {
            throw new CertificateExtensionException("IOException parsing user public key: " + e.getMessage(), e);
        }
        BcX509ExtensionUtils x509ExtensionUtils = new BcX509ExtensionUtils();
        return x509ExtensionUtils.createSubjectKeyIdentifier(spki);
    }
}

