/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.request;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.cesecore.certificates.certificate.request.RequestMessage;
import org.cesecore.util.CertTools;
import org.ejbca.cvc.CVCAuthenticatedRequest;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CardVerifiableCertificate;
import org.ejbca.cvc.CertificateParser;
import org.ejbca.cvc.HolderReferenceField;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.exception.ParseException;

public class CVCRequestMessage
implements RequestMessage {
    static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(CVCRequestMessage.class);
    protected byte[] cvcmsg;
    protected String password = null;
    protected String username = null;
    protected transient CVCertificate cvcert = null;
    private PrivateKey responsePrivateKey;
    private String responseProvider = "BC";

    public CVCRequestMessage() {
    }

    public CVCRequestMessage(byte[] msg) {
        this.cvcmsg = msg;
        this.init();
    }

    private void init() {
        try {
            CVCObject parsedObject = CertificateParser.parseCVCObject((byte[])this.cvcmsg);
            if (parsedObject instanceof CVCertificate) {
                this.cvcert = (CVCertificate)parsedObject;
            } else if (parsedObject instanceof CVCAuthenticatedRequest) {
                CVCAuthenticatedRequest authreq = (CVCAuthenticatedRequest)parsedObject;
                this.cvcert = authreq.getRequest();
            }
        }
        catch (ParseException e) {
            log.error((Object)"Error in init for CVC request: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (ConstructionException e) {
            log.error((Object)"Error in init for CVC request: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchFieldException e) {
            log.error((Object)"Error in init for CVC request: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public PublicKey getRequestPublicKey() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        CVCPublicKey pk;
        try {
            if (this.cvcert == null) {
                this.init();
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"CVC not inited!");
            return null;
        }
        try {
            pk = this.cvcert.getCertificateBody().getPublicKey();
        }
        catch (NoSuchFieldException e) {
            throw new InvalidKeyException(e);
        }
        return pk;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getUsername() {
        if (this.username != null) {
            return this.username;
        }
        String subject = null;
        try {
            HolderReferenceField hr = this.cvcert.getCertificateBody().getHolderReference();
            subject = hr.getMnemonic() + hr.getCountry();
        }
        catch (NoSuchFieldException e) {
            log.error((Object)e);
        }
        return subject;
    }

    @Override
    public String getIssuerDN() {
        CardVerifiableCertificate cc = this.getCardVerifiableCertificate();
        return CertTools.getIssuerDN((Certificate)cc);
    }

    @Override
    public BigInteger getSerialNo() {
        return null;
    }

    @Override
    public String getCRLIssuerDN() {
        return null;
    }

    @Override
    public BigInteger getCRLSerialNo() {
        return null;
    }

    @Override
    public String getRequestDN() {
        CardVerifiableCertificate cc = this.getCardVerifiableCertificate();
        return CertTools.getSubjectDN((Certificate)cc);
    }

    @Override
    public X500Name getRequestX500Name() {
        String dn = this.getRequestDN();
        return new X500Name(dn);
    }

    @Override
    public String getRequestAltNames() {
        return null;
    }

    @Override
    public Date getRequestValidityNotBefore() {
        CardVerifiableCertificate cc = this.getCardVerifiableCertificate();
        return CertTools.getNotBefore((Certificate)cc);
    }

    @Override
    public Date getRequestValidityNotAfter() {
        CardVerifiableCertificate cc = this.getCardVerifiableCertificate();
        return CertTools.getNotAfter((Certificate)cc);
    }

    @Override
    public Extensions getRequestExtensions() {
        return null;
    }

    @Override
    public boolean verify() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.verify(null);
    }

    private boolean verify(PublicKey pubKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        log.trace((Object)">verify()");
        boolean ret = false;
        try {
            CardVerifiableCertificate cc = this.getCardVerifiableCertificate();
            if (cc != null) {
                if (pubKey == null) {
                    cc.verify((PublicKey)this.cvcert.getCertificateBody().getPublicKey());
                    ret = true;
                } else {
                    cc.verify(pubKey);
                    ret = true;
                }
            }
        }
        catch (NoSuchFieldException e) {
            log.error((Object)"CVC error!", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            log.error((Object)"Error in CVC-request:", (Throwable)e);
            throw e;
        }
        catch (CertificateException e) {
            log.error((Object)"Error in CVC-signature:", (Throwable)e);
        }
        catch (SignatureException e) {
            log.error((Object)"Error in CVC-signature:", (Throwable)e);
        }
        log.trace((Object)"<verify()");
        return ret;
    }

    @Override
    public boolean requireKeyInfo() {
        return false;
    }

    @Override
    public void setKeyInfo(Certificate cert, PrivateKey key, String Provider2) {
    }

    @Override
    public int getErrorNo() {
        return 0;
    }

    @Override
    public String getErrorText() {
        return "";
    }

    @Override
    public String getSenderNonce() {
        return null;
    }

    @Override
    public String getTransactionId() {
        return null;
    }

    @Override
    public byte[] getRequestKeyInfo() {
        byte[] ret = null;
        try {
            String seq = this.cvcert.getCertificateBody().getHolderReference().getSequence();
            ret = seq.getBytes();
        }
        catch (NoSuchFieldException e) {
            log.error((Object)"CVC error!", (Throwable)e);
        }
        return ret;
    }

    @Override
    public String getPreferredDigestAlg() {
        return CMSSignedGenerator.DIGEST_SHA256;
    }

    @Override
    public boolean includeCACert() {
        return false;
    }

    @Override
    public int getRequestType() {
        return 0;
    }

    @Override
    public int getRequestId() {
        return 0;
    }

    @Override
    public void setResponseKeyInfo(PrivateKey key, String provider) {
        this.responsePrivateKey = key;
        if (provider != null) {
            this.responseProvider = provider;
        }
    }

    public String getKeySequence() {
        String ret = null;
        try {
            if (this.cvcert.getCertificateBody().getHolderReference() != null) {
                ret = this.cvcert.getCertificateBody().getHolderReference().getSequence();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return ret;
    }

    private CardVerifiableCertificate getCardVerifiableCertificate() {
        try {
            if (this.cvcert == null) {
                this.init();
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"CVC not inited!", (Throwable)e);
            return null;
        }
        CardVerifiableCertificate cc = new CardVerifiableCertificate(this.cvcert);
        return cc;
    }
}

