/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.request;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Date;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.cesecore.certificates.certificate.request.RequestMessage;
import org.cesecore.util.CeSecoreNameStyle;
import org.cesecore.util.CertTools;

public class PKCS10RequestMessage
implements RequestMessage {
    static final long serialVersionUID = 3597275157018205137L;
    private static final Logger log = Logger.getLogger(PKCS10RequestMessage.class);
    protected byte[] p10msg;
    protected String password = null;
    protected String username = null;
    protected boolean includeCACert = true;
    private transient String preferredDigestAlg = CMSSignedGenerator.DIGEST_SHA1;
    protected transient JcaPKCS10CertificationRequest pkcs10 = null;
    private int error = 0;
    private String errorText = null;
    private PrivateKey responsePrivateKey;
    private String responseProvider = "BC";

    public PKCS10RequestMessage() {
    }

    public PKCS10RequestMessage(byte[] msg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)">PKCS10RequestMessage(byte[])");
        }
        this.p10msg = msg;
        this.init();
        if (log.isTraceEnabled()) {
            log.trace((Object)"<PKCS10RequestMessage(byte[])");
        }
    }

    public PKCS10RequestMessage(JcaPKCS10CertificationRequest p10) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)">PKCS10RequestMessage(ExtendedPKCS10CertificationRequest)");
        }
        this.p10msg = p10.getEncoded();
        this.pkcs10 = p10;
        if (log.isTraceEnabled()) {
            log.trace((Object)"<PKCS10RequestMessage(ExtendedPKCS10CertificationRequest)");
        }
    }

    private void init() {
        if (this.p10msg == null) {
            throw new NullPointerException("Cannot initiate with p10msg == null");
        }
        try {
            this.pkcs10 = new JcaPKCS10CertificationRequest(this.p10msg);
        }
        catch (IOException e) {
            log.warn((Object)("PKCS10 not initiated! " + e.getMessage()));
        }
    }

    @Override
    public PublicKey getRequestPublicKey() throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.pkcs10 == null) {
            if (this.p10msg != null) {
                this.init();
            } else {
                return null;
            }
        }
        return this.pkcs10.getPublicKey();
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    @Override
    public String getPassword() {
        ASN1Set values;
        if (this.password != null) {
            return this.password;
        }
        try {
            if (this.pkcs10 == null) {
                this.init();
            }
        }
        catch (NullPointerException e) {
            log.error((Object)("PKCS10 not initated! " + e.getMessage()));
            return null;
        }
        String ret = null;
        Attribute[] attributes = this.pkcs10.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_challengePassword);
        ASN1Encodable obj = null;
        if (attributes.length == 0) {
            attributes = this.pkcs10.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
            if (attributes.length == 0) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"got extension request");
            }
            if ((values = attributes[0].getAttrValues()).size() == 0) {
                return null;
            }
            Extensions exts = Extensions.getInstance((Object)values.getObjectAt(0));
            Extension ext = exts.getExtension(PKCSObjectIdentifiers.pkcs_9_at_challengePassword);
            if (ext == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"no challenge password extension");
                }
                return null;
            }
            obj = ext.getExtnValue();
        } else {
            values = attributes[0].getAttrValues();
            obj = values.getObjectAt(0);
        }
        if (obj != null) {
            DERPrintableString str = null;
            try {
                str = DERPrintableString.getInstance((Object)obj);
            }
            catch (IllegalArgumentException ie) {
                str = DERUTF8String.getInstance((Object)obj);
            }
            if (str != null) {
                ret = str.getString();
            }
        }
        return ret;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getUsername() {
        if (this.username != null) {
            return this.username;
        }
        X500Name xname = this.getRequestX500Name();
        String ret = null;
        if (xname == null) {
            log.info((Object)"No requestDN in request, probably we could not read/parse/decrypt request.");
        } else {
            RDN[] cnValues = xname.getRDNs(CeSecoreNameStyle.CN);
            if (cnValues.length == 0) {
                log.info((Object)("No CN in DN: " + xname.toString()));
            } else {
                int index;
                AttributeTypeAndValue[] tavs;
                for (AttributeTypeAndValue tav : tavs = cnValues[0].getTypesAndValues()) {
                    if (!tav.getType().equals((Object)CeSecoreNameStyle.CN)) continue;
                    ret = tav.getValue().toString();
                    break;
                }
                if ((index = ret.indexOf(32)) > 0) {
                    ret = ret.substring(0, index);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("UserName='" + ret + "'"));
        }
        return ret;
    }

    @Override
    public String getIssuerDN() {
        return null;
    }

    @Override
    public BigInteger getSerialNo() {
        return null;
    }

    @Override
    public String getCRLIssuerDN() {
        return null;
    }

    @Override
    public BigInteger getCRLSerialNo() {
        return null;
    }

    @Override
    public String getRequestDN() {
        String ret = null;
        X500Name name = this.getRequestX500Name();
        if (name != null) {
            String dn = name.toString();
            dn = dn.replace("+unstructuredName=", ",unstructuredName=");
            dn = dn.replace(" + unstructuredName=", ",unstructuredName=");
            dn = dn.replace("+unstructuredAddress=", ",unstructuredAddress=");
            ret = dn = dn.replace(" + unstructuredAddress=", ",unstructuredAddress=");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRequestDN: " + ret));
        }
        return ret;
    }

    @Override
    public X500Name getRequestX500Name() {
        try {
            if (this.pkcs10 == null) {
                this.init();
            }
        }
        catch (NullPointerException e) {
            log.error((Object)("PKCS10 not inited: " + e.getMessage()));
            return null;
        }
        return new X500Name((X500NameStyle)new CeSecoreNameStyle(), this.pkcs10.getSubject());
    }

    @Override
    public String getRequestAltNames() {
        String ret;
        block6: {
            ret = null;
            try {
                Extensions exts = this.getRequestExtensions();
                if (exts != null) {
                    Extension ext = exts.getExtension(Extension.subjectAlternativeName);
                    if (ext != null) {
                        ret = CertTools.getAltNameStringFromExtension(ext);
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"no subject altName extension");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)"pkcs_9_extensionRequest does not contain Extensions that it should, ignoring invalid encoded extension request.");
            }
        }
        return ret;
    }

    @Override
    public Date getRequestValidityNotBefore() {
        return null;
    }

    @Override
    public Date getRequestValidityNotAfter() {
        return null;
    }

    @Override
    public Extensions getRequestExtensions() {
        Extensions ret;
        block8: {
            try {
                if (this.pkcs10 == null) {
                    this.init();
                }
            }
            catch (NullPointerException e) {
                log.error((Object)("PKCS10 not inited! " + e.getMessage()));
                return null;
            }
            ret = null;
            Attribute[] attr = this.pkcs10.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
            if (attr.length != 0) {
                ASN1Set values;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"got request extension");
                }
                if ((values = attr[0].getAttrValues()).size() > 0) {
                    try {
                        ret = Extensions.getInstance((Object)values.getObjectAt(0));
                    }
                    catch (IllegalArgumentException e) {
                        if (!log.isDebugEnabled()) break block8;
                        log.debug((Object)"pkcs_9_extensionRequest does not contain Extensions that it should, ignoring invalid encoded extension request.");
                    }
                }
            }
        }
        return ret;
    }

    public PKCS10CertificationRequest getCertificationRequest() {
        try {
            if (this.pkcs10 == null) {
                this.init();
            }
        }
        catch (NullPointerException e) {
            log.error((Object)("PKCS10 not inited! " + e.getMessage()));
            return null;
        }
        return this.pkcs10;
    }

    @Override
    public boolean verify() throws InvalidKeyException, NoSuchAlgorithmException {
        return this.verify(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(PublicKey pubKey) throws InvalidKeyException, NoSuchAlgorithmException {
        block12: {
            if (log.isTraceEnabled()) {
                log.trace((Object)">verify()");
            }
            if (this.pkcs10 == null) {
                this.init();
            }
            try {
                ContentVerifierProvider verifierProvider = pubKey == null ? CertTools.genContentVerifierProvider(this.pkcs10.getPublicKey()) : CertTools.genContentVerifierProvider(pubKey);
                try {
                    boolean bl = this.pkcs10.isSignatureValid(verifierProvider);
                    return bl;
                }
                catch (PKCSException e) {
                    try {
                        log.error((Object)"Signature could not be processed.", (Throwable)e);
                    }
                    catch (OperatorCreationException e2) {
                        log.error((Object)"Content verifier provider could not be created.", (Throwable)e2);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"<verify()");
                    }
                }
            }
            finally {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"<verify()");
                }
            }
        }
        return false;
    }

    @Override
    public boolean requireKeyInfo() {
        return false;
    }

    @Override
    public void setKeyInfo(Certificate cert, PrivateKey key, String Provider2) {
    }

    @Override
    public int getErrorNo() {
        return this.error;
    }

    @Override
    public String getErrorText() {
        return this.errorText;
    }

    @Override
    public String getSenderNonce() {
        return null;
    }

    @Override
    public String getTransactionId() {
        return null;
    }

    @Override
    public byte[] getRequestKeyInfo() {
        return null;
    }

    @Override
    public String getPreferredDigestAlg() {
        return this.preferredDigestAlg;
    }

    @Override
    public boolean includeCACert() {
        return this.includeCACert;
    }

    @Override
    public int getRequestType() {
        return 0;
    }

    @Override
    public int getRequestId() {
        return 0;
    }

    @Override
    public void setResponseKeyInfo(PrivateKey key, String provider) {
        this.responsePrivateKey = key;
        if (provider != null) {
            this.responseProvider = provider;
        }
    }
}

