/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.request;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extensions;

public interface RequestMessage
extends Serializable {
    public String getUsername();

    public String getPassword();

    public String getIssuerDN();

    public BigInteger getSerialNo();

    public String getRequestDN();

    public X500Name getRequestX500Name();

    public String getRequestAltNames();

    public Date getRequestValidityNotBefore();

    public Date getRequestValidityNotAfter();

    public Extensions getRequestExtensions();

    public String getCRLIssuerDN();

    public BigInteger getCRLSerialNo();

    public PublicKey getRequestPublicKey() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException;

    public boolean verify() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException;

    public boolean requireKeyInfo();

    public void setKeyInfo(Certificate var1, PrivateKey var2, String var3);

    public int getErrorNo();

    public String getErrorText();

    public String getSenderNonce();

    public String getTransactionId();

    public byte[] getRequestKeyInfo();

    public String getPreferredDigestAlg();

    public boolean includeCACert();

    public int getRequestType();

    public int getRequestId();

    public void setResponseKeyInfo(PrivateKey var1, String var2);
}

