/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.POPOSigningKey;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.jcajce.JcaCertificateRequestMessage;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.jce.netscape.NetscapeCertRequest;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.encoders.DecoderException;
import org.cesecore.certificates.ca.SignRequestSignatureException;
import org.cesecore.certificates.certificate.request.CVCRequestMessage;
import org.cesecore.certificates.certificate.request.PKCS10RequestMessage;
import org.cesecore.certificates.certificate.request.RequestMessage;
import org.cesecore.certificates.certificate.request.SimpleRequestMessage;
import org.cesecore.keys.util.KeyTools;
import org.cesecore.util.Base64;
import org.cesecore.util.FileTools;
import org.ejbca.cvc.CVCAuthenticatedRequest;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CertificateParser;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.exception.ParseException;

public abstract class RequestMessageUtils {
    private static final Logger log = Logger.getLogger(RequestMessageUtils.class);

    public static RequestMessage parseRequestMessage(byte[] request) {
        RequestMessage ret = null;
        try {
            ret = RequestMessageUtils.genPKCS10RequestMessage(request);
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)("Can not parse PKCS10 request, trying CVC instead: " + e.getMessage()));
            ret = RequestMessageUtils.genCVCRequestMessage(request);
        }
        return ret;
    }

    public static PKCS10RequestMessage genPKCS10RequestMessage(byte[] bytes) {
        byte[] buffer = RequestMessageUtils.getDecodedBytes(bytes);
        if (buffer == null) {
            return null;
        }
        return new PKCS10RequestMessage(buffer);
    }

    public static CVCRequestMessage genCVCRequestMessage(byte[] bytes) {
        byte[] buffer = RequestMessageUtils.getDecodedBytes(bytes);
        if (buffer == null) {
            return null;
        }
        return new CVCRequestMessage(buffer);
    }

    public static byte[] getDecodedBytes(byte[] bytes) {
        byte[] buffer = null;
        try {
            buffer = RequestMessageUtils.getRequestBytes(bytes);
        }
        catch (IOException e) {
            log.debug((Object)("Message not base64 encoded? Trying as binary: " + e.getMessage()));
            buffer = bytes;
        }
        return buffer;
    }

    public static byte[] getRequestBytes(byte[] b64Encoded) throws IOException {
        byte[] buffer = null;
        try {
            String beginKey = "-----BEGIN CERTIFICATE REQUEST-----";
            String endKey = "-----END CERTIFICATE REQUEST-----";
            buffer = FileTools.getBytesFromPEM(b64Encoded, beginKey, endKey);
        }
        catch (IOException e) {
            try {
                String beginKey = "-----BEGIN NEW CERTIFICATE REQUEST-----";
                String endKey = "-----END NEW CERTIFICATE REQUEST-----";
                buffer = FileTools.getBytesFromPEM(b64Encoded, beginKey, endKey);
            }
            catch (IOException ioe) {
                try {
                    String beginKey = "-----BEGIN CERTIFICATE-----";
                    String endKey = "-----END CERTIFICATE-----";
                    buffer = FileTools.getBytesFromPEM(b64Encoded, beginKey, endKey);
                }
                catch (IOException ioe2) {
                    try {
                        buffer = Base64.decode(b64Encoded);
                        if (buffer == null) {
                            throw new IOException("Base64 decode of buffer returns null");
                        }
                    }
                    catch (DecoderException de) {
                        throw new IOException("Base64 decode fails, message not base64 encoded: " + de.getMessage());
                    }
                }
            }
        }
        return buffer;
    }

    public static RequestMessage getRequestMessageFromType(String username, String password, String req, int reqType) throws SignRequestSignatureException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, IOException, SignatureException, InvalidKeySpecException, ParseException, ConstructionException, NoSuchFieldException {
        RequestMessage ret = null;
        if (reqType == 0) {
            PKCS10RequestMessage pkcs10RequestMessage = RequestMessageUtils.genPKCS10RequestMessage(req.getBytes());
            pkcs10RequestMessage.setUsername(username);
            pkcs10RequestMessage.setPassword(password);
            ret = pkcs10RequestMessage;
        } else if (reqType == 2) {
            byte[] reqBytes = req.getBytes();
            if (reqBytes != null) {
                byte[] buffer;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Received NS request: " + new String(reqBytes)));
                }
                if ((buffer = Base64.decode(reqBytes)) == null) {
                    return null;
                }
                ASN1InputStream in = new ASN1InputStream((InputStream)new ByteArrayInputStream(buffer));
                ASN1Sequence spkacSeq = (ASN1Sequence)in.readObject();
                in.close();
                NetscapeCertRequest nscr = new NetscapeCertRequest(spkacSeq);
                nscr.setChallenge("challenge");
                if (!nscr.verify("challenge")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"SPKAC POPO verification Failed");
                    }
                    throw new SignRequestSignatureException("Invalid signature in NetscapeCertRequest, popo-verification failed.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"POPO verification successful");
                }
                PublicKey pubKey = nscr.getPublicKey();
                ret = new SimpleRequestMessage(pubKey, username, password);
            }
        } else {
            if (reqType == 1) {
                byte[] certificateRequestMessages = Base64.decode(req.getBytes());
                CertReqMsg certReqMsg = CertReqMsg.getInstance((Object)((ASN1Sequence)ASN1Sequence.fromByteArray((byte[])certificateRequestMessages)).getObjectAt(0));
                JcaCertificateRequestMessage jcrm = new JcaCertificateRequestMessage(certReqMsg);
                try {
                    PublicKey publicKey = jcrm.getPublicKey();
                    if (jcrm.hasProofOfPossession()) {
                        switch (jcrm.getProofOfPossessionType()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                POPOSigningKey popoSigningKey = POPOSigningKey.getInstance((Object)jcrm.toASN1Structure().getPopo().getObject());
                                if (log.isDebugEnabled()) {
                                    if (popoSigningKey != null) {
                                        log.debug((Object)("CRMF POPOSigningKey poposkInput:                      " + popoSigningKey.getPoposkInput()));
                                        if (popoSigningKey.getPoposkInput() != null) {
                                            log.debug((Object)("CRMF POPOSigningKey poposkInput PublicKey:            " + popoSigningKey.getPoposkInput().getPublicKey()));
                                            log.debug((Object)("CRMF POPOSigningKey poposkInput PublicKeyMAC:         " + popoSigningKey.getPoposkInput().getPublicKeyMAC()));
                                        }
                                        log.debug((Object)("CRMF POPOSigningKey algorithmIdentifier.algorithm.id: " + popoSigningKey.getAlgorithmIdentifier().getAlgorithm().getId()));
                                        log.debug((Object)("CRMF POPOSigningKey signature:                        " + popoSigningKey.getSignature()));
                                    } else {
                                        log.debug((Object)"CRMF POPOSigningKey is not defined even though POP type is popSigningKey. Validation will fail.");
                                    }
                                }
                                ContentVerifierProvider cvp = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
                                if (popoSigningKey.getPoposkInput() != null && jcrm.hasSigningKeyProofOfPossessionWithPKMAC()) {
                                    PKMACBuilder pkmacBuilder = new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator().setProvider("BC"));
                                    if (!jcrm.isValidSigningKeyPOP(cvp, pkmacBuilder, password.toCharArray())) {
                                        throw new SignRequestSignatureException("CRMF POP with PKMAC failed signature or MAC validation.");
                                    }
                                    if (!log.isDebugEnabled()) break;
                                    log.debug((Object)"CRMF POP with PKMAC passed signature and PKMAC validation.");
                                    break;
                                }
                                if (!jcrm.isValidSigningKeyPOP(cvp)) {
                                    throw new SignRequestSignatureException("CRMF POP failed signature validation.");
                                }
                                if (!log.isDebugEnabled()) break;
                                log.debug((Object)"CRMF POP passed signature validation.");
                                break;
                            }
                            case 2: {
                                log.info((Object)"CRMF RFC4211 Section 4.2 KeyEncipherment POP validation is not implemented. Will try to use the request's public key anyway.");
                                break;
                            }
                            case 3: {
                                log.info((Object)"CRMF RFC4211 Section 4.3 KeyAgreement POP validation is not implemented. Will try to use the request's public key anyway.");
                                break;
                            }
                            default: {
                                throw new SignRequestSignatureException("CRMF POP of type " + jcrm.getProofOfPossessionType() + " is unknown.");
                            }
                        }
                    }
                    SimpleRequestMessage simpleRequestMessage = new SimpleRequestMessage(publicKey, username, password);
                    simpleRequestMessage.setRequestExtensions(jcrm.getCertTemplate().getExtensions());
                    ret = simpleRequestMessage;
                }
                catch (CRMFException e) {
                    throw new SignRequestSignatureException("CRMF POP verification failed.", e);
                }
                catch (OperatorCreationException e) {
                    throw new SignRequestSignatureException("CRMF POP verification failed.", e);
                }
            }
            if (reqType == 3) {
                byte[] request;
                try {
                    request = FileTools.getBytesFromPEM(req.getBytes(), "-----BEGIN PUBLIC KEY-----", "-----END PUBLIC KEY-----");
                }
                catch (IOException ex) {
                    try {
                        request = Base64.decode(req.getBytes());
                        if (request == null) {
                            throw new IOException("Base64 decode of buffer returns null");
                        }
                    }
                    catch (DecoderException de) {
                        throw new IOException("Base64 decode fails, message not base64 encoded: " + de.getMessage());
                    }
                }
                PublicKey pubKey = KeyTools.getPublicKeyFromBytes(request);
                ret = new SimpleRequestMessage(pubKey, username, password);
            } else if (reqType == 4) {
                CVCObject parsedObject = CertificateParser.parseCVCObject((byte[])Base64.decode(req.getBytes()));
                CVCertificate cvccert = null;
                if (parsedObject instanceof CVCAuthenticatedRequest) {
                    CVCAuthenticatedRequest cvcreq = (CVCAuthenticatedRequest)parsedObject;
                    cvccert = cvcreq.getRequest();
                } else {
                    cvccert = (CVCertificate)parsedObject;
                }
                CVCRequestMessage reqmsg = new CVCRequestMessage(cvccert.getDEREncoded());
                reqmsg.setUsername(username);
                reqmsg.setPassword(password);
                if (!reqmsg.verify()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"CVC POPO verification Failed");
                    }
                    throw new SignRequestSignatureException("Invalid inner signature in CVCRequest, popo-verification failed.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"POPO verification successful");
                }
                ret = reqmsg;
            }
        }
        return ret;
    }
}

