/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificate.request;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Date;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.cesecore.certificates.certificate.request.RequestMessage;
import org.cesecore.keys.util.PublicKeyWrapper;
import org.cesecore.util.CeSecoreNameStyle;

public class SimpleRequestMessage
implements RequestMessage {
    private static final Logger log = Logger.getLogger(SimpleRequestMessage.class);
    static final long serialVersionUID = 1L;
    protected PublicKeyWrapper pubkey;
    protected String password = null;
    protected String username = null;
    protected boolean includeCACert = true;
    private transient String preferredDigestAlg = CMSSignedGenerator.DIGEST_SHA1;
    private int error = 0;
    private String errorText = null;
    private String issuerDN = null;
    private String requestDN = null;
    private Extensions x509Extensions = null;
    private Date validityNotBefore = null;
    private Date validityNotAfter = null;

    public SimpleRequestMessage(PublicKey pubkey, String username, String password) {
        this.pubkey = new PublicKeyWrapper(pubkey);
        this.username = username;
        this.password = password;
    }

    public SimpleRequestMessage(PublicKey pubkey, String username, String password, Date validityNotAfter) {
        this.pubkey = new PublicKeyWrapper(pubkey);
        this.username = username;
        this.password = password;
        this.validityNotAfter = validityNotAfter;
    }

    public SimpleRequestMessage(PublicKey pubkey, String username, String password, Date validityNotBefore, Date validityNotAfter) {
        this.pubkey = new PublicKeyWrapper(pubkey);
        this.username = username;
        this.password = password;
        this.validityNotBefore = validityNotBefore;
        this.validityNotAfter = validityNotAfter;
    }

    @Override
    public PublicKey getRequestPublicKey() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.pubkey.getPublicKey();
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getIssuerDN() {
        return this.issuerDN;
    }

    public void setIssuerDN(String dn) {
        this.issuerDN = dn;
    }

    @Override
    public BigInteger getSerialNo() {
        return null;
    }

    @Override
    public String getCRLIssuerDN() {
        return null;
    }

    @Override
    public BigInteger getCRLSerialNo() {
        return null;
    }

    @Override
    public String getRequestDN() {
        return null;
    }

    @Override
    public X500Name getRequestX500Name() {
        if (this.requestDN == null) {
            return null;
        }
        return new X500Name((X500NameStyle)new CeSecoreNameStyle(), this.requestDN);
    }

    public void setRequestDN(String dn) {
        this.requestDN = dn;
    }

    @Override
    public String getRequestAltNames() {
        return null;
    }

    @Override
    public Date getRequestValidityNotBefore() {
        return this.validityNotBefore;
    }

    @Override
    public Date getRequestValidityNotAfter() {
        return this.validityNotAfter;
    }

    @Override
    public Extensions getRequestExtensions() {
        return this.x509Extensions;
    }

    public void setRequestExtensions(Extensions extensions) {
        this.x509Extensions = extensions;
    }

    @Override
    public boolean verify() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        return true;
    }

    @Override
    public boolean requireKeyInfo() {
        return false;
    }

    @Override
    public void setKeyInfo(Certificate cert, PrivateKey key, String Provider2) {
    }

    @Override
    public int getErrorNo() {
        return this.error;
    }

    @Override
    public String getErrorText() {
        return this.errorText;
    }

    @Override
    public String getSenderNonce() {
        return null;
    }

    @Override
    public String getTransactionId() {
        return null;
    }

    @Override
    public byte[] getRequestKeyInfo() {
        return null;
    }

    @Override
    public String getPreferredDigestAlg() {
        return this.preferredDigestAlg;
    }

    @Override
    public boolean includeCACert() {
        return this.includeCACert;
    }

    @Override
    public int getRequestType() {
        return 0;
    }

    @Override
    public int getRequestId() {
        return 0;
    }

    @Override
    public void setResponseKeyInfo(PrivateKey key, String provider) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Key and provider were set for a SimpleRequestMessage. These values are not used and will be ignored.");
        }
    }
}

