/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificateprofile;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.cesecore.certificates.certificateprofile.CertificatePolicy;
import org.cesecore.certificates.util.DNFieldExtractor;
import org.cesecore.internal.InternalResources;
import org.cesecore.internal.UpgradeableDataHashMap;

public class CertificateProfile
extends UpgradeableDataHashMap
implements Serializable,
Cloneable {
    private static final Logger log = Logger.getLogger(CertificateProfile.class);
    private static final InternalResources intres = InternalResources.getInstance();
    public static final float LATEST_VERSION = 38.0f;
    public static final String ROOTCAPROFILENAME = "ROOTCA";
    public static final String SUBCAPROFILENAME = "SUBCA";
    public static final String ENDUSERPROFILENAME = "ENDUSER";
    public static final String OCSPSIGNERPROFILENAME = "OCSPSIGNER";
    public static final String SERVERPROFILENAME = "SERVER";
    public static final String HARDTOKENAUTHPROFILENAME = "HARDTOKEN_AUTH";
    public static final String HARDTOKENAUTHENCPROFILENAME = "HARDTOKEN_AUTHENC";
    public static final String HARDTOKENENCPROFILENAME = "HARDTOKEN_ENC";
    public static final String HARDTOKENSIGNPROFILENAME = "HARDTOKEN_SIGN";
    public static final List<String> FIXED_PROFILENAMES = new ArrayList<String>();
    private static final long serialVersionUID = -8069608639716545206L;
    public static final String MSTEMPL_DOMAINCONTROLLER = "DomainController";
    public static final String[] AVAILABLE_MSTEMPLATES;
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final int CVC_ACCESS_NONE = 0;
    public static final int CVC_ACCESS_DG3 = 1;
    public static final int CVC_ACCESS_DG4 = 2;
    public static final int CVC_ACCESS_DG3DG4 = 3;
    public static final int CVC_ACCESS_SIGN = 16;
    public static final int CVC_ACCESS_QUALSIGN = 32;
    public static final int CVC_ACCESS_SIGN_AND_QUALSIGN = 48;
    public static final int CVC_TERMTYPE_IS = 0;
    public static final int CVC_TERMTYPE_AT = 1;
    public static final int CVC_TERMTYPE_ST = 2;
    public static final int CVC_SIGNTERM_DV_AB = 0;
    public static final int CVC_SIGNTERM_DV_CSP = 1;
    public static final String VERSION_X509V3 = "X509v3";
    public static final String CUSTOMPROFILENAME = "CUSTOM";
    public static final int ANYCA = -1;
    public static final int[] DEFAULTBITLENGTHS;
    public static final byte[] DEFAULT_CVC_RIGHTS_AT;
    protected static final String CERTVERSION = "certversion";
    protected static final String VALIDITY = "validity";
    protected static final String ALLOWVALIDITYOVERRIDE = "allowvalidityoverride";
    protected static final String ALLOWKEYUSAGEOVERRIDE = "allowkeyusageoverride";
    protected static final String ALLOWBACKDATEDREVOCATION = "allowbackdatedrevokation";
    protected static final String ALLOWEXTENSIONOVERRIDE = "allowextensionoverride";
    protected static final String ALLOWDNOVERRIDE = "allowdnoverride";
    protected static final String ALLOWDNOVERRIDEBYEEI = "allowdnoverridebyeei";
    protected static final String ALLOWCERTSNOVERIDE = "allowcertsnoverride";
    protected static final String AVAILABLEBITLENGTHS = "availablebitlengths";
    protected static final String MINIMUMAVAILABLEBITLENGTH = "minimumavailablebitlength";
    protected static final String MAXIMUMAVAILABLEBITLENGTH = "maximumavailablebitlength";
    public static final String TYPE = "type";
    protected static final String AVAILABLECAS = "availablecas";
    protected static final String USEDPUBLISHERS = "usedpublishers";
    protected static final String USECNPOSTFIX = "usecnpostfix";
    protected static final String CNPOSTFIX = "cnpostfix";
    protected static final String USESUBJECTDNSUBSET = "usesubjectdnsubset";
    protected static final String SUBJECTDNSUBSET = "subjectdnsubset";
    protected static final String USESUBJECTALTNAMESUBSET = "usesubjectaltnamesubset";
    protected static final String SUBJECTALTNAMESUBSET = "subjectaltnamesubset";
    protected static final String USEDCERTIFICATEEXTENSIONS = "usedcertificateextensions";
    protected static final String APPROVALSETTINGS = "approvalsettings";
    protected static final String NUMOFREQAPPROVALS = "numofreqapprovals";
    protected static final String SIGNATUREALGORITHM = "signaturealgorithm";
    protected static final String USECERTIFICATESTORAGE = "usecertificatestorage";
    protected static final String STORECERTIFICATEDATA = "storecertificatedata";
    protected static final String USECRLNUMBER = "usecrlnumber";
    protected static final String CRLNUMBERCRITICAL = "crlnumbercritical";
    protected static final String USECRLDISTRIBUTIONPOINTONCRL = "usecrldistributionpointoncrl";
    protected static final String USEBASICCONSTRAINTS = "usebasicconstrants";
    protected static final String BASICCONSTRAINTSCRITICAL = "basicconstraintscritical";
    protected static final String USEPATHLENGTHCONSTRAINT = "usepathlengthconstraint";
    protected static final String PATHLENGTHCONSTRAINT = "pathlengthconstraint";
    protected static final String USEKEYUSAGE = "usekeyusage";
    protected static final String KEYUSAGECRITICAL = "keyusagecritical";
    protected static final String KEYUSAGE = "keyusage";
    protected static final String USESUBJECTKEYIDENTIFIER = "usesubjectkeyidentifier";
    protected static final String SUBJECTKEYIDENTIFIERCRITICAL = "subjectkeyidentifiercritical";
    protected static final String USEAUTHORITYKEYIDENTIFIER = "useauthoritykeyidentifier";
    protected static final String AUTHORITYKEYIDENTIFIERCRITICAL = "authoritykeyidentifiercritical";
    protected static final String USESUBJECTALTERNATIVENAME = "usesubjectalternativename";
    protected static final String SUBJECTALTERNATIVENAMECRITICAL = "subjectalternativenamecritical";
    protected static final String USEISSUERALTERNATIVENAME = "useissueralternativename";
    protected static final String ISSUERALTERNATIVENAMECRITICAL = "issueralternativenamecritical";
    protected static final String USECRLDISTRIBUTIONPOINT = "usecrldistributionpoint";
    protected static final String USEDEFAULTCRLDISTRIBUTIONPOINT = "usedefaultcrldistributionpoint";
    protected static final String CRLDISTRIBUTIONPOINTCRITICAL = "crldistributionpointcritical";
    protected static final String CRLDISTRIBUTIONPOINTURI = "crldistributionpointuri";
    protected static final String CRLISSUER = "crlissuer";
    protected static final String USEFRESHESTCRL = "usefreshestcrl";
    protected static final String USECADEFINEDFRESHESTCRL = "usecadefinedfreshestcrl";
    protected static final String FRESHESTCRLURI = "freshestcrluri";
    protected static final String USECERTIFICATEPOLICIES = "usecertificatepolicies";
    protected static final String CERTIFICATEPOLICIESCRITICAL = "certificatepoliciescritical";
    protected static final String CERTIFICATE_POLICIES = "certificatepolicies";
    protected static final String USEEXTENDEDKEYUSAGE = "useextendedkeyusage";
    protected static final String EXTENDEDKEYUSAGE = "extendedkeyusage";
    protected static final String EXTENDEDKEYUSAGECRITICAL = "extendedkeyusagecritical";
    protected static final String USEDOCUMENTTYPELIST = "usedocumenttypelist";
    protected static final String DOCUMENTTYPELISTCRITICAL = "documenttypelistcritical";
    protected static final String DOCUMENTTYPELIST = "documenttypelist";
    protected static final String USEOCSPNOCHECK = "useocspnocheck";
    protected static final String USEAUTHORITYINFORMATIONACCESS = "useauthorityinformationaccess";
    protected static final String USEOCSPSERVICELOCATOR = "useocspservicelocator";
    protected static final String USEDEFAULTOCSPSERVICELOCATOR = "usedefaultocspservicelocator";
    protected static final String OCSPSERVICELOCATORURI = "ocspservicelocatoruri";
    protected static final String USECAISSUERS = "usecaissuersuri";
    protected static final String CAISSUERS = "caissuers";
    protected static final String USELDAPDNORDER = "useldapdnorder";
    protected static final String USEMICROSOFTTEMPLATE = "usemicrosofttemplate";
    protected static final String MICROSOFTTEMPLATE = "microsofttemplate";
    protected static final String USECARDNUMBER = "usecardnumber";
    protected static final String USEQCSTATEMENT = "useqcstatement";
    protected static final String USEPKIXQCSYNTAXV2 = "usepkixqcsyntaxv2";
    protected static final String QCSTATEMENTCRITICAL = "useqcstatementcritical";
    protected static final String QCSTATEMENTRANAME = "useqcstatementraname";
    protected static final String QCSSEMANTICSID = "useqcsematicsid";
    protected static final String USEQCETSIQCCOMPLIANCE = "useqcetsiqccompliance";
    protected static final String USEQCETSIVALUELIMIT = "useqcetsivaluelimit";
    protected static final String QCETSIVALUELIMIT = "qcetsivaluelimit";
    protected static final String QCETSIVALUELIMITEXP = "qcetsivaluelimitexp";
    protected static final String QCETSIVALUELIMITCURRENCY = "qcetsivaluelimitcurrency";
    protected static final String USEQCETSIRETENTIONPERIOD = "useqcetsiretentionperiod";
    protected static final String QCETSIRETENTIONPERIOD = "qcetsiretentionperiod";
    protected static final String USEQCETSISIGNATUREDEVICE = "useqcetsisignaturedevice";
    protected static final String USEQCCUSTOMSTRING = "useqccustomstring";
    protected static final String QCCUSTOMSTRINGOID = "qccustomstringoid";
    protected static final String QCCUSTOMSTRINGTEXT = "qccustomstringtext";
    protected static final String USENAMECONSTRAINTS = "usenameconstraints";
    protected static final String NAMECONSTRAINTSCRITICAL = "nameconstraintscritical";
    protected static final String USESUBJECTDIRATTRIBUTES = "usesubjectdirattributes";
    protected static final String CVCTERMINALTYPE = "cvctermtype";
    protected static final String CVCACCESSRIGHTS = "cvcaccessrights";
    protected static final String CVCLONGACCESSRIGHTS = "cvclongaccessrights";
    protected static final String CVCSIGNTERMDVTYPE = "cvcsigntermdvtype";
    protected static final String USEPRIVKEYUSAGEPERIOD = "useprivkeyusageperiod";
    protected static final String USEPRIVKEYUSAGEPERIODNOTBEFORE = "useprivkeyusageperiodnotbefore";
    protected static final String USEPRIVKEYUSAGEPERIODNOTAFTER = "useprivkeyusageperiodnotafter";
    protected static final String PRIVKEYUSAGEPERIODSTARTOFFSET = "privkeyusageperiodstartoffset";
    protected static final String PRIVKEYUSAGEPERIODLENGTH = "privkeyusageperiodlength";
    protected static final String USECERTIFICATETRANSPARENCYINCERTS = "usecertificatetransparencyincerts";
    protected static final String USECERTIFICATETRANSPARENCYINOCSP = "usecertificatetransparencyinocsp";
    protected static final String USECERTIFICATETRANSPARENCYINPUBLISHERS = "usecertificatetransparencyinpublisher";
    protected static final String CTSUBMITEXISTING = "ctsubmitexisting";
    protected static final String CTLOGS = "ctlogs";
    protected static final String CTMINSCTS = "ctminscts";
    protected static final String CTMAXSCTS = "ctmaxscts";
    protected static final String CTMINSCTSOCSP = "ctminsctsocsp";
    protected static final String CTMAXSCTSOCSP = "ctmaxsctsocsp";
    protected static final String CTMAXRETRIES = "ctmaxretries";
    protected static final String USERSINGLEACTIVECERTIFICATECONSTRAINT = "usesingleactivecertificateconstraint";
    public static final String OID_CARDNUMBER = "1.2.752.34.2.1";
    protected static final HashMap<String, String> useStandardCertificateExtensions;
    protected static final String CERTIFICATEPOLICYID = "certificatepolicyid";
    protected static final String POLICY_NOTICE_CPS_URL = "policynoticecpsurl";
    protected static final String POLICY_NOTICE_UNOTICE_TEXT = "policynoticeunoticetext";

    public CertificateProfile() {
        useStandardCertificateExtensions.put(USEBASICCONSTRAINTS, Extension.basicConstraints.getId());
        useStandardCertificateExtensions.put(USEKEYUSAGE, Extension.keyUsage.getId());
        useStandardCertificateExtensions.put(USESUBJECTKEYIDENTIFIER, Extension.subjectKeyIdentifier.getId());
        useStandardCertificateExtensions.put(USEAUTHORITYKEYIDENTIFIER, Extension.authorityKeyIdentifier.getId());
        useStandardCertificateExtensions.put(USESUBJECTALTERNATIVENAME, Extension.subjectAlternativeName.getId());
        useStandardCertificateExtensions.put(USEISSUERALTERNATIVENAME, Extension.issuerAlternativeName.getId());
        useStandardCertificateExtensions.put(USECRLDISTRIBUTIONPOINT, Extension.cRLDistributionPoints.getId());
        useStandardCertificateExtensions.put(USEFRESHESTCRL, Extension.freshestCRL.getId());
        useStandardCertificateExtensions.put(USECERTIFICATEPOLICIES, Extension.certificatePolicies.getId());
        useStandardCertificateExtensions.put(USEEXTENDEDKEYUSAGE, Extension.extendedKeyUsage.getId());
        useStandardCertificateExtensions.put(USEDOCUMENTTYPELIST, "2.23.136.1.1.6.2");
        useStandardCertificateExtensions.put(USEQCSTATEMENT, Extension.qCStatements.getId());
        useStandardCertificateExtensions.put(USENAMECONSTRAINTS, Extension.nameConstraints.getId());
        useStandardCertificateExtensions.put(USESUBJECTDIRATTRIBUTES, Extension.subjectDirectoryAttributes.getId());
        useStandardCertificateExtensions.put(USEAUTHORITYINFORMATIONACCESS, Extension.authorityInfoAccess.getId());
        useStandardCertificateExtensions.put(USEPRIVKEYUSAGEPERIOD, Extension.privateKeyUsagePeriod.getId());
        useStandardCertificateExtensions.put(USEOCSPNOCHECK, OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId());
        useStandardCertificateExtensions.put(USEMICROSOFTTEMPLATE, "1.3.6.1.4.1.311.20.2");
        useStandardCertificateExtensions.put(USECARDNUMBER, OID_CARDNUMBER);
        this.setCommonDefaults();
    }

    public CertificateProfile(int type) {
        useStandardCertificateExtensions.put(USEBASICCONSTRAINTS, Extension.basicConstraints.getId());
        useStandardCertificateExtensions.put(USEKEYUSAGE, Extension.keyUsage.getId());
        useStandardCertificateExtensions.put(USESUBJECTKEYIDENTIFIER, Extension.subjectKeyIdentifier.getId());
        useStandardCertificateExtensions.put(USEAUTHORITYKEYIDENTIFIER, Extension.authorityKeyIdentifier.getId());
        useStandardCertificateExtensions.put(USESUBJECTALTERNATIVENAME, Extension.subjectAlternativeName.getId());
        useStandardCertificateExtensions.put(USEISSUERALTERNATIVENAME, Extension.issuerAlternativeName.getId());
        useStandardCertificateExtensions.put(USECRLDISTRIBUTIONPOINT, Extension.cRLDistributionPoints.getId());
        useStandardCertificateExtensions.put(USEFRESHESTCRL, Extension.freshestCRL.getId());
        useStandardCertificateExtensions.put(USECERTIFICATEPOLICIES, Extension.certificatePolicies.getId());
        useStandardCertificateExtensions.put(USEEXTENDEDKEYUSAGE, Extension.extendedKeyUsage.getId());
        useStandardCertificateExtensions.put(USEDOCUMENTTYPELIST, "2.23.136.1.1.6.2");
        useStandardCertificateExtensions.put(USEQCSTATEMENT, Extension.qCStatements.getId());
        useStandardCertificateExtensions.put(USENAMECONSTRAINTS, Extension.nameConstraints.getId());
        useStandardCertificateExtensions.put(USESUBJECTDIRATTRIBUTES, Extension.subjectDirectoryAttributes.getId());
        useStandardCertificateExtensions.put(USEAUTHORITYINFORMATIONACCESS, Extension.authorityInfoAccess.getId());
        useStandardCertificateExtensions.put(USEPRIVKEYUSAGEPERIOD, Extension.privateKeyUsagePeriod.getId());
        useStandardCertificateExtensions.put(USEOCSPNOCHECK, OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId());
        useStandardCertificateExtensions.put(USEMICROSOFTTEMPLATE, "1.3.6.1.4.1.311.20.2");
        useStandardCertificateExtensions.put(USECARDNUMBER, OID_CARDNUMBER);
        this.setCommonDefaults();
        this.setDefaultValues(type);
    }

    private void setCommonDefaults() {
        this.setType(1);
        this.setCertificateVersion(VERSION_X509V3);
        this.setValidity(730L);
        this.setAllowValidityOverride(false);
        this.setAllowExtensionOverride(false);
        this.setAllowDNOverride(false);
        this.setAllowDNOverrideByEndEntityInformation(false);
        this.setUseBasicConstraints(true);
        this.setBasicConstraintsCritical(true);
        this.setUseSubjectKeyIdentifier(true);
        this.setSubjectKeyIdentifierCritical(false);
        this.setUseAuthorityKeyIdentifier(true);
        this.setAuthorityKeyIdentifierCritical(false);
        this.setUseSubjectAlternativeName(true);
        this.setSubjectAlternativeNameCritical(false);
        this.setUseIssuerAlternativeName(true);
        this.setIssuerAlternativeNameCritical(false);
        this.setUseCRLDistributionPoint(false);
        this.setUseDefaultCRLDistributionPoint(false);
        this.setCRLDistributionPointCritical(false);
        this.setCRLDistributionPointURI("");
        this.setUseCRLDistributionPointOnCRL(false);
        this.setUseFreshestCRL(false);
        this.setUseCADefinedFreshestCRL(false);
        this.setFreshestCRLURI("");
        this.setCRLIssuer(null);
        this.setUseCertificatePolicies(false);
        this.setCertificatePoliciesCritical(false);
        ArrayList<CertificatePolicy> policies = new ArrayList<CertificatePolicy>();
        this.setCertificatePolicies(policies);
        this.setAvailableBitLengths(DEFAULTBITLENGTHS);
        this.setUseKeyUsage(true);
        this.setKeyUsage(new boolean[9]);
        this.setAllowKeyUsageOverride(false);
        this.setKeyUsageCritical(true);
        this.setUseExtendedKeyUsage(false);
        this.setExtendedKeyUsage(new ArrayList<String>());
        this.setExtendedKeyUsageCritical(false);
        this.setUseDocumentTypeList(false);
        this.setDocumentTypeListCritical(false);
        this.setDocumentTypeList(new ArrayList<String>());
        ArrayList<Integer> availablecas = new ArrayList<Integer>();
        availablecas.add(-1);
        this.setAvailableCAs(availablecas);
        this.setPublisherList(new ArrayList<Integer>());
        this.setUseOcspNoCheck(false);
        this.setUseLdapDnOrder(true);
        this.setUseMicrosoftTemplate(false);
        this.setMicrosoftTemplate("");
        this.setUseCardNumber(false);
        this.setUseCNPostfix(false);
        this.setCNPostfix("");
        this.setUseSubjectDNSubSet(false);
        this.setSubjectDNSubSet(new ArrayList<String>());
        this.setUseSubjectAltNameSubSet(false);
        this.setSubjectAltNameSubSet(new ArrayList<Integer>());
        this.setUsePathLengthConstraint(false);
        this.setPathLengthConstraint(0);
        this.setUseQCStatement(false);
        this.setUsePkixQCSyntaxV2(false);
        this.setQCStatementCritical(false);
        this.setQCStatementRAName(null);
        this.setQCSemanticsId(null);
        this.setUseQCEtsiQCCompliance(false);
        this.setUseQCEtsiSignatureDevice(false);
        this.setUseQCEtsiValueLimit(false);
        this.setQCEtsiValueLimit(0);
        this.setQCEtsiValueLimitExp(0);
        this.setQCEtsiValueLimitCurrency(null);
        this.setUseQCEtsiRetentionPeriod(false);
        this.setQCEtsiRetentionPeriod(0);
        this.setUseQCCustomString(false);
        this.setQCCustomStringOid(null);
        this.setQCCustomStringText(null);
        this.setUseSubjectDirAttributes(false);
        this.setUseAuthorityInformationAccess(false);
        this.setCaIssuers(new ArrayList<String>());
        this.setUseDefaultOCSPServiceLocator(false);
        this.setOCSPServiceLocatorURI("");
        this.setCVCAccessRights(3);
        this.setUsedCertificateExtensions(new ArrayList<Integer>());
        this.setNumOfReqApprovals(1);
        List<Integer> emptyList = Collections.emptyList();
        this.setApprovalSettings(emptyList);
        this.setUsePrivateKeyUsagePeriodNotBefore(false);
        this.setUsePrivateKeyUsagePeriodNotAfter(false);
        this.setPrivateKeyUsagePeriodStartOffset(0L);
        this.setPrivateKeyUsagePeriodLength(this.getValidity() * 24L * 3600L);
        this.setSingleActiveCertificateConstraint(false);
    }

    private void setDefaultValues(int type) {
        if (type == 3) {
            this.setType(8);
            this.setAllowValidityOverride(true);
            this.setUseKeyUsage(true);
            this.setKeyUsage(new boolean[9]);
            this.setKeyUsage(0, true);
            this.setKeyUsage(5, true);
            this.setKeyUsage(6, true);
            this.setKeyUsageCritical(true);
            this.setValidity(9132L);
        } else if (type == 2) {
            this.setType(2);
            this.setAllowValidityOverride(true);
            this.setUseKeyUsage(true);
            this.setKeyUsage(new boolean[9]);
            this.setKeyUsage(0, true);
            this.setKeyUsage(5, true);
            this.setKeyUsage(6, true);
            this.setKeyUsageCritical(true);
            this.setValidity(9132L);
        } else if (type == 1) {
            this.setType(1);
            this.setUseKeyUsage(true);
            this.setKeyUsage(new boolean[9]);
            this.setKeyUsage(0, true);
            this.setKeyUsage(1, true);
            this.setKeyUsage(2, true);
            this.setKeyUsageCritical(true);
            this.setUseExtendedKeyUsage(true);
            ArrayList<String> eku = new ArrayList<String>();
            eku.add(KeyPurposeId.id_kp_clientAuth.getId());
            eku.add(KeyPurposeId.id_kp_emailProtection.getId());
            this.setExtendedKeyUsage(eku);
            this.setExtendedKeyUsageCritical(false);
        } else if (type == 4) {
            this.setType(1);
            this.setUseKeyUsage(true);
            this.setKeyUsage(new boolean[9]);
            this.setKeyUsage(0, true);
            this.setKeyUsageCritical(true);
            this.setUseExtendedKeyUsage(true);
            ArrayList<String> eku = new ArrayList<String>();
            eku.add(KeyPurposeId.id_kp_OCSPSigning.getId());
            this.setExtendedKeyUsage(eku);
            this.setExtendedKeyUsageCritical(false);
            this.setUseOcspNoCheck(true);
        } else if (type == 9) {
            this.setType(1);
            this.setUseKeyUsage(true);
            this.setKeyUsage(new boolean[9]);
            this.setKeyUsage(0, true);
            this.setKeyUsage(2, true);
            this.setKeyUsageCritical(true);
            this.setUseExtendedKeyUsage(true);
            ArrayList<String> eku = new ArrayList<String>();
            eku.add(KeyPurposeId.id_kp_serverAuth.getId());
            this.setExtendedKeyUsage(eku);
            this.setExtendedKeyUsageCritical(false);
        } else if (type == 5) {
            this.setType(1);
            this.setUseKeyUsage(true);
            this.setKeyUsage(new boolean[9]);
            this.setKeyUsage(0, true);
            this.setKeyUsageCritical(true);
            this.setUseExtendedKeyUsage(true);
            ArrayList<String> eku = new ArrayList<String>();
            eku.add(KeyPurposeId.id_kp_clientAuth.getId());
            eku.add(KeyPurposeId.id_kp_smartcardlogon.getId());
            this.setExtendedKeyUsage(eku);
            this.setExtendedKeyUsageCritical(false);
        } else if (type == 6) {
            this.setType(1);
            this.setUseKeyUsage(true);
            this.setKeyUsage(new boolean[9]);
            this.setKeyUsage(2, true);
            this.setKeyUsage(0, true);
            this.setKeyUsageCritical(true);
            this.setUseExtendedKeyUsage(true);
            ArrayList<String> eku = new ArrayList<String>();
            eku.add(KeyPurposeId.id_kp_clientAuth.getId());
            eku.add(KeyPurposeId.id_kp_emailProtection.getId());
            eku.add(KeyPurposeId.id_kp_smartcardlogon.getId());
            this.setExtendedKeyUsage(eku);
            this.setExtendedKeyUsageCritical(false);
        } else if (type == 7) {
            this.setType(1);
            this.setUseKeyUsage(true);
            this.setKeyUsage(new boolean[9]);
            this.setKeyUsage(2, true);
            this.setKeyUsageCritical(true);
            this.setUseExtendedKeyUsage(true);
            ArrayList<String> eku = new ArrayList<String>();
            eku.add(KeyPurposeId.id_kp_emailProtection.getId());
            this.setExtendedKeyUsage(eku);
            this.setExtendedKeyUsageCritical(false);
        } else if (type == 8) {
            this.setType(1);
            this.setUseKeyUsage(true);
            this.setKeyUsage(new boolean[9]);
            this.setKeyUsage(1, true);
            this.setKeyUsageCritical(true);
            this.setUseExtendedKeyUsage(true);
            ArrayList<String> eku = new ArrayList<String>();
            eku.add(KeyPurposeId.id_kp_emailProtection.getId());
            this.setExtendedKeyUsage(eku);
            this.setExtendedKeyUsageCritical(false);
        }
    }

    public String getCertificateVersion() {
        return (String)this.data.get(CERTVERSION);
    }

    public void setCertificateVersion(String version) {
        this.data.put(CERTVERSION, version);
    }

    public long getValidity() {
        return (Long)this.data.get(VALIDITY);
    }

    public void setValidity(long validity) {
        this.data.put(VALIDITY, validity);
    }

    public boolean getAllowValidityOverride() {
        return (Boolean)this.data.get(ALLOWVALIDITYOVERRIDE);
    }

    public void setAllowValidityOverride(boolean allowvalidityoverride) {
        this.data.put(ALLOWVALIDITYOVERRIDE, allowvalidityoverride);
    }

    public boolean getAllowExtensionOverride() {
        Object d = this.data.get(ALLOWEXTENSIONOVERRIDE);
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    public void setAllowExtensionOverride(boolean allowextensionoverride) {
        this.data.put(ALLOWEXTENSIONOVERRIDE, allowextensionoverride);
    }

    public boolean getAllowDNOverride() {
        Object d = this.data.get(ALLOWDNOVERRIDE);
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    public void setAllowDNOverride(boolean allowdnoverride) {
        this.data.put(ALLOWDNOVERRIDE, allowdnoverride);
    }

    public boolean getAllowDNOverrideByEndEntityInformation() {
        Object d = this.data.get(ALLOWDNOVERRIDEBYEEI);
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    public void setAllowDNOverrideByEndEntityInformation(boolean value) {
        this.data.put(ALLOWDNOVERRIDEBYEEI, value);
    }

    public boolean getAllowCertSerialNumberOverride() {
        Object d = this.data.get(ALLOWCERTSNOVERIDE);
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    public void setAllowCertSerialNumberOverride(boolean allowdnoverride) {
        this.data.put(ALLOWCERTSNOVERIDE, allowdnoverride);
    }

    public boolean getUseBasicConstraints() {
        return (Boolean)this.data.get(USEBASICCONSTRAINTS);
    }

    public void setUseBasicConstraints(boolean usebasicconstraints) {
        this.data.put(USEBASICCONSTRAINTS, usebasicconstraints);
    }

    public boolean getBasicConstraintsCritical() {
        return (Boolean)this.data.get(BASICCONSTRAINTSCRITICAL);
    }

    public void setBasicConstraintsCritical(boolean basicconstraintscritical) {
        this.data.put(BASICCONSTRAINTSCRITICAL, basicconstraintscritical);
    }

    public boolean getUseKeyUsage() {
        return (Boolean)this.data.get(USEKEYUSAGE);
    }

    public void setUseKeyUsage(boolean usekeyusage) {
        this.data.put(USEKEYUSAGE, usekeyusage);
    }

    public boolean getKeyUsageCritical() {
        return (Boolean)this.data.get(KEYUSAGECRITICAL);
    }

    public void setKeyUsageCritical(boolean keyusagecritical) {
        this.data.put(KEYUSAGECRITICAL, keyusagecritical);
    }

    public boolean getUseSubjectKeyIdentifier() {
        return (Boolean)this.data.get(USESUBJECTKEYIDENTIFIER);
    }

    public void setUseSubjectKeyIdentifier(boolean usesubjectkeyidentifier) {
        this.data.put(USESUBJECTKEYIDENTIFIER, usesubjectkeyidentifier);
    }

    public boolean getSubjectKeyIdentifierCritical() {
        return (Boolean)this.data.get(SUBJECTKEYIDENTIFIERCRITICAL);
    }

    public void setSubjectKeyIdentifierCritical(boolean subjectkeyidentifiercritical) {
        this.data.put(SUBJECTKEYIDENTIFIERCRITICAL, subjectkeyidentifiercritical);
    }

    public boolean getUseAuthorityKeyIdentifier() {
        return (Boolean)this.data.get(USEAUTHORITYKEYIDENTIFIER);
    }

    public void setUseAuthorityKeyIdentifier(boolean useauthoritykeyidentifier) {
        this.data.put(USEAUTHORITYKEYIDENTIFIER, useauthoritykeyidentifier);
    }

    public boolean getAuthorityKeyIdentifierCritical() {
        return (Boolean)this.data.get(AUTHORITYKEYIDENTIFIERCRITICAL);
    }

    public void setAuthorityKeyIdentifierCritical(boolean authoritykeyidentifiercritical) {
        this.data.put(AUTHORITYKEYIDENTIFIERCRITICAL, authoritykeyidentifiercritical);
    }

    public boolean getUseSubjectAlternativeName() {
        return (Boolean)this.data.get(USESUBJECTALTERNATIVENAME);
    }

    public void setUseSubjectAlternativeName(boolean usesubjectalternativename) {
        this.data.put(USESUBJECTALTERNATIVENAME, usesubjectalternativename);
    }

    public boolean getStoreCertificateData() {
        Boolean value = (Boolean)this.data.get(STORECERTIFICATEDATA);
        if (value == null) {
            this.setStoreCertificateData(true);
            return true;
        }
        return value;
    }

    public void setStoreCertificateData(boolean storeCertificateData) {
        this.data.put(STORECERTIFICATEDATA, storeCertificateData);
    }

    public boolean getSubjectAlternativeNameCritical() {
        return (Boolean)this.data.get(SUBJECTALTERNATIVENAMECRITICAL);
    }

    public void setSubjectAlternativeNameCritical(boolean subjectalternativenamecritical) {
        this.data.put(SUBJECTALTERNATIVENAMECRITICAL, subjectalternativenamecritical);
    }

    public boolean getUseIssuerAlternativeName() {
        return (Boolean)this.data.get(USEISSUERALTERNATIVENAME);
    }

    public void setUseIssuerAlternativeName(boolean useissueralternativename) {
        this.data.put(USEISSUERALTERNATIVENAME, useissueralternativename);
    }

    public boolean getIssuerAlternativeNameCritical() {
        return (Boolean)this.data.get(ISSUERALTERNATIVENAMECRITICAL);
    }

    public void setIssuerAlternativeNameCritical(boolean issueralternativenamecritical) {
        this.data.put(ISSUERALTERNATIVENAMECRITICAL, issueralternativenamecritical);
    }

    public boolean getUseCRLDistributionPoint() {
        return (Boolean)this.data.get(USECRLDISTRIBUTIONPOINT);
    }

    public void setUseCRLDistributionPoint(boolean usecrldistributionpoint) {
        this.data.put(USECRLDISTRIBUTIONPOINT, usecrldistributionpoint);
    }

    public boolean getUseDefaultCRLDistributionPoint() {
        return (Boolean)this.data.get(USEDEFAULTCRLDISTRIBUTIONPOINT);
    }

    public void setUseDefaultCRLDistributionPoint(boolean usedefaultcrldistributionpoint) {
        this.data.put(USEDEFAULTCRLDISTRIBUTIONPOINT, usedefaultcrldistributionpoint);
    }

    public boolean getCRLDistributionPointCritical() {
        return (Boolean)this.data.get(CRLDISTRIBUTIONPOINTCRITICAL);
    }

    public void setCRLDistributionPointCritical(boolean crldistributionpointcritical) {
        this.data.put(CRLDISTRIBUTIONPOINTCRITICAL, crldistributionpointcritical);
    }

    public String getCRLDistributionPointURI() {
        return (String)this.data.get(CRLDISTRIBUTIONPOINTURI);
    }

    public void setCRLDistributionPointURI(String crldistributionpointuri) {
        if (crldistributionpointuri == null) {
            this.data.put(CRLDISTRIBUTIONPOINTURI, "");
        } else {
            this.data.put(CRLDISTRIBUTIONPOINTURI, crldistributionpointuri);
        }
    }

    public String getCRLIssuer() {
        return (String)this.data.get(CRLISSUER);
    }

    public void setCRLIssuer(String crlissuer) {
        if (crlissuer == null) {
            this.data.put(CRLISSUER, "");
        } else {
            this.data.put(CRLISSUER, crlissuer);
        }
    }

    public boolean getUseFreshestCRL() {
        Object obj = this.data.get(USEFRESHESTCRL);
        if (obj == null) {
            return false;
        }
        return (Boolean)obj;
    }

    public boolean getUseCRLDistributionPointOnCRL() {
        Object obj = this.data.get(USECRLDISTRIBUTIONPOINTONCRL);
        if (obj == null) {
            return false;
        }
        return (Boolean)obj;
    }

    public void setUseCRLDistributionPointOnCRL(boolean usecrldistributionpointoncrl) {
        this.data.put(USECRLDISTRIBUTIONPOINTONCRL, usecrldistributionpointoncrl);
    }

    public void setUseFreshestCRL(boolean usefreshestcrl) {
        this.data.put(USEFRESHESTCRL, usefreshestcrl);
    }

    public boolean getUseCADefinedFreshestCRL() {
        Object obj = this.data.get(USECADEFINEDFRESHESTCRL);
        if (obj == null) {
            return false;
        }
        return (Boolean)obj;
    }

    public void setUseCADefinedFreshestCRL(boolean usecadefinedfreshestcrl) {
        this.data.put(USECADEFINEDFRESHESTCRL, usecadefinedfreshestcrl);
    }

    public String getFreshestCRLURI() {
        return (String)this.data.get(FRESHESTCRLURI);
    }

    public void setFreshestCRLURI(String freshestcrluri) {
        if (freshestcrluri == null) {
            this.data.put(FRESHESTCRLURI, "");
        } else {
            this.data.put(FRESHESTCRLURI, freshestcrluri);
        }
    }

    public boolean getUseCertificatePolicies() {
        return (Boolean)this.data.get(USECERTIFICATEPOLICIES);
    }

    public void setUseCertificatePolicies(boolean usecertificatepolicies) {
        this.data.put(USECERTIFICATEPOLICIES, usecertificatepolicies);
    }

    public boolean getUseCertificateStorage() {
        Boolean value = (Boolean)this.data.get(USECERTIFICATESTORAGE);
        if (value == null) {
            this.setUseCertificateStorage(true);
            return true;
        }
        return value;
    }

    public void setUseCertificateStorage(boolean useCertificateStorage) {
        this.data.put(USECERTIFICATESTORAGE, useCertificateStorage);
    }

    public boolean getCertificatePoliciesCritical() {
        return (Boolean)this.data.get(CERTIFICATEPOLICIESCRITICAL);
    }

    public void setCertificatePoliciesCritical(boolean certificatepoliciescritical) {
        this.data.put(CERTIFICATEPOLICIESCRITICAL, certificatepoliciescritical);
    }

    public List<CertificatePolicy> getCertificatePolicies() {
        ArrayList<CertificatePolicy> l = (ArrayList<CertificatePolicy>)this.data.get(CERTIFICATE_POLICIES);
        if (l == null) {
            l = new ArrayList<CertificatePolicy>();
        } else if (l.size() > 0) {
            try {
                CertificatePolicy test = (CertificatePolicy)l.get(0);
                test.getPolicyID();
            }
            catch (ClassCastException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"CertificatePolicy in profile is old class name (< EJBCA 5), post-upgrade has not been run. Converting in code to return new class type.");
                }
                List oldl = (List)this.data.get(CERTIFICATE_POLICIES);
                l = new ArrayList();
                for (int i = 0; i < oldl.size(); ++i) {
                    CertificatePolicy newPol;
                    try {
                        org.ejbca.core.model.ca.certificateprofiles.CertificatePolicy oldPol = (org.ejbca.core.model.ca.certificateprofiles.CertificatePolicy)oldl.get(i);
                        newPol = new CertificatePolicy(oldPol.getPolicyID(), oldPol.getQualifierId(), oldPol.getQualifier());
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"Adding converted policy");
                        }
                        l.add(newPol);
                        continue;
                    }
                    catch (ClassCastException e2) {
                        newPol = (CertificatePolicy)oldl.get(i);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"Adding non-converted policy");
                        }
                        l.add(newPol);
                    }
                }
            }
        }
        return l;
    }

    public void addCertificatePolicy(CertificatePolicy policy) {
        if (this.data.get(CERTIFICATE_POLICIES) == null) {
            this.setCertificatePolicies(new ArrayList<CertificatePolicy>());
        }
        ((List)this.data.get(CERTIFICATE_POLICIES)).add(policy);
    }

    public void setCertificatePolicies(List<CertificatePolicy> policies) {
        if (policies == null) {
            this.data.put(CERTIFICATE_POLICIES, new ArrayList(0));
        } else {
            this.data.put(CERTIFICATE_POLICIES, policies);
        }
    }

    public void removeCertificatePolicy(CertificatePolicy policy) {
        if (this.data.get(CERTIFICATE_POLICIES) != null) {
            ((List)this.data.get(CERTIFICATE_POLICIES)).remove(policy);
        }
    }

    public int getType() {
        return (Integer)this.data.get(TYPE);
    }

    public void setType(int type) {
        this.data.put(TYPE, type);
    }

    public boolean isTypeSubCA() {
        return (Integer)this.data.get(TYPE) == 2;
    }

    public boolean isTypeRootCA() {
        return (Integer)this.data.get(TYPE) == 8;
    }

    public boolean isTypeEndEntity() {
        return (Integer)this.data.get(TYPE) == 1;
    }

    public int[] getAvailableBitLengths() {
        List availablebitlengths = (List)this.data.get(AVAILABLEBITLENGTHS);
        int[] returnval = new int[availablebitlengths.size()];
        for (int i = 0; i < availablebitlengths.size(); ++i) {
            returnval[i] = (Integer)availablebitlengths.get(i);
        }
        return returnval;
    }

    public List<Integer> getAvailableBitLengthsAsList() {
        return (ArrayList)this.data.get(AVAILABLEBITLENGTHS);
    }

    public void setAvailableBitLengths(List<Integer> availablebitlengths) {
        int minimumavailablebitlength = 99999999;
        int maximumavailablebitlength = 0;
        for (int i = 0; i < availablebitlengths.size(); ++i) {
            if (availablebitlengths.get(i) > maximumavailablebitlength) {
                maximumavailablebitlength = availablebitlengths.get(i);
            }
            if (availablebitlengths.get(i) >= minimumavailablebitlength) continue;
            minimumavailablebitlength = availablebitlengths.get(i);
        }
        this.data.put(AVAILABLEBITLENGTHS, availablebitlengths);
        this.data.put(MINIMUMAVAILABLEBITLENGTH, minimumavailablebitlength);
        this.data.put(MAXIMUMAVAILABLEBITLENGTH, maximumavailablebitlength);
    }

    public void setAvailableBitLengths(int[] availablebitlengths) {
        ArrayList<Integer> availbitlengths = new ArrayList<Integer>(availablebitlengths.length);
        for (int i = 0; i < availablebitlengths.length; ++i) {
            availbitlengths.add(availablebitlengths[i]);
        }
        this.setAvailableBitLengths(availbitlengths);
    }

    public int getMinimumAvailableBitLength() {
        return (Integer)this.data.get(MINIMUMAVAILABLEBITLENGTH);
    }

    public int getMaximumAvailableBitLength() {
        return (Integer)this.data.get(MAXIMUMAVAILABLEBITLENGTH);
    }

    public String getSignatureAlgorithm() {
        return (String)this.data.get(SIGNATUREALGORITHM);
    }

    public void setSignatureAlgorithm(String signAlg) {
        this.data.put(SIGNATUREALGORITHM, signAlg);
    }

    public boolean[] getKeyUsage() {
        ArrayList keyusage = (ArrayList)this.data.get(KEYUSAGE);
        boolean[] returnval = new boolean[keyusage.size()];
        for (int i = 0; i < keyusage.size(); ++i) {
            returnval[i] = (Boolean)keyusage.get(i);
        }
        return returnval;
    }

    public boolean getKeyUsage(int keyusageconstant) {
        return (Boolean)((ArrayList)this.data.get(KEYUSAGE)).get(keyusageconstant);
    }

    public void setKeyUsage(boolean[] keyusage) {
        ArrayList<Boolean> keyuse = new ArrayList<Boolean>(keyusage.length);
        for (int i = 0; i < keyusage.length; ++i) {
            keyuse.add(keyusage[i]);
        }
        this.data.put(KEYUSAGE, keyuse);
    }

    public void setKeyUsage(int keyusageconstant, boolean value) {
        ((ArrayList)this.data.get(KEYUSAGE)).set(keyusageconstant, value);
    }

    public void setAllowKeyUsageOverride(boolean override) {
        this.data.put(ALLOWKEYUSAGEOVERRIDE, override);
    }

    public boolean getAllowKeyUsageOverride() {
        return (Boolean)this.data.get(ALLOWKEYUSAGEOVERRIDE);
    }

    public void setAllowBackdatedRevocation(boolean override) {
        this.data.put(ALLOWBACKDATEDREVOCATION, override);
    }

    public boolean getAllowBackdatedRevocation() {
        Object value = this.data.get(ALLOWBACKDATEDREVOCATION);
        return value != null && value instanceof Boolean && (Boolean)value != false;
    }

    public void setUseDocumentTypeList(boolean use) {
        this.data.put(USEDOCUMENTTYPELIST, use);
    }

    public boolean getUseDocumentTypeList() {
        return (Boolean)this.data.get(USEDOCUMENTTYPELIST);
    }

    public void setDocumentTypeListCritical(boolean critical) {
        this.data.put(DOCUMENTTYPELISTCRITICAL, critical);
    }

    public boolean getDocumentTypeListCritical() {
        return (Boolean)this.data.get(DOCUMENTTYPELISTCRITICAL);
    }

    public void setDocumentTypeList(ArrayList<String> docTypes) {
        this.data.put(DOCUMENTTYPELIST, docTypes);
    }

    public ArrayList<String> getDocumentTypeList() {
        return (ArrayList)this.data.get(DOCUMENTTYPELIST);
    }

    public void setUseExtendedKeyUsage(boolean use) {
        this.data.put(USEEXTENDEDKEYUSAGE, use);
    }

    public boolean getUseExtendedKeyUsage() {
        return (Boolean)this.data.get(USEEXTENDEDKEYUSAGE);
    }

    public void setExtendedKeyUsageCritical(boolean critical) {
        this.data.put(EXTENDEDKEYUSAGECRITICAL, critical);
    }

    public boolean getExtendedKeyUsageCritical() {
        return (Boolean)this.data.get(EXTENDEDKEYUSAGECRITICAL);
    }

    public void setExtendedKeyUsage(ArrayList<String> extendedkeyusage) {
        this.data.put(EXTENDEDKEYUSAGE, extendedkeyusage);
    }

    public ArrayList<String> getExtendedKeyUsageOids() {
        return (ArrayList)this.data.get(EXTENDEDKEYUSAGE);
    }

    public void setExtendedKeyUsageOids(ArrayList<String> extendedKeyUsageOids) {
        this.setExtendedKeyUsage(extendedKeyUsageOids);
    }

    public boolean getUseLdapDnOrder() {
        boolean ret = true;
        Object o = this.data.get(USELDAPDNORDER);
        if (o != null) {
            ret = (Boolean)o;
        }
        return ret;
    }

    public void setUseLdapDnOrder(boolean use) {
        this.data.put(USELDAPDNORDER, use);
    }

    public boolean getUseMicrosoftTemplate() {
        return (Boolean)this.data.get(USEMICROSOFTTEMPLATE);
    }

    public void setUseMicrosoftTemplate(boolean use) {
        this.data.put(USEMICROSOFTTEMPLATE, use);
    }

    public String getMicrosoftTemplate() {
        return (String)this.data.get(MICROSOFTTEMPLATE);
    }

    public void setMicrosoftTemplate(String mstemplate) {
        this.data.put(MICROSOFTTEMPLATE, mstemplate);
    }

    public boolean getUseCardNumber() {
        return (Boolean)this.data.get(USECARDNUMBER);
    }

    public void setUseCardNumber(boolean use) {
        this.data.put(USECARDNUMBER, use);
    }

    public boolean getUseCNPostfix() {
        return (Boolean)this.data.get(USECNPOSTFIX);
    }

    public void setUseCNPostfix(boolean use) {
        this.data.put(USECNPOSTFIX, use);
    }

    public String getCNPostfix() {
        return (String)this.data.get(CNPOSTFIX);
    }

    public void setCNPostfix(String cnpostfix) {
        this.data.put(CNPOSTFIX, cnpostfix);
    }

    public boolean getUseSubjectDNSubSet() {
        return (Boolean)this.data.get(USESUBJECTDNSUBSET);
    }

    public void setUseSubjectDNSubSet(boolean use) {
        this.data.put(USESUBJECTDNSUBSET, use);
    }

    public List<Integer> getSubjectDNSubSet() {
        return (List)this.data.get(SUBJECTDNSUBSET);
    }

    public void setSubjectDNSubSet(List<String> subjectdns) {
        ArrayList<Integer> convertedList = new ArrayList<Integer>();
        for (String value : subjectdns) {
            convertedList.add(Integer.valueOf(value));
        }
        this.data.put(SUBJECTDNSUBSET, convertedList);
    }

    public String createSubjectDNSubSet(String dn) {
        DNFieldExtractor extractor = new DNFieldExtractor(dn, 0);
        return CertificateProfile.constructUserData(extractor, this.getSubjectDNSubSet(), true);
    }

    public boolean getUseSubjectAltNameSubSet() {
        return (Boolean)this.data.get(USESUBJECTALTNAMESUBSET);
    }

    public void setUseSubjectAltNameSubSet(boolean use) {
        this.data.put(USESUBJECTALTNAMESUBSET, use);
    }

    public List<Integer> getSubjectAltNameSubSet() {
        return (List)this.data.get(SUBJECTALTNAMESUBSET);
    }

    public void setSubjectAltNameSubSet(List<Integer> subjectaltnames) {
        this.data.put(SUBJECTALTNAMESUBSET, subjectaltnames);
    }

    public String createSubjectAltNameSubSet(String subjectaltname) {
        DNFieldExtractor extractor = new DNFieldExtractor(subjectaltname, 1);
        return CertificateProfile.constructUserData(extractor, this.getSubjectAltNameSubSet(), false);
    }

    protected static String constructUserData(DNFieldExtractor extractor, Collection<Integer> usefields, boolean subjectdn) {
        String retval = "";
        if (usefields instanceof List) {
            Collections.sort((List)usefields);
        }
        String dnField = null;
        for (Integer next : usefields) {
            dnField = extractor.getFieldString(next);
            if (!StringUtils.isNotEmpty((String)dnField)) continue;
            if (retval.length() == 0) {
                retval = retval + dnField;
                continue;
            }
            retval = retval + "," + dnField;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CertificateProfile: constructed DN or AltName: " + retval));
        }
        return retval;
    }

    public List<Integer> getAvailableCAs() {
        return (List)this.data.get(AVAILABLECAS);
    }

    public void setAvailableCAs(List<Integer> availablecas) {
        this.data.put(AVAILABLECAS, availablecas);
    }

    public boolean isApplicableToAnyCA() {
        return ((List)this.data.get(AVAILABLECAS)).contains(-1);
    }

    public List<Integer> getPublisherList() {
        Object o = this.data.get(USEDPUBLISHERS);
        if (o == null) {
            o = new ArrayList();
        }
        return (List)o;
    }

    public void setPublisherList(List<Integer> publisher) {
        this.data.put(USEDPUBLISHERS, publisher);
    }

    public boolean getUsePathLengthConstraint() {
        return (Boolean)this.data.get(USEPATHLENGTHCONSTRAINT);
    }

    public void setUsePathLengthConstraint(boolean use) {
        this.data.put(USEPATHLENGTHCONSTRAINT, use);
    }

    public int getPathLengthConstraint() {
        return (Integer)this.data.get(PATHLENGTHCONSTRAINT);
    }

    public void setPathLengthConstraint(int pathlength) {
        this.data.put(PATHLENGTHCONSTRAINT, pathlength);
    }

    public void setCaIssuers(List<String> caIssuers) {
        this.data.put(CAISSUERS, caIssuers);
    }

    public void addCaIssuer(String caIssuer) {
        if ((caIssuer = caIssuer.trim()).length() < 1) {
            return;
        }
        if (this.data.get(CAISSUERS) == null) {
            ArrayList<String> caIssuers = new ArrayList<String>();
            caIssuers.add(caIssuer);
            this.setCaIssuers(caIssuers);
        } else {
            ((List)this.data.get(CAISSUERS)).add(caIssuer);
        }
    }

    public List<String> getCaIssuers() {
        if (this.data.get(CAISSUERS) == null) {
            return new ArrayList<String>();
        }
        return (List)this.data.get(CAISSUERS);
    }

    public void removeCaIssuer(String caIssuer) {
        if (this.data.get(CAISSUERS) != null) {
            ((List)this.data.get(CAISSUERS)).remove(caIssuer);
        }
    }

    public boolean getUseOcspNoCheck() {
        if (this.data.get(USEOCSPNOCHECK) == null) {
            return false;
        }
        return (Boolean)this.data.get(USEOCSPNOCHECK);
    }

    public void setUseOcspNoCheck(boolean useocspnocheck) {
        this.data.put(USEOCSPNOCHECK, useocspnocheck);
    }

    public boolean getUseAuthorityInformationAccess() {
        return (Boolean)this.data.get(USEAUTHORITYINFORMATIONACCESS);
    }

    public void setUseAuthorityInformationAccess(boolean useauthorityinformationaccess) {
        this.data.put(USEAUTHORITYINFORMATIONACCESS, useauthorityinformationaccess);
    }

    public boolean getUseDefaultOCSPServiceLocator() {
        return (Boolean)this.data.get(USEDEFAULTOCSPSERVICELOCATOR);
    }

    public void setUseDefaultOCSPServiceLocator(boolean usedefaultocspservicelocator) {
        this.data.put(USEDEFAULTOCSPSERVICELOCATOR, usedefaultocspservicelocator);
    }

    public String getOCSPServiceLocatorURI() {
        return (String)this.data.get(OCSPSERVICELOCATORURI);
    }

    public void setOCSPServiceLocatorURI(String ocspservicelocatoruri) {
        if (ocspservicelocatoruri == null) {
            this.data.put(OCSPSERVICELOCATORURI, "");
        } else {
            this.data.put(OCSPSERVICELOCATORURI, ocspservicelocatoruri);
        }
    }

    public boolean getUseQCStatement() {
        return (Boolean)this.data.get(USEQCSTATEMENT);
    }

    public void setUseQCStatement(boolean useqcstatement) {
        this.data.put(USEQCSTATEMENT, useqcstatement);
    }

    public boolean getUsePkixQCSyntaxV2() {
        return (Boolean)this.data.get(USEPKIXQCSYNTAXV2);
    }

    public void setUsePkixQCSyntaxV2(boolean pkixqcsyntaxv2) {
        this.data.put(USEPKIXQCSYNTAXV2, pkixqcsyntaxv2);
    }

    public boolean getQCStatementCritical() {
        return (Boolean)this.data.get(QCSTATEMENTCRITICAL);
    }

    public void setQCStatementCritical(boolean qcstatementcritical) {
        this.data.put(QCSTATEMENTCRITICAL, qcstatementcritical);
    }

    public String getQCStatementRAName() {
        return (String)this.data.get(QCSTATEMENTRANAME);
    }

    public void setQCStatementRAName(String qcstatementraname) {
        if (qcstatementraname == null) {
            this.data.put(QCSTATEMENTRANAME, "");
        } else {
            this.data.put(QCSTATEMENTRANAME, qcstatementraname);
        }
    }

    public String getQCSemanticsId() {
        return (String)this.data.get(QCSSEMANTICSID);
    }

    public void setQCSemanticsId(String qcsemanticsid) {
        if (qcsemanticsid == null) {
            this.data.put(QCSSEMANTICSID, "");
        } else {
            this.data.put(QCSSEMANTICSID, qcsemanticsid);
        }
    }

    public boolean getUseQCEtsiQCCompliance() {
        return (Boolean)this.data.get(USEQCETSIQCCOMPLIANCE);
    }

    public void setUseQCEtsiQCCompliance(boolean useqcetsiqccompliance) {
        this.data.put(USEQCETSIQCCOMPLIANCE, useqcetsiqccompliance);
    }

    public boolean getUseQCEtsiValueLimit() {
        return (Boolean)this.data.get(USEQCETSIVALUELIMIT);
    }

    public void setUseQCEtsiValueLimit(boolean useqcetsivaluelimit) {
        this.data.put(USEQCETSIVALUELIMIT, useqcetsivaluelimit);
    }

    public int getQCEtsiValueLimit() {
        return (Integer)this.data.get(QCETSIVALUELIMIT);
    }

    public void setQCEtsiValueLimit(int qcetsivaluelimit) {
        this.data.put(QCETSIVALUELIMIT, qcetsivaluelimit);
    }

    public int getQCEtsiValueLimitExp() {
        return (Integer)this.data.get(QCETSIVALUELIMITEXP);
    }

    public void setQCEtsiValueLimitExp(int qcetsivaluelimitexp) {
        this.data.put(QCETSIVALUELIMITEXP, qcetsivaluelimitexp);
    }

    public String getQCEtsiValueLimitCurrency() {
        return (String)this.data.get(QCETSIVALUELIMITCURRENCY);
    }

    public void setQCEtsiValueLimitCurrency(String qcetsicaluelimitcurrency) {
        if (qcetsicaluelimitcurrency == null) {
            this.data.put(QCETSIVALUELIMITCURRENCY, "");
        } else {
            this.data.put(QCETSIVALUELIMITCURRENCY, qcetsicaluelimitcurrency);
        }
    }

    public boolean getUseQCEtsiRetentionPeriod() {
        return (Boolean)this.data.get(USEQCETSIRETENTIONPERIOD);
    }

    public void setUseQCEtsiRetentionPeriod(boolean useqcetsiretentionperiod) {
        this.data.put(USEQCETSIRETENTIONPERIOD, useqcetsiretentionperiod);
    }

    public int getQCEtsiRetentionPeriod() {
        return (Integer)this.data.get(QCETSIRETENTIONPERIOD);
    }

    public void setQCEtsiRetentionPeriod(int qcetsiretentionperiod) {
        this.data.put(QCETSIRETENTIONPERIOD, qcetsiretentionperiod);
    }

    public boolean getUseQCEtsiSignatureDevice() {
        return (Boolean)this.data.get(USEQCETSISIGNATUREDEVICE);
    }

    public void setUseQCEtsiSignatureDevice(boolean useqcetsisignaturedevice) {
        this.data.put(USEQCETSISIGNATUREDEVICE, useqcetsisignaturedevice);
    }

    public boolean getUseQCCustomString() {
        return (Boolean)this.data.get(USEQCCUSTOMSTRING);
    }

    public void setUseQCCustomString(boolean useqccustomstring) {
        this.data.put(USEQCCUSTOMSTRING, useqccustomstring);
    }

    public String getQCCustomStringOid() {
        return (String)this.data.get(QCCUSTOMSTRINGOID);
    }

    public void setQCCustomStringOid(String qccustomstringoid) {
        if (qccustomstringoid == null) {
            this.data.put(QCCUSTOMSTRINGOID, "");
        } else {
            this.data.put(QCCUSTOMSTRINGOID, qccustomstringoid);
        }
    }

    public String getQCCustomStringText() {
        return (String)this.data.get(QCCUSTOMSTRINGTEXT);
    }

    public void setQCCustomStringText(String qccustomstringtext) {
        if (qccustomstringtext == null) {
            this.data.put(QCCUSTOMSTRINGTEXT, "");
        } else {
            this.data.put(QCCUSTOMSTRINGTEXT, qccustomstringtext);
        }
    }

    public boolean getUseNameConstraints() {
        Boolean b = (Boolean)this.data.get(USENAMECONSTRAINTS);
        return b != null && b != false;
    }

    public void setUseNameConstraints(boolean use) {
        this.data.put(USENAMECONSTRAINTS, use);
    }

    public boolean getNameConstraintsCritical() {
        Boolean b = (Boolean)this.data.get(NAMECONSTRAINTSCRITICAL);
        return b != null && b != false;
    }

    public void setNameConstraintsCritical(boolean use) {
        this.data.put(NAMECONSTRAINTSCRITICAL, use);
    }

    public boolean getUseSubjectDirAttributes() {
        return (Boolean)this.data.get(USESUBJECTDIRATTRIBUTES);
    }

    public void setUseSubjectDirAttributes(boolean use) {
        this.data.put(USESUBJECTDIRATTRIBUTES, use);
    }

    public void setSingleActiveCertificateConstraint(boolean enabled) {
        this.data.put(USERSINGLEACTIVECERTIFICATECONSTRAINT, enabled);
    }

    public boolean isSingleActiveCertificateConstraint() {
        Object constraintObject = this.data.get(USERSINGLEACTIVECERTIFICATECONSTRAINT);
        if (constraintObject == null) {
            this.setSingleActiveCertificateConstraint(false);
            return false;
        }
        return (Boolean)this.data.get(USERSINGLEACTIVECERTIFICATECONSTRAINT);
    }

    public int getCVCTerminalType() {
        if (this.data.get(CVCTERMINALTYPE) == null) {
            return 0;
        }
        return (Integer)this.data.get(CVCTERMINALTYPE);
    }

    public void setCVCTerminalType(int termtype) {
        this.data.put(CVCTERMINALTYPE, termtype);
    }

    public int getCVCAccessRights() {
        if (this.data.get(CVCACCESSRIGHTS) == null) {
            return 0;
        }
        return (Integer)this.data.get(CVCACCESSRIGHTS);
    }

    public void setCVCAccessRights(int access) {
        this.data.put(CVCACCESSRIGHTS, access);
    }

    public byte[] getCVCLongAccessRights() {
        if (this.data.get(CVCLONGACCESSRIGHTS) == null) {
            return null;
        }
        List rightsList = (List)this.data.get(CVCLONGACCESSRIGHTS);
        return ArrayUtils.toPrimitive((Byte[])rightsList.toArray(new Byte[0]));
    }

    public void setCVCLongAccessRights(byte[] access) {
        if (access == null) {
            this.data.put(CVCLONGACCESSRIGHTS, null);
        } else {
            this.data.put(CVCLONGACCESSRIGHTS, new ArrayList<Byte>(Arrays.asList(ArrayUtils.toObject((byte[])access))));
        }
    }

    public int getCVCSignTermDVType() {
        if (this.data.get(CVCSIGNTERMDVTYPE) == null) {
            return 1;
        }
        return (Integer)this.data.get(CVCSIGNTERMDVTYPE);
    }

    public void setCVCSignTermDVType(int type) {
        this.data.put(CVCSIGNTERMDVTYPE, type);
    }

    public List<Integer> getUsedCertificateExtensions() {
        if (this.data.get(USEDCERTIFICATEEXTENSIONS) == null) {
            return new ArrayList<Integer>();
        }
        return (List)this.data.get(USEDCERTIFICATEEXTENSIONS);
    }

    public void setUsedCertificateExtensions(List<Integer> usedCertificateExtensions) {
        if (usedCertificateExtensions == null) {
            this.data.put(USEDCERTIFICATEEXTENSIONS, new ArrayList());
        } else {
            this.data.put(USEDCERTIFICATEEXTENSIONS, usedCertificateExtensions);
        }
    }

    public List<String> getUsedStandardCertificateExtensions() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : useStandardCertificateExtensions.keySet()) {
            if (this.data.get(s) != null && ((Boolean)this.data.get(s)).booleanValue()) {
                ret.add(useStandardCertificateExtensions.get(s));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Using standard certificate extension: " + s));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Not using standard certificate extensions: " + s));
        }
        return ret;
    }

    public List<Integer> getApprovalSettings() {
        return (List)this.data.get(APPROVALSETTINGS);
    }

    public void setApprovalSettings(List<Integer> approvalSettings) {
        this.data.put(APPROVALSETTINGS, approvalSettings);
    }

    public int getNumOfReqApprovals() {
        return (Integer)this.data.get(NUMOFREQAPPROVALS);
    }

    public void setNumOfReqApprovals(int numOfReqApprovals) {
        this.data.put(NUMOFREQAPPROVALS, numOfReqApprovals);
    }

    public boolean isApprovalRequired(int action) {
        Collection approvalSettings = (Collection)this.data.get(APPROVALSETTINGS);
        return approvalSettings.contains(action);
    }

    public boolean isUsePrivateKeyUsagePeriodNotBefore() {
        if (this.data.get(USEPRIVKEYUSAGEPERIODNOTAFTER) == null) {
            return false;
        }
        return (Boolean)this.data.get(USEPRIVKEYUSAGEPERIODNOTBEFORE);
    }

    public void setUsePrivateKeyUsagePeriodNotBefore(boolean use) {
        this.data.put(USEPRIVKEYUSAGEPERIODNOTBEFORE, use);
        this.data.put(USEPRIVKEYUSAGEPERIOD, use || this.isUsePrivateKeyUsagePeriodNotAfter());
    }

    public boolean isUsePrivateKeyUsagePeriodNotAfter() {
        if (this.data.get(USEPRIVKEYUSAGEPERIODNOTAFTER) == null) {
            return false;
        }
        return (Boolean)this.data.get(USEPRIVKEYUSAGEPERIODNOTAFTER);
    }

    public void setUsePrivateKeyUsagePeriodNotAfter(boolean use) {
        this.data.put(USEPRIVKEYUSAGEPERIODNOTAFTER, use);
        this.data.put(USEPRIVKEYUSAGEPERIOD, use || this.isUsePrivateKeyUsagePeriodNotBefore());
    }

    public long getPrivateKeyUsagePeriodStartOffset() {
        return (Long)this.data.get(PRIVKEYUSAGEPERIODSTARTOFFSET);
    }

    public void setPrivateKeyUsagePeriodStartOffset(long start) {
        this.data.put(PRIVKEYUSAGEPERIODSTARTOFFSET, start);
    }

    public long getPrivateKeyUsagePeriodLength() {
        return (Long)this.data.get(PRIVKEYUSAGEPERIODLENGTH);
    }

    public void setPrivateKeyUsagePeriodLength(long validity) {
        this.data.put(PRIVKEYUSAGEPERIODLENGTH, validity);
    }

    public boolean isUseCertificateTransparencyInCerts() {
        if (this.data.get(USECERTIFICATETRANSPARENCYINCERTS) == null) {
            return false;
        }
        return (Boolean)this.data.get(USECERTIFICATETRANSPARENCYINCERTS);
    }

    public void setUseCertificateTransparencyInCerts(boolean use) {
        this.data.put(USECERTIFICATETRANSPARENCYINCERTS, use);
    }

    public boolean isUseCertificateTransparencyInOCSP() {
        if (this.data.get(USECERTIFICATETRANSPARENCYINOCSP) == null) {
            return false;
        }
        return (Boolean)this.data.get(USECERTIFICATETRANSPARENCYINOCSP);
    }

    public void setUseCertificateTransparencyInOCSP(boolean use) {
        this.data.put(USECERTIFICATETRANSPARENCYINOCSP, use);
    }

    public boolean isUseCertificateTransparencyInPublishers() {
        if (this.data.get(USECERTIFICATETRANSPARENCYINPUBLISHERS) == null) {
            return this.isUseCertificateTransparencyInOCSP();
        }
        return (Boolean)this.data.get(USECERTIFICATETRANSPARENCYINPUBLISHERS);
    }

    public void setUseCertificateTransparencyInPublishers(boolean use) {
        this.data.put(USECERTIFICATETRANSPARENCYINPUBLISHERS, use);
    }

    public boolean isUseCTSubmitExisting() {
        if (this.data.get(CTSUBMITEXISTING) == null) {
            return true;
        }
        return (Boolean)this.data.get(CTSUBMITEXISTING);
    }

    public void setUseCTSubmitExisting(boolean use) {
        this.data.put(CTSUBMITEXISTING, use);
    }

    public Set<Integer> getEnabledCTLogs() {
        if (this.data.get(CTLOGS) == null) {
            return new LinkedHashSet<Integer>();
        }
        return (Set)this.data.get(CTLOGS);
    }

    public void setEnabledCTLogs(Set<Integer> logIds) {
        this.data.put(CTLOGS, new LinkedHashSet<Integer>(logIds));
    }

    public int getCTMinSCTs() {
        if (this.data.get(CTMINSCTS) == null) {
            return 1;
        }
        return (Integer)this.data.get(CTMINSCTS);
    }

    public void setCTMinSCTs(int minSCTs) {
        this.data.put(CTMINSCTS, minSCTs);
    }

    public int getCTMinSCTsOCSP() {
        if (this.data.get(CTMINSCTSOCSP) == null) {
            return this.getCTMinSCTs();
        }
        return (Integer)this.data.get(CTMINSCTSOCSP);
    }

    public void setCTMinSCTsOCSP(int minSCTsOCSP) {
        this.data.put(CTMINSCTSOCSP, minSCTsOCSP);
    }

    public int getCTMaxSCTs() {
        if (this.data.get(CTMAXSCTS) == null) {
            return 1;
        }
        return (Integer)this.data.get(CTMAXSCTS);
    }

    public void setCTMaxSCTs(int maxSCTs) {
        this.data.put(CTMAXSCTS, maxSCTs);
    }

    public int getCTMaxSCTsOCSP() {
        if (this.data.get(CTMAXSCTSOCSP) == null) {
            return this.getCTMaxSCTs();
        }
        return (Integer)this.data.get(CTMAXSCTSOCSP);
    }

    public void setCTMaxSCTsOCSP(int maxSCTsOCSP) {
        this.data.put(CTMAXSCTSOCSP, maxSCTsOCSP);
    }

    public int getCTMaxRetries() {
        if (this.data.get(CTMAXRETRIES) == null) {
            return 0;
        }
        return (Integer)this.data.get(CTMAXRETRIES);
    }

    public void setCTMaxRetries(int numRetries) {
        this.data.put(CTMAXRETRIES, numRetries);
    }

    public CertificateProfile clone() throws CloneNotSupportedException {
        CertificateProfile clone = new CertificateProfile(0);
        clone.data = new LinkedHashMap(this.data.size());
        for (Map.Entry entry : this.data.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof ArrayList) {
                value = ((ArrayList)value).clone();
            }
            clone.data.put(entry.getKey(), value);
        }
        return clone;
    }

    @Override
    public float getLatestVersion() {
        return 38.0f;
    }

    protected void setVersion(float version) {
        this.data.put("version", Float.valueOf(version));
    }

    @Override
    public void upgrade() {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">upgrade: " + this.getLatestVersion() + ", " + this.getVersion()));
        }
        if (Float.compare(this.getLatestVersion(), this.getVersion()) != 0) {
            String msg = intres.getLocalizedMessage("certprofile.upgrade", new Float(this.getVersion()));
            log.info((Object)msg);
            if (this.data.get(ALLOWKEYUSAGEOVERRIDE) == null) {
                this.data.put(ALLOWKEYUSAGEOVERRIDE, Boolean.TRUE);
            }
            if (this.data.get(USEEXTENDEDKEYUSAGE) == null) {
                this.data.put(USEEXTENDEDKEYUSAGE, Boolean.FALSE);
            }
            if (this.data.get(EXTENDEDKEYUSAGE) == null) {
                this.data.put(EXTENDEDKEYUSAGE, new ArrayList());
            }
            if (this.data.get(EXTENDEDKEYUSAGECRITICAL) == null) {
                this.data.put(EXTENDEDKEYUSAGECRITICAL, Boolean.FALSE);
            }
            if (this.data.get(AVAILABLECAS) == null) {
                ArrayList<Integer> availablecas = new ArrayList<Integer>();
                availablecas.add(-1);
                this.data.put(AVAILABLECAS, availablecas);
            }
            if (this.data.get(USEDPUBLISHERS) == null) {
                this.data.put(USEDPUBLISHERS, new ArrayList());
            }
            if (this.data.get(USEOCSPSERVICELOCATOR) == null && this.data.get(USEAUTHORITYINFORMATIONACCESS) == null) {
                this.data.put(USEOCSPSERVICELOCATOR, Boolean.FALSE);
                this.setOCSPServiceLocatorURI("");
            }
            if (this.data.get(USEMICROSOFTTEMPLATE) == null) {
                this.setUseMicrosoftTemplate(false);
                this.setMicrosoftTemplate("");
            }
            if (this.data.get(USECNPOSTFIX) == null) {
                this.setUseCNPostfix(false);
                this.setCNPostfix("");
            }
            if (this.data.get(USESUBJECTDNSUBSET) == null) {
                this.setUseSubjectDNSubSet(false);
                this.setSubjectDNSubSet(new ArrayList<String>());
                this.setUseSubjectAltNameSubSet(false);
                this.setSubjectAltNameSubSet(new ArrayList<Integer>());
            }
            if (this.data.get(USEPATHLENGTHCONSTRAINT) == null) {
                this.setUsePathLengthConstraint(false);
                this.setPathLengthConstraint(0);
            }
            if (this.data.get(USEQCSTATEMENT) == null) {
                this.setUseQCStatement(false);
                this.setUsePkixQCSyntaxV2(false);
                this.setQCStatementCritical(false);
                this.setQCStatementRAName(null);
                this.setQCSemanticsId(null);
                this.setUseQCEtsiQCCompliance(false);
                this.setUseQCEtsiSignatureDevice(false);
                this.setUseQCEtsiValueLimit(false);
                this.setUseQCEtsiRetentionPeriod(false);
                this.setQCEtsiRetentionPeriod(0);
                this.setQCEtsiValueLimit(0);
                this.setQCEtsiValueLimitExp(0);
                this.setQCEtsiValueLimitCurrency(null);
            }
            if (this.data.get(USEDEFAULTCRLDISTRIBUTIONPOINT) == null) {
                this.setUseDefaultCRLDistributionPoint(false);
                this.setUseDefaultOCSPServiceLocator(false);
            }
            if (this.data.get(USEQCCUSTOMSTRING) == null) {
                this.setUseQCCustomString(false);
                this.setQCCustomStringOid(null);
                this.setQCCustomStringText(null);
            }
            if (this.data.get(USESUBJECTDIRATTRIBUTES) == null) {
                this.setUseSubjectDirAttributes(false);
            }
            if (this.data.get(ALLOWVALIDITYOVERRIDE) == null) {
                this.setAllowValidityOverride(false);
            }
            if (this.data.get(CRLISSUER) == null) {
                this.setCRLIssuer(null);
            }
            if (this.data.get(USEOCSPNOCHECK) == null) {
                this.setUseOcspNoCheck(false);
            }
            if (this.data.get(USEFRESHESTCRL) == null) {
                this.setUseFreshestCRL(false);
                this.setUseCADefinedFreshestCRL(false);
                this.setFreshestCRLURI(null);
            }
            if (this.data.get(CERTIFICATE_POLICIES) == null && this.data.get(CERTIFICATEPOLICYID) != null) {
                CertificatePolicy newpolicy;
                String id;
                StringTokenizer tokenizer;
                String ids = (String)this.data.get(CERTIFICATEPOLICYID);
                String unotice = null;
                String cpsuri = null;
                if (this.data.get(POLICY_NOTICE_UNOTICE_TEXT) != null) {
                    unotice = (String)this.data.get(POLICY_NOTICE_UNOTICE_TEXT);
                }
                if (this.data.get(POLICY_NOTICE_CPS_URL) != null) {
                    cpsuri = (String)this.data.get(POLICY_NOTICE_CPS_URL);
                }
                if ((tokenizer = new StringTokenizer(ids, ";", false)).hasMoreTokens()) {
                    id = tokenizer.nextToken();
                    newpolicy = null;
                    if (StringUtils.isNotEmpty((String)unotice)) {
                        newpolicy = new CertificatePolicy(id, CertificatePolicy.id_qt_unotice, unotice);
                        this.addCertificatePolicy(newpolicy);
                    }
                    if (StringUtils.isNotEmpty((String)cpsuri)) {
                        newpolicy = new CertificatePolicy(id, CertificatePolicy.id_qt_cps, cpsuri);
                        this.addCertificatePolicy(newpolicy);
                    }
                    if (newpolicy == null) {
                        newpolicy = new CertificatePolicy(id, null, null);
                        this.addCertificatePolicy(newpolicy);
                    }
                }
                while (tokenizer.hasMoreTokens()) {
                    id = tokenizer.nextToken();
                    newpolicy = new CertificatePolicy(id, null, null);
                    this.addCertificatePolicy(newpolicy);
                }
            }
            if (this.data.get(USECRLDISTRIBUTIONPOINTONCRL) == null) {
                this.setUseCRLDistributionPointOnCRL(false);
            }
            if (this.data.get(USECAISSUERS) == null && this.data.get(USEAUTHORITYINFORMATIONACCESS) == null) {
                this.data.put(USECAISSUERS, Boolean.FALSE);
                this.setCaIssuers(new ArrayList<String>());
            }
            if ((this.data.get(USEOCSPSERVICELOCATOR) != null || this.data.get(USECAISSUERS) != null) && this.data.get(USEAUTHORITYINFORMATIONACCESS) == null) {
                boolean ocsp = false;
                if (this.data.get(USEOCSPSERVICELOCATOR) != null) {
                    ocsp = (Boolean)this.data.get(USEOCSPSERVICELOCATOR);
                }
                boolean caissuers = false;
                if (this.data.get(USECAISSUERS) != null) {
                    caissuers = (Boolean)this.data.get(USECAISSUERS);
                }
                if (ocsp || caissuers) {
                    this.setUseAuthorityInformationAccess(true);
                } else {
                    this.setUseAuthorityInformationAccess(false);
                }
            } else if (this.data.get(USEAUTHORITYINFORMATIONACCESS) == null) {
                this.setUseAuthorityInformationAccess(false);
            }
            if (this.data.get(ALLOWEXTENSIONOVERRIDE) == null) {
                this.setAllowExtensionOverride(false);
            }
            if (this.data.get(USEQCETSIRETENTIONPERIOD) == null) {
                this.setUseQCEtsiRetentionPeriod(false);
                this.setQCEtsiRetentionPeriod(0);
            }
            if (this.data.get(CVCACCESSRIGHTS) == null) {
                this.setCVCAccessRights(0);
            }
            if (this.data.get(USELDAPDNORDER) == null) {
                this.setUseLdapDnOrder(true);
            }
            if (this.data.get(USECARDNUMBER) == null) {
                this.setUseCardNumber(false);
            }
            if (this.data.get(ALLOWDNOVERRIDE) == null) {
                this.setAllowDNOverride(false);
            }
            if (this.data.get(NUMOFREQAPPROVALS) == null) {
                this.setNumOfReqApprovals(1);
            }
            if (this.data.get(APPROVALSETTINGS) == null) {
                this.setApprovalSettings(new ArrayList<Integer>());
            }
            if (this.data.get(SIGNATUREALGORITHM) == null) {
                this.setSignatureAlgorithm(null);
            }
            if (this.data.get(USEPRIVKEYUSAGEPERIODNOTBEFORE) == null) {
                this.setUsePrivateKeyUsagePeriodNotBefore(false);
            }
            if (this.data.get(USEPRIVKEYUSAGEPERIODNOTAFTER) == null) {
                this.setUsePrivateKeyUsagePeriodNotAfter(false);
            }
            if (this.data.get(PRIVKEYUSAGEPERIODSTARTOFFSET) == null) {
                this.setPrivateKeyUsagePeriodStartOffset(0L);
            }
            if (this.data.get(PRIVKEYUSAGEPERIODLENGTH) == null) {
                this.setPrivateKeyUsagePeriodLength(this.getValidity() * 24L * 3600L);
            }
            if (this.data.get(USEISSUERALTERNATIVENAME) == null) {
                this.setUseIssuerAlternativeName(false);
            }
            if (this.data.get(ISSUERALTERNATIVENAMECRITICAL) == null) {
                this.setIssuerAlternativeNameCritical(false);
            }
            if (this.data.get(USEDOCUMENTTYPELIST) == null) {
                this.setUseDocumentTypeList(false);
            }
            if (this.data.get(DOCUMENTTYPELISTCRITICAL) == null) {
                this.setDocumentTypeListCritical(false);
            }
            if (this.data.get(DOCUMENTTYPELIST) == null) {
                this.setDocumentTypeList(new ArrayList<String>());
            }
            this.data.put("version", new Float(38.0f));
        }
        log.trace((Object)"<upgrade");
    }

    static {
        FIXED_PROFILENAMES.add(ROOTCAPROFILENAME);
        FIXED_PROFILENAMES.add(SUBCAPROFILENAME);
        FIXED_PROFILENAMES.add(ENDUSERPROFILENAME);
        FIXED_PROFILENAMES.add(OCSPSIGNERPROFILENAME);
        FIXED_PROFILENAMES.add(SERVERPROFILENAME);
        FIXED_PROFILENAMES.add(HARDTOKENAUTHPROFILENAME);
        FIXED_PROFILENAMES.add(HARDTOKENAUTHENCPROFILENAME);
        FIXED_PROFILENAMES.add(HARDTOKENENCPROFILENAME);
        FIXED_PROFILENAMES.add(HARDTOKENSIGNPROFILENAME);
        AVAILABLE_MSTEMPLATES = new String[]{MSTEMPL_DOMAINCONTROLLER};
        DEFAULTBITLENGTHS = new int[]{0, 192, 224, 239, 256, 384, 512, 521, 1024, 1536, 2048, 3072, 4096, 6144, 8192};
        DEFAULT_CVC_RIGHTS_AT = new byte[]{0, 0, 0, 0, 0};
        useStandardCertificateExtensions = new HashMap();
    }
}

